/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.support;

import alfio.controller.support.FormattedEventDates;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.LocalizedContent;
import alfio.util.MustacheCustomTag;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class Formatters {
    public static final String LINK_NEW_TAB_KEY = "link.new-tab";
    private static final Logger log = LoggerFactory.getLogger(Formatters.class);

    private Formatters() {
    }

    public static Map<String, String> getFormattedDate(LocalizedContent localizedContent, ZonedDateTime date, String code, MessageSource messageSource) {
        if (localizedContent != null && date != null) {
            return Formatters.getFormattedDate((List)localizedContent.getContentLanguages(), (ZonedDateTime)date, (String)code, (MessageSource)messageSource);
        }
        return null;
    }

    private static Map<String, String> getFormattedDate(List<ContentLanguage> languages, ZonedDateTime date, String code, MessageSource messageSource) {
        HashMap<String, String> formatted = new HashMap<String, String>();
        languages.forEach(cl -> Formatters.formatDateForLocale((ZonedDateTime)date, (String)code, (MessageSource)messageSource, formatted::put, (ContentLanguage)cl, (boolean)false));
        return formatted;
    }

    static void formatDateForLocale(ZonedDateTime date, String code, MessageSource messageSource, BiConsumer<String, String> storeFunction, ContentLanguage cl, boolean notifyError) {
        String pattern = null;
        try {
            pattern = messageSource.getMessage(code, null, cl.getLocale());
            storeFunction.accept(cl.getLanguage(), DateTimeFormatter.ofPattern(pattern, cl.getLocale()).format(date));
        }
        catch (RuntimeException e) {
            String message = "cannot parse pattern " + code + " (" + pattern + ") for language " + cl.getLanguage();
            if (notifyError) {
                throw new RuntimeException(message, e);
            }
            log.warn(message, (Throwable)e);
        }
    }

    public static FormattedEventDates getFormattedDates(Event e, MessageSource messageSource, List<ContentLanguage> contentLanguages) {
        return new FormattedEventDates(Formatters.getFormattedDate(contentLanguages, (ZonedDateTime)e.getBegin(), (String)"common.event.date-format", (MessageSource)messageSource), Formatters.getFormattedDate(contentLanguages, (ZonedDateTime)e.getBegin(), (String)"common.event.time-format", (MessageSource)messageSource), Formatters.getFormattedDate(contentLanguages, (ZonedDateTime)e.getEnd(), (String)"common.event.date-format", (MessageSource)messageSource), Formatters.getFormattedDate(contentLanguages, (ZonedDateTime)e.getEnd(), (String)"common.event.time-format", (MessageSource)messageSource));
    }

    public static Map<String, String> applyCommonMark(Map<String, String> in) {
        return Formatters.applyCommonMark(in, null);
    }

    public static Map<String, String> applyCommonMark(Map<String, String> in, MessageSource messageSource) {
        if (in == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        in.forEach((k, v) -> {
            String targetBlankMessage = messageSource != null ? messageSource.getMessage("link.new-tab", null, Locale.forLanguageTag(k)) : null;
            res.put((String)k, MustacheCustomTag.renderToHtmlCommonmarkEscaped((String)v, (String)targetBlankMessage));
        });
        return res;
    }
}

