/*
 * Decompiled with CFR 0.152.
 */
package alfio.controller.support;

import alfio.controller.api.support.AdditionalServiceWithData;
import alfio.controller.support.TemplateProcessor;
import alfio.manager.ExtensionManager;
import alfio.manager.FileUploadManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.support.PartialTicketTextGenerator;
import alfio.model.BillingDocument;
import alfio.model.Event;
import alfio.model.EventCheckInInfo;
import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.FileBlobMetadata;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketWithMetadataAttributes;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.user.Organization;
import alfio.util.EventUtil;
import alfio.util.ImageUtil;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import ch.digitalfondue.jfiveparse.Document;
import ch.digitalfondue.jfiveparse.Parser;
import ch.digitalfondue.jfiveparse.W3CDom;
import com.openhtmltopdf.extend.FSStreamFactory;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TemplateProcessor {
    private TemplateProcessor() {
    }

    public static PartialTicketTextGenerator buildPartialEmail(Event event, Organization organization, TicketReservation ticketReservation, TicketCategory category, TemplateManager templateManager, String baseUrl, String ticketURL, String calendarURL, Locale language, Map<String, Object> additionalOptions) {
        return ticket -> {
            Map model = TemplateResource.buildModelForTicketEmail((Organization)organization, (Event)event, (TicketReservation)ticketReservation, (String)baseUrl, (String)ticketURL, (String)calendarURL, (Ticket)ticket, (TicketCategory)category, (Map)additionalOptions);
            return templateManager.renderTemplate((PurchaseContext)event, EventUtil.isAccessOnline((TicketCategory)category, (EventCheckInInfo)event) ? TemplateResource.TICKET_EMAIL_FOR_ONLINE_EVENT : TemplateResource.TICKET_EMAIL, model, language);
        };
    }

    public static PartialTicketTextGenerator buildEmailForOwnerChange(Event e, Ticket oldTicket, Organization organization, String ticketUrl, TemplateManager templateManager, Locale language) {
        return newTicket -> {
            Map emailModel = TemplateResource.buildModelForTicketHasChangedOwner((Organization)organization, (Event)e, (Ticket)oldTicket, (Ticket)newTicket, (String)ticketUrl);
            return templateManager.renderTemplate((PurchaseContext)e, TemplateResource.TICKET_HAS_CHANGED_OWNER, emailModel, language);
        };
    }

    public static void renderPDFTicket(Locale language, Event event, TicketReservation ticketReservation, TicketWithMetadataAttributes ticketWithMetadata, TicketCategory ticketCategory, Organization organization, TemplateManager templateManager, FileUploadManager fileUploadManager, String reservationID, OutputStream os, BiFunction<Ticket, Event, List<FieldConfigurationDescriptionAndValue>> retrieveFieldValues, ExtensionManager extensionManager, Map<String, Object> initialModel, List<AdditionalServiceWithData> additionalServiceWithData) throws IOException {
        Optional imageData = TemplateProcessor.extractImageModel((PurchaseContext)event, (FileUploadManager)fileUploadManager);
        List<FieldConfigurationDescriptionAndValue> fields = retrieveFieldValues.apply(ticketWithMetadata.getTicket(), event);
        HashMap model = new HashMap(Objects.requireNonNullElse(initialModel, Map.of()));
        model.putAll(TemplateResource.buildModelForTicketPDF((Organization)organization, (Event)event, (TicketReservation)ticketReservation, (TicketCategory)ticketCategory, (TicketWithMetadataAttributes)ticketWithMetadata, (Optional)imageData, (String)reservationID, fields.stream().collect(Collectors.toMap(FieldConfigurationDescriptionAndValue::getName, FieldConfigurationDescriptionAndValue::getValueDescription)), additionalServiceWithData));
        String page = templateManager.renderTemplate((PurchaseContext)event, TemplateResource.TICKET_PDF, model, language).getTextPart();
        TemplateProcessor.renderToPdf((String)page, (OutputStream)os, (ExtensionManager)extensionManager, (PurchaseContext)event, (FileUploadManager)fileUploadManager);
    }

    public static Map<String, Object> getSubscriptionDetailsModelForTicket(Ticket ticket, Function<UUID, SubscriptionDescriptor> subscriptionDescriptorLoader, Locale locale) {
        boolean hasSubscription = ticket.getSubscriptionId() != null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("hasSubscription", hasSubscription);
        if (hasSubscription) {
            SubscriptionDescriptor subscriptionDescriptor = subscriptionDescriptorLoader.apply(ticket.getSubscriptionId());
            result.put("subscriptionTitle", subscriptionDescriptor.getLocalizedTitle(locale));
        }
        return result;
    }

    public static void renderSubscriptionPDF(Subscription subscription, Locale locale, SubscriptionDescriptor subscriptionDescriptor, TicketReservation reservation, SubscriptionMetadata metadata, Organization organization, TemplateManager templateManager, FileUploadManager fileUploadManager, String reservationId, ByteArrayOutputStream os, ExtensionManager extensionManager, PurchaseContextFieldManager purchaseContextFieldManager) throws IOException {
        Optional imageData = TemplateProcessor.extractImageModel((PurchaseContext)subscriptionDescriptor, (FileUploadManager)fileUploadManager);
        List additionalFields = purchaseContextFieldManager.getFieldDescriptionAndValues((PurchaseContext)subscriptionDescriptor, null, subscription, List.of(), locale.getLanguage(), true);
        Map model = TemplateResource.buildModelForSubscriptionPDF((Subscription)subscription, (SubscriptionDescriptor)subscriptionDescriptor, (Organization)organization, (SubscriptionMetadata)metadata, (Optional)imageData, (String)reservationId, (Locale)locale, (TicketReservation)reservation, (List)additionalFields);
        String page = templateManager.renderTemplate((PurchaseContext)subscriptionDescriptor, TemplateResource.SUBSCRIPTION_PDF, model, locale).getTextPart();
        TemplateProcessor.renderToPdf((String)page, (OutputStream)os, (ExtensionManager)extensionManager, (PurchaseContext)subscriptionDescriptor, (FileUploadManager)fileUploadManager);
    }

    public static void renderToPdf(String page, OutputStream os, ExtensionManager extensionManager, PurchaseContext purchaseContext, FileUploadManager fileUploadManager) throws IOException {
        if (extensionManager.handlePdfTransformation(page, purchaseContext, os)) {
            return;
        }
        PdfRendererBuilder builder = new PdfRendererBuilder();
        PDDocument doc = new PDDocument(IOUtils.createTempFileOnlyStreamCache());
        builder.usePDDocument(doc);
        builder.toStream(os);
        builder.useProtocolsStreamImplementation((FSStreamFactory)new AlfioInternalFSStreamFactory(), new String[]{"alfio-internal"});
        builder.useProtocolsStreamImplementation((FSStreamFactory)new InvalidProtocolFSStreamFactory(), new String[]{"http", "https", "file", "jar"});
        builder.useFastMode();
        builder.usePdfUaAccessibility(true);
        builder.usePdfAConformance(PdfRendererBuilder.PdfAConformance.PDFA_3_U);
        Parser parser = new Parser();
        builder.withW3cDocument(W3CDom.toW3CDocument((Document)parser.parse(page)), "");
        try (PdfBoxRenderer renderer = builder.buildPdfRenderer();){
            File serifFont;
            File sansFont;
            File monoFont = ImageUtil.getDejaVuSansMonoFont((FileUploadManager)fileUploadManager);
            if (monoFont != null) {
                renderer.getFontResolver().addFont(monoFont, "DejaVu Sans Mono", null, null, false, PdfBoxFontResolver.FontGroup.MAIN);
                renderer.getFontResolver().addFont(monoFont, "Monospaced", null, null, false, PdfBoxFontResolver.FontGroup.MAIN);
            }
            if ((sansFont = ImageUtil.getDejaVuSansFont((FileUploadManager)fileUploadManager)) != null) {
                renderer.getFontResolver().addFont(sansFont, "SansSerif", null, null, false, PdfBoxFontResolver.FontGroup.MAIN);
            }
            if ((serifFont = ImageUtil.getDejaVuSerifFont((FileUploadManager)fileUploadManager)) != null) {
                renderer.getFontResolver().addFont(sansFont, "Serif", null, null, false, PdfBoxFontResolver.FontGroup.MAIN);
            }
            renderer.layout();
            renderer.createPDF();
        }
    }

    public static Optional<TemplateResource.ImageData> extractImageModel(PurchaseContext purchaseContext, FileUploadManager fileUploadManager) {
        if (purchaseContext.getFileBlobIdIsPresent()) {
            return fileUploadManager.findMetadata(purchaseContext.getFileBlobId()).map(metadata -> {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                fileUploadManager.outputFile(metadata.getId(), (OutputStream)baos);
                return TemplateResource.fillWithImageData((FileBlobMetadata)metadata, (byte[])baos.toByteArray());
            });
        }
        return Optional.empty();
    }

    public static boolean buildReceiptOrInvoicePdf(PurchaseContext purchaseContext, FileUploadManager fileUploadManager, Locale language, TemplateManager templateManager, Map<String, Object> model, TemplateResource templateResource, ExtensionManager extensionManager, OutputStream os) {
        try {
            String html = TemplateProcessor.renderReceiptOrInvoicePdfTemplate((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager, (Locale)language, (TemplateManager)templateManager, model, (TemplateResource)templateResource);
            TemplateProcessor.renderToPdf((String)html, (OutputStream)os, (ExtensionManager)extensionManager, (PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static String renderReceiptOrInvoicePdfTemplate(PurchaseContext purchaseContext, FileUploadManager fileUploadManager, Locale language, TemplateManager templateManager, Map<String, Object> model, TemplateResource templateResource) {
        TemplateProcessor.extractImageModel((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager).ifPresent(imageData -> {
            model.put("eventImage", imageData.getEventImage());
            model.put("imageWidth", imageData.getImageWidth());
            model.put("imageHeight", imageData.getImageHeight());
        });
        return templateManager.renderTemplate(purchaseContext, templateResource, model, language).getTextPart();
    }

    public static Optional<byte[]> buildBillingDocumentPdf(BillingDocument.Type documentType, PurchaseContext purchaseContext, FileUploadManager fileUploadManager, Locale language, TemplateManager templateManager, Map<String, Object> model, ExtensionManager extensionManager) {
        return switch (1.$SwitchMap$alfio$model$BillingDocument$Type[documentType.ordinal()]) {
            case 1 -> TemplateProcessor.buildInvoicePdf((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager, (Locale)language, (TemplateManager)templateManager, model, (ExtensionManager)extensionManager);
            case 2 -> TemplateProcessor.buildReceiptPdf((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager, (Locale)language, (TemplateManager)templateManager, model, (ExtensionManager)extensionManager);
            case 3 -> TemplateProcessor.buildCreditNotePdf((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager, (Locale)language, (TemplateManager)templateManager, model, (ExtensionManager)extensionManager);
            default -> throw new IllegalStateException(documentType + " not supported");
        };
    }

    private static Optional<byte[]> buildFrom(PurchaseContext purchaseContext, FileUploadManager fileUploadManager, Locale language, TemplateManager templateManager, Map<String, Object> model, TemplateResource templateResource, ExtensionManager extensionManager) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean res = TemplateProcessor.buildReceiptOrInvoicePdf((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager, (Locale)language, (TemplateManager)templateManager, model, (TemplateResource)templateResource, (ExtensionManager)extensionManager, (OutputStream)baos);
        return res ? Optional.of(baos.toByteArray()) : Optional.empty();
    }

    public static Optional<byte[]> buildReceiptPdf(PurchaseContext purchaseContext, FileUploadManager fileUploadManager, Locale language, TemplateManager templateManager, Map<String, Object> model, ExtensionManager extensionManager) {
        return TemplateProcessor.buildFrom((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager, (Locale)language, (TemplateManager)templateManager, model, (TemplateResource)TemplateResource.RECEIPT_PDF, (ExtensionManager)extensionManager);
    }

    public static Optional<byte[]> buildInvoicePdf(PurchaseContext purchaseContext, FileUploadManager fileUploadManager, Locale language, TemplateManager templateManager, Map<String, Object> model, ExtensionManager extensionManager) {
        return TemplateProcessor.buildFrom((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager, (Locale)language, (TemplateManager)templateManager, model, (TemplateResource)TemplateResource.INVOICE_PDF, (ExtensionManager)extensionManager);
    }

    public static Optional<byte[]> buildCreditNotePdf(PurchaseContext purchaseContext, FileUploadManager fileUploadManager, Locale language, TemplateManager templateManager, Map<String, Object> model, ExtensionManager extensionManager) {
        return TemplateProcessor.buildFrom((PurchaseContext)purchaseContext, (FileUploadManager)fileUploadManager, (Locale)language, (TemplateManager)templateManager, model, (TemplateResource)TemplateResource.CREDIT_NOTE_PDF, (ExtensionManager)extensionManager);
    }
}

