/*
 * Decompiled with CFR 0.152.
 */
package alfio.extension;

import alfio.extension.Extension;
import alfio.extension.ExtensionLogger;
import alfio.extension.ExtensionMetadata;
import alfio.extension.ExtensionService;
import alfio.extension.ScriptValidation;
import alfio.extension.ScriptingExecutionService;
import alfio.manager.support.extension.ExtensionCapability;
import alfio.manager.support.extension.ExtensionEvent;
import alfio.manager.system.ExternalConfiguration;
import alfio.model.EventAndOrganizationId;
import alfio.model.ExtensionCapabilitySummary;
import alfio.model.ExtensionLog;
import alfio.model.ExtensionSupport;
import alfio.model.PurchaseContext;
import alfio.model.user.Organization;
import alfio.repository.ExtensionLogRepository;
import alfio.repository.ExtensionRepository;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ExtensionService {
    private static final String EVALUATE_RESULT = "res = GSON.fromJson(JSON.stringify(res), returnClass);";
    private static final String PROCESS_EXTENSION_RESULT = "var res = executeScript(extensionEvent); res = GSON.fromJson(JSON.stringify(res), returnClass);";
    private static final String PROCESS_CAPABILITY_RESULT = "var res = executeCapability(capability); res = GSON.fromJson(JSON.stringify(res), returnClass);";
    private static final String EXECUTE_SCRIPT = "executeScript(extensionEvent);";
    private static final String OUTPUT = "output";
    private static final String EXECUTION_KEY = "executionKey";
    private static final String EXTENSION_EVENT = "extensionEvent";
    private final ScriptingExecutionService scriptingExecutionService;
    private final ExtensionRepository extensionRepository;
    private final ExtensionLogRepository extensionLogRepository;
    private final PlatformTransactionManager platformTransactionManager;
    private final ExternalConfiguration externalConfiguration;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    private ExtensionMetadata getMetadata(String name, String script) {
        return (ExtensionMetadata)this.scriptingExecutionService.executeScript(name, script + "\n;GSON.fromJson(JSON.stringify(getScriptMetadata()), returnClass);", Collections.emptyMap(), ExtensionMetadata.class, (ExtensionLogger)new NoopExtensionLogger());
    }

    @Transactional
    public void createOrUpdate(String previousPath, String previousName, Extension script) {
        Validate.notBlank((CharSequence)script.getName(), (String)"Name is mandatory", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)script.getPath(), (String)"Path must be defined", (Object[])new Object[0]);
        ScriptValidation validation = new ScriptValidation(script.getScript());
        validation.validate();
        String hash = DigestUtils.sha256Hex((String)script.getScript());
        ExtensionMetadata extensionMetadata = this.getMetadata(script.getName(), script.getScript());
        Validate.notBlank((CharSequence)extensionMetadata.getDisplayName(), (String)"Display Name is mandatory", (Object[])new Object[0]);
        this.validateCapabilities(extensionMetadata);
        if (previousPath != null && previousName != null) {
            this.extensionRepository.deleteEventsForPath(previousPath, previousName);
        }
        if (!Objects.equals(previousPath, script.getPath()) || !Objects.equals(previousName, script.getName())) {
            this.extensionRepository.deleteScriptForPath(previousPath, previousName);
            this.extensionRepository.insert(script.getPath(), script.getName(), extensionMetadata.getDisplayName(), hash, script.isEnabled(), extensionMetadata.isAsync(), script.getScript(), extensionMetadata);
        } else {
            this.extensionRepository.update(script.getPath(), script.getName(), extensionMetadata.getDisplayName(), hash, script.isEnabled(), extensionMetadata.isAsync(), script.getScript(), extensionMetadata);
        }
        int extensionId = this.extensionRepository.getExtensionIdFor(script.getPath(), script.getName());
        for (String event : extensionMetadata.getEvents()) {
            this.extensionRepository.insertEvent(extensionId, event);
        }
        ExtensionMetadata.Parameters parameters = extensionMetadata.getParameters();
        if (parameters != null) {
            List extensionParameterKeyValue = this.extensionRepository.findExtensionParameterKeyValue(extensionId);
            this.extensionRepository.deleteExtensionParameter(extensionId);
            for (ExtensionMetadata.Field field : Objects.requireNonNullElse(parameters.getFields(), List.of())) {
                for (String level : parameters.getConfigurationLevels()) {
                    int confFieldId = (Integer)this.extensionRepository.registerExtensionConfigurationMetadata(extensionId, field.getName(), field.getDescription(), field.getType(), level, field.isRequired()).getKey();
                    List filteredParam = extensionParameterKeyValue.stream().filter(kv -> field.getName().equals(kv.getName()) && level.equals(kv.getConfigurationLevel())).collect(Collectors.toList());
                    MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])filteredParam.stream().map(kv -> new MapSqlParameterSource("ecmId", (Object)confFieldId).addValue("confPath", (Object)kv.getConfigurationPath()).addValue("value", (Object)kv.getConfigurationValue())).toArray(MapSqlParameterSource[]::new);
                    this.jdbcTemplate.batchUpdate(this.extensionRepository.bulkInsertSettingValue(), (SqlParameterSource[])parameterSources);
                }
            }
        }
    }

    void validateCapabilities(ExtensionMetadata extensionMetadata) {
        Set events = Objects.requireNonNull(extensionMetadata.getEvents(), "Events are mandatory").stream().map(ExtensionEvent::valueOf).collect(Collectors.toSet());
        Validate.isTrue((!events.isEmpty() ? 1 : 0) != 0, (String)"Events are mandatory", (Object[])new Object[0]);
        Set invalidCapabilities = Objects.requireNonNullElse(extensionMetadata.getCapabilities(), List.of()).stream().filter(s -> ExtensionCapability.valueOf((String)s).getCompatibleEvents().stream().noneMatch(events::contains)).collect(Collectors.toSet());
        if (!invalidCapabilities.isEmpty()) {
            throw new IllegalArgumentException("Invalid capabilities: " + String.join((CharSequence)", ", invalidCapabilities));
        }
    }

    public List<ExtensionSupport.ExtensionParameterMetadataAndValue> getConfigurationParametersFor(String basePath, String pathPattern, String configurationLevel) {
        return this.extensionRepository.getParametersForLevelAndPath(configurationLevel, ExtensionService.generatePossiblePath((String)basePath), pathPattern);
    }

    @Transactional
    public void bulkUpdateSystemSettings(List<ExtensionSupport.ExtensionMetadataValue> toUpdate) {
        this.deleteAndInsertSetting("SYSTEM", "-", toUpdate);
    }

    @Transactional
    public void bulkUpdateOrganizationSettings(Organization org, List<ExtensionSupport.ExtensionMetadataValue> toUpdate) {
        String path = "-" + org.getId();
        this.deleteAndInsertSetting("ORGANIZATION", path, toUpdate);
    }

    @Transactional
    public void bulkUpdateEventSettings(Organization org, EventAndOrganizationId event, List<ExtensionSupport.ExtensionMetadataValue> toUpdate) {
        String path = "-" + org.getId() + "-" + event.getId();
        this.deleteAndInsertSetting("EVENT", path, toUpdate);
    }

    @Transactional
    public void deleteSettingValue(int id, String path) {
        this.extensionRepository.deleteSettingValue(id, path);
    }

    private void deleteAndInsertSetting(String level, String path, List<ExtensionSupport.ExtensionMetadataValue> toUpdate) {
        this.extensionRepository.deleteSettingValue(level, path);
        List<Object> toUpdate2 = toUpdate == null ? Collections.emptyList() : toUpdate;
        List filtered = toUpdate2.stream().filter(f -> StringUtils.trimToNull((String)f.getValue()) != null).collect(Collectors.toList());
        MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])filtered.stream().map(kv -> new MapSqlParameterSource("ecmId", (Object)kv.getId()).addValue("confPath", (Object)path).addValue("value", (Object)kv.getValue())).toArray(MapSqlParameterSource[]::new);
        this.jdbcTemplate.batchUpdate(this.extensionRepository.bulkInsertSettingValue(), (SqlParameterSource[])parameterSources);
    }

    @Transactional
    public void toggle(String path, String name, boolean status) {
        this.extensionRepository.toggle(path, name, status);
    }

    @Transactional
    public void delete(String path, String name) {
        this.extensionRepository.deleteEventsForPath(path, name);
        this.extensionRepository.deleteScriptForPath(path, name);
    }

    @Transactional(readOnly=true)
    public String getScript(String path, String name) {
        return this.externalConfiguration.getScript(path, name).orElseGet(() -> this.extensionRepository.getScript(path, name));
    }

    @Transactional(readOnly=true)
    public Optional<ExtensionSupport> getSingle(String path, String name) {
        return this.extensionRepository.getSingle(path, name);
    }

    @Transactional(readOnly=true)
    public Optional<ExtensionSupport> getSingle(Organization organization, EventAndOrganizationId event, String name) {
        Set paths = ExtensionService.generatePossiblePath((String)ExtensionService.toPath((EventAndOrganizationId)new EventAndOrganizationId(organization.getId(), event.getId())), Comparator.reverseOrder());
        return this.extensionRepository.getSingle((Collection)paths, name);
    }

    @Transactional(readOnly=true)
    public boolean isCapabilitySupported(ExtensionCapability capability, PurchaseContext purchaseContext) {
        List externalScripts = this.externalConfiguration.getAllExtensionsForCapability(capability);
        if (!externalScripts.isEmpty()) {
            return true;
        }
        Set paths = ExtensionService.generatePossiblePath((String)ExtensionService.toPath((PurchaseContext)purchaseContext), Comparator.reverseOrder());
        int count = this.extensionRepository.countScriptsSupportingCapability(paths, List.of(capability.name()));
        return count > 0;
    }

    @Transactional(readOnly=true)
    public Set<ExtensionCapabilitySummary> getSupportedCapabilities(Set<ExtensionCapability> requested, PurchaseContext purchaseContext) {
        Set externalScriptsSupportedCapabilities = this.externalConfiguration.getSupportedCapabilities(requested);
        if (requested.stream().allMatch(capability -> externalScriptsSupportedCapabilities.stream().anyMatch(sc -> sc.getCapability() == capability))) {
            return externalScriptsSupportedCapabilities;
        }
        HashSet<ExtensionCapabilitySummary> result = new HashSet<ExtensionCapabilitySummary>(externalScriptsSupportedCapabilities);
        Set paths = ExtensionService.generatePossiblePath((String)ExtensionService.toPath((PurchaseContext)purchaseContext), Comparator.reverseOrder());
        result.addAll(this.extensionRepository.getSupportedCapabilities(paths, ExtensionCapability.toString(requested)));
        return result;
    }

    private Optional<ExtensionSupport.ScriptPathNameHash> getFirstScriptSupportingCapability(ExtensionCapability capability, String basePath) {
        List externalConfCapabilities = this.externalConfiguration.getAllExtensionsForCapability(capability);
        if (!externalConfCapabilities.isEmpty()) {
            return Optional.of((ExtensionSupport.ScriptPathNameHash)externalConfCapabilities.get(0));
        }
        return this.extensionRepository.getFirstScriptForCapability(ExtensionService.generatePossiblePath((String)basePath), capability.name());
    }

    public <T> Optional<T> executeCapability(ExtensionCapability capability, String basePath, Map<String, Object> params, Class<T> resultType) {
        return this.getFirstScriptSupportingCapability(capability, basePath).map(scriptPathNameHash -> {
            Map context = new HashMap<String, String>(params);
            context.put("capability", capability.name());
            context.put("output", null);
            context.put("executionKey", UUID.randomUUID().toString());
            context = this.internalExecuteScript(scriptPathNameHash, context, basePath, false, "var res = executeCapability(capability); res = GSON.fromJson(JSON.stringify(res), returnClass);", resultType);
            return resultType.cast(context.get("output"));
        });
    }

    public <T> T executeScriptsForEvent(String event, String basePath, Map<String, Object> payload, Class<T> clazz) {
        List activePaths = this.getActiveScriptsForEvent(event, basePath, false);
        Map<String, Object> context = new HashMap<String, Object>(payload);
        context.put("extensionEvent", event);
        context.put("executionKey", UUID.randomUUID().toString());
        context.put("output", null);
        for (ExtensionSupport.ScriptPathNameHash activePath : activePaths) {
            context = this.internalExecuteScript(activePath, context, basePath, false, "var res = executeScript(extensionEvent); res = GSON.fromJson(JSON.stringify(res), returnClass);", clazz);
        }
        return clazz.cast(context.get("output"));
    }

    public void executeScriptAsync(String event, String basePath, Map<String, Object> payload) {
        List activePaths = this.getActiveScriptsForEvent(event, basePath, true);
        Map<String, Object> input = new HashMap<String, Object>(payload);
        input.put("extensionEvent", event);
        input.put("executionKey", UUID.randomUUID().toString());
        for (ExtensionSupport.ScriptPathNameHash activePath : activePaths) {
            input = this.internalExecuteScript(activePath, input, basePath, true, "executeScript(extensionEvent);", Void.class);
        }
    }

    public void retryFailedAsyncScript(String path, String name, Map<String, Object> payload) {
        String extensionEvent = (String)payload.get("extensionEvent");
        Optional<ExtensionSupport.ScriptPathNameHash> activePathOptional = this.getActiveScriptsForEvent(extensionEvent, path, true).stream().filter(nh -> nh.getName().equals(name)).findFirst();
        activePathOptional.ifPresent(scriptPathNameHash -> this.internalExecuteScript(scriptPathNameHash, payload, path, false, "executeScript(extensionEvent);\nvar res = null;", Void.class, true));
    }

    private <T> Map<String, Object> internalExecuteScript(ExtensionSupport.ScriptPathNameHash activePath, Map<String, Object> input, String basePath, boolean async, String executeInstruction, Class<T> expectedResult) {
        return this.internalExecuteScript(activePath, input, basePath, async, executeInstruction, expectedResult, false);
    }

    private <T> Map<String, Object> internalExecuteScript(ExtensionSupport.ScriptPathNameHash activePath, Map<String, Object> input, String basePath, boolean async, String executeInstruction, Class<T> expectedResult, boolean throwErrorIfNotExecuted) {
        String path = activePath.getPath();
        String name = activePath.getName();
        Pair params = this.addExtensionParameters(input, basePath, activePath);
        Map context = (Map)params.getRight();
        ExtensionLoggerImpl extLogger = new ExtensionLoggerImpl(this.extensionLogRepository, this.platformTransactionManager, basePath, path, name);
        if (((Set)params.getLeft()).isEmpty()) {
            Supplier<String> scriptGetter = () -> this.getScript(path, name) + "\n;" + executeInstruction;
            if (async) {
                this.scriptingExecutionService.executeScriptAsync(path, name, activePath.getHash(), scriptGetter, context, (ExtensionLogger)extLogger);
            } else {
                Object res = this.scriptingExecutionService.executeScript(name, activePath.getHash(), scriptGetter, context, expectedResult, (ExtensionLogger)extLogger);
                context.put("output", res);
            }
        } else {
            extLogger.logWarning("script not run, missing parameters: " + params.getLeft());
            if (throwErrorIfNotExecuted) {
                throw new IllegalStateException("Script not run, missing parameters: " + params.getLeft());
            }
        }
        return context;
    }

    private Pair<Set<String>, Map<String, Object>> addExtensionParameters(Map<String, Object> input, String basePath, ExtensionSupport.ScriptPathNameHash activePath) {
        if (ExternalConfiguration.isExternalPath((String)activePath.getPath())) {
            return this.getExternalExtensionParameters(input, activePath);
        }
        return this.getExtensionParameters(input, basePath, activePath);
    }

    private Pair<Set<String>, Map<String, Object>> getExternalExtensionParameters(Map<String, Object> input, ExtensionSupport.ScriptPathNameHash activePath) {
        HashMap<String, Object> copy = new HashMap<String, Object>(input);
        copy.put("extensionParameters", this.externalConfiguration.getParametersForExtension(activePath.getName()));
        return Pair.of(Set.of(), copy);
    }

    private Pair<Set<String>, Map<String, Object>> getExtensionParameters(Map<String, Object> input, String basePath, ExtensionSupport.ScriptPathNameHash activePath) {
        HashMap<String, Object> copy = new HashMap<String, Object>(input);
        Map<String, String> nameAndValues = this.extensionRepository.findParametersForScript(activePath.getName(), activePath.getPath(), ExtensionService.generatePossiblePath((String)basePath)).stream().collect(Collectors.toMap(ExtensionSupport.NameAndValue::getName, ExtensionSupport.NameAndValue::getValue));
        HashSet mandatory = new HashSet(this.extensionRepository.findMandatoryParametersForScript(activePath.getName(), activePath.getPath()));
        mandatory.removeAll(nameAndValues.keySet());
        copy.put("extensionParameters", nameAndValues);
        return Pair.of(mandatory, copy);
    }

    private List<ExtensionSupport.ScriptPathNameHash> getActiveScriptsForEvent(String event, String basePath, boolean async) {
        Set paths = ExtensionService.generatePossiblePath((String)basePath);
        ArrayList<ExtensionSupport.ScriptPathNameHash> allExtensions = new ArrayList<ExtensionSupport.ScriptPathNameHash>(this.externalConfiguration.getAllExtensionsFor(event, async));
        allExtensions.addAll(this.extensionRepository.findActive(paths, async, event));
        return allExtensions;
    }

    private static Set<String> generatePossiblePath(String basePath, Comparator<String> comparator) {
        TreeSet<String> paths = new TreeSet<String>(comparator);
        int basePathLength = basePath.length();
        for (int i = 1; i < basePathLength; ++i) {
            if (basePath.charAt(i) != '-') continue;
            paths.add(basePath.substring(0, i));
        }
        paths.add("-");
        paths.add(basePath);
        return paths;
    }

    private static Set<String> generatePossiblePath(String basePath) {
        return ExtensionService.generatePossiblePath((String)basePath, Comparator.naturalOrder());
    }

    @Transactional(readOnly=true)
    public List<ExtensionSupport> listAll() {
        return this.extensionRepository.listAll();
    }

    @Transactional(readOnly=true)
    public Pair<List<ExtensionLog>, Integer> getLog(String path, String name, ExtensionLog.Type type, int pageSize, int offset) {
        String typeAsString = type != null ? type.name() : null;
        int count = this.extensionLogRepository.countPages(path, name, typeAsString);
        List logs = this.extensionLogRepository.getPage(path, name, typeAsString, pageSize, offset);
        return Pair.of((Object)logs, (Object)count);
    }

    public static String toPath(EventAndOrganizationId event) {
        return "-" + event.getOrganizationId() + "-" + event.getId();
    }

    public static String toPath(PurchaseContext purchaseContext) {
        if (purchaseContext == null) {
            return "-";
        }
        int organizationId = purchaseContext.getOrganizationId();
        return purchaseContext.event().map(e -> ExtensionService.toPath((EventAndOrganizationId)e)).orElseGet(() -> "-" + organizationId);
    }

    @ConstructorProperties(value={"scriptingExecutionService", "extensionRepository", "extensionLogRepository", "platformTransactionManager", "externalConfiguration", "jdbcTemplate"})
    @Generated
    public ExtensionService(ScriptingExecutionService scriptingExecutionService, ExtensionRepository extensionRepository, ExtensionLogRepository extensionLogRepository, PlatformTransactionManager platformTransactionManager, ExternalConfiguration externalConfiguration, NamedParameterJdbcTemplate jdbcTemplate) {
        this.scriptingExecutionService = scriptingExecutionService;
        this.extensionRepository = extensionRepository;
        this.extensionLogRepository = extensionLogRepository;
        this.platformTransactionManager = platformTransactionManager;
        this.externalConfiguration = externalConfiguration;
        this.jdbcTemplate = jdbcTemplate;
    }
}

