/*
 * Decompiled with CFR 0.152.
 */
package alfio.extension;

import alfio.extension.ExtensionUtils;
import alfio.util.Json;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExtensionUtils {
    private static final Gson JSON_SERIALIZER = Json.GSON.newBuilder().registerTypeAdapter(Double.class, (Object)new DoubleSerializer()).create();

    private ExtensionUtils() {
    }

    public static String format(String str, String ... params) {
        return str.formatted(params);
    }

    public static String md5(String str) {
        try {
            return Hex.encodeHexString((byte[])MessageDigest.getInstance("MD5").digest(str.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException nae) {
            throw new IllegalStateException(nae);
        }
    }

    public static String computeHMAC(String secret, String ... parts) {
        if (parts == null || parts.length == 0) {
            return "";
        }
        String text = Arrays.stream(parts).map(StringUtils::trimToEmpty).collect(Collectors.joining(""));
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_256, secret).hmacHex(text);
    }

    public static String formatDateTime(String dateTimeAsString, String formatPattern, boolean utc) {
        return ExtensionUtils.formatDateTime((ZonedDateTime)ZonedDateTime.parse(dateTimeAsString), (String)formatPattern, (boolean)utc);
    }

    public static String formatDateTime(ZonedDateTime dateTime, String formatPattern, boolean utc) {
        ZonedDateTime dateTimeToFormat = utc ? dateTime.withZoneSameInstant(ZoneId.of("UTC")) : dateTime;
        return dateTimeToFormat.format(DateTimeFormatter.ofPattern(formatPattern));
    }

    public static String base64UrlSafe(String input) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String convertToJson(Object o) {
        return JSON_SERIALIZER.toJson(ExtensionUtils.unwrap((Object)o));
    }

    static Object unwrap(Object o) {
        if (o instanceof Scriptable) {
            if (o instanceof NativeArray) {
                NativeArray na = (NativeArray)o;
                ArrayList<Object> res = new ArrayList<Object>();
                for (Object a : na) {
                    res.add(ExtensionUtils.unwrap(a));
                }
                return res;
            }
            if (o instanceof NativeJavaObject) {
                NativeJavaObject object = (NativeJavaObject)o;
                return object.unwrap();
            }
            if (o instanceof NativeObject) {
                NativeObject na = (NativeObject)o;
                LinkedHashMap res = new LinkedHashMap();
                for (Map.Entry kv : na.entrySet()) {
                    res.put(kv.getKey(), ExtensionUtils.unwrap(kv.getValue()));
                }
                return res;
            }
            if (o instanceof IdScriptableObject) {
                IdScriptableObject object = (IdScriptableObject)o;
                return ExtensionUtils.parseIdScriptableObject((IdScriptableObject)object);
            }
        } else if (o instanceof CharSequence) {
            return o.toString();
        }
        return o;
    }

    private static Object parseIdScriptableObject(IdScriptableObject object) {
        String className;
        return switch (className = object.getClassName()) {
            case "String" -> ScriptRuntime.toCharSequence((Object)object);
            case "Boolean" -> Context.jsToJava((Object)object, Boolean.class);
            case "Date" -> Context.jsToJava((Object)object, Date.class);
            default -> null;
        };
    }
}

