/*
 * Decompiled with CFR 0.152.
 */
package alfio.extension;

import alfio.extension.JSSymbol;
import alfio.extension.exception.ScriptNotValidException;
import java.util.ArrayList;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.mozilla.javascript.ast.WithStatement;

class JSNodeVisitor
implements NodeVisitor {
    private JSSymbol root = null;
    private final ArrayList<String> functionCalls = new ArrayList();

    JSNodeVisitor() {
    }

    public boolean visit(AstNode node) {
        if (node == null) {
            return false;
        }
        this.checkNode(node);
        return true;
    }

    private void checkNode(AstNode node) {
        PropertyGet propertyGet;
        PropertyGet get;
        FunctionCall call;
        AstNode target;
        if (this.root == null) {
            this.root = new JSSymbol(node);
            return;
        }
        int nodeType = node.getType();
        if (nodeType != 113 && nodeType != 127 && nodeType != 134 && nodeType != 126 && nodeType != 39 && nodeType != 121 && nodeType != 122 && nodeType != 67 && nodeType != 38 && nodeType != 33 && nodeType != 137) {
            return;
        }
        if (node.getType() == 126 && !(node instanceof VariableInitializer)) {
            return;
        }
        if (node instanceof FunctionCall && !((target = (call = (FunctionCall)node).getTarget()) instanceof PropertyGet)) {
            Name name = (Name)target;
            this.functionCalls.add(name.getIdentifier());
            for (AstNode parentNode = node.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
                if (!(parentNode instanceof FunctionNode)) continue;
                FunctionNode functionNode = (FunctionNode)parentNode;
                Name parentName = functionNode.getFunctionName();
                String id = parentName.getIdentifier();
                if (!this.functionCalls.contains(id)) break;
                throw new ScriptNotValidException("Script not valid. Cannot call nested functions: " + name.getIdentifier());
            }
        }
        if (node instanceof WhileLoop || node instanceof DoLoop || node instanceof WithStatement || node instanceof LabeledStatement || node instanceof PropertyGet && (get = (PropertyGet)node).getRight().getString().equals("System") || node instanceof PropertyGet && (propertyGet = (PropertyGet)node).getRight().getString().equals("getClass") || node instanceof Name && node.getString().equals("newInstance")) {
            throw new ScriptNotValidException("Script not valid. One or more of the following components have been detected: \n- while() Loop\n- with() Statement\n- a labeled statement\n- Access to java.lang.System\n- Access to Object.getClass()\n- Java reflection usage");
        }
    }

    public JSSymbol getRoot() {
        return this.root;
    }
}

