/*
 * Decompiled with CFR 0.152.
 */
package alfio.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.VariableInitializer;

class JSSymbol {
    private final AstNode node;
    private final ArrayList<JSSymbol> children = new ArrayList();
    private final Map<String, JSSymbol> localVars = new HashMap();
    private JSSymbol parent = null;

    public JSSymbol(AstNode node) {
        FunctionNode funcNode;
        List args;
        this.node = node;
        if (node instanceof FunctionNode && (args = (funcNode = (FunctionNode)node).getParams()) != null) {
            for (AstNode argNode : args) {
                this.addChild(argNode);
            }
        }
    }

    public int getType() {
        return this.node.getType();
    }

    public void addChild(JSSymbol child) {
        AstNode childNode;
        if (child.getType() == 126 && (childNode = child.getNode()) instanceof VariableInitializer) {
            VariableInitializer initializer = (VariableInitializer)childNode;
            String varName = ((Name)initializer.getTarget()).getIdentifier();
            if (this.localVars.containsKey(varName)) {
                return;
            }
            this.localVars.put(varName, child);
        }
        this.children.add(child);
        child.setParent(this);
    }

    public void addChild(AstNode node) {
        this.addChild(new JSSymbol(node));
    }

    public ArrayList<JSSymbol> getChildren() {
        return new ArrayList<JSSymbol>(this.children);
    }

    public AstNode getNode() {
        return this.node;
    }

    public boolean childExist(String name) {
        return this.localVars.containsKey(name);
    }

    public JSSymbol getParent() {
        return this.parent;
    }

    public void setParent(JSSymbol parent) {
        this.parent = parent;
    }
}

