/*
 * Decompiled with CFR 0.152.
 */
package alfio.extension;

import alfio.extension.ConsoleLogger;
import alfio.extension.ExtensionLogger;
import alfio.extension.ExtensionUtils;
import alfio.extension.JSON;
import alfio.extension.ScriptingExecutionService;
import alfio.extension.SimpleHttpClient;
import alfio.extension.exception.AlfioScriptingException;
import alfio.extension.exception.InvalidScriptException;
import alfio.extension.exception.OutOfBoundariesException;
import alfio.extension.exception.ScriptRuntimeException;
import alfio.extension.support.SandboxContextFactory;
import alfio.manager.system.AdminJobExecutor;
import alfio.manager.system.AdminJobManager;
import alfio.model.CustomerName;
import alfio.repository.system.AdminJobQueueRepository;
import alfio.util.ClockProvider;
import alfio.util.Json;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.ConnectException;
import java.net.http.HttpClient;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScriptingExecutionService {
    public static final String EXTENSION_NAME = "extensionName";
    public static final String EXTENSION_PATH = "path";
    public static final String EXTENSION_PARAMS = "params";
    public static final String EXTENSION_CONFIGURATION_PARAMETERS = "extensionParameters";
    static final String CONNECT_EXCEPTION_MESSAGE = "Cannot connect to remote service. Please check your configuration";
    static final String DEFAULT_ERROR_MESSAGE = "Error while executing extension. Please retry.";
    private static final Logger log = LoggerFactory.getLogger(ScriptingExecutionService.class);
    private final Supplier<Executor> executorSupplier;
    private final ScriptableObject sealedScope;
    private final AdminJobQueueRepository adminJobQueueRepository;
    private final Cache<String, Executor> asyncExecutors = Caffeine.newBuilder().expireAfterAccess(Duration.ofHours(12L)).removalListener((key, value, cause) -> {
        if (value instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)value;
            service.shutdown();
        }
    }).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptingExecutionService(HttpClient httpClient, AdminJobQueueRepository adminJobQueueRepository, Supplier<Executor> executorSupplier) {
        this.executorSupplier = executorSupplier;
        this.adminJobQueueRepository = adminJobQueueRepository;
        SimpleHttpClient simpleHttpClient = new SimpleHttpClient(httpClient);
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            this.sealedScope = cx.initSafeStandardObjects(null, true);
            this.sealedScope.put("log", (Scriptable)this.sealedScope, (Object)log);
            this.sealedScope.put("GSON", (Scriptable)this.sealedScope, (Object)Json.GSON);
            this.sealedScope.put("JSON", (Scriptable)this.sealedScope, (Object)new NativeJavaClass((Scriptable)this.sealedScope, JSON.class));
            this.sealedScope.put("simpleHttpClient", (Scriptable)this.sealedScope, (Object)simpleHttpClient);
            this.sealedScope.put("HashMap", (Scriptable)this.sealedScope, (Object)new NativeJavaClass((Scriptable)this.sealedScope, HashMap.class));
            this.sealedScope.put("ExtensionUtils", (Scriptable)this.sealedScope, (Object)new NativeJavaClass((Scriptable)this.sealedScope, ExtensionUtils.class));
        }
        finally {
            Context.exit();
        }
    }

    public <T> T executeScript(String name, String hash, Supplier<String> scriptFetcher, Map<String, Object> params, Class<T> clazz, ExtensionLogger extensionLogger) {
        return (T)this.executeScriptFinally(name, scriptFetcher.get(), params, clazz, extensionLogger);
    }

    public void executeScriptAsync(String path, String name, String hash, Supplier<String> scriptFetcher, Map<String, Object> params, ExtensionLogger extensionLogger) {
        Optional.ofNullable((Executor)this.asyncExecutors.get((Object)path, key -> (Executor)this.executorSupplier.get())).ifPresent(it -> it.execute(() -> this.lambda$executeScriptAsync$2(name, hash, (Supplier)scriptFetcher, params, extensionLogger, path)));
    }

    public <T> T executeScript(String name, String script, Map<String, Object> params, Class<T> clazz, ExtensionLogger extensionLogger) {
        return (T)this.executeScriptFinally(name, script, params, clazz, extensionLogger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeScriptFinally(String name, String script, Map<String, Object> params, Class<T> clazz, ExtensionLogger extensionLogger) {
        try (Context cx = Context.enter();){
            Object object;
            if (params == null) {
                params = Collections.emptyMap();
            }
            Scriptable scope = cx.newObject((Scriptable)this.sealedScope);
            scope.setPrototype((Scriptable)this.sealedScope);
            scope.setParentScope(null);
            scope.put("extensionLogger", scope, (Object)extensionLogger);
            scope.put("console", scope, (Object)new ConsoleLogger(extensionLogger));
            scope.put("Java", scope, (Object)new JavaClassInterop(Map.of("alfio.model.CustomerName", CustomerName.class), scope));
            scope.put("returnClass", scope, clazz);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object value = entry.getValue();
                if (entry.getKey().equals(EXTENSION_CONFIGURATION_PARAMETERS)) {
                    scope.put(entry.getKey(), scope, this.convertExtensionParameters(scope, value));
                    continue;
                }
                scope.put(entry.getKey(), scope, Context.javaToJS((Object)value, (Scriptable)scope));
            }
            Object res = cx.evaluateString(scope, script, name, 1, null);
            extensionLogger.logSuccess("Script executed successfully.");
            if (res instanceof NativeJavaObject) {
                NativeJavaObject nativeRes = (NativeJavaObject)res;
                object = nativeRes.unwrap();
                return (T)object;
            }
            if (clazz.isInstance(res)) {
                object = res;
                return (T)object;
            }
            object = null;
            return (T)object;
        }
        catch (EcmaError ex) {
            log.warn("Syntax error detected in script " + name, (Throwable)ex);
            extensionLogger.logError("Syntax error while executing script: " + ex.getMessage() + "(" + ex.lineNumber() + ":" + ex.columnNumber() + ")");
            throw new InvalidScriptException("Syntax error in script " + name);
        }
        catch (WrappedException ex) {
            Throwable actualException = ex.getWrappedException();
            String message = this.getErrorMessage(actualException);
            extensionLogger.logError("Error from script: " + message);
            throw new AlfioScriptingException(message, actualException);
        }
        catch (JavaScriptException ex) {
            String message = ex.getValue() != null ? ex.details() : ex.getMessage();
            extensionLogger.logError(message);
            throw new ScriptRuntimeException(message, (Throwable)ex);
        }
        catch (OutOfBoundariesException ex) {
            throw ex;
        }
        catch (Exception ex) {
            extensionLogger.logError("Error while executing script: " + ex.getMessage());
            throw new IllegalStateException(ex);
        }
    }

    String getErrorMessage(Throwable ex) {
        if (ex.getMessage() != null) {
            return ex.getMessage();
        }
        Throwable root = ex;
        String lastMessage = root.getMessage();
        while (root.getCause() != null) {
            if ((root = root.getCause()) instanceof ConnectException) {
                return CONNECT_EXCEPTION_MESSAGE;
            }
            if (root.getMessage() == null) continue;
            lastMessage = root.getMessage();
        }
        return Objects.requireNonNullElse(lastMessage, DEFAULT_ERROR_MESSAGE);
    }

    private Object convertExtensionParameters(Scriptable context, Object extensionParameters) {
        return ((Map)extensionParameters).entrySet().stream().map(entry -> Map.entry(entry.getKey(), ScriptRuntime.toObject((Scriptable)context, entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private /* synthetic */ void lambda$executeScriptAsync$2(String name, String hash, Supplier scriptFetcher, Map params, ExtensionLogger extensionLogger, String path) {
        try {
            this.executeScript(name, hash, scriptFetcher, params, Object.class, extensionLogger);
        }
        catch (AlfioScriptingException | IllegalStateException ex) {
            HashMap paramsCopy = new HashMap(params);
            paramsCopy.remove(EXTENSION_CONFIGURATION_PARAMETERS);
            Map metadata = Map.of(EXTENSION_NAME, name, EXTENSION_PATH, path, EXTENSION_PARAMS, paramsCopy);
            boolean scheduled = (Boolean)AdminJobManager.executionScheduler((AdminJobExecutor.JobName)AdminJobExecutor.JobName.EXECUTE_EXTENSION, metadata, (ZonedDateTime)ZonedDateTime.now(ClockProvider.clock()).plusSeconds(2L)).apply(this.adminJobQueueRepository);
            if (!scheduled) {
                log.warn("Cannot schedule extension {} for retry", (Object)name);
                throw ex;
            }
            log.warn("Error while executing extension " + name + ", which has been scheduled for retry", ex);
        }
    }

    static {
        ContextFactory.initGlobal((ContextFactory)new SandboxContextFactory());
    }
}

