/*
 * Decompiled with CFR 0.152.
 */
package alfio.extension;

import alfio.extension.ExtensionUtils;
import alfio.extension.SimpleHttpClientCachedResponse;
import alfio.extension.SimpleHttpClientResponse;
import alfio.util.HttpUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleHttpClient {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpClient.class);
    private static final Set<String> NULL_REQUEST_BODY = Set.of("GET", "HEAD");
    private final HttpClient httpClient;

    public SimpleHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public SimpleHttpClientResponse get(String url) throws IOException {
        return this.get(url, Collections.emptyMap());
    }

    public SimpleHttpClientResponse get(String url, Map<String, String> headers) throws IOException {
        return this.doRequest(url, headers, "GET", null);
    }

    public SimpleHttpClientResponse head(String url) throws IOException {
        return this.head(url, Collections.emptyMap());
    }

    public SimpleHttpClientResponse head(String url, Map<String, String> headers) throws IOException {
        return this.doRequest(url, headers, "HEAD", null);
    }

    public SimpleHttpClientResponse post(String url) throws IOException {
        return this.post(url, Collections.emptyMap());
    }

    public SimpleHttpClientResponse post(String url, Map<String, String> headers) throws IOException {
        return this.post(url, headers, null);
    }

    public SimpleHttpClientResponse post(String url, Map<String, String> headers, Object body) throws IOException {
        return this.postJSON(url, headers, body);
    }

    public SimpleHttpClientResponse postJSON(String url, Map<String, String> headers, Object body) throws IOException {
        return this.doRequest(url, headers, "POST", body);
    }

    public SimpleHttpClientResponse postForm(String url, Map<String, String> headers, Map<String, String> params) throws IOException {
        HttpRequest request = SimpleHttpClient.buildUrlAndHeader((String)url, headers, (String)"application/x-www-form-urlencoded").POST(HttpUtils.ofFormUrlEncodedBody(params)).build();
        return this.callRemote(request);
    }

    public SimpleHttpClientCachedResponse postFileAndSaveResponse(String url, Map<String, String> headers, String file, String filename, String contentType) throws IOException {
        HttpUtils.MultiPartBodyPublisher mpb = new HttpUtils.MultiPartBodyPublisher();
        mpb.addPart("file", () -> {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }, filename, contentType);
        HttpRequest request = SimpleHttpClient.buildUrlAndHeader((String)url, headers, (String)("multipart/form-data;boundary=\"" + mpb.getBoundary() + "\"")).POST(mpb.build()).build();
        return this.callRemoteAndSaveResponse(request);
    }

    public SimpleHttpClientCachedResponse postBodyAndSaveResponse(String url, Map<String, String> headers, String content, String contentType) throws IOException {
        HttpRequest request = SimpleHttpClient.buildUrlAndHeader((String)url, headers, (String)contentType).POST(HttpRequest.BodyPublishers.ofString(content)).build();
        return this.callRemoteAndSaveResponse(request);
    }

    public SimpleHttpClientResponse delete(String url) throws IOException {
        return this.delete(url, Collections.emptyMap());
    }

    public SimpleHttpClientResponse delete(String url, Map<String, String> headers) throws IOException {
        return this.delete(url, headers, null);
    }

    public SimpleHttpClientResponse delete(String url, Map<String, String> headers, Object body) throws IOException {
        return this.doRequest(url, headers, "DELETE", body);
    }

    public SimpleHttpClientResponse put(String url) throws IOException {
        return this.put(url, Collections.emptyMap());
    }

    public SimpleHttpClientResponse put(String url, Map<String, String> headers) throws IOException {
        return this.put(url, headers, null);
    }

    public SimpleHttpClientResponse put(String url, Map<String, String> headers, Object body) throws IOException {
        return this.doRequest(url, headers, "PUT", body);
    }

    public SimpleHttpClientResponse patch(String url) throws IOException {
        return this.patch(url, Collections.emptyMap());
    }

    public SimpleHttpClientResponse patch(String url, Map<String, String> headers) throws IOException {
        return this.patch(url, headers, null);
    }

    public SimpleHttpClientResponse patch(String url, Map<String, String> headers, Object body) throws IOException {
        return this.doRequest(url, headers, "PATCH", body);
    }

    public SimpleHttpClientResponse method(String method, String url, Map<String, String> headers, Object body) throws IOException {
        return this.doRequest(url, headers, method, body);
    }

    private SimpleHttpClientResponse doRequest(String url, Map<String, String> headers, String method, Object requestBody) throws IOException {
        HttpRequest request = SimpleHttpClient.buildUrlAndHeader((String)url, headers, (String)(NULL_REQUEST_BODY.contains(method) ? null : "application/json")).method(method, SimpleHttpClient.buildRequestBody((Object)requestBody)).build();
        return this.callRemote(request);
    }

    private SimpleHttpClientResponse callRemote(HttpRequest request) throws IOException {
        HttpResponse<String> response = null;
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            SimpleHttpClient.logInterruption((InterruptedException)exception);
        }
        if (response != null) {
            return new SimpleHttpClientResponse(HttpUtils.callSuccessful(response), response.statusCode(), response.headers().map(), response.body());
        }
        return new SimpleHttpClientResponse(false, 0, Map.of(), "");
    }

    private static void logInterruption(InterruptedException exception) {
        log.warn("HTTP request interrupted", (Throwable)exception);
    }

    private SimpleHttpClientCachedResponse callRemoteAndSaveResponse(HttpRequest request) throws IOException {
        InputStream body;
        HttpResponse<InputStream> response = null;
        try {
            response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            SimpleHttpClient.logInterruption((InterruptedException)exception);
            throw new IllegalStateException(exception);
        }
        Path tempFile = null;
        if (HttpUtils.callSuccessful(response) && (body = response.body()) != null) {
            tempFile = Files.createTempFile("extension-out", ".tmp", new FileAttribute[0]);
            try (FileOutputStream out = new FileOutputStream(tempFile.toFile());){
                body.transferTo(out);
            }
        }
        return new SimpleHttpClientCachedResponse(HttpUtils.callSuccessful(response), response.statusCode(), response.headers().map(), tempFile != null ? tempFile.toAbsolutePath().toString() : null);
    }

    public String basicCredentials(String username, String password) {
        return HttpUtils.basicAuth((String)username, (String)password);
    }

    private static HttpRequest.Builder buildUrlAndHeader(String url, Map<?, ?> headers, String contentType) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        requestBuilder.uri(URI.create(url));
        if (headers != null) {
            headers.forEach((k, v) -> requestBuilder.header(String.valueOf(k), String.valueOf(v)));
        }
        if (contentType != null) {
            requestBuilder.header("Content-Type", contentType);
        }
        return requestBuilder;
    }

    private static HttpRequest.BodyPublisher buildRequestBody(Object body) {
        return body == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(ExtensionUtils.convertToJson((Object)body));
    }
}

