/*
 * Decompiled with CFR 0.152.
 */
package alfio.extension.support;

import alfio.extension.exception.ExecutionTimeoutException;
import alfio.extension.support.SandboxContextFactory;
import alfio.extension.support.SandboxWrapFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class SandboxContextFactory
extends ContextFactory {
    protected Context makeContext() {
        MyContext cx = new MyContext(ContextFactory.getGlobal());
        cx.setWrapFactory((WrapFactory)new SandboxWrapFactory());
        cx.setOptimizationLevel(-1);
        cx.setInstructionObserverThreshold(10000);
        return cx;
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        MyContext mcx = (MyContext)cx;
        long currentTime = System.currentTimeMillis();
        long executionTime = currentTime - mcx.startTime;
        if (executionTime > 15000L) {
            throw new ExecutionTimeoutException("Script execution timeout.");
        }
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        MyContext mcx = (MyContext)cx;
        mcx.startTime = System.currentTimeMillis();
        return super.doTopCall(callable, cx, scope, thisObj, args);
    }

    protected boolean hasFeature(Context cx, int featureIndex) {
        if (featureIndex == 21) {
            return true;
        }
        return super.hasFeature(cx, featureIndex);
    }
}

