/*
 * Decompiled with CFR 0.152.
 */
package alfio.job;

import alfio.manager.AdminReservationRequestManager;
import alfio.manager.FileUploadManager;
import alfio.manager.NotificationManager;
import alfio.manager.SpecialPriceTokenGenerator;
import alfio.manager.TicketReservationManager;
import alfio.manager.WaitingQueueSubscriptionProcessor;
import alfio.manager.system.AdminJobExecutor;
import alfio.manager.system.AdminJobManager;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"migrator"})
@Profile(value={"!disable-jobs"})
public class Jobs {
    private static final Logger log = LoggerFactory.getLogger(Jobs.class);
    private static final int ONE_MINUTE = 60000;
    private static final int THIRTY_SECONDS = 30000;
    private static final int FIVE_SECONDS = 5000;
    private static final int THIRTY_MINUTES = 1800000;
    private static final String EVERY_HOUR = "0 0 0/1 * * ?";
    private final AdminReservationRequestManager adminReservationRequestManager;
    private final FileUploadManager fileUploadManager;
    private final NotificationManager notificationManager;
    private final SpecialPriceTokenGenerator specialPriceTokenGenerator;
    private final TicketReservationManager ticketReservationManager;
    private final WaitingQueueSubscriptionProcessor waitingQueueSubscriptionProcessor;
    private final AdminJobManager adminJobManager;

    @Scheduled(fixedRate=3600000L)
    public void cleanupUnreferencedBlobFiles() {
        log.trace("running job cleanupUnreferencedBlobFiles");
        try {
            this.fileUploadManager.cleanupUnreferencedBlobFiles(DateUtils.addDays((Date)new Date(), (int)-1));
        }
        finally {
            log.trace("end job cleanupUnreferencedBlobFiles");
        }
    }

    @Scheduled(fixedRate=30000L)
    public void generateSpecialPriceCodes() {
        log.trace("running job generateSpecialPriceCodes");
        try {
            this.specialPriceTokenGenerator.generatePendingCodes();
        }
        finally {
            log.trace("end job generateSpecialPriceCodes");
        }
    }

    @Scheduled(cron="0 0 0/1 * * ?")
    public void sendOfflinePaymentReminderToEventOrganizers() {
        log.trace("running job sendOfflinePaymentReminderToEventOrganizers");
        try {
            this.adminJobManager.scheduleExecution(AdminJobExecutor.JobName.SEND_OFFLINE_PAYMENT_TO_ORGANIZER, Map.of());
        }
        finally {
            log.trace("end job sendOfflinePaymentReminderToEventOrganizers");
        }
    }

    @Scheduled(cron="0 0 0/1 * * ?")
    public void assignTicketsToSubscribers() {
        log.trace("running job assignTicketsToSubscribers");
        try {
            this.adminJobManager.scheduleExecution(AdminJobExecutor.JobName.ASSIGN_TICKETS_TO_SUBSCRIBERS, Map.of());
        }
        finally {
            log.trace("end job assignTicketsToSubscribers");
        }
    }

    @Scheduled(fixedRate=5000L)
    public void sendEmails() {
        log.trace("running job sendEmails");
        try {
            this.notificationManager.sendWaitingMessages();
        }
        finally {
            log.trace("end job sendEmails");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=5000L)
    public void processReservationRequests() {
        log.trace("running job processReservationRequests");
        try {
            long start = System.currentTimeMillis();
            Pair result = this.adminReservationRequestManager.processPendingReservations();
            if ((Integer)result.getLeft() > 0 || (Integer)result.getRight() > 0) {
                log.info("ProcessReservationRequests: got {} success and {} failures. Elapsed {} ms", new Object[]{result.getLeft(), result.getRight(), System.currentTimeMillis() - start});
            }
        }
        finally {
            log.trace("end job processReservationRequests");
        }
    }

    @Scheduled(fixedRate=1800000L)
    public void sendOfflinePaymentReminder() {
        log.trace("running job sendOfflinePaymentReminder");
        try {
            this.adminJobManager.scheduleExecution(AdminJobExecutor.JobName.SEND_OFFLINE_PAYMENT_REMINDER, Map.of());
        }
        finally {
            log.trace("end job sendOfflinePaymentReminder");
        }
    }

    @Scheduled(fixedRate=1800000L)
    public void sendTicketAssignmentReminder() {
        log.trace("running job sendTicketAssignmentReminder");
        try {
            this.adminJobManager.scheduleExecution(AdminJobExecutor.JobName.SEND_TICKET_ASSIGNMENT_REMINDER, Map.of());
        }
        finally {
            log.trace("end job sendTicketAssignmentReminder");
        }
    }

    @Scheduled(fixedRate=30000L)
    public void cleanupExpiredPendingReservation() {
        log.trace("running job cleanupExpiredPendingReservation");
        try {
            Date expirationDate = DateUtils.addMinutes((Date)new Date(), (int)-10);
            this.ticketReservationManager.cleanupExpiredReservations(expirationDate);
            this.ticketReservationManager.cleanupExpiredOfflineReservations(expirationDate);
            this.ticketReservationManager.markExpiredInPaymentReservationAsStuck(expirationDate);
        }
        finally {
            log.trace("end job cleanupExpiredPendingReservation");
        }
    }

    @Scheduled(fixedRate=30000L)
    public void processReleasedTickets() {
        log.trace("running job processReleasedTickets");
        try {
            this.waitingQueueSubscriptionProcessor.handleWaitingTickets();
        }
        finally {
            log.trace("end job processReleasedTickets");
        }
    }

    @Scheduled(fixedRateString="#{environment.acceptsProfiles('dev') ? (1000 * 60) : (30 * 60 * 1000)}")
    public void checkOfflinePaymentsStatus() {
        log.trace("running job checkOfflinePaymentsStatus");
        try {
            this.adminJobManager.scheduleExecution(AdminJobExecutor.JobName.CHECK_OFFLINE_PAYMENTS, Map.of());
        }
        finally {
            log.trace("end job checkOfflinePaymentsStatus");
        }
    }

    @ConstructorProperties(value={"adminReservationRequestManager", "fileUploadManager", "notificationManager", "specialPriceTokenGenerator", "ticketReservationManager", "waitingQueueSubscriptionProcessor", "adminJobManager"})
    @Generated
    public Jobs(AdminReservationRequestManager adminReservationRequestManager, FileUploadManager fileUploadManager, NotificationManager notificationManager, SpecialPriceTokenGenerator specialPriceTokenGenerator, TicketReservationManager ticketReservationManager, WaitingQueueSubscriptionProcessor waitingQueueSubscriptionProcessor, AdminJobManager adminJobManager) {
        this.adminReservationRequestManager = adminReservationRequestManager;
        this.fileUploadManager = fileUploadManager;
        this.notificationManager = notificationManager;
        this.specialPriceTokenGenerator = specialPriceTokenGenerator;
        this.ticketReservationManager = ticketReservationManager;
        this.waitingQueueSubscriptionProcessor = waitingQueueSubscriptionProcessor;
        this.adminJobManager = adminJobManager;
    }
}

