/*
 * Decompiled with CFR 0.152.
 */
package alfio.job.executor;

import alfio.manager.AdminReservationRequestManager;
import alfio.manager.system.AdminJobExecutor;
import alfio.manager.system.ConfigurationManager;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.FieldNameAndValue;
import alfio.model.TicketCategory;
import alfio.model.modification.AdminReservationModification;
import alfio.model.modification.DateTimeModification;
import alfio.model.subscription.AvailableSubscriptionsByEvent;
import alfio.model.system.AdminJobSchedule;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.EventRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.util.ClockProvider;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AssignTicketToSubscriberJobExecutor
implements AdminJobExecutor {
    public static final String EVENT_ID = "eventId";
    public static final String ORGANIZATION_ID = "organizationId";
    public static final String FORCE_GENERATION = "forceGeneration";
    private static final Logger log = LoggerFactory.getLogger(AssignTicketToSubscriberJobExecutor.class);
    private final AdminReservationRequestManager requestManager;
    private final ConfigurationManager configurationManager;
    private final SubscriptionRepository subscriptionRepository;
    private final EventRepository eventRepository;
    private final ClockProvider clockProvider;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;

    public AssignTicketToSubscriberJobExecutor(AdminReservationRequestManager requestManager, ConfigurationManager configurationManager, SubscriptionRepository subscriptionRepository, EventRepository eventRepository, ClockProvider clockProvider, TicketCategoryRepository ticketCategoryRepository, PurchaseContextFieldRepository purchaseContextFieldRepository) {
        this.requestManager = requestManager;
        this.configurationManager = configurationManager;
        this.subscriptionRepository = subscriptionRepository;
        this.eventRepository = eventRepository;
        this.clockProvider = clockProvider;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
    }

    public Set<AdminJobExecutor.JobName> getJobNames() {
        return EnumSet.of(AdminJobExecutor.JobName.ASSIGN_TICKETS_TO_SUBSCRIBERS);
    }

    public String process(AdminJobSchedule schedule) {
        Map metadata = schedule.getMetadata();
        log.debug("Executing AssignTicketToSubscribers with metadata {}", (Object)metadata);
        Map subscriptionsByEvent = this.subscriptionRepository.loadAvailableSubscriptionsByEvent((Integer)metadata.get("eventId"), (Integer)metadata.get("organizationId"));
        if (!subscriptionsByEvent.isEmpty()) {
            boolean forceGeneration = Boolean.TRUE.equals(metadata.get("forceGeneration"));
            Set ids = subscriptionsByEvent.keySet();
            Map fieldsByEventId = this.purchaseContextFieldRepository.findAdditionalFieldNamesForEvents(ids);
            this.eventRepository.findByIds(ids).forEach(event -> {
                boolean generationEnabled;
                boolean bl = generationEnabled = forceGeneration || this.configurationManager.getFor(ConfigurationKeys.GENERATE_TICKETS_FOR_SUBSCRIPTIONS, event.getConfigurationLevel()).getValueAsBooleanOrDefault();
                if (generationEnabled) {
                    List subscriptions = (List)subscriptionsByEvent.get(event.getId());
                    List availableCategories = this.ticketCategoryRepository.findAllWithAvailableTickets(event.getId());
                    if (CollectionUtils.isNotEmpty((Collection)availableCategories)) {
                        String requestId = String.format("AUTO_%s_%s", event.getShortName(), LocalDateTime.now(this.clockProvider.getClock()).format(DateTimeFormatter.ISO_DATE_TIME));
                        this.requestManager.insertRequest(requestId, this.buildBody(event, subscriptions, availableCategories, fieldsByEventId.getOrDefault(event.getId(), Set.of())), (EventAndOrganizationId)event, false, "admin");
                    } else {
                        log.warn("Cannot find a suitable ticket category for event {}", (Object)event.getId());
                    }
                }
            });
        } else {
            log.debug("No subscriptions found for metadata {}", (Object)metadata);
        }
        return null;
    }

    private AdminReservationModification buildBody(Event event, List<AvailableSubscriptionsByEvent> subscriptions, List<TicketCategory> availableCategories, Set<String> fieldsForEvent) {
        Clock clock = this.clockProvider.getClock();
        Map<UUID, List<AvailableSubscriptionsByEvent>> subscriptionsByDescriptor = subscriptions.stream().collect(Collectors.groupingBy(AvailableSubscriptionsByEvent::getDescriptorId));
        List tickets = subscriptionsByDescriptor.values().stream().flatMap(availableSubscriptionsByEvents -> {
            AvailableSubscriptionsByEvent firstValue = (AvailableSubscriptionsByEvent)availableSubscriptionsByEvents.get(0);
            Optional<TicketCategory> categoryOptional = availableCategories.stream().filter(c -> CollectionUtils.isEmpty((Collection)firstValue.getCompatibleCategoryIds()) || firstValue.getCompatibleCategoryIds().contains(c.getId())).findFirst();
            if (categoryOptional.isEmpty()) {
                Set categoriesIds = availableCategories.stream().map(TicketCategory::getId).collect(Collectors.toSet());
                log.warn("Skipping descriptor {}. No compatible category found (wanted: one of {}, available: {})", new Object[]{firstValue.getDescriptorId(), firstValue.getCompatibleCategoryIds(), categoriesIds});
            }
            return categoryOptional.stream().map(category -> new AdminReservationModification.TicketsInfo(new AdminReservationModification.Category(Integer.valueOf(category.getId()), category.getName(), category.getPrice(), category.getTicketAccessType()), this.toAttendees(availableSubscriptionsByEvents, fieldsForEvent), false, Boolean.valueOf(false)));
        }).collect(Collectors.toList());
        return new AdminReservationModification(new DateTimeModification(LocalDate.now(clock), LocalTime.now(clock).plusMinutes(5L)), new AdminReservationModification.CustomerData("", "", "", null, "", null, null, null, null), tickets, ((ContentLanguage)event.getContentLanguages().get(0)).getLanguage(), Boolean.valueOf(false), Boolean.valueOf(false), null, new AdminReservationModification.Notification(false, true), null, null);
    }

    private List<AdminReservationModification.Attendee> toAttendees(List<AvailableSubscriptionsByEvent> subscriptions, Set<String> fieldsForEvent) {
        return subscriptions.stream().map(s -> {
            Map<Object, Object> metadata = Map.of();
            if (!s.getEmailAddress().strip().equalsIgnoreCase(s.getReservationEmail().strip())) {
                metadata = Map.of("sendTicketCc", "[\"" + s.getReservationEmail() + "\"]");
            }
            return new AdminReservationModification.Attendee(null, s.getFirstName(), s.getLastName(), s.getEmailAddress(), s.getUserLanguage(), Boolean.valueOf(false), s.getSubscriptionId() + "_auto", s.getSubscriptionId(), AssignTicketToSubscriberJobExecutor.parseExistingFields((AvailableSubscriptionsByEvent)s, (Set)fieldsForEvent), metadata);
        }).collect(Collectors.toList());
    }

    private static Map<String, List<String>> parseExistingFields(AvailableSubscriptionsByEvent s, Set<String> eventFieldNames) {
        return s.getAdditionalFields().stream().filter(f -> eventFieldNames.contains(f.getName())).collect(Collectors.groupingBy(FieldNameAndValue::getName, Collectors.mapping(FieldNameAndValue::getValue, Collectors.toList())));
    }
}

