/*
 * Decompiled with CFR 0.152.
 */
package alfio.job.executor;

import alfio.manager.BillingDocumentManager;
import alfio.manager.NotificationManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.system.AdminJobExecutor;
import alfio.model.BillingDocument;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.system.AdminJobSchedule;
import alfio.model.user.Organization;
import alfio.repository.EventRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.RenderedTemplate;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class BillingDocumentJobExecutor
implements AdminJobExecutor {
    private final BillingDocumentManager billingDocumentManager;
    private final TicketReservationManager ticketReservationManager;
    private final EventRepository eventRepository;
    private final NotificationManager notificationManager;
    private final OrganizationRepository organizationRepository;

    public Set<AdminJobExecutor.JobName> getJobNames() {
        return EnumSet.of(AdminJobExecutor.JobName.REGENERATE_INVOICES);
    }

    public String process(AdminJobSchedule schedule) {
        Map metadata = schedule.getMetadata();
        int eventId = Objects.requireNonNull((Integer)metadata.get("eventId"));
        String username = (String)metadata.get("username");
        Event event = this.eventRepository.findById(eventId);
        AtomicInteger counter = new AtomicInteger();
        Pattern.compile(",").splitAsStream(Objects.requireNonNull((String)metadata.get("ids"))).map(String::trim).map(Long::valueOf).forEach(id -> {
            BillingDocument billingDocument = (BillingDocument)this.billingDocumentManager.getDocumentById(id.longValue()).orElseThrow();
            TicketReservation reservation = (TicketReservation)this.ticketReservationManager.findById(billingDocument.getReservationId()).orElseThrow();
            this.billingDocumentManager.createBillingDocument((PurchaseContext)event, reservation, username, this.ticketReservationManager.orderSummaryForReservation(reservation, (PurchaseContext)event));
            counter.incrementAndGet();
        });
        if (counter.get() > 0) {
            Organization organization = this.organizationRepository.getById(event.getOrganizationId());
            this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, organization.getEmail(), "Invoice Regeneration complete", () -> RenderedTemplate.plaintext((String)("Invoice regeneration for event " + event.getDisplayName() + " is now complete. " + counter.get() + " invoices generated."), Map.of()));
        }
        return "generated";
    }

    @ConstructorProperties(value={"billingDocumentManager", "ticketReservationManager", "eventRepository", "notificationManager", "organizationRepository"})
    @Generated
    public BillingDocumentJobExecutor(BillingDocumentManager billingDocumentManager, TicketReservationManager ticketReservationManager, EventRepository eventRepository, NotificationManager notificationManager, OrganizationRepository organizationRepository) {
        this.billingDocumentManager = billingDocumentManager;
        this.ticketReservationManager = ticketReservationManager;
        this.eventRepository = eventRepository;
        this.notificationManager = notificationManager;
        this.organizationRepository = organizationRepository;
    }
}

