/*
 * Decompiled with CFR 0.152.
 */
package alfio.job.executor;

import alfio.extension.ExtensionService;
import alfio.manager.system.AdminJobExecutor;
import alfio.model.system.AdminJobSchedule;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryFailedExtensionJobExecutor
implements AdminJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(RetryFailedExtensionJobExecutor.class);
    private final ExtensionService extensionService;

    public RetryFailedExtensionJobExecutor(ExtensionService extensionService) {
        this.extensionService = extensionService;
    }

    public Set<AdminJobExecutor.JobName> getJobNames() {
        return EnumSet.of(AdminJobExecutor.JobName.EXECUTE_EXTENSION);
    }

    public String process(AdminJobSchedule schedule) {
        Map metadata = schedule.getMetadata();
        String name = (String)metadata.get("extensionName");
        String path = (String)metadata.get("path");
        Map payload = (Map)metadata.get("params");
        try {
            this.extensionService.retryFailedAsyncScript(path, name, payload);
        }
        catch (RuntimeException ex) {
            log.warn("Caught error while retrying extension " + name, (Throwable)ex);
            throw ex;
        }
        return "OK";
    }
}

