/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.config.authentication.support.APITokenAuthentication;
import alfio.controller.form.ReservationCreate;
import alfio.manager.support.AccessDeniedException;
import alfio.model.EventAndOrganizationId;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.ReservationIdAndEventId;
import alfio.model.Ticket;
import alfio.model.modification.AdditionalServiceReservationModification;
import alfio.model.modification.GroupModification;
import alfio.model.modification.PromoCodeDiscountModification;
import alfio.model.modification.ReservationRequest;
import alfio.model.subscription.LinkEventsToSubscriptionRequest;
import alfio.model.subscription.LinkSubscriptionsToEventRequest;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.user.Organization;
import alfio.model.user.Role;
import alfio.model.user.User;
import alfio.repository.AdditionalServiceRepository;
import alfio.repository.BillingDocumentRepository;
import alfio.repository.EventRepository;
import alfio.repository.GroupRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.WaitingQueueRepository;
import alfio.repository.user.AuthorityRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.UserRepository;
import alfio.repository.user.join.UserOrganizationRepository;
import alfio.util.MiscUtils;
import java.security.Principal;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional(readOnly=true)
public class AccessService {
    private static final Logger log = LogManager.getLogger(AccessService.class);
    private final UserRepository userRepository;
    private final EventRepository eventRepository;
    private final AuthorityRepository authorityRepository;
    private final UserOrganizationRepository userOrganizationRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final TicketReservationRepository reservationRepository;
    private final TicketRepository ticketRepository;
    private final BillingDocumentRepository billingDocumentRepository;
    private final GroupRepository groupRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final PromoCodeDiscountRepository promoCodeDiscountRepository;
    private final OrganizationRepository organizationRepository;
    private final AdditionalServiceRepository additionalServiceRepository;
    private final WaitingQueueRepository waitingQueueRepository;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    public static final Set<Role> MEMBERSHIP_ROLES = Set.of(Role.ADMIN, Role.OWNER, Role.API_CONSUMER, Role.SUPERVISOR);
    public static final Set<Role> CHECKIN_ROLES = Set.of(Role.ADMIN, Role.OWNER, Role.API_CONSUMER, Role.SUPERVISOR, Role.OPERATOR);

    public AccessService(UserRepository userRepository, AuthorityRepository authorityRepository, UserOrganizationRepository userOrganizationRepository, EventRepository eventRepository, SubscriptionRepository subscriptionRepository, TicketReservationRepository reservationRepository, TicketRepository ticketRepository, BillingDocumentRepository billingDocumentRepository, GroupRepository groupRepository, TicketCategoryRepository ticketCategoryRepository, PromoCodeDiscountRepository promoCodeDiscountRepository, OrganizationRepository organizationRepository, AdditionalServiceRepository additionalServiceRepository, WaitingQueueRepository waitingQueueRepository, PurchaseContextFieldRepository purchaseContextFieldRepository) {
        this.userRepository = userRepository;
        this.authorityRepository = authorityRepository;
        this.userOrganizationRepository = userOrganizationRepository;
        this.eventRepository = eventRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.reservationRepository = reservationRepository;
        this.ticketRepository = ticketRepository;
        this.billingDocumentRepository = billingDocumentRepository;
        this.groupRepository = groupRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.promoCodeDiscountRepository = promoCodeDiscountRepository;
        this.organizationRepository = organizationRepository;
        this.additionalServiceRepository = additionalServiceRepository;
        this.waitingQueueRepository = waitingQueueRepository;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
    }

    public void checkAccessToUser(Principal principal, Integer userId) {
        if (userId == null || principal == null) {
            throw new AccessDeniedException();
        }
        if (this.isAdmin(principal) || AccessService.isSystemApiUser((Principal)principal)) {
            log.trace("principal {} identified as ADMIN is allowed to retrieve user details for user {}", (Object)principal.getName(), (Object)userId);
            return;
        }
        User targetUser = (User)this.userRepository.findOptionalById(userId.intValue()).orElseThrow(AccessDeniedException::new);
        if (targetUser.getUsername().equals("admin") || this.checkRole(targetUser.getUsername(), EnumSet.of(Role.ADMIN))) {
            throw new AccessDeniedException();
        }
        List targetUserOrgs = this.organizationRepository.findAllForUser(targetUser.getUsername());
        if (targetUserOrgs.size() != 1) {
            log.warn("denied access to user {} which is member of {} organizations", (Object)targetUser.getUsername(), (Object)targetUserOrgs.size());
            throw new AccessDeniedException();
        }
        for (Organization targetUserOrg : targetUserOrgs) {
            this.checkOrganizationOwnership(principal, Integer.valueOf(targetUserOrg.getId()));
        }
    }

    public void checkOrganizationMembership(Principal principal, int organizationId, Set<Role> roles) {
        if (principal == null) {
            log.trace("No user present, we will allow it");
            return;
        }
        if (AccessService.isSystemApiUser((Principal)principal)) {
            log.trace("Allowing ownership to Organization {} to System API Key", (Object)organizationId);
            return;
        }
        if (this.hasRole(principal, organizationId, roles)) {
            log.trace("Allowing ownership to Organization {} to user {}", (Object)organizationId, (Object)principal.getName());
            return;
        }
        log.warn("User {} is NOT an owner or supervisor of organizationId {}", (Object)principal.getName(), (Object)organizationId);
        throw new AccessDeniedException();
    }

    public void checkOrganizationOwnership(Principal principal, Integer organizationId) {
        if (principal == null) {
            log.trace("No user present, we will allow it");
            return;
        }
        if (AccessService.isSystemApiUser((Principal)principal)) {
            log.trace("Allowing ownership to Organization {} to System API Key", (Object)organizationId);
            return;
        }
        if (organizationId == null && this.isAdmin(principal)) {
            log.trace("Allowing Organization create to ADMIN");
            return;
        }
        if (organizationId != null && this.isOwnerOfOrganization(principal, organizationId.intValue())) {
            log.trace("Allowing ownership to Organization {} to user {}", (Object)organizationId, (Object)principal.getName());
            return;
        }
        log.warn("User {} is NOT an owner of organizationId {}", (Object)principal.getName(), (Object)organizationId);
        throw new AccessDeniedException();
    }

    public void ensureAdmin(Principal principal) {
        if (!this.isAdmin(principal)) {
            throw new AccessDeniedException();
        }
    }

    public void ensureSystemApiKey(Principal principal) {
        if (!AccessService.isSystemApiUser((Principal)principal)) {
            throw new AccessDeniedException();
        }
    }

    public EventAndOrganizationId checkEventOwnership(Principal principal, int eventId) {
        EventAndOrganizationId eventAndOrgId = this.eventRepository.findEventAndOrganizationIdById(eventId);
        this.checkOrganizationOwnership(principal, Integer.valueOf(eventAndOrgId.getOrganizationId()));
        return eventAndOrgId;
    }

    public EventAndOrganizationId checkEventOwnership(Principal principal, int eventId, int organizationId) {
        EventAndOrganizationId eventAndOrgId = this.checkEventOwnership(principal, eventId);
        if (organizationId != eventAndOrgId.getOrganizationId()) {
            throw new AccessDeniedException();
        }
        return eventAndOrgId;
    }

    public EventAndOrganizationId checkEventOwnership(Principal principal, String eventShortName) {
        EventAndOrganizationId eventAndOrgId = (EventAndOrganizationId)this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventShortName).orElseThrow(AccessDeniedException::new);
        this.checkOrganizationOwnership(principal, Integer.valueOf(eventAndOrgId.getOrganizationId()));
        return eventAndOrgId;
    }

    public EventAndOrganizationId checkEventMembership(Principal principal, String eventShortName, Set<Role> roles) {
        EventAndOrganizationId eventAndOrgId = (EventAndOrganizationId)this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventShortName).orElseThrow(AccessDeniedException::new);
        this.checkOrganizationMembership(principal, eventAndOrgId.getOrganizationId(), roles);
        return eventAndOrgId;
    }

    public EventAndOrganizationId checkEventMembership(Principal principal, int eventId, Set<Role> roles) {
        EventAndOrganizationId eventAndOrgId = this.eventRepository.findEventAndOrganizationIdById(eventId);
        this.checkOrganizationMembership(principal, eventAndOrgId.getOrganizationId(), roles);
        return eventAndOrgId;
    }

    public EventAndOrganizationId checkCategoryOwnership(Principal principal, int eventId, int categoryId) {
        return this.checkCategoryOwnership(principal, eventId, Set.of(Integer.valueOf(categoryId)));
    }

    public EventAndOrganizationId checkCategoryOwnership(Principal principal, int eventId, Set<Integer> categoryIds) {
        EventAndOrganizationId eventAndOrganizationId = this.checkEventOwnership(principal, eventId);
        if (categoryIds.size() != this.ticketCategoryRepository.countCategoryForEvent(categoryIds, eventAndOrganizationId.getId())) {
            throw new AccessDeniedException();
        }
        return eventAndOrganizationId;
    }

    public EventAndOrganizationId checkCategoryOwnership(Principal principal, String eventShortName, Set<Integer> categoryIds) {
        EventAndOrganizationId eventAndOrganizationId = this.checkEventOwnership(principal, eventShortName);
        if (categoryIds.size() != this.ticketCategoryRepository.countCategoryForEvent(categoryIds, eventAndOrganizationId.getId())) {
            throw new AccessDeniedException();
        }
        return eventAndOrganizationId;
    }

    public EventAndOrganizationId checkCategoryOwnership(Principal principal, String eventShortName, int categoryId) {
        return this.checkCategoryOwnership(principal, eventShortName, Set.of(Integer.valueOf(categoryId)));
    }

    public void checkEventReservationCreationRequest(Principal principal, String eventShortName, ReservationCreate<? extends ReservationRequest> createRequest) {
        EventAndOrganizationId eventAndOrganizationId = this.checkEventOwnership(principal, eventShortName);
        Set categoryIds = createRequest.getTickets().stream().map(ReservationRequest::getTicketCategoryId).collect(Collectors.toSet());
        int eventId = eventAndOrganizationId.getId();
        if (categoryIds.size() != this.ticketCategoryRepository.countCategoriesBelongingToEvent(eventId, categoryIds).intValue()) {
            throw new AccessDeniedException();
        }
        Set additionalServicesIds = Objects.requireNonNullElse(createRequest.getAdditionalServices(), List.of()).stream().map(AdditionalServiceReservationModification::getAdditionalServiceId).collect(Collectors.toSet());
        if (!additionalServicesIds.isEmpty() && additionalServicesIds.size() != this.additionalServiceRepository.countAdditionalServicesBelongingToEvent(eventId, additionalServicesIds).intValue()) {
            throw new AccessDeniedException();
        }
    }

    public EventAndOrganizationId checkEventOwnership(Principal principal, String eventShortName, int organizationId) {
        EventAndOrganizationId eventAndOrganizationId = this.checkEventOwnership(principal, eventShortName);
        int orgId = eventAndOrganizationId.getOrganizationId();
        if (orgId != organizationId) {
            throw new AccessDeniedException();
        }
        return eventAndOrganizationId;
    }

    private static boolean isSystemApiUser(Principal principal) {
        APITokenAuthentication apita;
        return principal instanceof APITokenAuthentication && (apita = (APITokenAuthentication)principal).getAuthorities().stream().allMatch(authority -> authority.getAuthority().equals("ROLE_SYSTEM_API_CLIENT"));
    }

    private boolean isAdmin(Principal user) {
        return this.checkRole(user, Collections.singleton(Role.ADMIN));
    }

    private boolean isOwner(Principal principal) {
        return this.checkRole(principal, EnumSet.of(Role.ADMIN, Role.OWNER, Role.API_CONSUMER));
    }

    private boolean checkRole(Principal principal, Set<Role> expectedRoles) {
        return this.checkRole(principal.getName(), expectedRoles);
    }

    private boolean checkRole(String username, Set<Role> expectedRoles) {
        Set roleNames = expectedRoles.stream().map(Role::getRoleName).collect(Collectors.toSet());
        return this.authorityRepository.checkRole(username, roleNames);
    }

    private boolean isOwnerOfOrganization(Principal principal, int organizationId) {
        return this.userRepository.findIdByUserName(principal.getName()).filter(userId -> this.isAdmin(principal) || this.isOwner(principal) && this.userOrganizationRepository.userIsInOrganization(userId.intValue(), organizationId)).isPresent();
    }

    private boolean hasRole(Principal principal, int organizationId, Set<Role> roles) {
        return this.userRepository.findIdByUserName(principal.getName()).filter(userId -> this.isAdmin(principal) || this.checkRole(principal, roles) && this.userOrganizationRepository.userIsInOrganization(userId.intValue(), organizationId)).isPresent();
    }

    public void checkReservationOwnership(Principal principal, PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId) {
        if (purchaseContextType == PurchaseContext.PurchaseContextType.event) {
            this.checkReservationOwnershipForEvent(principal, publicIdentifier, reservationId);
        } else {
            SubscriptionDescriptor subscriptionDescriptor = (SubscriptionDescriptor)this.subscriptionRepository.findDescriptorByReservationId(reservationId).orElseThrow(AccessDeniedException::new);
            this.checkOrganizationOwnership(principal, Integer.valueOf(subscriptionDescriptor.getOrganizationId()));
            if (!subscriptionDescriptor.getPublicIdentifier().equals(publicIdentifier)) {
                throw new AccessDeniedException();
            }
        }
    }

    public void checkReservationMembership(Principal principal, PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId) {
        if (purchaseContextType == PurchaseContext.PurchaseContextType.event) {
            this.checkReservationMembershipForEvent(principal, publicIdentifier, reservationId, MEMBERSHIP_ROLES);
        } else {
            SubscriptionDescriptor subscriptionDescriptor = (SubscriptionDescriptor)this.subscriptionRepository.findDescriptorByReservationId(reservationId).orElseThrow(AccessDeniedException::new);
            this.checkOrganizationMembership(principal, subscriptionDescriptor.getOrganizationId(), MEMBERSHIP_ROLES);
            if (!subscriptionDescriptor.getPublicIdentifier().equals(publicIdentifier)) {
                throw new AccessDeniedException();
            }
        }
    }

    public void checkPurchaseContextOwnership(Principal principal, PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier) {
        if (purchaseContextType == PurchaseContext.PurchaseContextType.event) {
            this.checkEventOwnership(principal, publicIdentifier);
        } else {
            this.checkSubscriptionDescriptorOwnership(principal, publicIdentifier);
        }
    }

    public void checkPurchaseContextOwnership(Principal principal, int organizationId, Integer eventId, UUID subscriptionDescriptorId) {
        if (eventId != null) {
            this.checkEventOwnership(principal, eventId.intValue(), organizationId);
        } else {
            this.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
            int subscriptionOrg = (Integer)this.subscriptionRepository.findOrganizationIdForDescriptor(subscriptionDescriptorId).orElseThrow(AccessDeniedException::new);
            if (subscriptionOrg != organizationId) {
                throw new AccessDeniedException();
            }
        }
    }

    public EventAndOrganizationId checkDescriptorsLinkRequest(Principal principal, String eventSlug, List<LinkSubscriptionsToEventRequest> descriptorsToLink) {
        EventAndOrganizationId event = this.checkEventOwnership(principal, eventSlug);
        if (descriptorsToLink.isEmpty()) {
            return event;
        }
        List<UUID> descriptorsId = descriptorsToLink.stream().map(LinkSubscriptionsToEventRequest::getDescriptorId).toList();
        Integer count = this.subscriptionRepository.countDescriptorsBelongingToOrganization(descriptorsId, event.getOrganizationId());
        if (count == null || descriptorsToLink.size() != count.intValue()) {
            throw new AccessDeniedException();
        }
        Set categoriesToLink = descriptorsToLink.stream().flatMap(sl -> sl.getCategories().stream()).collect(Collectors.toSet());
        if (!categoriesToLink.isEmpty()) {
            count = this.ticketCategoryRepository.countCategoryForEvent(categoriesToLink, event.getId());
            if (categoriesToLink.size() != count.intValue()) {
                throw new AccessDeniedException();
            }
        }
        return event;
    }

    public void checkSubscriptionDescriptorOwnership(Principal principal, String publicIdentifier) {
        int organizationId = (Integer)this.subscriptionRepository.findOrganizationIdForDescriptor(UUID.fromString(publicIdentifier)).orElseThrow(AccessDeniedException::new);
        this.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
    }

    private void checkReservationOwnershipForEvent(Principal principal, String publicIdentifier, String reservationId) {
        EventAndOrganizationId event = (EventAndOrganizationId)this.eventRepository.findOptionalEventAndOrganizationIdByShortName(publicIdentifier).orElseThrow(AccessDeniedException::new);
        this.checkOrganizationOwnership(principal, Integer.valueOf(event.getOrganizationId()));
        List reservations = this.reservationRepository.getReservationIdAndEventId(List.of(reservationId));
        if (reservations.size() != 1 || ((ReservationIdAndEventId)reservations.get(0)).getEventId() != event.getId()) {
            throw new AccessDeniedException();
        }
    }

    private void checkReservationMembershipForEvent(Principal principal, String publicIdentifier, String reservationId, Set<Role> roles) {
        EventAndOrganizationId event = (EventAndOrganizationId)this.eventRepository.findOptionalEventAndOrganizationIdByShortName(publicIdentifier).orElseThrow(AccessDeniedException::new);
        this.checkEventMembership(principal, event.getId(), roles);
        List reservations = this.reservationRepository.getReservationIdAndEventId(List.of(reservationId));
        if (reservations.size() != 1 || ((ReservationIdAndEventId)reservations.get(0)).getEventId() != event.getId()) {
            throw new AccessDeniedException();
        }
    }

    public void checkBillingDocumentOwnership(Principal principal, PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, long billingDocumentId) {
        this.checkReservationOwnership(principal, purchaseContextType, publicIdentifier, reservationId);
        if (!Boolean.TRUE.equals(this.billingDocumentRepository.checkBillingDocumentExistsForReservation(billingDocumentId, reservationId))) {
            throw new AccessDeniedException();
        }
    }

    public void checkGroupLinkOwnership(Principal principal, int groupLinkId, int organizationId, int eventId, Integer categoryId) {
        EventAndOrganizationId eventAndOrgId = this.checkEventOwnership(principal, eventId);
        if (eventAndOrgId.getOrganizationId() != organizationId) {
            throw new AccessDeniedException();
        }
        if (!Boolean.TRUE.equals(this.groupRepository.checkGroupLinkExists(groupLinkId, organizationId, eventId, categoryId))) {
            throw new AccessDeniedException();
        }
    }

    public void checkGroupOwnership(Principal principal, int groupId, int organizationId) {
        this.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        if (!Boolean.TRUE.equals(this.groupRepository.checkGroupExists(groupId, organizationId))) {
            throw new AccessDeniedException();
        }
    }

    public void checkGroupUpdateRequest(Principal principal, int groupId, int organizationId, GroupModification groupModification) {
        if (groupModification.getOrganizationId() != organizationId || groupModification.getId() != groupId) {
            throw new AccessDeniedException();
        }
        this.checkGroupOwnership(principal, groupId, organizationId);
    }

    public void checkGroupCreateRequest(Principal principal, int organizationId, GroupModification groupModification) {
        if (groupModification.getOrganizationId() != organizationId) {
            throw new AccessDeniedException();
        }
        this.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
    }

    public void checkAccessToPromoCode(Principal principal, int promoCodeId, PromoCodeDiscountModification payload) {
        int organizationId = this.checkAccessToPromoCodeEventOrganization(principal, payload.getEventId(), payload.getOrganizationId());
        if (!Boolean.TRUE.equals(this.promoCodeDiscountRepository.checkPromoCodeExists(promoCodeId, organizationId, payload.getEventId()))) {
            throw new AccessDeniedException();
        }
    }

    public void checkAccessToPromoCode(Principal principal, int promoCodeId) {
        PromoCodeDiscount promoCode = (PromoCodeDiscount)this.promoCodeDiscountRepository.findOptionalById(promoCodeId).orElseThrow(AccessDeniedException::new);
        if (promoCode.getEventId() != null) {
            this.checkEventOwnership(principal, promoCode.getEventId().intValue(), promoCode.getOrganizationId().intValue());
        } else {
            this.checkOrganizationOwnership(principal, promoCode.getOrganizationId());
        }
    }

    public int checkAccessToPromoCodeEventOrganization(Principal principal, Integer eventId, Integer organizationId) {
        if (eventId == null && organizationId == null) {
            throw new AccessDeniedException();
        }
        if (eventId != null && organizationId != null) {
            return this.checkEventOwnership(principal, eventId.intValue(), organizationId.intValue()).getOrganizationId();
        }
        if (eventId != null) {
            return this.checkEventOwnership(principal, eventId.intValue()).getOrganizationId();
        }
        this.checkOrganizationOwnership(principal, organizationId);
        return organizationId;
    }

    public void checkEventLinkRequest(Principal principal, String subscriptionId, List<LinkEventsToSubscriptionRequest> linkRequests) {
        int organizationId = (Integer)this.subscriptionRepository.findOrganizationIdForDescriptor(UUID.fromString(subscriptionId)).orElseThrow(AccessDeniedException::new);
        this.checkOrganizationOwnership(principal, Integer.valueOf(organizationId));
        Set eventSlugs = linkRequests.stream().map(LinkEventsToSubscriptionRequest::getSlug).collect(Collectors.toSet());
        if (!eventSlugs.isEmpty() && eventSlugs.size() != this.eventRepository.countEventsInOrganization(organizationId, eventSlugs).intValue()) {
            throw new AccessDeniedException();
        }
        linkRequests.forEach(request -> {
            List categoriesToLink = request.getCategories();
            if (!categoriesToLink.isEmpty()) {
                int count = this.ticketCategoryRepository.countCategoryForEvent(Set.copyOf(request.getCategories()), request.getSlug());
                if (categoriesToLink.size() != count) {
                    throw new AccessDeniedException();
                }
            }
        });
    }

    public EventAndOrganizationId canAccessEvent(Principal principal, String eventShortName) {
        EventAndOrganizationId eventAndOrgId = (EventAndOrganizationId)this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventShortName).orElseThrow(AccessDeniedException::new);
        User user = this.userRepository.getByUsername(principal.getName());
        if (!this.userOrganizationRepository.userIsInOrganization(user.getId(), eventAndOrgId.getOrganizationId())) {
            throw new AccessDeniedException();
        }
        return eventAndOrgId;
    }

    public void canAccessTicket(Principal principal, String eventShortName, String uuid) {
        EventAndOrganizationId eventAndOrgId = this.canAccessEvent(principal, eventShortName);
        Ticket ticket = this.ticketRepository.findByUUID(uuid);
        if (ticket.getEventId() != eventAndOrgId.getId()) {
            throw new AccessDeniedException();
        }
    }

    public EventAndOrganizationId checkWaitingQueueSubscriberInEvent(Principal principal, int subscriberId, String eventName) {
        EventAndOrganizationId eventAndOrgId = this.checkEventOwnership(principal, eventName);
        if (!this.waitingQueueRepository.exists(subscriberId, eventAndOrgId.getId())) {
            if (log.isWarnEnabled()) {
                log.warn("subscriberId {} does not exists in event {}", (Object)subscriberId, (Object)MiscUtils.removeTabsAndNewlines((String)eventName));
            }
            throw new AccessDeniedException();
        }
        return eventAndOrgId;
    }

    public void checkBillingDocumentsOwnership(Principal principal, Integer eventId, List<Long> documentIds) {
        this.checkEventOwnership(principal, eventId.intValue());
        if (!new HashSet<Long>(documentIds).equals(new HashSet(this.billingDocumentRepository.findByIdsAndEvent(documentIds, eventId.intValue())))) {
            log.warn("Some document ids {} are not inside eventId {}", documentIds, (Object)eventId);
            throw new AccessDeniedException();
        }
    }

    public void checkPurchaseContextOwnershipAndTicketAdditionalFieldIds(Principal principal, PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, Set<Long> additionalFieldIds) {
        this.checkPurchaseContextOwnership(principal, purchaseContextType, publicIdentifier);
        UUID subscriptionUuid = null;
        Integer eventId = null;
        if (purchaseContextType == PurchaseContext.PurchaseContextType.event) {
            eventId = ((EventAndOrganizationId)this.eventRepository.findOptionalEventAndOrganizationIdByShortName(publicIdentifier).orElseThrow()).getId();
        } else {
            subscriptionUuid = UUID.fromString(publicIdentifier);
        }
        if (additionalFieldIds.size() != this.purchaseContextFieldRepository.countMatchingAdditionalFieldsForPurchaseContext(eventId, subscriptionUuid, additionalFieldIds)) {
            if (log.isWarnEnabled()) {
                log.warn("Some additional field ids {} are not inside purchaseContext {}", additionalFieldIds, (Object)MiscUtils.removeTabsAndNewlines((String)publicIdentifier));
            }
            throw new AccessDeniedException();
        }
    }

    public void checkCategoryOwnershipAndTicket(Principal principal, String eventName, int categoryId, int ticketId) {
        this.checkCategoryOwnership(principal, eventName, categoryId);
        if (!this.ticketRepository.isInCategory(ticketId, categoryId)) {
            log.warn("Ticket with id {} is not in category id {}", (Object)ticketId, (Object)categoryId);
            throw new AccessDeniedException();
        }
    }

    public void checkEventAndReservationOwnership(Principal principal, String eventName, Set<String> reservationIds) {
        this.checkEventAndReservationOwnership(principal, eventName, reservationIds, false);
    }

    public void checkEventAndReservationOwnership(Principal principal, String eventName, Set<String> reservationIds, boolean partialIds) {
        EventAndOrganizationId eventAndOrgId = this.checkEventOwnership(principal, eventName);
        int countExisting = partialIds ? this.reservationRepository.countReservationWithShortIdsForEvent(reservationIds.stream().map(String::toLowerCase).toList(), eventAndOrgId.getId()) : this.reservationRepository.countReservationsWithEventId(reservationIds, eventAndOrgId.getId());
        if (reservationIds.size() != countExisting) {
            if (log.isWarnEnabled()) {
                log.warn("Some reservation ids {} are not in the event {}", reservationIds.stream().map(MiscUtils::removeTabsAndNewlines).collect(Collectors.toSet()), (Object)MiscUtils.removeTabsAndNewlines((String)eventName));
            }
            throw new AccessDeniedException();
        }
    }

    public void checkEventAndReservationAndTransactionOwnership(Principal principal, String eventName, String reservationId, int transactionId) {
        this.checkEventAndReservationOwnership(principal, eventName, Set.of(reservationId));
        if (!this.reservationRepository.hasReservationWithTransactionId(reservationId, transactionId)) {
            if (log.isWarnEnabled()) {
                log.warn("Reservation id {} does not have transaction id {}", (Object)MiscUtils.removeTabsAndNewlines((String)reservationId), (Object)transactionId);
            }
            throw new AccessDeniedException();
        }
    }

    public void checkTicketMembership(Principal principal, String publicIdentifier, String reservationId, int ticketId) {
        this.checkReservationMembershipForEvent(principal, publicIdentifier, reservationId, MEMBERSHIP_ROLES);
        List tickets = this.ticketRepository.findByIds(List.of(Integer.valueOf(ticketId)));
        if (tickets.size() != 1 || !((Ticket)tickets.get(0)).getTicketsReservationId().equals(reservationId)) {
            throw new AccessDeniedException();
        }
    }

    public void checkEventTicketIdentifierMembership(Principal principal, int eventId, String ticketIdentifier, Set<Role> roles) {
        this.checkEventMembership(principal, eventId, roles);
        if (!this.ticketRepository.isTicketInEvent(eventId, ticketIdentifier)) {
            if (log.isWarnEnabled()) {
                log.warn("ticket {} is not in eventId {}", (Object)MiscUtils.removeTabsAndNewlines((String)ticketIdentifier), (Object)eventId);
            }
            throw new AccessDeniedException();
        }
    }

    public EventAndOrganizationId checkEventTicketIdentifierMembership(Principal principal, String eventName, String ticketIdentifier, Set<Role> roles) {
        EventAndOrganizationId eventAndOrgId = this.checkEventMembership(principal, eventName, roles);
        if (!this.ticketRepository.isTicketInEvent(eventAndOrgId.getId(), ticketIdentifier)) {
            if (log.isWarnEnabled()) {
                log.warn("ticket {} is not in eventId {}", (Object)MiscUtils.removeTabsAndNewlines((String)ticketIdentifier), (Object)eventAndOrgId.getId());
            }
            throw new AccessDeniedException();
        }
        return eventAndOrgId;
    }

    public void checkAdditionalServiceOwnership(Principal principal, int eventId, int additionalServiceId) {
        this.checkEventOwnership(principal, eventId);
        if (!this.additionalServiceRepository.additionalServiceExistsForEvent(additionalServiceId, eventId)) {
            log.warn("denying access to additional service {}", (Object)additionalServiceId);
            throw new AccessDeniedException();
        }
    }
}

