/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.form.AdditionalServiceLinkForm;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.support.reservation.NotEnoughItemsException;
import alfio.manager.support.reservation.ReservationCostCalculator;
import alfio.model.AdditionalService;
import alfio.model.AdditionalServiceItem;
import alfio.model.AdditionalServiceItemExport;
import alfio.model.AdditionalServiceText;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.Ticket;
import alfio.model.TotalPrice;
import alfio.model.decorator.AdditionalServicePriceContainer;
import alfio.model.modification.ASReservationWithOptionalCodeModification;
import alfio.model.modification.AdditionalServiceReservationModification;
import alfio.model.modification.EventModification;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.AdditionalServiceRepository;
import alfio.repository.AdditionalServiceTextRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.TicketRepository;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.iterators.LoopingIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional
public class AdditionalServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditionalServiceManager.class);
    private final AdditionalServiceRepository additionalServiceRepository;
    private final AdditionalServiceTextRepository additionalServiceTextRepository;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final TicketRepository ticketRepository;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final ReservationCostCalculator reservationCostCalculator;

    public List<AdditionalService> loadAllForEvent(int eventId) {
        return this.additionalServiceRepository.loadAllForEvent(eventId);
    }

    public List<AdditionalServiceText> findAllTextByAdditionalServiceId(int additionalServiceId) {
        return this.additionalServiceTextRepository.findAllByAdditionalServiceId(additionalServiceId);
    }

    public Map<Integer, Map<AdditionalServiceItem.AdditionalServiceItemStatus, Integer>> countUsageForEvent(int eventId) {
        return this.additionalServiceRepository.getCount(eventId);
    }

    public int update(int additionalServiceId, Event event, EventModification.AdditionalService additionalService) {
        int result = this.additionalServiceRepository.update(additionalServiceId, additionalService.isFixPrice(), additionalService.getOrdinal(), additionalService.getAvailableQuantity(), additionalService.getMaxQtyPerOrder(), additionalService.getInception().toZonedDateTime(event.getZoneId()), additionalService.getExpiration().toZonedDateTime(event.getZoneId()), additionalService.getVat(), additionalService.getVatType(), Optional.ofNullable(additionalService.getPrice()).map(p -> MonetaryUtil.unitToCents((BigDecimal)p, (String)event.getCurrency())).orElse(0).intValue(), additionalService.getSupplementPolicy().name(), (Integer)Optional.ofNullable(additionalService.getMinPrice()).map(p -> MonetaryUtil.unitToCents((BigDecimal)p, (String)event.getCurrency())).orElse(null), (Integer)Optional.ofNullable(additionalService.getMaxPrice()).map(p -> MonetaryUtil.unitToCents((BigDecimal)p, (String)event.getCurrency())).orElse(null));
        this.preGenerateItems(additionalServiceId, event, additionalService);
        return result;
    }

    public void updateText(Integer textId, String locale, AdditionalServiceText.TextType type, String value, Integer additionalServiceId) {
        Assert.isTrue((this.additionalServiceTextRepository.update(textId.intValue(), locale, type, value, additionalServiceId.intValue()) == 1 ? 1 : 0) != 0, (String)("Error while updating the text with id " + textId + " and additionalServiceId " + additionalServiceId + ", should have affected 1 row"));
    }

    public void insertText(Integer additionalServiceId, String locale, AdditionalServiceText.TextType type, String value) {
        this.additionalServiceTextRepository.insert(additionalServiceId.intValue(), locale, type, value);
    }

    public Optional<AdditionalService> getOptionalById(int additionalServiceId, int eventId) {
        return this.additionalServiceRepository.getOptionalById(additionalServiceId, eventId);
    }

    public void deleteAdditionalService(int additionalServiceId, int eventId) {
        int deletedTexts = this.deleteAdditionalServiceTexts(additionalServiceId);
        LOGGER.debug("deleted {} texts", (Object)deletedTexts);
        int deletedItems = this.additionalServiceItemRepository.deleteByAdditionalServiceId(eventId, additionalServiceId);
        LOGGER.debug("deleted {} items", (Object)deletedItems);
        this.delete(additionalServiceId, eventId);
        LOGGER.debug("additional service #{} successfully deleted", (Object)additionalServiceId);
    }

    public int deleteAdditionalServiceTexts(int additionalServiceId) {
        return this.additionalServiceTextRepository.deleteAdditionalServiceTexts(additionalServiceId);
    }

    public void delete(int additionalServiceId, int eventId) {
        this.additionalServiceRepository.delete(additionalServiceId, eventId);
    }

    public List<AdditionalServiceItemExport> exportItemsForEvent(AdditionalService.AdditionalServiceType type, int eventId, String locale) {
        return this.additionalServiceItemRepository.getAdditionalServicesOfTypeForEvent(eventId, type.name(), locale);
    }

    public EventModification.AdditionalService insertAdditionalService(Event event, EventModification.AdditionalService additionalService) {
        int eventId = event.getId();
        AffectedRowCountAndKey result = this.additionalServiceRepository.insert(eventId, AdditionalServiceManager.evaluateAdditionalServicePriceCts((EventModification.AdditionalService)additionalService, (String)event.getCurrency()), additionalService.isFixPrice(), additionalService.getOrdinal(), additionalService.getAvailableQuantity(), additionalService.getMaxQtyPerOrder(), additionalService.getInception().toZonedDateTime(event.getZoneId()), additionalService.getExpiration().toZonedDateTime(event.getZoneId()), additionalService.getVat(), additionalService.getVatType(), additionalService.getType(), Objects.requireNonNullElse(additionalService.getSupplementPolicy(), AdditionalService.SupplementPolicy.OPTIONAL_UNLIMITED_AMOUNT), additionalService.getMinPrice() != null ? Integer.valueOf(MonetaryUtil.unitToCents((BigDecimal)additionalService.getMinPrice(), (String)event.getCurrency())) : null, additionalService.getMaxPrice() != null ? Integer.valueOf(MonetaryUtil.unitToCents((BigDecimal)additionalService.getMaxPrice(), (String)event.getCurrency())) : null);
        Validate.isTrue((result.getAffectedRowCount() == 1 ? 1 : 0) != 0, (String)"too many records updated", (Object[])new Object[0]);
        int id = (Integer)result.getKey();
        Stream.concat(additionalService.getTitle().stream(), additionalService.getDescription().stream()).forEach(t -> this.additionalServiceTextRepository.insert(id, t.getLocale(), t.getType(), t.getValue()));
        if (additionalService.getAvailableQuantity() > 0) {
            this.preGenerateItems(((Integer)result.getKey()).intValue(), event, additionalService);
        }
        return EventModification.AdditionalService.from((AdditionalService)this.additionalServiceRepository.getById(((Integer)result.getKey()).intValue(), eventId)).withText(this.additionalServiceTextRepository.findAllByAdditionalServiceId(((Integer)result.getKey()).intValue())).withZoneId(event.getZoneId()).build();
    }

    void createAllAdditionalServices(Event event, List<EventModification.AdditionalService> additionalServices) {
        if (!CollectionUtils.isEmpty(additionalServices)) {
            int eventId = event.getId();
            String currencyCode = event.getCurrency();
            ZoneId zoneId = event.getZoneId();
            additionalServices.forEach(as -> {
                AffectedRowCountAndKey service = this.additionalServiceRepository.insert(eventId, AdditionalServiceManager.evaluateAdditionalServicePriceCts((EventModification.AdditionalService)as, (String)currencyCode), as.isFixPrice(), as.getOrdinal(), as.getAvailableQuantity(), as.getMaxQtyPerOrder(), as.getInception().toZonedDateTime(zoneId), as.getExpiration().toZonedDateTime(zoneId), as.getVat(), as.getVatType(), as.getType(), as.getSupplementPolicy(), as.getMinPrice() != null ? Integer.valueOf(MonetaryUtil.unitToCents((BigDecimal)as.getMinPrice(), (String)currencyCode)) : null, as.getMaxPrice() != null ? Integer.valueOf(MonetaryUtil.unitToCents((BigDecimal)as.getMaxPrice(), (String)currencyCode)) : null);
                if (as.getAvailableQuantity() > 0) {
                    this.preGenerateItems(((Integer)service.getKey()).intValue(), event, as);
                }
                as.getTitle().forEach(this.insertAdditionalServiceDescription(((Integer)service.getKey()).intValue()));
                as.getDescription().forEach(this.insertAdditionalServiceDescription(((Integer)service.getKey()).intValue()));
            });
        }
    }

    private static int evaluateAdditionalServicePriceCts(EventModification.AdditionalService as, String currencyCode) {
        if (AdditionalService.SupplementPolicy.isMandatoryPercentage((AdditionalService.SupplementPolicy)as.getSupplementPolicy())) {
            BigDecimal decimalAwarePrice = Objects.requireNonNullElse(as.getPrice(), BigDecimal.ZERO).multiply(MonetaryUtil.HUNDRED).setScale(0, RoundingMode.HALF_UP);
            return decimalAwarePrice.intValueExact();
        }
        return as.getPrice() != null ? MonetaryUtil.unitToCents((BigDecimal)as.getPrice(), (String)currencyCode) : 0;
    }

    private void preGenerateItems(int serviceId, Event event, EventModification.AdditionalService as) {
        int requested;
        if (!event.supportsLinkedAdditionalServices()) {
            LOGGER.trace("Event does not support linked additional services");
            return;
        }
        if (as.getAvailableQuantity() == -1) {
            return;
        }
        int count = this.additionalServiceItemRepository.countItemsForService(serviceId);
        if (count > (requested = Math.max(0, as.getAvailableQuantity()))) {
            LOGGER.debug("Requested {} items, found {}", (Object)requested, (Object)count);
            int result = this.additionalServiceItemRepository.invalidateItems(serviceId, count - requested);
            Validate.isTrue((result == count - requested ? 1 : 0) != 0, (String)("Cannot reduce available items to " + requested), (Object[])new Object[0]);
        } else if (count < requested) {
            ArrayList<MapSqlParameterSource> batchReserveParameters = new ArrayList<MapSqlParameterSource>();
            for (int i = 0; i < requested - count; ++i) {
                batchReserveParameters.add(this.buildInsertItemParameterSource(serviceId, null, AdditionalServiceItem.AdditionalServiceItemStatus.FREE, event, 0, 0, 0, 0));
            }
            int result = (int)Arrays.stream(this.jdbcTemplate.batchUpdate(this.additionalServiceItemRepository.batchInsert(), (SqlParameterSource[])batchReserveParameters.toArray(MapSqlParameterSource[]::new))).asLongStream().sum();
            Validate.isTrue((result + count == requested ? 1 : 0) != 0, (String)"Error while pre-generating items", (Object[])new Object[0]);
        }
    }

    void bookAdditionalServiceItems(int quantity, BigDecimal amount, AdditionalService as, Event event, PromoCodeDiscount discount, String reservationId) {
        int result;
        String queryTemplate;
        Validate.isTrue((quantity > 0 ? 1 : 0) != 0);
        AdditionalServicePriceContainer pc = AdditionalServicePriceContainer.from((BigDecimal)amount, (AdditionalService)as, (Event)event, (PromoCodeDiscount)discount);
        String currencyCode = pc.getCurrencyCode();
        ArrayList<MapSqlParameterSource> batchReserveParameters = new ArrayList<MapSqlParameterSource>();
        if (as.availableQuantity() > 0) {
            queryTemplate = this.additionalServiceItemRepository.batchUpdate();
            List ids = this.additionalServiceItemRepository.lockExistingItems(as.id(), quantity);
            if (ids.size() != quantity) {
                throw new NotEnoughItemsException();
            }
            for (int i = 0; i < quantity; ++i) {
                batchReserveParameters.add(new MapSqlParameterSource("uuid", (Object)UUID.randomUUID().toString()).addValue("ticketsReservationUuid", (Object)reservationId).addValue("additionalServiceId", (Object)as.id()).addValue("status", (Object)AdditionalServiceItem.AdditionalServiceItemStatus.PENDING.name()).addValue("id", ids.get(i)).addValue("srcPriceCts", (Object)pc.getSrcPriceCts()).addValue("finalPriceCts", (Object)MonetaryUtil.unitToCents((BigDecimal)pc.getFinalPrice(), (String)currencyCode)).addValue("vatCts", (Object)MonetaryUtil.unitToCents((BigDecimal)pc.getVAT(), (String)currencyCode)).addValue("discountCts", (Object)MonetaryUtil.unitToCents((BigDecimal)pc.getAppliedDiscount(), (String)currencyCode)).addValue("currencyCode", (Object)event.getCurrency()));
            }
        } else {
            queryTemplate = this.additionalServiceItemRepository.batchInsert();
            for (int i = 0; i < quantity; ++i) {
                batchReserveParameters.add(this.buildInsertItemParameterSource(as.id(), reservationId, AdditionalServiceItem.AdditionalServiceItemStatus.PENDING, event, pc.getSrcPriceCts(), MonetaryUtil.unitToCents((BigDecimal)pc.getFinalPrice(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)pc.getVAT(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)pc.getAppliedDiscount(), (String)currencyCode)));
            }
        }
        Validate.isTrue(((result = (int)Arrays.stream(this.jdbcTemplate.batchUpdate(queryTemplate, (SqlParameterSource[])batchReserveParameters.toArray(MapSqlParameterSource[]::new))).asLongStream().sum()) == quantity ? 1 : 0) != 0, (String)"Cannot book additional services", (Object[])new Object[0]);
    }

    private Consumer<EventModification.AdditionalServiceText> insertAdditionalServiceDescription(int serviceId) {
        return t -> this.additionalServiceTextRepository.insert(serviceId, t.getLocale(), t.getType(), t.getValue());
    }

    public AdditionalService getAdditionalServiceById(int id, int eventId) {
        return this.additionalServiceRepository.getById(id, eventId);
    }

    public Map<Integer, Map<AdditionalServiceText.TextType, Map<String, String>>> getDescriptionsByAdditionalServiceIds(Collection<Integer> additionalServiceIds) {
        return this.additionalServiceTextRepository.getDescriptionsByAdditionalServiceIds(additionalServiceIds);
    }

    public Map<Integer, AdditionalService.AdditionalServiceType> getTypeByIds(Collection<Integer> additionalServiceIds) {
        if (additionalServiceIds.isEmpty()) {
            return Map.of();
        }
        return this.additionalServiceRepository.getTypeByIds(additionalServiceIds);
    }

    private MapSqlParameterSource buildInsertItemParameterSource(int serviceId, String reservationId, AdditionalServiceItem.AdditionalServiceItemStatus status, Event event, int srcPriceCts, int finalPriceCts, int vatCts, int discountCts) {
        return new MapSqlParameterSource("uuid", (Object)UUID.randomUUID().toString()).addValue("ticketsReservationUuid", (Object)reservationId).addValue("additionalServiceId", (Object)serviceId).addValue("status", (Object)status.name()).addValue("eventId", (Object)event.getId()).addValue("srcPriceCts", (Object)srcPriceCts).addValue("finalPriceCts", (Object)finalPriceCts).addValue("vatCts", (Object)vatCts).addValue("discountCts", (Object)discountCts).addValue("currencyCode", (Object)event.getCurrency());
    }

    int updateStatusForReservationId(int eventId, String reservationId, AdditionalServiceItem.AdditionalServiceItemStatus additionalServiceItemStatus) {
        return this.additionalServiceItemRepository.updateItemsStatusWithReservationUUID(eventId, reservationId, additionalServiceItemStatus);
    }

    public List<AdditionalServiceItem> findItemsInReservation(int eventId, String reservationId) {
        return this.additionalServiceItemRepository.findByReservationUuid(eventId, reservationId);
    }

    public List<AdditionalServiceItem> findItemsForTicket(Ticket ticket) {
        return this.additionalServiceItemRepository.findByTicketId(ticket.getEventId(), ticket.getTicketsReservationId(), ticket.getId());
    }

    public List<AdditionalServiceItem> findItemsInReservation(PurchaseContext purchaseContext, String reservationId) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return this.findItemsInReservation(((Event)purchaseContext).getId(), reservationId);
        }
        return List.of();
    }

    public int countItemsInReservation(PurchaseContext purchaseContext, String reservationId) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return this.additionalServiceItemRepository.countByReservationUuid(((Event)purchaseContext).getId(), reservationId);
        }
        return 0;
    }

    Optional<AdditionalServiceText> loadItemTitle(AdditionalServiceItem asi, Locale locale) {
        return this.additionalServiceTextRepository.findByLocaleAndType(asi.getAdditionalServiceId(), locale.getLanguage(), AdditionalServiceText.TextType.TITLE);
    }

    boolean hasPaidSupplements(int eventId, String reservationId) {
        return this.additionalServiceItemRepository.hasPaidSupplements(eventId, reservationId);
    }

    List<AdditionalService> findAllInEventWithPolicy(int eventId, AdditionalService.SupplementPolicy supplementPolicy) {
        return this.additionalServiceRepository.findAllInEventWithPolicy(eventId, supplementPolicy);
    }

    public List<AdditionalService> loadAllForReservation(String reservationId, int eventId) {
        return this.additionalServiceRepository.loadAllForReservation(reservationId, eventId);
    }

    public void linkItemsToTickets(String reservationId, Map<String, List<AdditionalServiceLinkForm>> links, List<Ticket> tickets) {
        if (links == null || links.isEmpty()) {
            return;
        }
        MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])links.entrySet().stream().flatMap(entry -> {
            List asl = (List)entry.getValue();
            Integer ticketId = tickets.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getKey())) && t.getPublicUuid().toString().equals(entry.getKey())).findFirst().map(Ticket::getId).orElse(null);
            return asl.stream().map(form -> AdditionalServiceManager.batchLinkSource((String)reservationId, (int)form.getAdditionalServiceItemId(), (Integer)ticketId));
        }).toArray(MapSqlParameterSource[]::new);
        int[] results = this.jdbcTemplate.batchUpdate(this.additionalServiceItemRepository.batchLinkToTicket(), (SqlParameterSource[])parameterSources);
        Validate.isTrue((boolean)Arrays.stream(results).allMatch(i -> i == 1));
    }

    private static MapSqlParameterSource batchLinkSource(String reservationId, int itemId, Integer ticketId) {
        return new MapSqlParameterSource("ticketId", (Object)ticketId).addValue("itemId", (Object)itemId).addValue("reservationId", (Object)reservationId);
    }

    public void bookAdditionalServicesForReservation(Event event, String reservationId, List<ASReservationWithOptionalCodeModification> additionalServices, Optional<PromoCodeDiscount> discount) {
        List ticketIds = this.ticketRepository.findTicketIdsInReservation(reservationId);
        int ticketCount = ticketIds.size();
        List additionalServicesForEvent = this.loadAllForEvent(event.getId());
        List<ASReservationWithOptionalCodeModification> automatic = additionalServicesForEvent.stream().filter(as -> as.supplementPolicy().isMandatory() && as.getSaleable()).map(as -> {
            AdditionalServiceReservationModification asrm = new AdditionalServiceReservationModification();
            asrm.setAdditionalServiceId(Integer.valueOf(as.id()));
            asrm.setQuantity(Integer.valueOf(as.supplementPolicy() == AdditionalService.SupplementPolicy.MANDATORY_ONE_FOR_TICKET ? ticketCount : 1));
            return new ASReservationWithOptionalCodeModification(asrm, Optional.empty());
        }).toList();
        if (automatic.isEmpty() && additionalServices.isEmpty()) {
            return;
        }
        ArrayList<ASReservationWithOptionalCodeModification> items = new ArrayList<ASReservationWithOptionalCodeModification>(automatic);
        items.addAll(additionalServices);
        this.reserveAdditionalServicesForReservation(event, reservationId, items, (PromoCodeDiscount)discount.orElse(null), additionalServicesForEvent, ticketIds);
    }

    public void persistFieldsForAdditionalItems(int eventId, int organizationId, Map<String, List<AdditionalServiceLinkForm>> additionalServices, List<Ticket> tickets) {
        Set ticketIds = tickets.stream().map(Ticket::getId).collect(Collectors.toSet());
        int res = this.purchaseContextFieldRepository.deleteAllValuesForAdditionalItems(ticketIds, eventId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted {} field values", (Object)res);
        }
        List<PurchaseContextFieldConfiguration> fields = this.purchaseContextFieldRepository.findAdditionalFieldsForEvent(eventId).stream().filter(c -> c.getContext() == PurchaseContextFieldConfiguration.Context.ADDITIONAL_SERVICE).toList();
        MapSqlParameterSource[] sources = (MapSqlParameterSource[])additionalServices.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().flatMap(form -> form.getAdditional().entrySet().stream().filter(e2 -> !((List)e2.getValue()).isEmpty()).map(e2 -> {
            long configurationId = fields.stream().filter(f -> f.getName().equals(e2.getKey())).findFirst().orElseThrow().getId();
            return new MapSqlParameterSource("additionalServiceItemId", (Object)form.getAdditionalServiceItemId()).addValue("fieldConfigurationId", (Object)configurationId).addValue("value", (Object)this.purchaseContextFieldRepository.getFieldValueJson((List)e2.getValue())).addValue("organizationId", (Object)organizationId);
        }))).toArray(MapSqlParameterSource[]::new);
        int[] results = this.jdbcTemplate.batchUpdate(this.purchaseContextFieldRepository.batchInsertAdditionalItemsFields(), (SqlParameterSource[])sources);
        Validate.isTrue((boolean)Arrays.stream(results).allMatch(r -> r == 1), (String)"error while persisting additional fields", (Object[])new Object[0]);
    }

    private void reserveAdditionalServicesForReservation(Event event, String reservationId, List<ASReservationWithOptionalCodeModification> additionalServiceReservationList, PromoCodeDiscount discount, List<AdditionalService> additionalServicesForEvent, List<Integer> ticketIds) {
        Map<AdditionalService.SupplementPolicy, List<MappedRequestedService>> allAdditionalItems = additionalServiceReservationList.stream().filter(ar -> ar.getAdditionalServiceId() != null).map(requested -> {
            Optional<AdditionalService> optionalAs = additionalServicesForEvent.stream().filter(as -> as.id() == requested.getAdditionalServiceId().intValue() && as.supplementPolicy() != null).findFirst();
            return new MappedRequestedService(requested, (AdditionalService)optionalAs.orElse(null));
        }).filter(o -> Objects.nonNull(o.additionalService)).collect(Collectors.groupingBy(o -> o.additionalService.supplementPolicy()));
        this.handleMandatoryPercentage(AdditionalService.SupplementPolicy.MANDATORY_PERCENTAGE_FOR_TICKET, event, reservationId, discount, allAdditionalItems);
        Set nonMandatoryPolicies = AdditionalService.SupplementPolicy.userSelected();
        nonMandatoryPolicies.stream().filter(allAdditionalItems::containsKey).flatMap(p -> ((List)allAdditionalItems.get(p)).stream().filter(as -> as.requested.getQuantity() > 0 && (as.additionalService.fixPrice() || Objects.requireNonNullElse(as.requested.getAmount(), BigDecimal.ZERO).compareTo(BigDecimal.ZERO) > 0))).forEach(mapped -> {
            AdditionalService as = mapped.additionalService;
            ASReservationWithOptionalCodeModification additionalServiceReservation = mapped.requested;
            this.bookAdditionalServiceItems(additionalServiceReservation.getQuantity().intValue(), additionalServiceReservation.getAmount(), as, event, discount, reservationId);
        });
        this.handleMandatoryPercentage(AdditionalService.SupplementPolicy.MANDATORY_PERCENTAGE_RESERVATION, event, reservationId, discount, allAdditionalItems);
        allAdditionalItems.getOrDefault(AdditionalService.SupplementPolicy.MANDATORY_ONE_FOR_TICKET, List.of()).forEach(mrs -> {
            BigDecimal amount = mrs.requested.getAmount();
            this.bookAdditionalServiceItems(mrs.requested.getQuantity().intValue(), amount, mrs.additionalService, event, discount, reservationId);
        });
        List bookedItems = this.additionalServiceItemRepository.findByReservationUuid(event.getId(), reservationId);
        MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])allAdditionalItems.entrySet().stream().flatMap(entry -> {
            List values = (List)entry.getValue();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Processing {} items with policy {}", (Object)values.size(), entry.getKey());
            }
            return values.stream().flatMap(m -> AdditionalServiceManager.linkWithEveryTicket((String)reservationId, (List)additionalServiceReservationList, (List)bookedItems, (List)ticketIds, (AdditionalService)m.additionalService));
        }).toArray(MapSqlParameterSource[]::new);
        int[] results = this.jdbcTemplate.batchUpdate(this.additionalServiceItemRepository.batchLinkToTicket(), (SqlParameterSource[])parameterSources);
        Validate.isTrue((boolean)Arrays.stream(results).allMatch(i -> i == 1));
        List firstTicketId = ticketIds.stream().findFirst().map(List::of).orElseThrow();
        MapSqlParameterSource[] noPoliciesParameterSources = (MapSqlParameterSource[])additionalServicesForEvent.stream().filter(as -> as.supplementPolicy() == null && additionalServiceReservationList.stream().anyMatch(AdditionalServiceManager.findAdditionalServiceRequest((AdditionalService)as))).flatMap(as -> AdditionalServiceManager.linkWithEveryTicket((String)reservationId, (List)additionalServiceReservationList, (List)bookedItems, (List)firstTicketId, (AdditionalService)as)).toArray(MapSqlParameterSource[]::new);
        int[] noPolicyResults = this.jdbcTemplate.batchUpdate(this.additionalServiceItemRepository.batchLinkToTicket(), (SqlParameterSource[])noPoliciesParameterSources);
        Validate.isTrue((boolean)Arrays.stream(noPolicyResults).allMatch(i -> i == 1));
    }

    private void handleMandatoryPercentage(AdditionalService.SupplementPolicy supplementPolicy, Event event, String reservationId, PromoCodeDiscount discount, Map<AdditionalService.SupplementPolicy, List<MappedRequestedService>> allMapped) {
        if (allMapped.containsKey(supplementPolicy)) {
            TotalPrice reservationPrice = (TotalPrice)this.reservationCostCalculator.totalReservationCostWithVAT(reservationId).getKey();
            allMapped.get(supplementPolicy).forEach(mrs -> {
                int basePrice = reservationPrice.getPriceWithVAT();
                PriceContainer.VatStatus vatStatus = event.getVatStatus();
                if (PriceContainer.VatStatus.isVatNotIncluded((PriceContainer.VatStatus)vatStatus)) {
                    basePrice -= reservationPrice.getVAT();
                }
                BigDecimal percentage = new BigDecimal(String.valueOf(mrs.additionalService.srcPriceCts())).divide(MonetaryUtil.HUNDRED, RoundingMode.HALF_UP);
                int amountCts = AdditionalServiceManager.adjustUsingMinMaxPrice((int)((Integer)MonetaryUtil.calcPercentage((long)basePrice, (BigDecimal)percentage, BigDecimal::intValueExact)), (AdditionalService)mrs.additionalService);
                BigDecimal amount = MonetaryUtil.centsToUnit((int)amountCts, (String)reservationPrice.getCurrencyCode());
                this.bookAdditionalServiceItems(mrs.requested.getQuantity().intValue(), amount, mrs.additionalService, event, discount, reservationId);
            });
        }
    }

    private static int adjustUsingMinMaxPrice(int amountCts, AdditionalService additionalService) {
        if (additionalService.minPriceCts() != null && additionalService.minPriceCts() > amountCts) {
            return additionalService.minPriceCts();
        }
        if (additionalService.maxPriceCts() != null && additionalService.maxPriceCts() < amountCts) {
            return additionalService.maxPriceCts();
        }
        return amountCts;
    }

    private static Stream<MapSqlParameterSource> linkWithEveryTicket(String reservationId, List<ASReservationWithOptionalCodeModification> additionalServiceReservationList, List<AdditionalServiceItem> bookedItems, List<Integer> ticketIds, AdditionalService m) {
        ASReservationWithOptionalCodeModification additionalServiceRequest = (ASReservationWithOptionalCodeModification)additionalServiceReservationList.stream().filter(AdditionalServiceManager.findAdditionalServiceRequest((AdditionalService)m)).findFirst().orElseThrow();
        LoopingIterator ticketIterator = new LoopingIterator(ticketIds);
        return bookedItems.stream().filter(i -> i.getAdditionalServiceId() == additionalServiceRequest.getAdditionalServiceId().intValue()).map(i -> AdditionalServiceManager.batchLinkSource((String)reservationId, (int)i.getId(), (Integer)((Integer)ticketIterator.next())));
    }

    private static Predicate<ASReservationWithOptionalCodeModification> findAdditionalServiceRequest(AdditionalService as) {
        return asr -> as.id() == asr.getAdditionalServiceId().intValue();
    }

    public void swapAdditionalServicesPosition(int eventId, int id1, int id2) {
        int id1Ordinal = (Integer)this.additionalServiceRepository.getServiceOrdinal(id1, eventId).orElseThrow();
        int id2Ordinal = (Integer)this.additionalServiceRepository.getServiceOrdinal(id2, eventId).orElseThrow();
        this.additionalServiceRepository.updateOrdinal(id1, id2Ordinal);
        this.additionalServiceRepository.updateOrdinal(id2, id1Ordinal);
    }

    @ConstructorProperties(value={"additionalServiceRepository", "additionalServiceTextRepository", "additionalServiceItemRepository", "jdbcTemplate", "ticketRepository", "purchaseContextFieldRepository", "reservationCostCalculator"})
    @Generated
    public AdditionalServiceManager(AdditionalServiceRepository additionalServiceRepository, AdditionalServiceTextRepository additionalServiceTextRepository, AdditionalServiceItemRepository additionalServiceItemRepository, NamedParameterJdbcTemplate jdbcTemplate, TicketRepository ticketRepository, PurchaseContextFieldRepository purchaseContextFieldRepository, ReservationCostCalculator reservationCostCalculator) {
        this.additionalServiceRepository = additionalServiceRepository;
        this.additionalServiceTextRepository = additionalServiceTextRepository;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.ticketRepository = ticketRepository;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.reservationCostCalculator = reservationCostCalculator;
    }
}

