/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.support.TemplateProcessor;
import alfio.manager.AccessService;
import alfio.manager.BillingDocumentManager;
import alfio.manager.EventManager;
import alfio.manager.ExtensionManager;
import alfio.manager.FileUploadManager;
import alfio.manager.NotificationManager;
import alfio.manager.PaymentManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.SpecialPriceTokenGenerator;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.DuplicateReferenceException;
import alfio.manager.support.IncompatibleStateException;
import alfio.manager.support.reservation.ReservationEmailContentHelper;
import alfio.manager.system.ReservationPriceCalculator;
import alfio.model.AdditionalServiceItem;
import alfio.model.Audit;
import alfio.model.BillingDocument;
import alfio.model.CustomerName;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.LightweightMailMessage;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.SpecialPrice;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketWithMetadataAttributes;
import alfio.model.TotalPrice;
import alfio.model.TransactionAndPaymentInfo;
import alfio.model.api.v1.admin.ReservationBillingData;
import alfio.model.decorator.TicketPriceContainer;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.metadata.TicketMetadata;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.modification.AdminReservationModification;
import alfio.model.modification.DateTimeModification;
import alfio.model.modification.TicketCategoryModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.model.user.Organization;
import alfio.model.user.User;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.AdditionalServiceRepository;
import alfio.repository.AuditingRepository;
import alfio.repository.BillingDocumentRepository;
import alfio.repository.EventRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SpecialPriceRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.repository.user.UserRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.Json;
import alfio.util.LocaleUtil;
import alfio.util.MonetaryUtil;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import alfio.util.Wrappers;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.MapBindingResult;

@Component
public class AdminReservationManager {
    private static final ErrorCode ERROR_CANNOT_CANCEL_CHECKED_IN_TICKETS = ErrorCode.custom((String)"remove-reservation.failed", (String)"This reservation contains checked-in tickets. Unable to cancel it.");
    private static final Logger log = LoggerFactory.getLogger(AdminReservationManager.class);
    private final PurchaseContextManager purchaseContextManager;
    private final EventManager eventManager;
    private final TicketReservationManager ticketReservationManager;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final TicketRepository ticketRepository;
    private final SpecialPriceRepository specialPriceRepository;
    private final TicketReservationRepository ticketReservationRepository;
    private final EventRepository eventRepository;
    private final PlatformTransactionManager transactionManager;
    private final SpecialPriceTokenGenerator specialPriceTokenGenerator;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final PaymentManager paymentManager;
    private final NotificationManager notificationManager;
    private final MessageSourceManager messageSourceManager;
    private final TemplateManager templateManager;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final AuditingRepository auditingRepository;
    private final UserRepository userRepository;
    private final ExtensionManager extensionManager;
    private final BillingDocumentRepository billingDocumentRepository;
    private final FileUploadManager fileUploadManager;
    private final PromoCodeDiscountRepository promoCodeDiscountRepository;
    private final AdditionalServiceRepository additionalServiceRepository;
    private final BillingDocumentManager billingDocumentManager;
    private final ClockProvider clockProvider;
    private final SubscriptionRepository subscriptionRepository;
    private final ReservationEmailContentHelper reservationEmailContentHelper;
    private final TransactionRepository transactionRepository;
    private final AccessService accessService;

    Result<Triple<TicketReservation, List<Ticket>, PurchaseContext>> confirmReservation(PurchaseContext.PurchaseContextType purchaseContextType, String eventName, String reservationId, String username, AdminReservationModification.Notification notification, AdminReservationModification.TransactionDetails transactionDetails, UUID subscriptionId) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        TransactionTemplate template = new TransactionTemplate(this.transactionManager, (TransactionDefinition)definition);
        Result result = (Result)template.execute(status -> {
            try {
                Result confirmationResult = this.purchaseContextManager.findBy(purchaseContextType, eventName).map(purchaseContext -> this.ticketReservationRepository.findOptionalReservationById(reservationId).filter(r -> r.getStatus() == TicketReservation.TicketReservationStatus.PENDING || r.getStatus() == TicketReservation.TicketReservationStatus.STUCK).map(r -> this.performConfirmation(reservationId, purchaseContext, r, notification, transactionDetails, username, subscriptionId)).orElseGet(() -> Result.error((ErrorCode)ErrorCode.ReservationError.UPDATE_FAILED))).orElseGet(() -> Result.error((ErrorCode)ErrorCode.ReservationError.NOT_FOUND));
                if (!confirmationResult.isSuccess()) {
                    log.debug("Reservation confirmation failed for eventName: {} reservationId: {}, username: {}", new Object[]{eventName, reservationId, username});
                    status.setRollbackOnly();
                }
                return confirmationResult;
            }
            catch (Exception e) {
                log.error("Error during confirmation of reservation eventName: {} reservationId: {}, username: {}", new Object[]{eventName, reservationId, username});
                status.setRollbackOnly();
                return Result.error(Collections.singletonList(ErrorCode.custom((String)"", (String)e.getMessage())));
            }
        });
        return Objects.requireNonNull(result).flatMap(arg_0 -> this.loadReservation(arg_0));
    }

    public Result<Triple<TicketReservation, List<Ticket>, PurchaseContext>> confirmReservation(PurchaseContext.PurchaseContextType purchaseContextType, String eventName, String reservationId, String username, AdminReservationModification.Notification notification) {
        return this.confirmReservation(purchaseContextType, eventName, reservationId, username, notification, AdminReservationModification.TransactionDetails.admin(), null);
    }

    public Result<Triple<TicketReservation, List<Ticket>, PurchaseContext>> confirmReservation(String reservationId, Principal principal, AdminReservationModification.TransactionDetails transaction, AdminReservationModification.Notification notification, ReservationBillingData billingData) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        TransactionTemplate template = new TransactionTemplate(this.transactionManager, (TransactionDefinition)definition);
        return (Result)template.execute(t -> {
            Optional purchaseContextOptional = this.purchaseContextManager.findByReservationId(reservationId);
            if (purchaseContextOptional.isEmpty()) {
                return Result.error((ErrorCode)ErrorCode.ReservationError.NOT_FOUND);
            }
            PurchaseContext purchaseContext = (PurchaseContext)purchaseContextOptional.get();
            this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(purchaseContext.getOrganizationId()));
            if (billingData != null) {
                log.debug("Setting billing address to reservation {}", (Object)reservationId);
                String billingAddress = TicketReservationManager.buildCompleteBillingAddress((CustomerName)new CustomerName(billingData.fullName(), null, null, false), (String)billingData.company(), (String)billingData.line1(), (String)billingData.line2(), (String)billingData.zip(), (String)billingData.city(), (String)billingData.state(), (String)billingData.countryCode(), (Locale)Locale.forLanguageTag(this.ticketReservationRepository.loadUserLanguage(reservationId)));
                Validate.isTrue((1 == this.ticketReservationRepository.updateBillingAddress(billingAddress, reservationId) ? 1 : 0) != 0);
            }
            return this.confirmReservation(purchaseContext.getType(), purchaseContext.getPublicIdentifier(), reservationId, principal.getName(), notification, transaction, null);
        });
    }

    public Result<Boolean> updateReservation(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, AdminReservationModification adminReservationModification, String username) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        TransactionTemplate template = new TransactionTemplate(this.transactionManager, (TransactionDefinition)definition);
        return (Result)template.execute(status -> {
            try {
                Result result = this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).map(event -> this.ticketReservationRepository.findOptionalReservationById(reservationId).map(r -> this.performUpdate(reservationId, event, r, adminReservationModification, username)).orElseGet(() -> Result.error((ErrorCode)ErrorCode.ReservationError.UPDATE_FAILED))).orElseGet(() -> Result.error((ErrorCode)ErrorCode.ReservationError.NOT_FOUND));
                if (!result.isSuccess()) {
                    log.debug("Application error detected eventName: {} reservationId: {}, username: {}, reservation: {}", new Object[]{publicIdentifier, reservationId, username, AdminReservationModification.summary((AdminReservationModification)adminReservationModification)});
                    status.setRollbackOnly();
                }
                return result;
            }
            catch (Exception e) {
                log.error("Error during update of reservation eventName: {} reservationId: {}, username: {}, reservation: {}", new Object[]{publicIdentifier, reservationId, username, AdminReservationModification.summary((AdminReservationModification)adminReservationModification)});
                status.setRollbackOnly();
                return Result.error(Collections.singletonList(ErrorCode.custom((String)"", (String)e.getMessage())));
            }
        });
    }

    public Result<Pair<TicketReservation, List<Ticket>>> createReservation(AdminReservationModification input, String eventName, String username) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(6);
        TransactionTemplate template = new TransactionTemplate(this.transactionManager, (TransactionDefinition)definition);
        return (Result)template.execute(status -> {
            Object savepoint = status.createSavepoint();
            try {
                Result result = this.eventRepository.findOptionalByShortNameForUpdate(eventName).map(e -> this.validateTickets(input, e)).map(r -> r.flatMap(p -> this.transactionalCreateReservation((AdminReservationModification)p.getRight(), (Event)p.getLeft(), username))).orElse(Result.error((ErrorCode)ErrorCode.EventError.NOT_FOUND));
                if (!result.isSuccess()) {
                    log.warn("Error during update of reservation eventName: {}, username: {}, reservation: {}", new Object[]{eventName, username, AdminReservationModification.summary((AdminReservationModification)input)});
                    status.rollbackToSavepoint(savepoint);
                }
                return result;
            }
            catch (Exception e2) {
                log.error("Error during update of reservation eventName: {}, username: {}, reservation: {}", new Object[]{eventName, username, AdminReservationModification.summary((AdminReservationModification)input)});
                log.debug("Error detail:", (Throwable)e2);
                status.rollbackToSavepoint(savepoint);
                return Result.error(Collections.singletonList(ErrorCode.custom((String)(e2 instanceof DuplicateReferenceException ? "duplicate-reference" : ""), (String)e2.getMessage())));
            }
        });
    }

    @Transactional
    public Result<Boolean> notifyAttendees(String eventName, String reservationId, List<Integer> ids, String username) {
        return this.getEventTicketReservationPair(PurchaseContext.PurchaseContextType.event, eventName, reservationId, username).map(pair -> {
            Event event = (Event)((PurchaseContext)pair.getLeft()).event().orElseThrow();
            TicketReservation reservation = (TicketReservation)pair.getRight();
            this.sendTicketToAttendees(event, reservation, t -> t.getAssigned() && ids.contains(t.getId()));
            return Result.success((Object)true);
        }).orElseGet(() -> Result.error((ErrorCode)ErrorCode.EventError.NOT_FOUND));
    }

    @Transactional
    public Result<Boolean> notify(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, AdminReservationModification arm, String username) {
        AdminReservationModification.Notification notification = arm.getNotification();
        return this.getEventTicketReservationPair(purchaseContextType, publicIdentifier, reservationId, username).map(pair -> {
            PurchaseContext purchaseContext = (PurchaseContext)pair.getLeft();
            TicketReservation reservation = (TicketReservation)pair.getRight();
            if (notification.isCustomer()) {
                this.ticketReservationManager.sendConfirmationEmail(purchaseContext, reservation, LocaleUtil.forLanguageTag((String)reservation.getUserLanguage()), username);
            }
            if (notification.isAttendees() && purchaseContextType == PurchaseContext.PurchaseContextType.event) {
                this.sendTicketToAttendees((Event)purchaseContext.event().orElseThrow(), reservation, Ticket::getAssigned);
            }
            return Result.success((Object)true);
        }).orElseGet(() -> Result.error((ErrorCode)ErrorCode.EventError.NOT_FOUND));
    }

    private Optional<Pair<PurchaseContext, TicketReservation>> getEventTicketReservationPair(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, String username) {
        return this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).flatMap(ev -> this.ticketReservationRepository.findOptionalReservationById(reservationId).map(r -> Pair.of((Object)ev, (Object)r)));
    }

    private void sendTicketToAttendees(Event event, TicketReservation reservation, Predicate<Ticket> matcher) {
        this.ticketRepository.findTicketsInReservation(reservation.getId()).stream().filter(matcher).forEach(t -> {
            Locale locale = LocaleUtil.forLanguageTag((String)t.getUserLanguage());
            Map additionalInfo = this.ticketReservationManager.retrieveAttendeeAdditionalInfoForTicket(t);
            this.reservationEmailContentHelper.sendTicketByEmail(t, locale, event, this.ticketReservationManager.getTicketEmailGenerator(event, reservation, locale, additionalInfo));
        });
    }

    private Result<Boolean> performUpdate(String reservationId, PurchaseContext purchaseContext, TicketReservation r, AdminReservationModification arm, String username) {
        this.billingDocumentManager.ensureBillingDocumentIsPresent(purchaseContext, r, username, () -> this.ticketReservationManager.orderSummaryForReservationId(reservationId, purchaseContext));
        this.ticketReservationRepository.updateValidity(reservationId, Date.from(arm.getExpiration().toZonedDateTime(purchaseContext.getZoneId()).toInstant()));
        if (arm.isUpdateContactData()) {
            AdminReservationModification.CustomerData customerData = arm.getCustomerData();
            this.ticketReservationRepository.updateTicketReservation(reservationId, r.getStatus().name(), customerData.getEmailAddress(), customerData.getFullName(), customerData.getFirstName(), customerData.getLastName(), customerData.getUserLanguage(), customerData.getBillingAddress(), r.getConfirmationTimestamp(), (String)Optional.ofNullable(r.getPaymentMethod()).map(Enum::name).orElse(null), customerData.getCustomerReference());
            if (StringUtils.isNotBlank((CharSequence)customerData.getVatNr()) || StringUtils.isNotBlank((CharSequence)customerData.getVatCountryCode())) {
                this.ticketReservationRepository.updateBillingData(r.getVatStatus(), r.getSrcPriceCts(), r.getFinalPriceCts(), r.getVatCts(), r.getDiscountCts(), r.getCurrencyCode(), customerData.getVatNr(), customerData.getVatCountryCode(), r.isInvoiceRequested(), reservationId);
            }
            this.ticketReservationRepository.updateInvoicingAdditionalInformation(reservationId, Json.toJson((Object)arm.getCustomerData().getInvoicingAdditionalInfo()));
        }
        if (arm.isUpdateAdvancedBillingOptions() && purchaseContext.getVatStatus() != PriceContainer.VatStatus.NONE) {
            PriceContainer.VatStatus newVatStatus;
            boolean vatApplicationRequested = arm.getAdvancedBillingOptions().isVatApplied();
            if (vatApplicationRequested) {
                newVatStatus = purchaseContext.getVatStatus();
            } else {
                PriceContainer.VatStatus vatStatus = newVatStatus = purchaseContext.getVatStatus() == PriceContainer.VatStatus.INCLUDED ? PriceContainer.VatStatus.INCLUDED_EXEMPT : PriceContainer.VatStatus.NOT_INCLUDED_EXEMPT;
            }
            if (newVatStatus != ObjectUtils.firstNonNull((Object[])new PriceContainer.VatStatus[]{r.getVatStatus(), purchaseContext.getVatStatus()})) {
                this.auditingRepository.insert(reservationId, Integer.valueOf(this.userRepository.getByUsername(username).getId()), purchaseContext, Audit.EventType.FORCE_VAT_APPLICATION, new Date(), Audit.EntityType.RESERVATION, reservationId, Collections.singletonList(Collections.singletonMap("vatStatus", newVatStatus)));
                this.ticketReservationRepository.addReservationInvoiceOrReceiptModel(reservationId, null);
                TotalPrice newPrice = (TotalPrice)this.ticketReservationManager.totalReservationCostWithVAT(r.withVatStatus(newVatStatus)).getLeft();
                this.ticketReservationRepository.resetVat(reservationId, r.isInvoiceRequested(), newVatStatus, r.getSrcPriceCts(), newPrice.getPriceWithVAT(), newPrice.getVAT(), Math.abs(newPrice.getDiscount()), r.getCurrencyCode());
                this.ticketRepository.updateVatStatusForReservation(reservationId, newVatStatus);
            }
        }
        Date d = new Date();
        arm.getTicketsInfo().stream().filter(AdminReservationModification.TicketsInfo::isUpdateAttendees).flatMap(ti -> ti.getAttendees().stream()).forEach(a -> {
            String email = StringUtils.trimToNull((String)a.getEmailAddress());
            String firstName = StringUtils.trimToNull((String)a.getFirstName());
            String lastName = StringUtils.trimToNull((String)a.getLastName());
            String fullName = StringUtils.trimToNull((String)a.getFullName());
            this.ticketRepository.updateTicketOwnerById(a.getTicketId().intValue(), email, fullName, firstName, lastName);
            Integer userId = this.userRepository.findByUsername(username).map(User::getId).orElse(null);
            HashMap<String, String> modifications = new HashMap<String, String>();
            modifications.put("firstName", firstName);
            modifications.put("lastName", lastName);
            modifications.put("fullName", fullName);
            this.auditingRepository.insert(reservationId, userId, purchaseContext, Audit.EventType.UPDATE_TICKET, d, Audit.EntityType.TICKET, Integer.toString(a.getTicketId()), Collections.singletonList(modifications));
        });
        if (purchaseContext.getType() == PurchaseContext.PurchaseContextType.subscription && arm.getSubscriptionDetails() != null) {
            AdminReservationModification.SubscriptionDetails subscriptionDetailsModification = arm.getSubscriptionDetails();
            Subscription subscription = (Subscription)this.subscriptionRepository.findFirstSubscriptionByReservationIdForUpdate(reservationId).orElseThrow();
            this.subscriptionRepository.updateSubscription(subscription.getId(), (String)StringUtils.firstNonBlank((CharSequence[])new String[]{subscriptionDetailsModification.getFirstName(), subscription.getFirstName()}), (String)StringUtils.firstNonBlank((CharSequence[])new String[]{subscriptionDetailsModification.getLastName(), subscription.getLastName()}), (String)StringUtils.firstNonBlank((CharSequence[])new String[]{subscriptionDetailsModification.getEmail(), subscription.getEmail()}), Objects.requireNonNullElse(subscriptionDetailsModification.getMaxAllowed(), subscription.getMaxEntries()).intValue(), subscriptionDetailsModification.getValidityFrom() != null ? subscriptionDetailsModification.getValidityFrom().toZonedDateTime(subscription.getZoneId()) : null, subscriptionDetailsModification.getValidityTo() != null ? subscriptionDetailsModification.getValidityTo().toZonedDateTime(subscription.getZoneId()) : null);
        }
        return Result.success((Object)true);
    }

    @Transactional
    public Result<Triple<TicketReservation, List<Ticket>, PurchaseContext>> loadReservation(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, String username) {
        return this.purchaseContextManager.findBy(purchaseContextType, publicIdentifier).map(r -> this.loadReservation(reservationId)).orElseGet(() -> Result.error((ErrorCode)ErrorCode.ReservationError.NOT_FOUND));
    }

    @Transactional
    public List<Integer> getTicketIdsWithAdditionalData(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId) {
        if (purchaseContextType != PurchaseContext.PurchaseContextType.event) {
            return List.of();
        }
        return this.ticketRepository.findTicketsWithAdditionalData(reservationId, publicIdentifier);
    }

    @Transactional
    public Optional<Pair<Event, Ticket>> loadFullTicketInfo(String reservationId, String eventShortName, String ticketUUID) {
        return this.purchaseContextManager.findBy(PurchaseContext.PurchaseContextType.event, eventShortName).flatMap(event -> this.ticketRepository.findOptionalByUUID(ticketUUID).filter(ticket -> reservationId.equals(ticket.getTicketsReservationId())).map(ticket -> Pair.of((Object)((Event)event), (Object)ticket)));
    }

    private Result<Triple<TicketReservation, List<Ticket>, PurchaseContext>> loadReservation(String reservationId) {
        return this.ticketReservationRepository.findOptionalReservationById(reservationId).map(r -> Triple.of((Object)r, (Object)this.ticketRepository.findTicketsInReservation(reservationId), (Object)((PurchaseContext)this.purchaseContextManager.findByReservationId(reservationId).orElseThrow()))).map(Result::success).orElseGet(() -> Result.error((ErrorCode)ErrorCode.ReservationError.NOT_FOUND));
    }

    private Result<String> performConfirmation(String reservationId, PurchaseContext purchaseContext, TicketReservation original, AdminReservationModification.Notification notification, AdminReservationModification.TransactionDetails transactionDetails, String username, UUID subscriptionId) {
        try {
            TicketReservation reservation = original;
            if (subscriptionId != null && purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
                if (reservation.getVatStatus() == null && purchaseContext.getVatStatus() != null) {
                    this.ticketReservationRepository.updateVatStatus(reservationId, purchaseContext.getVatStatus());
                    reservation = (TicketReservation)this.ticketReservationManager.findById(reservationId).orElseThrow();
                }
                Subscription subscriptionDetails = this.subscriptionRepository.findSubscriptionById(subscriptionId);
                MapBindingResult bindingResult = new MapBindingResult(new HashMap(), "");
                boolean result = this.ticketReservationManager.validateAndApplySubscriptionCode(purchaseContext, reservation, Optional.of(subscriptionId), subscriptionId.toString(), subscriptionDetails.getEmail(), (BindingResult)bindingResult);
                if (!result) {
                    String message = bindingResult.getGlobalErrors().stream().findFirst().map(DefaultMessageSourceResolvable::getCode).orElse("Unknown error");
                    log.warn("Unable to apply subscription {}: {}", (Object)subscriptionId, (Object)bindingResult.getAllErrors().stream().map(DefaultMessageSourceResolvable::getCode).collect(Collectors.joining(", ")));
                    return Result.error((ErrorCode)ErrorCode.custom((String)message, (String)"Cannot assign subscription %s to Reservation %s".formatted(subscriptionId, reservationId)));
                }
                reservation = (TicketReservation)this.ticketReservationManager.findById(reservationId).orElseThrow();
            }
            PaymentSpecification spec = new PaymentSpecification(reservationId, null, reservation.getFinalPriceCts(), purchaseContext, reservation.getEmail(), new CustomerName(reservation.getFullName(), reservation.getFirstName(), reservation.getLastName(), purchaseContext.mustUseFirstAndLastName()), reservation.getBillingAddress(), reservation.getCustomerReference(), LocaleUtil.forLanguageTag((String)reservation.getUserLanguage()), false, false, null, reservation.getVatCountryCode(), reservation.getVatNr(), reservation.getVatStatus(), false, false);
            if (transactionDetails.getPaymentProvider() != PaymentProxy.ADMIN) {
                ZonedDateTime timestamp = Objects.requireNonNullElseGet(transactionDetails.getTimestamp(), () -> LocalDateTime.now(this.clockProvider.getClock())).atZone(purchaseContext.getZoneId());
                if (this.transactionRepository.transactionExists(reservationId)) {
                    this.paymentManager.updateTransactionDetails(reservationId, transactionDetails.getNotes(), timestamp, null);
                } else {
                    BigDecimal paidAmount = Objects.requireNonNullElse(transactionDetails.getPaidAmount(), BigDecimal.ZERO);
                    this.transactionRepository.insert(StringUtils.trimToEmpty((String)transactionDetails.getId()), "", reservationId, timestamp, MonetaryUtil.unitToCents((BigDecimal)paidAmount, (String)reservation.getCurrencyCode()), reservation.getCurrencyCode(), "", transactionDetails.getPaymentProvider().name(), 0L, 0L, Transaction.Status.COMPLETE, Map.of("transactionNotes", StringUtils.trimToEmpty((String)transactionDetails.getNotes())));
                }
            }
            this.ticketReservationManager.completeReservation(spec, transactionDetails.getPaymentProvider(), notification.isCustomer(), notification.isAttendees(), username);
            return Result.success((Object)reservationId);
        }
        catch (Exception e) {
            return Result.error((ErrorCode)ErrorCode.ReservationError.UPDATE_FAILED);
        }
    }

    @Transactional
    Result<Pair<Event, AdminReservationModification>> validateTickets(AdminReservationModification input, Event event) {
        Set keys = input.getTicketsInfo().stream().flatMap(ti -> ti.getAttendees().stream()).flatMap(a -> a.getAdditionalInfo().keySet().stream()).map(String::toLowerCase).collect(Collectors.toSet());
        if (keys.isEmpty()) {
            return Result.success((Object)Pair.of((Object)event, (Object)input));
        }
        List existing = this.purchaseContextFieldRepository.getExistingFields(event.getId(), keys);
        if (existing.size() == keys.size()) {
            return Result.success((Object)Pair.of((Object)event, (Object)input));
        }
        return Result.error(keys.stream().filter(k -> !existing.contains(k)).map(k -> ErrorCode.custom((String)("error.notfound." + k), (String)(k + " not found"))).collect(Collectors.toList()));
    }

    private Result<Pair<TicketReservation, List<Ticket>>> transactionalCreateReservation(AdminReservationModification input, Event event, String username) {
        return Wrappers.optionally(() -> {
            this.eventManager.checkOwnership((EventAndOrganizationId)event, username, event.getOrganizationId());
            return event;
        }).map(e -> this.processReservation(input, username, e)).orElseGet(() -> Result.error(Collections.singletonList(ErrorCode.EventError.NOT_FOUND)));
    }

    private Result<Pair<TicketReservation, List<Ticket>>> processReservation(AdminReservationModification input, String username, Event event) {
        return input.getTicketsInfo().stream().map(ti -> this.checkCategoryCapacity(ti, event, input, username)).reduce((r1, r2) -> this.reduceResults(r1, r2, (arg_0, arg_1) -> this.joinData(arg_0, arg_1))).map(r -> this.createReservation(r, event, input)).orElseGet(() -> Result.error(Collections.singletonList(ErrorCode.custom((String)"", (String)"something went wrong..."))));
    }

    private List<AdminReservationModification.TicketsInfo> joinData(List<AdminReservationModification.TicketsInfo> t1, List<AdminReservationModification.TicketsInfo> t2) {
        ArrayList<AdminReservationModification.TicketsInfo> join = new ArrayList<AdminReservationModification.TicketsInfo>();
        join.addAll(t1);
        join.addAll(t2);
        return join;
    }

    private Result<Pair<TicketReservation, List<Ticket>>> createReservation(Result<List<AdminReservationModification.TicketsInfo>> input, Event event, AdminReservationModification arm) {
        AdminReservationModification.TicketsInfo empty = new AdminReservationModification.TicketsInfo(null, null, false, Boolean.valueOf(false));
        return input.flatMap(t -> {
            String reservationId = UUID.randomUUID().toString();
            Date validity = Date.from(arm.getExpiration().toZonedDateTime(event.getZoneId()).toInstant());
            this.ticketReservationRepository.createNewReservation(reservationId, event.now(this.clockProvider), validity, null, arm.getLanguage(), Integer.valueOf(event.getId()), event.getVat(), Boolean.valueOf(event.isVatIncluded()), event.getCurrency(), event.getOrganizationId(), null);
            AdminReservationModification.CustomerData customerData = arm.getCustomerData();
            this.ticketReservationRepository.updateTicketReservation(reservationId, TicketReservation.TicketReservationStatus.PENDING.name(), customerData.getEmailAddress(), customerData.getFullName(), customerData.getFirstName(), customerData.getLastName(), arm.getLanguage(), customerData.getBillingAddress(), null, null, customerData.getCustomerReference());
            Result result = this.flattenTicketsInfo(event, empty, t).map(pair -> this.reserveForTicketsInfo(event, arm, reservationId, pair)).reduce((arg_0, arg_1) -> this.reduceReservationResults(arg_0, arg_1)).orElseGet(() -> Result.error((ErrorCode)ErrorCode.custom((String)"", (String)"unknown error")));
            return result.map(list -> Pair.of((Object)this.ticketReservationRepository.findReservationById(reservationId), (Object)list));
        });
    }

    private Result<List<Ticket>> reserveForTicketsInfo(Event event, AdminReservationModification arm, String reservationId, Pair<TicketCategory, AdminReservationModification.TicketsInfo> pair) {
        List codes;
        TicketCategory category = (TicketCategory)pair.getLeft();
        AdminReservationModification.TicketsInfo ticketsInfo = (AdminReservationModification.TicketsInfo)pair.getRight();
        int categoryId = category.getId();
        List attendees = ticketsInfo.getAttendees();
        List reservedForUpdate = this.ticketReservationManager.reserveTickets(event.getId(), categoryId, attendees.size(), Collections.singletonList(Ticket.TicketStatus.FREE));
        if (reservedForUpdate.isEmpty() || reservedForUpdate.size() != attendees.size()) {
            return Result.error((ErrorCode)ErrorCode.CategoryError.NOT_ENOUGH_SEATS);
        }
        String currencyCode = category.getCurrencyCode();
        this.ticketRepository.reserveTickets(reservationId, reservedForUpdate, category, arm.getLanguage(), event.getVatStatus(), i -> null);
        Ticket ticket = this.ticketRepository.findById(((Integer)reservedForUpdate.get(0)).intValue(), categoryId);
        TicketPriceContainer priceContainer = TicketPriceContainer.from((Ticket)ticket, null, (BigDecimal)event.getVat(), (PriceContainer.VatStatus)event.getVatStatus(), null);
        this.ticketRepository.updateTicketPrice(reservedForUpdate, categoryId, event.getId(), category.getSrcPriceCts(), MonetaryUtil.unitToCents((BigDecimal)priceContainer.getFinalPrice(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)priceContainer.getVAT(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)priceContainer.getAppliedDiscount(), (String)currencyCode), currencyCode, priceContainer.getVatStatus());
        List list = codes = category.isAccessRestricted() ? this.bindSpecialPriceTokens(categoryId, attendees) : Collections.emptyList();
        if (category.isAccessRestricted() && codes.size() < attendees.size()) {
            return Result.error((ErrorCode)ErrorCode.CategoryError.NOT_ENOUGH_SEATS);
        }
        this.assignTickets(event, attendees, categoryId, reservedForUpdate, codes, reservationId, arm.getLanguage(), category.getSrcPriceCts());
        List tickets = reservedForUpdate.stream().map(id -> this.ticketRepository.findById(id.intValue(), categoryId)).collect(Collectors.toList());
        return Result.success(tickets);
    }

    private Result<List<Ticket>> reduceReservationResults(Result<List<Ticket>> r1, Result<List<Ticket>> r2) {
        return this.reduceResults(r1, r2, (arg_0, arg_1) -> this.joinCreateReservationResults(arg_0, arg_1));
    }

    private List<Ticket> joinCreateReservationResults(List<Ticket> r1, List<Ticket> r2) {
        ArrayList<Ticket> data = new ArrayList<Ticket>(r1);
        data.addAll(r2);
        return data;
    }

    private <T> Result<T> reduceResults(Result<T> r1, Result<T> r2, BinaryOperator<T> processData) {
        boolean successful = r1.isSuccess() && r2.isSuccess();
        Result.ResultStatus global = r1.isSuccess() ? r2.getStatus() : r1.getStatus();
        ArrayList errors = new ArrayList();
        if (!successful) {
            errors.addAll(r1.getErrors());
            errors.addAll(r2.getErrors());
            return new Result(global, null, errors);
        }
        return new Result(global, processData.apply(r1.getData(), r2.getData()), errors);
    }

    private Stream<Pair<TicketCategory, AdminReservationModification.TicketsInfo>> flattenTicketsInfo(Event event, AdminReservationModification.TicketsInfo empty, List<AdminReservationModification.TicketsInfo> t) {
        return t.stream().collect(Collectors.groupingBy(ti -> ti.getCategory().getExistingCategoryId())).entrySet().stream().map(entry -> {
            AdminReservationModification.TicketsInfo ticketsInfo = ((List)entry.getValue()).stream().reduce((ti1, ti2) -> {
                ArrayList attendees = new ArrayList(ti1.getAttendees());
                attendees.addAll(ti2.getAttendees());
                return new AdminReservationModification.TicketsInfo(ti1.getCategory(), attendees, ti1.isAddSeatsIfNotAvailable() && ti2.isAddSeatsIfNotAvailable(), Boolean.valueOf(ti1.isUpdateAttendees() && ti2.isUpdateAttendees()));
            }).orElse(empty);
            return Pair.of((Object)this.ticketCategoryRepository.getByIdAndActive(((Integer)entry.getKey()).intValue(), event.getId()), (Object)ticketsInfo);
        });
    }

    private List<SpecialPrice> bindSpecialPriceTokens(int categoryId, List<AdminReservationModification.Attendee> attendees) {
        this.specialPriceTokenGenerator.generatePendingCodesForCategory(categoryId);
        List codes = this.specialPriceRepository.findActiveNotAssignedByCategoryId(categoryId, attendees.size());
        codes.forEach(c -> this.specialPriceRepository.updateStatus(c.getId(), SpecialPrice.Status.PENDING.toString(), null, null));
        return codes;
    }

    private void assignTickets(Event event, List<AdminReservationModification.Attendee> attendees, int categoryId, List<Integer> reservedForUpdate, List<SpecialPrice> codes, String reservationId, String userLanguage, int srcPriceCts) {
        Optional<Iterator> specialPriceIterator = Optional.of(codes).filter(c -> !c.isEmpty()).map(Collection::iterator);
        for (int i = 0; i < reservedForUpdate.size(); ++i) {
            AdminReservationModification.Attendee attendee = attendees.get(i);
            Integer ticketId = reservedForUpdate.get(i);
            if (!attendee.isEmpty()) {
                this.ticketRepository.updateTicketOwnerById(ticketId.intValue(), attendee.getEmailAddress(), attendee.getFullName(), attendee.getFirstName(), attendee.getLastName());
                if (StringUtils.isNotBlank((CharSequence)attendee.getReference()) || attendee.isReassignmentForbidden()) {
                    this.updateExtRefAndLocking(categoryId, attendee, ticketId);
                }
                if (!attendee.getAdditionalInfo().isEmpty()) {
                    this.purchaseContextFieldRepository.updateOrInsert(attendee.getAdditionalInfo(), (PurchaseContext)event, ticketId, null);
                }
                if (!attendee.getMetadata().isEmpty()) {
                    TicketMetadata ticketMetadata = new TicketMetadata(null, null, attendee.getMetadata());
                    this.ticketRepository.updateTicketMetadata(ticketId.intValue(), TicketMetadataContainer.fromMetadata((TicketMetadata)ticketMetadata));
                }
            }
            specialPriceIterator.map(Iterator::next).ifPresent(code -> this.ticketRepository.reserveTicket(reservationId, ticketId.intValue(), code.getId(), userLanguage, srcPriceCts, event.getCurrency(), event.getVatStatus(), null));
        }
    }

    private void updateExtRefAndLocking(int categoryId, AdminReservationModification.Attendee attendee, Integer ticketId) {
        try {
            this.ticketRepository.updateExternalReferenceAndLocking(ticketId.intValue(), categoryId, StringUtils.trimToNull((String)attendee.getReference()), attendee.isReassignmentForbidden());
        }
        catch (DataIntegrityViolationException ex) {
            log.warn("Duplicate found for external reference: " + attendee.getReference() + " and ticketID: " + ticketId);
            throw new DuplicateReferenceException("Duplicated Reference: " + attendee.getReference(), (Throwable)ex);
        }
    }

    private Result<List<AdminReservationModification.TicketsInfo>> checkCategoryCapacity(AdminReservationModification.TicketsInfo ti, Event event, AdminReservationModification reservation, String username) {
        Result ticketCategoryResult = ti.getCategory().isExisting() ? this.checkExistingCategory(ti, event, username) : this.createCategory(ti, event, reservation, username);
        return ticketCategoryResult.map(tc -> List.of(new AdminReservationModification.TicketsInfo(new AdminReservationModification.Category(Integer.valueOf(tc.getId()), tc.getName(), tc.getPrice(), tc.getTicketAccessType()), ti.getAttendees(), ti.isAddSeatsIfNotAvailable(), Boolean.valueOf(ti.isUpdateAttendees()))));
    }

    private Result<TicketCategory> createCategory(AdminReservationModification.TicketsInfo ti, Event event, AdminReservationModification reservation, String username) {
        AdminReservationModification.Category category = ti.getCategory();
        List attendees = ti.getAttendees();
        DateTimeModification inception = DateTimeModification.fromZonedDateTime((ZonedDateTime)event.now(this.clockProvider));
        int tickets = attendees.size();
        TicketCategory.TicketAccessType accessType = event.getFormat() != Event.EventFormat.HYBRID ? TicketCategory.TicketAccessType.INHERIT : Objects.requireNonNull(category.getTicketAccessType());
        TicketCategoryModification tcm = new TicketCategoryModification(category.getExistingCategoryId(), category.getName(), accessType, tickets, inception, reservation.getExpiration(), Collections.emptyMap(), category.getPrice(), true, "", true, null, null, null, null, null, Integer.valueOf(0), null, null, AlfioMetadata.empty());
        int notAllocated = this.getNotAllocatedTickets((EventAndOrganizationId)event);
        int missingTickets = Math.max(tickets - notAllocated, 0);
        Event modified = this.increaseSeatsIfNeeded(ti, event, missingTickets, event);
        return this.eventManager.insertCategory(modified, tcm, username).map(id -> this.ticketCategoryRepository.getByIdAndActive(id.intValue(), event.getId()));
    }

    private Event increaseSeatsIfNeeded(AdminReservationModification.TicketsInfo ti, Event event, int missingTickets, Event modified) {
        if (missingTickets > 0 && ti.isAddSeatsIfNotAvailable()) {
            int newTotal = this.eventRepository.countExistingTickets(event.getId()) + missingTickets;
            this.extensionManager.handleEventSeatsUpdateValidation(event, newTotal);
            this.createMissingTickets(event, missingTickets);
            log.debug("adding {} extra seats to the event", (Object)missingTickets);
            this.eventRepository.updateAvailableSeats(event.getId(), newTotal);
            modified = this.eventRepository.findById(event.getId());
        }
        return modified;
    }

    private int getNotAllocatedTickets(EventAndOrganizationId event) {
        return this.ticketRepository.countFreeTicketsForUnbounded(event.getId());
    }

    private Result<TicketCategory> checkExistingCategory(AdminReservationModification.TicketsInfo ti, Event event, String username) {
        AdminReservationModification.Category category = ti.getCategory();
        List attendees = ti.getAttendees();
        int tickets = attendees.size();
        int eventId = event.getId();
        TicketCategory existing = this.ticketCategoryRepository.getByIdAndActive(category.getExistingCategoryId().intValue(), eventId);
        int existingCategoryId = existing.getId();
        int freeTicketsInCategory = this.ticketRepository.countFreeTickets(eventId, existingCategoryId);
        int notAllocated = this.getNotAllocatedTickets((EventAndOrganizationId)event);
        int missingTickets = Math.max(tickets - (freeTicketsInCategory + notAllocated), 0);
        Event modified = this.increaseSeatsIfNeeded(ti, event, missingTickets, event);
        if (freeTicketsInCategory < tickets && existing.isBounded()) {
            int maxTickets = existing.getMaxTickets() + (tickets - freeTicketsInCategory);
            TicketCategoryModification tcm = new TicketCategoryModification(Integer.valueOf(existingCategoryId), existing.getName(), existing.getTicketAccessType(), maxTickets, DateTimeModification.fromZonedDateTime((ZonedDateTime)existing.getInception(modified.getZoneId())), DateTimeModification.fromZonedDateTime((ZonedDateTime)existing.getExpiration(event.getZoneId())), Collections.emptyMap(), existing.getPrice(), existing.isAccessRestricted(), "", true, existing.getCode(), DateTimeModification.fromZonedDateTime((ZonedDateTime)existing.getValidCheckInFrom(modified.getZoneId())), DateTimeModification.fromZonedDateTime((ZonedDateTime)existing.getValidCheckInTo(modified.getZoneId())), DateTimeModification.fromZonedDateTime((ZonedDateTime)existing.getTicketValidityStart(modified.getZoneId())), DateTimeModification.fromZonedDateTime((ZonedDateTime)existing.getTicketValidityEnd(modified.getZoneId())), Integer.valueOf(0), existing.getTicketCheckInStrategy(), null, AlfioMetadata.empty());
            return this.eventManager.updateCategory(existingCategoryId, modified, tcm, username, true);
        }
        return Result.success((Object)existing);
    }

    private void createMissingTickets(Event event, int tickets) {
        MapSqlParameterSource[] params = (MapSqlParameterSource[])EventUtil.generateEmptyTickets((EventAndOrganizationId)event, (Date)Date.from(event.now(this.clockProvider).toInstant()), (int)tickets, (Ticket.TicketStatus)Ticket.TicketStatus.FREE).toArray(MapSqlParameterSource[]::new);
        this.ticketRepository.bulkTicketInitialization(params);
    }

    @Transactional
    public Optional<Ticket> findTicketWithReservationId(String ticketUUID, String eventSlug, String username) {
        return this.eventManager.getOptionalEventAndOrganizationIdByName(eventSlug, username).flatMap(eventAndOrganizationId -> {
            Ticket ticket = this.ticketRepository.findByUUID(ticketUUID);
            if (ticket.getEventId() != eventAndOrganizationId.getId() || StringUtils.isEmpty((CharSequence)ticket.getTicketsReservationId())) {
                return Optional.empty();
            }
            return Optional.of(ticket);
        });
    }

    @Transactional
    public Result<Boolean> removeTickets(String publicIdentifier, String reservationId, List<Integer> ticketIds, List<Integer> toRefund, boolean notify, boolean creditNoteRequested, String username) {
        return this.loadReservation(PurchaseContext.PurchaseContextType.event, publicIdentifier, reservationId, username).map(res -> {
            Event e = (Event)((PurchaseContext)res.getRight()).event().orElseThrow();
            TicketReservation reservation = (TicketReservation)res.getLeft();
            List tickets = (List)res.getMiddle();
            Map ticketsById = tickets.stream().collect(Collectors.toMap(Ticket::getId, Function.identity()));
            Set ticketIdsInReservation = tickets.stream().map(Ticket::getId).collect(Collectors.toSet());
            Assert.isTrue((boolean)ticketIdsInReservation.containsAll(ticketIds), (String)"Some ticket ids are not contained in the reservation");
            Assert.isTrue((boolean)ticketIdsInReservation.containsAll(toRefund), (String)"Some ticket ids to refund are not contained in the reservation");
            if (!this.ticketsStatusIsCompatibleWithCancellation(tickets.stream().filter(t -> ticketIds.contains(t.getId())))) {
                throw new IncompatibleStateException("Cannot remove checked-in tickets");
            }
            this.handleTicketsRefund(toRefund, e, reservation, ticketsById, username);
            boolean removeReservation = tickets.size() - ticketIds.size() <= 0;
            boolean issueCreditNote = creditNoteRequested && (!toRefund.isEmpty() || !reservation.getPaymentMethod().isSupportRefund());
            this.removeTicketsFromReservation(reservation, e, ticketIds, notify, username, removeReservation, issueCreditNote);
            if (removeReservation) {
                this.markAsCancelled(reservation, username, (PurchaseContext)e);
                this.additionalServiceItemRepository.updateItemsStatusWithReservationUUID(e.getId(), reservation.getId(), AdditionalServiceItem.AdditionalServiceItemStatus.CANCELLED);
            } else {
                TotalPrice totalPrice = (TotalPrice)this.ticketReservationManager.totalReservationCostWithVAT(reservationId).getLeft();
                String currencyCode = totalPrice.getCurrencyCode();
                List updatedTickets = this.ticketRepository.findTicketsInReservation(reservationId);
                PromoCodeDiscount discount = reservation.getPromoCodeDiscountId() != null ? this.promoCodeDiscountRepository.findById(reservation.getPromoCodeDiscountId().intValue()) : null;
                List additionalServiceItems = this.additionalServiceItemRepository.findByReservationUuid(e.getId(), reservationId);
                ReservationPriceCalculator calculator = new ReservationPriceCalculator(reservation, discount, updatedTickets, additionalServiceItems, this.additionalServiceRepository.loadAllForEvent(e.getId()), (PurchaseContext)e, List.of(), Optional.empty());
                this.ticketReservationRepository.updateBillingData(calculator.getVatStatus(), calculator.getSrcPriceCts(), MonetaryUtil.unitToCents((BigDecimal)calculator.getFinalPrice(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)calculator.getVAT(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)calculator.getAppliedDiscount(), (String)currencyCode), calculator.getCurrencyCode(), reservation.getVatNr(), reservation.getVatCountryCode(), reservation.isInvoiceRequested(), reservationId);
            }
            return issueCreditNote;
        });
    }

    @Transactional
    public Optional<Pair<SubscriptionDescriptor, String>> findReservationIdForSubscription(String subscriptionDescriptorId, UUID subscriptionId, Principal principal) {
        return this.purchaseContextManager.findBy(PurchaseContext.PurchaseContextType.subscription, subscriptionDescriptorId).flatMap(purchaseContext -> {
            this.accessService.checkOrganizationOwnership(principal, Integer.valueOf(purchaseContext.getOrganizationId()));
            Subscription subscription = this.subscriptionRepository.findSubscriptionById(subscriptionId);
            SubscriptionDescriptor descriptor = (SubscriptionDescriptor)purchaseContext;
            if (subscription.getSubscriptionDescriptorId().equals(descriptor.getId()) && StringUtils.isNotBlank((CharSequence)subscription.getReservationId())) {
                return Optional.of(Pair.of((Object)descriptor, (Object)subscription.getReservationId()));
            }
            return Optional.empty();
        });
    }

    @Transactional
    public Result<Boolean> removeSubscription(SubscriptionDescriptor descriptor, String reservationId, UUID subscriptionId, String username) {
        int result = this.subscriptionRepository.cancelSubscription(reservationId, subscriptionId, descriptor.getId());
        this.markAsCancelled((TicketReservation)this.ticketReservationManager.findById(reservationId).orElseThrow(), username, (PurchaseContext)descriptor);
        return result == 1 ? Result.success((Object)true) : Result.error((ErrorCode)ErrorCode.custom((String)"cannot-cancel-subscription", (String)"Cannot cancel subscription"));
    }

    @Transactional(readOnly=true)
    public Result<List<Audit>> getAudit(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, String username) {
        return Result.success((Object)this.auditingRepository.findAllForReservation(reservationId));
    }

    @Transactional(readOnly=true)
    public Result<List<BillingDocument>> getBillingDocuments(String eventName, String reservationId, String username) {
        return Result.success((Object)this.billingDocumentRepository.findAllByReservationId(reservationId));
    }

    @Transactional(readOnly=true)
    public Result<Pair<BillingDocument, byte[]>> getSingleBillingDocumentAsPdf(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, long documentId, String username) {
        return this.loadReservation(purchaseContextType, publicIdentifier, reservationId, username).map(res -> {
            BillingDocument billingDocument = (BillingDocument)this.billingDocumentRepository.findByIdAndReservationId(documentId, reservationId).orElseThrow(IllegalArgumentException::new);
            Function<Map, Optional> pdfGenerator = model -> TemplateProcessor.buildBillingDocumentPdf((BillingDocument.Type)billingDocument.getType(), (PurchaseContext)((PurchaseContext)res.getRight()), (FileUploadManager)this.fileUploadManager, (Locale)LocaleUtil.forLanguageTag((String)((TicketReservation)res.getLeft()).getUserLanguage()), (TemplateManager)this.templateManager, (Map)model, (ExtensionManager)this.extensionManager);
            Map billingModel = billingDocument.getModel();
            return Pair.of((Object)billingDocument, (Object)pdfGenerator.apply(billingModel).orElse(null));
        });
    }

    @Transactional
    public Result<Boolean> invalidateBillingDocument(String reservationId, long documentId, String username) {
        return this.updateBillingDocumentStatus(reservationId, documentId, username, BillingDocument.Status.NOT_VALID, Audit.EventType.BILLING_DOCUMENT_INVALIDATED);
    }

    @Transactional
    public Result<Boolean> restoreBillingDocument(String reservationId, long documentId, String username) {
        return this.updateBillingDocumentStatus(reservationId, documentId, username, BillingDocument.Status.VALID, Audit.EventType.BILLING_DOCUMENT_RESTORED);
    }

    private Result<Boolean> updateBillingDocumentStatus(String reservationId, long documentId, String username, BillingDocument.Status status, Audit.EventType eventType) {
        return this.loadReservation(reservationId).map(res -> {
            Integer userId = this.userRepository.findIdByUserName(username).orElse(null);
            this.auditingRepository.insert(reservationId, userId, (PurchaseContext)res.getRight(), eventType, new Date(), Audit.EntityType.RESERVATION, String.valueOf(documentId));
            return this.billingDocumentRepository.updateStatus(documentId, status, reservationId) == 1;
        });
    }

    @Transactional
    public Result<TransactionAndPaymentInfo> getPaymentInfo(String reservationId) {
        return this.loadReservation(reservationId).map(res -> this.paymentManager.getInfo((TicketReservation)res.getLeft(), (PurchaseContext)res.getRight()));
    }

    @Transactional
    public Result<Boolean> removeReservation(PurchaseContext.PurchaseContextType purchaseContextType, String eventName, String reservationId, boolean refund, boolean notify, boolean creditNoteRequested, String username) {
        return this.loadReservation(purchaseContextType, eventName, reservationId, username).flatMap(result -> new Result.Builder().checkPrecondition(() -> this.ticketsStatusIsCompatibleWithCancellation((List)result.getMiddle()), ERROR_CANNOT_CANCEL_CHECKED_IN_TICKETS).buildAndEvaluate(() -> {
            TicketReservation reservation = (TicketReservation)result.getLeft();
            ErrorCode refundErrorCode = this.refundIfRequested(reservation, (PurchaseContext)result.getRight(), username, refund);
            if (refundErrorCode != null) {
                return Result.error((ErrorCode)refundErrorCode);
            }
            if (creditNoteRequested && reservation.getHasInvoiceNumber()) {
                this.ticketReservationManager.issueCreditNoteForReservation((PurchaseContext)result.getRight(), reservation, username, false);
            }
            return this.removeReservation(result, false, notify, username, true, false);
        })).map(pair -> {
            PurchaseContext purchaseContext = (PurchaseContext)pair.getLeft();
            TicketReservation ticketReservation = (TicketReservation)pair.getRight();
            if (!creditNoteRequested || !ticketReservation.getHasInvoiceNumber()) {
                this.markAsCancelled(ticketReservation, username, purchaseContext);
            }
            if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.subscription)) {
                this.subscriptionRepository.cancelSubscriptions(reservationId);
            }
            return true;
        });
    }

    @Transactional
    public void creditReservation(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, boolean refund, boolean notify, String username) {
        this.loadReservation(purchaseContextType, publicIdentifier, reservationId, username).ifSuccess(res -> {
            if (((TicketReservation)res.getLeft()).getStatus() == TicketReservation.TicketReservationStatus.OFFLINE_PAYMENT) {
                this.ticketReservationManager.deleteOfflinePayment((Event)((PurchaseContext)res.getRight()).event().orElseThrow(), reservationId, false, true, notify, username);
            } else {
                this.removeReservation(res, refund, notify, username, false, true);
            }
        });
    }

    private Result<Pair<PurchaseContext, TicketReservation>> removeReservation(Triple<TicketReservation, List<Ticket>, PurchaseContext> triple, boolean refund, boolean notify, String username, boolean removeReservation, boolean issueCreditNote) {
        return new Result.Builder().checkPrecondition(() -> this.ticketsStatusIsCompatibleWithCancellation((List)triple.getMiddle()), ERROR_CANNOT_CANCEL_CHECKED_IN_TICKETS).buildAndEvaluate(() -> {
            PurchaseContext pc = (PurchaseContext)triple.getRight();
            TicketReservation reservation = (TicketReservation)triple.getLeft();
            ErrorCode refundErrorCode = this.refundIfRequested(reservation, pc, username, refund);
            if (refundErrorCode != null) {
                return Result.error((ErrorCode)refundErrorCode);
            }
            return Result.success((Object)triple);
        }).map(t -> {
            PurchaseContext purchaseContext = (PurchaseContext)t.getRight();
            TicketReservation reservation = (TicketReservation)t.getLeft();
            List tickets = (List)t.getMiddle();
            this.specialPriceRepository.resetToFreeAndCleanupForReservation(List.of(reservation.getId()));
            if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
                Event event = (Event)purchaseContext;
                this.removeTicketsFromReservation(reservation, event, tickets.stream().map(Ticket::getId).collect(Collectors.toList()), notify, username, removeReservation, issueCreditNote);
                this.additionalServiceItemRepository.updateItemsStatusWithReservationUUID(event.getId(), reservation.getId(), AdditionalServiceItem.AdditionalServiceItemStatus.CANCELLED);
            }
            return Pair.of((Object)purchaseContext, (Object)reservation);
        });
    }

    private ErrorCode refundIfRequested(TicketReservation reservation, PurchaseContext purchaseContext, String username, boolean requested) {
        boolean refundResult;
        if (requested && reservation.getPaymentMethod() != null && reservation.getPaymentMethod().isSupportRefund() && !(refundResult = this.paymentManager.refund(reservation, purchaseContext, null, username))) {
            return ErrorCode.custom((String)"refund.failed", (String)"Cannot perform refund");
        }
        return null;
    }

    private boolean ticketsStatusIsCompatibleWithCancellation(List<Ticket> tickets) {
        return this.ticketsStatusIsCompatibleWithCancellation(tickets.stream());
    }

    private boolean ticketsStatusIsCompatibleWithCancellation(Stream<Ticket> ticketsStream) {
        return ticketsStream.noneMatch(c -> c.getStatus() == Ticket.TicketStatus.CHECKED_IN);
    }

    @Transactional
    public Result<Boolean> refund(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, BigDecimal refundAmount, String username) {
        return this.loadReservation(purchaseContextType, publicIdentifier, reservationId, username).map(res -> {
            TicketReservation reservation = (TicketReservation)res.getLeft();
            PurchaseContext purchaseContext = (PurchaseContext)res.getRight();
            if (reservation.getHasInvoiceNumber()) {
                this.ticketReservationManager.issueCreditNoteForRefund(purchaseContext, reservation, refundAmount, username);
            }
            return reservation.getPaymentMethod() != null && reservation.getPaymentMethod().isSupportRefund() && this.paymentManager.refund(reservation, purchaseContext, Integer.valueOf(MonetaryUtil.unitToCents((BigDecimal)refundAmount, (String)reservation.getCurrencyCode())), username);
        });
    }

    @Transactional
    public Result<Boolean> regenerateBillingDocument(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, String username) {
        return this.loadReservation(purchaseContextType, publicIdentifier, reservationId, username).map(res -> {
            TicketReservation reservation;
            PurchaseContext event = (PurchaseContext)res.getRight();
            BillingDocument billingDocument = this.billingDocumentManager.createBillingDocument(event, reservation = (TicketReservation)res.getLeft(), username, this.ticketReservationManager.orderSummaryForReservation(reservation, event));
            if (billingDocument.getType() != BillingDocument.Type.CREDIT_NOTE) {
                this.billingDocumentRepository.invalidateAllPreviousDocumentsOfType(billingDocument.getType(), Long.valueOf(billingDocument.getId()), reservationId);
            }
            return true;
        });
    }

    @Transactional
    public Result<List<LightweightMailMessage>> getEmailsForReservation(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier, String reservationId, String username) {
        return this.loadReservation(purchaseContextType, publicIdentifier, reservationId, username).map(res -> this.notificationManager.loadAllMessagesForReservationId((PurchaseContext)res.getRight(), reservationId));
    }

    @Transactional
    public List<TicketWithMetadataAttributes> findTicketsWithMetadata(String reservationId) {
        return this.ticketRepository.findTicketsInReservationWithMetadata(reservationId);
    }

    @Transactional
    public SubscriptionMetadata findSubscriptionMetadata(UUID subscriptionId) {
        return this.subscriptionRepository.getSubscriptionMetadata(subscriptionId);
    }

    private void removeTicketsFromReservation(TicketReservation reservation, Event purchaseContext, List<Integer> ticketIds, boolean notify, String username, boolean removeReservation, boolean issueCreditNote) {
        String reservationId = reservation.getId();
        if (!ticketIds.isEmpty() && issueCreditNote && reservation.getHasInvoiceNumber()) {
            this.ticketReservationManager.issuePartialCreditNoteForReservation(purchaseContext, reservation, username, ticketIds);
        }
        if (notify && !ticketIds.isEmpty()) {
            Organization o = this.eventManager.loadOrganizer((EventAndOrganizationId)purchaseContext, username);
            this.ticketRepository.findByIds(ticketIds).forEach(t -> {
                if (StringUtils.isNotBlank((CharSequence)t.getEmail())) {
                    this.sendTicketHasBeenRemoved(purchaseContext, o, t);
                }
            });
        }
        if (!issueCreditNote || !reservation.getHasInvoiceNumber()) {
            this.billingDocumentManager.ensureBillingDocumentIsPresent((PurchaseContext)purchaseContext, reservation, username, () -> this.ticketReservationManager.orderSummaryForReservation(reservation, (PurchaseContext)purchaseContext));
        }
        Integer userId = this.userRepository.findIdByUserName(username).orElse(null);
        Date date = new Date();
        ticketIds.forEach(id -> this.auditingRepository.insert(reservationId, userId, Integer.valueOf(purchaseContext.getId()), Audit.EventType.CANCEL_TICKET, date, Audit.EntityType.TICKET, id.toString()));
        this.ticketRepository.resetCategoryIdForUnboundedCategoriesWithTicketIds(ticketIds);
        this.purchaseContextFieldRepository.deleteAllValuesForTicketIds(ticketIds);
        this.specialPriceRepository.resetToFreeAndCleanupForTickets(ticketIds);
        List reservationIds = this.ticketRepository.findReservationIds(ticketIds);
        List ticketUUIDs = this.ticketRepository.findUUIDs(ticketIds);
        int[] results = this.ticketRepository.batchReleaseTickets(reservationId, ticketIds, purchaseContext);
        Validate.isTrue((Arrays.stream(results).sum() == ticketIds.size() ? 1 : 0) != 0, (String)"Failed to update tickets", (Object[])new Object[0]);
        if (!removeReservation) {
            this.extensionManager.handleTicketCancelledForEvent(purchaseContext, (Collection)ticketUUIDs);
        } else {
            this.extensionManager.handleReservationsCancelled((PurchaseContext)purchaseContext, (Collection)reservationIds);
        }
    }

    private void sendTicketHasBeenRemoved(Event event, Organization organization, Ticket ticket) {
        Map model = TemplateResource.buildModelForTicketHasBeenCancelled((Organization)organization, (Event)event, (Ticket)ticket);
        Locale locale = LocaleUtil.forLanguageTag((String)Optional.ofNullable(ticket.getUserLanguage()).orElse("en"));
        this.notificationManager.sendSimpleEmail((PurchaseContext)event, ticket.getTicketsReservationId(), ticket.getEmail(), this.messageSourceManager.getMessageSourceFor((PurchaseContext)event).getMessage("email-ticket-released.subject", new Object[]{event.getDisplayName()}, locale), () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.TICKET_HAS_BEEN_CANCELLED, model, locale));
    }

    private void markAsCancelled(TicketReservation ticketReservation, String username, PurchaseContext purchaseContext) {
        this.markAsCancelled(ticketReservation.getId(), username, purchaseContext);
    }

    private void markAsCancelled(String reservationId, String username, PurchaseContext purchaseContext) {
        this.ticketReservationRepository.updateReservationStatus(reservationId, TicketReservation.TicketReservationStatus.CANCELLED.toString());
        this.auditingRepository.insert(reservationId, (Integer)this.userRepository.nullSafeFindIdByUserName(username).orElse(null), purchaseContext, Audit.EventType.CANCEL_RESERVATION, new Date(), Audit.EntityType.RESERVATION, reservationId);
    }

    private void handleTicketsRefund(List<Integer> toRefund, Event e, TicketReservation reservation, Map<Integer, Ticket> ticketsById, String username) {
        if (reservation.getPaymentMethod() == null || !reservation.getPaymentMethod().isSupportRefund()) {
            return;
        }
        for (Integer toRefundId : toRefund) {
            int toBeRefunded = ticketsById.get(toRefundId).getFinalPriceCts();
            if (toBeRefunded <= 0) continue;
            this.paymentManager.refund(reservation, (PurchaseContext)e, Integer.valueOf(toBeRefunded), username);
        }
    }

    @ConstructorProperties(value={"purchaseContextManager", "eventManager", "ticketReservationManager", "ticketCategoryRepository", "ticketRepository", "specialPriceRepository", "ticketReservationRepository", "eventRepository", "transactionManager", "specialPriceTokenGenerator", "purchaseContextFieldRepository", "paymentManager", "notificationManager", "messageSourceManager", "templateManager", "additionalServiceItemRepository", "auditingRepository", "userRepository", "extensionManager", "billingDocumentRepository", "fileUploadManager", "promoCodeDiscountRepository", "additionalServiceRepository", "billingDocumentManager", "clockProvider", "subscriptionRepository", "reservationEmailContentHelper", "transactionRepository", "accessService"})
    @Generated
    public AdminReservationManager(PurchaseContextManager purchaseContextManager, EventManager eventManager, TicketReservationManager ticketReservationManager, TicketCategoryRepository ticketCategoryRepository, TicketRepository ticketRepository, SpecialPriceRepository specialPriceRepository, TicketReservationRepository ticketReservationRepository, EventRepository eventRepository, PlatformTransactionManager transactionManager, SpecialPriceTokenGenerator specialPriceTokenGenerator, PurchaseContextFieldRepository purchaseContextFieldRepository, PaymentManager paymentManager, NotificationManager notificationManager, MessageSourceManager messageSourceManager, TemplateManager templateManager, AdditionalServiceItemRepository additionalServiceItemRepository, AuditingRepository auditingRepository, UserRepository userRepository, ExtensionManager extensionManager, BillingDocumentRepository billingDocumentRepository, FileUploadManager fileUploadManager, PromoCodeDiscountRepository promoCodeDiscountRepository, AdditionalServiceRepository additionalServiceRepository, BillingDocumentManager billingDocumentManager, ClockProvider clockProvider, SubscriptionRepository subscriptionRepository, ReservationEmailContentHelper reservationEmailContentHelper, TransactionRepository transactionRepository, AccessService accessService) {
        this.purchaseContextManager = purchaseContextManager;
        this.eventManager = eventManager;
        this.ticketReservationManager = ticketReservationManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.ticketRepository = ticketRepository;
        this.specialPriceRepository = specialPriceRepository;
        this.ticketReservationRepository = ticketReservationRepository;
        this.eventRepository = eventRepository;
        this.transactionManager = transactionManager;
        this.specialPriceTokenGenerator = specialPriceTokenGenerator;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.paymentManager = paymentManager;
        this.notificationManager = notificationManager;
        this.messageSourceManager = messageSourceManager;
        this.templateManager = templateManager;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.auditingRepository = auditingRepository;
        this.userRepository = userRepository;
        this.extensionManager = extensionManager;
        this.billingDocumentRepository = billingDocumentRepository;
        this.fileUploadManager = fileUploadManager;
        this.promoCodeDiscountRepository = promoCodeDiscountRepository;
        this.additionalServiceRepository = additionalServiceRepository;
        this.billingDocumentManager = billingDocumentManager;
        this.clockProvider = clockProvider;
        this.subscriptionRepository = subscriptionRepository;
        this.reservationEmailContentHelper = reservationEmailContentHelper;
        this.transactionRepository = transactionRepository;
        this.accessService = accessService;
    }
}

