/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.AdminReservationManager;
import alfio.manager.EventManager;
import alfio.model.AdminReservationRequest;
import alfio.model.AdminReservationRequestStats;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.modification.AdminReservationModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.user.User;
import alfio.repository.AdminReservationRequestRepository;
import alfio.repository.EventRepository;
import alfio.repository.user.UserRepository;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Component
@Transactional
public class AdminReservationRequestManager {
    private static final Logger log = LoggerFactory.getLogger(AdminReservationRequestManager.class);
    private final AdminReservationManager adminReservationManager;
    private final EventManager eventManager;
    private final UserRepository userRepository;
    private final AdminReservationRequestRepository adminReservationRequestRepository;
    private final EventRepository eventRepository;
    private final PlatformTransactionManager transactionManager;

    public Result<AdminReservationRequestStats> getRequestStatus(String requestId, String eventName, String username) {
        return this.eventManager.getOptionalEventAndOrganizationIdByName(eventName, username).flatMap(e -> this.adminReservationRequestRepository.findStatsByRequestIdAndEventId(requestId, (long)e.getId())).map(Result::success).orElseGet(() -> Result.error((ErrorCode)ErrorCode.EventError.ACCESS_DENIED));
    }

    public Result<String> scheduleReservations(String eventName, AdminReservationModification body, boolean singleReservation, String username) {
        if (singleReservation && body.getTicketsInfo().stream().mapToLong(ti -> ti.getAttendees().size()).sum() > 100L) {
            return Result.error((ErrorCode)ErrorCode.custom((String)"MAX_NUMBER_EXCEEDED", (String)"Maximum allowed attendees per reservation is 100"));
        }
        List attendeesWithDuplicateReference = body.getTicketsInfo().stream().flatMap(ti -> ti.getAttendees().stream()).filter(attendee -> StringUtils.isNotEmpty((CharSequence)attendee.getReference())).collect(Collectors.groupingBy(attendee -> attendee.getReference().trim(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).limit(5L).collect(Collectors.toList());
        if (!attendeesWithDuplicateReference.isEmpty()) {
            return Result.error((ErrorCode)ErrorCode.custom((String)"DUPLICATE_REFERENCE", (String)("The following codes are duplicate:" + attendeesWithDuplicateReference)));
        }
        return this.eventManager.getOptionalByName(eventName, username).map(event -> this.adminReservationManager.validateTickets(body, event)).map(request -> request.flatMap(pair -> this.insertRequest((AdminReservationModification)pair.getRight(), (EventAndOrganizationId)pair.getLeft(), singleReservation, username))).orElseGet(() -> Result.error((ErrorCode)ErrorCode.ReservationError.UPDATE_FAILED));
    }

    public Pair<Integer, Integer> processPendingReservations() {
        Map<Boolean, List<MapSqlParameterSource>> result = this.adminReservationRequestRepository.findPendingForUpdate(1000).stream().map(id -> {
            AdminReservationRequest request = this.adminReservationRequestRepository.fetchCompleteById(id.longValue());
            Result reservationResult = Result.fromNullable((Object)this.eventRepository.findOptionalById((int)request.getEventId()).orElse(null), (ErrorCode)ErrorCode.EventError.NOT_FOUND).flatMap(e -> Result.fromNullable((Object)this.userRepository.findOptionalById((int)request.getUserId()).map(u -> Pair.of((Object)e, (Object)u)).orElse(null), (ErrorCode)ErrorCode.EventError.ACCESS_DENIED)).flatMap(p -> this.processReservation(request, (Event)p.getLeft(), (User)p.getRight()));
            return this.buildParameterSource(id, reservationResult);
        }).collect(Collectors.partitioningBy(ps -> AdminReservationRequest.Status.SUCCESS.name().equals(ps.getValue("status"))));
        result.values().forEach(list -> {
            try {
                this.adminReservationRequestRepository.updateStatus(list);
            }
            catch (Exception e) {
                log.warn("cannot update the status of " + list.size() + " reservations", (Throwable)e);
            }
        });
        return Pair.of((Object)CollectionUtils.size(result.get(true)), (Object)CollectionUtils.size(result.get(false)));
    }

    private Result<Triple<TicketReservation, List<Ticket>, Event>> processReservation(AdminReservationRequest request, Event event, User user) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(6);
        TransactionTemplate template = new TransactionTemplate(this.transactionManager, (TransactionDefinition)definition);
        return (Result)template.execute(status -> {
            Object savepoint = status.createSavepoint();
            try {
                String eventName = event.getShortName();
                String username = user.getUsername();
                AdminReservationModification requestBody = request.getBody();
                Result result = this.adminReservationManager.createReservation(requestBody, eventName, username).flatMap(r -> this.adminReservationManager.confirmReservation(PurchaseContext.PurchaseContextType.event, eventName, ((TicketReservation)r.getLeft()).getId(), username, AdminReservationModification.Notification.orEmpty((AdminReservationModification.Notification)requestBody.getNotification()), AdminReservationModification.TransactionDetails.admin(), requestBody.getLinkedSubscriptionId())).map(triple -> Triple.of((Object)((TicketReservation)triple.getLeft()), (Object)((List)triple.getMiddle()), (Object)((Event)triple.getRight())));
                if (!result.isSuccess()) {
                    status.rollbackToSavepoint(savepoint);
                    log.warn("Cannot process reservation: \n{}", (Object)result.getFormattedErrors());
                }
                return result;
            }
            catch (Exception ex) {
                status.rollbackToSavepoint(savepoint);
                return Result.error(Collections.singletonList(ErrorCode.custom((String)"", (String)ex.getMessage())));
            }
        });
    }

    private MapSqlParameterSource buildParameterSource(Long id, Result<Triple<TicketReservation, List<Ticket>, Event>> result) {
        boolean success = result.isSuccess();
        if (!success) {
            log.warn("Cannot process request {}. Got the following errors:\n{}", (Object)id, (Object)result.getFormattedErrors());
        }
        return new MapSqlParameterSource("id", (Object)id).addValue("status", (Object)(success ? AdminReservationRequest.Status.SUCCESS.name() : AdminReservationRequest.Status.ERROR.name())).addValue("reservationId", success ? ((TicketReservation)((Triple)result.getData()).getLeft()).getId() : null).addValue("failureCode", success ? null : Optional.ofNullable(result.getFirstErrorOrNull()).map(ErrorCode::getCode).orElse(null));
    }

    private Result<String> insertRequest(AdminReservationModification body, EventAndOrganizationId event, boolean singleReservation, String username) {
        try {
            return this.insertRequest(UUID.randomUUID().toString(), body, event, singleReservation, username);
        }
        catch (DataIntegrityViolationException e) {
            log.error("data integrity violation while inserting request", (Throwable)e);
            return Result.error((ErrorCode)ErrorCode.custom((String)"internal_server_error", (String)e.getMessage()));
        }
    }

    public Result<String> insertRequest(String requestId, AdminReservationModification body, EventAndOrganizationId event, boolean singleReservation, String username) {
        try {
            long userId = ((Integer)this.userRepository.findIdByUserName(username).orElseThrow(IllegalArgumentException::new)).intValue();
            this.adminReservationRequestRepository.insertRequest(requestId, userId, event, this.spread(body, singleReservation));
            return Result.success((Object)requestId);
        }
        catch (DataIntegrityViolationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("can't insert reservation request", (Throwable)e);
            return Result.error((ErrorCode)ErrorCode.custom((String)"internal_server_error", (String)e.getMessage()));
        }
    }

    private Stream<AdminReservationModification> spread(AdminReservationModification src, boolean single) {
        if (single) {
            return Stream.of(src);
        }
        return src.getTicketsInfo().stream().flatMap(ti -> ti.getAttendees().stream().map(a -> Pair.of((Object)a, (Object)new AdminReservationModification.TicketsInfo(ti.getCategory(), Collections.singletonList(a), ti.isAddSeatsIfNotAvailable(), Boolean.valueOf(ti.isUpdateAttendees()))))).map(p -> {
            AdminReservationModification.Attendee attendee = (AdminReservationModification.Attendee)p.getLeft();
            String language = (String)StringUtils.defaultIfBlank((CharSequence)attendee.getLanguage(), (CharSequence)src.getLanguage());
            AdminReservationModification.CustomerData cd = new AdminReservationModification.CustomerData(attendee.getFirstName(), attendee.getLastName(), attendee.getEmailAddress(), null, language, null, null, null, null);
            return new AdminReservationModification(src.getExpiration(), cd, Collections.singletonList((AdminReservationModification.TicketsInfo)p.getRight()), language, Boolean.valueOf(src.isUpdateContactData()), Boolean.valueOf(false), null, src.getNotification(), null, attendee.getSubscriptionId());
        });
    }

    @ConstructorProperties(value={"adminReservationManager", "eventManager", "userRepository", "adminReservationRequestRepository", "eventRepository", "transactionManager"})
    @Generated
    public AdminReservationRequestManager(AdminReservationManager adminReservationManager, EventManager eventManager, UserRepository userRepository, AdminReservationRequestRepository adminReservationRequestRepository, EventRepository eventRepository, PlatformTransactionManager transactionManager) {
        this.adminReservationManager = adminReservationManager;
        this.eventManager = eventManager;
        this.userRepository = userRepository;
        this.adminReservationRequestRepository = adminReservationRequestRepository;
        this.eventRepository = eventRepository;
        this.transactionManager = transactionManager;
    }
}

