/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.support.CheckInResult;
import alfio.manager.support.CheckInStatus;
import alfio.manager.support.DefaultCheckInResult;
import alfio.manager.support.SponsorAttendeeData;
import alfio.manager.support.TicketAndCheckInResult;
import alfio.manager.user.UserManager;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.SponsorScan;
import alfio.model.Ticket;
import alfio.model.TicketWithCategory;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.support.TicketWithAdditionalFields;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.EventRepository;
import alfio.repository.SponsorScanRepository;
import alfio.repository.TicketRepository;
import alfio.repository.user.UserRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class AttendeeManager {
    public static final String DEFAULT_OPERATOR_ID = "__DEFAULT__";
    private final SponsorScanRepository sponsorScanRepository;
    private final EventRepository eventRepository;
    private final TicketRepository ticketRepository;
    private final UserRepository userRepository;
    private final UserManager userManager;
    private final PurchaseContextFieldManager purchaseContextFieldManager;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final ClockProvider clockProvider;

    public TicketAndCheckInResult registerSponsorScan(String eventShortName, String ticketUid, String notes, SponsorScan.LeadStatus leadStatus, String username, String operatorId, Long timestamp) {
        int userId = this.userRepository.getByUsername(username).getId();
        Optional maybeEvent = this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventShortName);
        if (maybeEvent.isEmpty()) {
            return new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.EVENT_NOT_FOUND, "event not found"));
        }
        EventAndOrganizationId event = (EventAndOrganizationId)maybeEvent.get();
        Optional maybeTicket = this.ticketRepository.findOptionalByUUID(ticketUid);
        if (maybeTicket.isEmpty()) {
            return new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.TICKET_NOT_FOUND, "ticket not found"));
        }
        Ticket ticket = (Ticket)maybeTicket.get();
        if (ticket.getStatus() != Ticket.TicketStatus.CHECKED_IN || ticket.getEventId() != event.getId()) {
            return new TicketAndCheckInResult(new TicketWithCategory(ticket, null), (CheckInResult)new DefaultCheckInResult(CheckInStatus.INVALID_TICKET_STATE, "not checked-in"));
        }
        String operator = Objects.requireNonNullElse(operatorId, DEFAULT_OPERATOR_ID);
        Optional existingRegistration = this.sponsorScanRepository.getRegistrationTimestamp(userId, event.getId(), ticket.getId(), operator);
        if (existingRegistration.isEmpty()) {
            ZoneId eventZoneId = this.eventRepository.getZoneIdByEventId(event.getId());
            ZonedDateTime creation = timestamp != null ? Instant.ofEpochMilli(timestamp).atZone(eventZoneId) : ZonedDateTime.now(this.clockProvider.withZone(eventZoneId));
            this.sponsorScanRepository.insert(userId, creation, event.getId(), ticket.getId(), notes, leadStatus, operator);
        } else {
            this.sponsorScanRepository.updateNotesAndLeadStatus(userId, event.getId(), ticket.getId(), notes, leadStatus, operator);
        }
        return new TicketAndCheckInResult(new TicketWithCategory(ticket, null), (CheckInResult)new DefaultCheckInResult(CheckInStatus.SUCCESS, "success"));
    }

    public Result<TicketWithAdditionalFields> retrieveTicket(String eventShortName, String ticketUid, String username) {
        Optional<Event> maybeEvent = this.eventRepository.findOptionalByShortName(eventShortName).filter(e -> this.userManager.findUserOrganizations(username).stream().anyMatch(o -> o.getId() == e.getOrganizationId()));
        if (maybeEvent.isEmpty()) {
            return Result.error((ErrorCode)ErrorCode.EventError.NOT_FOUND);
        }
        Event event = maybeEvent.get();
        Optional<Ticket> maybeTicket = this.ticketRepository.findOptionalByUUID(ticketUid).filter(t -> t.getEventId() == event.getId());
        return new Result.Builder().checkPrecondition(maybeTicket::isPresent, ErrorCode.custom((String)"ticket_not_found", (String)"ticket not found")).build(() -> {
            Ticket ticket = (Ticket)maybeTicket.orElseThrow();
            List descriptionAndValues = (List)EventUtil.retrieveFieldValues((TicketRepository)this.ticketRepository, (PurchaseContextFieldManager)this.purchaseContextFieldManager, (AdditionalServiceItemRepository)this.additionalServiceItemRepository, (boolean)true).apply(ticket, event);
            return new TicketWithAdditionalFields(ticket, descriptionAndValues);
        });
    }

    public Optional<List<SponsorAttendeeData>> retrieveScannedAttendees(String eventShortName, String username, ZonedDateTime start) {
        int userId = this.userRepository.getByUsername(username).getId();
        Optional maybeEvent = this.eventRepository.findOptionalByShortName(eventShortName);
        return maybeEvent.map(event -> this.loadAttendeesData((EventAndOrganizationId)event, userId, start));
    }

    private List<SponsorAttendeeData> loadAttendeesData(EventAndOrganizationId event, int userId, ZonedDateTime start) {
        return this.sponsorScanRepository.loadSponsorData(event.getId(), userId, start).stream().map(scan -> {
            Ticket ticket = scan.getTicket();
            return new SponsorAttendeeData(ticket.getUuid(), scan.getSponsorScan().getTimestamp().format(EventUtil.JSON_DATETIME_FORMATTER), ticket.getFullName(), ticket.getEmail());
        }).distinct().collect(Collectors.toList());
    }

    @ConstructorProperties(value={"sponsorScanRepository", "eventRepository", "ticketRepository", "userRepository", "userManager", "purchaseContextFieldManager", "additionalServiceItemRepository", "clockProvider"})
    @Generated
    public AttendeeManager(SponsorScanRepository sponsorScanRepository, EventRepository eventRepository, TicketRepository ticketRepository, UserRepository userRepository, UserManager userManager, PurchaseContextFieldManager purchaseContextFieldManager, AdditionalServiceItemRepository additionalServiceItemRepository, ClockProvider clockProvider) {
        this.sponsorScanRepository = sponsorScanRepository;
        this.eventRepository = eventRepository;
        this.ticketRepository = ticketRepository;
        this.userRepository = userRepository;
        this.userManager = userManager;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.clockProvider = clockProvider;
    }
}

