/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.BillingDocumentManager;
import alfio.manager.ExtensionManager;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.Audit;
import alfio.model.BillingDetails;
import alfio.model.BillingDocument;
import alfio.model.Configurable;
import alfio.model.EventAndOrganizationId;
import alfio.model.OrderSummary;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationAdditionalInfo;
import alfio.model.TotalPrice;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.AuditingRepository;
import alfio.repository.BillingDocumentRepository;
import alfio.repository.InvoiceSequencesRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.UserRepository;
import alfio.util.ClockProvider;
import alfio.util.Json;
import alfio.util.ReservationUtil;
import alfio.util.TemplateResource;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class BillingDocumentManager {
    static final String CREDIT_NOTE_NUMBER = "creditNoteNumber";
    private static final Logger log = LoggerFactory.getLogger(BillingDocumentManager.class);
    private static final String APPLICATION_PDF = "application/pdf";
    private final BillingDocumentRepository billingDocumentRepository;
    private final Json json;
    private final ConfigurationManager configurationManager;
    private final TicketRepository ticketRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final OrganizationRepository organizationRepository;
    private final UserRepository userRepository;
    private final AuditingRepository auditingRepository;
    private final TicketReservationRepository ticketReservationRepository;
    private final ClockProvider clockProvider;
    private final ExtensionManager extensionManager;
    private final InvoiceSequencesRepository invoiceSequencesRepository;

    public Optional<ZonedDateTime> findFirstInvoiceDate(int eventId) {
        return this.billingDocumentRepository.findFirstInvoiceGenerationDate(eventId);
    }

    public List<Integer> findMatchingInvoiceIds(Integer eventId, ZonedDateTime from, ZonedDateTime to) {
        return this.billingDocumentRepository.findMatchingInvoiceIds(eventId.intValue(), from, to);
    }

    static boolean mustGenerateBillingDocument(OrderSummary summary, TicketReservation ticketReservation) {
        return !summary.getFree() && (!summary.getNotYetPaid() || summary.getWaitingForPayment() && ticketReservation.isInvoiceRequested());
    }

    public List<Mailer.Attachment> generateBillingDocumentAttachment(PurchaseContext purchaseContext, TicketReservation ticketReservation, Locale language, BillingDocument.Type documentType, String username, OrderSummary orderSummary) {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("reservationId", ticketReservation.getId());
        model.put("eventId", purchaseContext.event().map(ev -> Integer.toString(ev.getId())).orElse(null));
        model.put("language", this.json.asJsonString((Object)language));
        model.put("reservationEmailModel", this.json.asJsonString((Object)this.internalGetOrCreate(purchaseContext, ticketReservation, username, orderSummary).getModel()));
        return switch (1.$SwitchMap$alfio$model$BillingDocument$Type[documentType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> Collections.singletonList(new Mailer.Attachment("invoice.pdf", null, "application/pdf", model, Mailer.AttachmentIdentifier.INVOICE_PDF));
            case 2 -> Collections.singletonList(new Mailer.Attachment("receipt.pdf", null, "application/pdf", model, Mailer.AttachmentIdentifier.RECEIPT_PDF));
            case 3 -> Collections.singletonList(new Mailer.Attachment("credit-note.pdf", null, "application/pdf", model, Mailer.AttachmentIdentifier.CREDIT_NOTE_PDF));
        };
    }

    @Transactional
    public void ensureBillingDocumentIsPresent(PurchaseContext purchaseContext, TicketReservation reservation, String username, Supplier<OrderSummary> orderSummarySupplier) {
        if (reservation.getStatus() == TicketReservation.TicketReservationStatus.PENDING || reservation.getStatus() == TicketReservation.TicketReservationStatus.CANCELLED) {
            return;
        }
        OrderSummary orderSummary = orderSummarySupplier.get();
        if (BillingDocumentManager.mustGenerateBillingDocument((OrderSummary)orderSummary, (TicketReservation)reservation)) {
            this.getOrCreateBillingDocument(purchaseContext, reservation, username, orderSummary);
        }
    }

    @Transactional
    public BillingDocument createBillingDocument(PurchaseContext purchaseContext, TicketReservation reservation, String username, OrderSummary orderSummary) {
        return this.createBillingDocument(purchaseContext, reservation, username, reservation.getHasInvoiceNumber() ? BillingDocument.Type.INVOICE : BillingDocument.Type.RECEIPT, orderSummary);
    }

    BillingDocument createBillingDocument(PurchaseContext purchaseContext, TicketReservation reservation, String username, BillingDocument.Type type, OrderSummary orderSummary) {
        Map model = this.prepareModelForBillingDocument(purchaseContext, reservation, orderSummary, type);
        String number = type == BillingDocument.Type.INVOICE ? reservation.getInvoiceNumber() : (type == BillingDocument.Type.CREDIT_NOTE ? (String)model.get("creditNoteNumber") : UUID.randomUUID().toString());
        Integer eventId = purchaseContext.event().map(EventAndOrganizationId::getId).orElse(null);
        AffectedRowCountAndKey doc = this.billingDocumentRepository.insert(eventId, reservation.getId(), number, type, this.json.asJsonString((Object)model), purchaseContext.now(this.clockProvider), purchaseContext.getOrganizationId());
        log.trace("billing document #{} created", doc.getKey());
        this.auditingRepository.insert(reservation.getId(), (Integer)this.userRepository.nullSafeFindIdByUserName(username).orElse(null), purchaseContext, Audit.EventType.BILLING_DOCUMENT_GENERATED, new Date(), Audit.EntityType.RESERVATION, reservation.getId(), Collections.singletonList(Collections.singletonMap("documentId", doc.getKey())));
        return (BillingDocument)this.billingDocumentRepository.findByIdAndReservationId(((Long)doc.getKey()).longValue(), reservation.getId()).orElseThrow(IllegalStateException::new);
    }

    @Transactional
    public BillingDocument getOrCreateBillingDocument(PurchaseContext purchaseContext, TicketReservation reservation, String username, OrderSummary orderSummary) {
        return this.internalGetOrCreate(purchaseContext, reservation, username, orderSummary);
    }

    private BillingDocument internalGetOrCreate(PurchaseContext purchaseContext, TicketReservation reservation, String username, OrderSummary orderSummary) {
        Optional existing = this.billingDocumentRepository.findLatestByReservationId(reservation.getId());
        return existing.orElseGet(() -> this.createBillingDocument(purchaseContext, reservation, username, orderSummary));
    }

    public Optional<BillingDocument> getDocumentById(long id) {
        return this.billingDocumentRepository.findById(id);
    }

    @Transactional
    public Optional<String> generateInvoiceNumber(PaymentSpecification spec, TotalPrice reservationCost) {
        if (!(reservationCost.requiresPayment() && spec.isInvoiceRequested() && this.configurationManager.hasAllConfigurationsForInvoice((Configurable)spec.getPurchaseContext()))) {
            return Optional.empty();
        }
        String reservationId = spec.getReservationId();
        BillingDetails billingDetails = this.ticketReservationRepository.getBillingDetailsForReservation(reservationId);
        Optional optionalInvoiceNumber = this.extensionManager.handleInvoiceGeneration(spec, reservationCost, billingDetails, Map.of("organization", this.organizationRepository.getById(spec.getPurchaseContext().getOrganizationId()))).flatMap(invoiceGeneration -> Optional.ofNullable(StringUtils.trimToNull((String)invoiceGeneration.getInvoiceNumber())));
        optionalInvoiceNumber.ifPresent(invoiceNumber -> {
            List<Map<String, String>> modifications = List.of(Map.of("invoiceNumber", invoiceNumber));
            this.auditingRepository.insert(reservationId, null, spec.getPurchaseContext(), Audit.EventType.EXTERNAL_INVOICE_NUMBER, new Date(), Audit.EntityType.RESERVATION, reservationId, modifications);
        });
        return optionalInvoiceNumber.or(() -> {
            int invoiceSequence = this.invoiceSequencesRepository.lockSequenceForUpdate(spec.getPurchaseContext().getOrganizationId());
            this.invoiceSequencesRepository.incrementSequenceFor(spec.getPurchaseContext().getOrganizationId());
            return Optional.of(this.formatDocumentNumber(spec.getPurchaseContext(), invoiceSequence));
        });
    }

    String generateCreditNoteNumber(PurchaseContext purchaseContext, TicketReservation reservation) {
        return this.extensionManager.handleCreditNoteGeneration(purchaseContext, reservation.getId(), reservation.getInvoiceNumber(), this.organizationRepository.getById(purchaseContext.getOrganizationId())).map(cng -> {
            String reservationId = reservation.getId();
            String creditNoteNumber = cng.getCreditNoteNumber();
            this.auditingRepository.insert(reservationId, null, purchaseContext, Audit.EventType.EXTERNAL_CREDIT_NOTE_NUMBER, new Date(), Audit.EntityType.RESERVATION, reservationId, List.of(Map.of("creditNoteNumber", creditNoteNumber)));
            return creditNoteNumber;
        }).orElseGet(() -> {
            if (this.configurationManager.getFor(ConfigurationKeys.REUSE_INVOICE_NUMBER_FOR_CREDIT_NOTE, purchaseContext.getConfigurationLevel()).getValueAsBooleanOrDefault()) {
                return reservation.getInvoiceNumber();
            }
            int creditNoteSequence = this.invoiceSequencesRepository.lockSequenceForUpdate(purchaseContext.getOrganizationId(), BillingDocument.Type.CREDIT_NOTE);
            this.invoiceSequencesRepository.incrementSequenceFor(purchaseContext.getOrganizationId(), BillingDocument.Type.CREDIT_NOTE);
            return this.formatDocumentNumber(purchaseContext, creditNoteSequence);
        });
    }

    private String formatDocumentNumber(PurchaseContext purchaseContext, int sequence) {
        String pattern = this.configurationManager.getFor(ConfigurationKeys.INVOICE_NUMBER_PATTERN, purchaseContext.getConfigurationLevel()).getValueOrDefault("%d");
        return ((String)ObjectUtils.firstNonNull((Object[])new String[]{StringUtils.trimToNull((String)pattern), "%d"})).formatted(sequence);
    }

    private Map<String, Object> prepareModelForBillingDocument(PurchaseContext purchaseContext, TicketReservation reservation, OrderSummary summary, BillingDocument.Type type) {
        Organization organization = this.organizationRepository.getById(purchaseContext.getOrganizationId());
        String creditNoteNumber = null;
        if (type == BillingDocument.Type.CREDIT_NOTE) {
            creditNoteNumber = this.generateCreditNoteNumber(purchaseContext, reservation);
        }
        Map bankingInfo = this.configurationManager.getFor(Set.of(ConfigurationKeys.VAT_NR, ConfigurationKeys.INVOICE_ADDRESS, ConfigurationKeys.BANK_ACCOUNT_NR, ConfigurationKeys.BANK_ACCOUNT_OWNER), purchaseContext.getConfigurationLevel());
        Optional invoiceAddress = ((ConfigurationManager.MaybeConfiguration)bankingInfo.get(ConfigurationKeys.INVOICE_ADDRESS)).getValue();
        Optional bankAccountNr = ((ConfigurationManager.MaybeConfiguration)bankingInfo.get(ConfigurationKeys.BANK_ACCOUNT_NR)).getValue();
        Optional bankAccountOwner = ((ConfigurationManager.MaybeConfiguration)bankingInfo.get(ConfigurationKeys.BANK_ACCOUNT_OWNER)).getValue();
        Optional vat = ((ConfigurationManager.MaybeConfiguration)bankingInfo.get(ConfigurationKeys.VAT_NR)).getValue();
        Map<Integer, List<Ticket>> ticketsByCategory = this.ticketRepository.findTicketsInReservation(reservation.getId()).stream().collect(Collectors.groupingBy(Ticket::getCategoryId));
        List ticketsWithCategory = ReservationUtil.collectTicketsWithCategory(ticketsByCategory, (TicketCategoryRepository)this.ticketCategoryRepository);
        String reservationShortId = this.configurationManager.getShortReservationID((Configurable)purchaseContext, reservation);
        Map model = TemplateResource.prepareModelForConfirmationEmail((Organization)organization, (PurchaseContext)purchaseContext, (TicketReservation)reservation, (Optional)vat, (List)ticketsWithCategory, (OrderSummary)summary, (String)"", (String)"", (String)reservationShortId, (Optional)invoiceAddress, (Optional)bankAccountNr, (Optional)bankAccountOwner, Map.of());
        boolean euBusiness = StringUtils.isNotBlank((CharSequence)reservation.getVatCountryCode()) && StringUtils.isNotBlank((CharSequence)reservation.getVatNr()) && this.configurationManager.getForSystem(ConfigurationKeys.EU_COUNTRIES_LIST).getRequiredValue().contains(reservation.getVatCountryCode()) && PriceContainer.VatStatus.isVatExempt((PriceContainer.VatStatus)reservation.getVatStatus());
        model.put("isEvent", purchaseContext.ofType(PurchaseContext.PurchaseContextType.event));
        model.put("euBusiness", euBusiness);
        model.put("publicId", this.configurationManager.getPublicReservationID((Configurable)purchaseContext, reservation));
        TicketReservationAdditionalInfo additionalInfo = this.ticketReservationRepository.getAdditionalInfo(reservation.getId());
        model.put("invoicingAdditionalInfo", additionalInfo.getInvoicingAdditionalInfo());
        model.put("proforma", !additionalInfo.getInvoicingAdditionalInfo().isEmpty());
        model.put("billingDetails", additionalInfo.getBillingDetails());
        if (type == BillingDocument.Type.CREDIT_NOTE) {
            model.put("creditNoteNumber", creditNoteNumber);
        }
        return model;
    }

    @ConstructorProperties(value={"billingDocumentRepository", "json", "configurationManager", "ticketRepository", "ticketCategoryRepository", "organizationRepository", "userRepository", "auditingRepository", "ticketReservationRepository", "clockProvider", "extensionManager", "invoiceSequencesRepository"})
    @Generated
    public BillingDocumentManager(BillingDocumentRepository billingDocumentRepository, Json json, ConfigurationManager configurationManager, TicketRepository ticketRepository, TicketCategoryRepository ticketCategoryRepository, OrganizationRepository organizationRepository, UserRepository userRepository, AuditingRepository auditingRepository, TicketReservationRepository ticketReservationRepository, ClockProvider clockProvider, ExtensionManager extensionManager, InvoiceSequencesRepository invoiceSequencesRepository) {
        this.billingDocumentRepository = billingDocumentRepository;
        this.json = json;
        this.configurationManager = configurationManager;
        this.ticketRepository = ticketRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.organizationRepository = organizationRepository;
        this.userRepository = userRepository;
        this.auditingRepository = auditingRepository;
        this.ticketReservationRepository = ticketReservationRepository;
        this.clockProvider = clockProvider;
        this.extensionManager = extensionManager;
        this.invoiceSequencesRepository = invoiceSequencesRepository;
    }
}

