/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.AccessService;
import alfio.manager.EventManager;
import alfio.manager.ExtensionManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.support.AdditionalServiceInfo;
import alfio.manager.support.CheckInResult;
import alfio.manager.support.CheckInStatistics;
import alfio.manager.support.CheckInStatus;
import alfio.manager.support.DefaultCheckInResult;
import alfio.manager.support.OnSitePaymentResult;
import alfio.manager.support.SuccessfulCheckIn;
import alfio.manager.support.TicketAndCheckInResult;
import alfio.manager.support.TicketCheckInStatusResult;
import alfio.manager.system.ConfigurationManager;
import alfio.model.AdditionalServiceFieldValue;
import alfio.model.AdditionalServiceItem;
import alfio.model.Audit;
import alfio.model.BookedAdditionalService;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventCheckInInfo;
import alfio.model.FullTicketInfo;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketInfoContainer;
import alfio.model.TicketReservation;
import alfio.model.TicketWithCategory;
import alfio.model.api.v1.admin.CheckInLogEntry;
import alfio.model.audit.ScanAudit;
import alfio.model.checkin.AttendeeSearchResults;
import alfio.model.checkin.AttendeeSearchResultsCount;
import alfio.model.decorator.TicketPriceContainer;
import alfio.model.support.CheckInOutputColorConfiguration;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentProxy;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.AuditingRepository;
import alfio.repository.EventRepository;
import alfio.repository.PollRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.audit.ScanAuditRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.UserRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.Json;
import alfio.util.MiscUtils;
import alfio.util.MonetaryUtil;
import alfio.util.PinGenerator;
import alfio.util.Wrappers;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Principal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional
public class CheckInManager {
    private static final Logger log = LoggerFactory.getLogger(CheckInManager.class);
    static final Pattern CYPHER_SPLITTER = Pattern.compile("\\|");
    private static final int SEARCH_ATTENDEES_LIMIT = 20;
    private final TicketRepository ticketRepository;
    private final EventRepository eventRepository;
    private final TicketReservationRepository ticketReservationRepository;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final ScanAuditRepository scanAuditRepository;
    private final AuditingRepository auditingRepository;
    private final ConfigurationManager configurationManager;
    private final OrganizationRepository organizationRepository;
    private final UserRepository userRepository;
    private final TicketReservationManager ticketReservationManager;
    private final ExtensionManager extensionManager;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final PollRepository pollRepository;
    private final ClockProvider clockProvider;
    private final AccessService accessService;

    private void checkIn(String uuid, Event event) {
        int n;
        Ticket ticket = this.ticketRepository.findByUUID(uuid);
        Validate.isTrue((ticket.getStatus() == Ticket.TicketStatus.ACQUIRED ? 1 : 0) != 0);
        this.ticketRepository.updateTicketStatusWithUUID(uuid, Ticket.TicketStatus.CHECKED_IN.toString());
        this.ticketRepository.toggleTicketLocking(ticket.getId(), ticket.getCategoryId().intValue(), true);
        if (event.supportsLinkedAdditionalServices() && (n = this.additionalServiceItemRepository.updateItemsStatusWithTicketId(event.getId(), ticket.getTicketsReservationId(), ticket.getId(), AdditionalServiceItem.AdditionalServiceItemStatus.CHECKED_IN)) > 0 && log.isDebugEnabled()) {
            log.debug("Checked in {} additional services for ticket {}", (Object)n, (Object)MiscUtils.removeTabsAndNewlines((String)uuid));
        }
        this.extensionManager.handleTicketCheckedIn(this.ticketRepository.findByUUID(uuid));
    }

    private void acquire(String uuid) {
        Ticket ticket = this.ticketRepository.findByUUID(uuid);
        Validate.isTrue((ticket.getStatus() == Ticket.TicketStatus.TO_BE_PAID ? 1 : 0) != 0);
        this.ticketRepository.updateTicketStatusWithUUID(uuid, Ticket.TicketStatus.ACQUIRED.toString());
        this.ticketReservationManager.registerAlfioTransactionForOnsitePayment(this.eventRepository.findById(ticket.getEventId()), ticket.getTicketsReservationId());
    }

    public AttendeeSearchResults searchAttendees(Event event, String query, int page, Principal principal) {
        this.accessService.checkEventMembership(principal, event.getShortName(), AccessService.MEMBERSHIP_ROLES);
        if (StringUtils.isBlank((CharSequence)query)) {
            return new AttendeeSearchResults(0, 0, 0, 0, List.of());
        }
        int eventId = event.getId();
        String search = "%" + query + "%";
        List results = this.ticketRepository.searchAttendees(eventId, search, 20, 20 * page);
        AttendeeSearchResultsCount statistics = this.ticketRepository.countSearchResults(eventId, search);
        List attendees = results.stream().map(fi -> {
            Ticket ticket = fi.getTicket();
            TicketReservation reservation = fi.getTicketReservation();
            String amountToPay = null;
            if (reservation.getPaymentMethod() == PaymentProxy.ON_SITE) {
                TicketPriceContainer priceContainer = TicketPriceContainer.from((Ticket)ticket, (PriceContainer.VatStatus)reservation.getVatStatus(), (BigDecimal)reservation.getVAT(), (PriceContainer.VatStatus)event.getVatStatus(), (PromoCodeDiscount)reservation.getDiscount().orElse(null));
                amountToPay = event.getCurrency() + " " + MonetaryUtil.formatUnit((BigDecimal)priceContainer.getFinalPrice(), (String)event.getCurrency());
            }
            return new AttendeeSearchResults.AttendeeResult(ticket.getUuid(), ticket.getPublicUuid(), ticket.getFirstName(), ticket.getLastName(), fi.getTicketCategory().getName(), fi.getTicketAdditionalInfo(), ticket.getStatus(), amountToPay);
        }).collect(Collectors.toList());
        int totalPages = (int)Math.ceil((double)statistics.getTotal() / 20.0);
        return new AttendeeSearchResults(statistics.getTotal(), statistics.getCheckedIn(), totalPages, page, attendees);
    }

    public CheckInStatus performCheckinForOnlineEvent(Ticket ticket, EventCheckInInfo event, TicketCategory tc) {
        Validate.isTrue((boolean)EventUtil.isAccessOnline((TicketCategory)tc, (EventCheckInInfo)event));
        if (!tc.hasValidCheckIn(event.now(this.clockProvider), event.getZoneId())) {
            return CheckInStatus.INVALID_TICKET_CATEGORY_CHECK_IN_DATE;
        }
        if (ticket.isCheckedIn()) {
            return CheckInStatus.ALREADY_CHECK_IN;
        }
        int affectedCount = this.ticketRepository.performCheckIn(ticket.getUuid(), event.getId());
        if (affectedCount == 1) {
            this.auditingRepository.insert(ticket.getTicketsReservationId(), null, Integer.valueOf(event.getId()), Audit.EventType.CHECK_IN, new Date(), Audit.EntityType.TICKET, Integer.toString(ticket.getId()));
            this.extensionManager.handleTicketCheckedIn(ticket);
            return CheckInStatus.SUCCESS;
        }
        return CheckInStatus.ERROR;
    }

    public TicketAndCheckInResult confirmOnSitePayment(String eventName, String ticketIdentifier, Optional<String> ticketCode, String username, String auditUser) {
        return this.eventRepository.findOptionalByShortName(eventName).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository)).flatMap(e -> this.confirmOnSitePayment(ticketIdentifier).map(s -> Pair.of((Object)s, (Object)e))).map(p -> this.checkIn(((Event)p.getRight()).getId(), ticketIdentifier, ticketCode, auditUser)).orElseGet(() -> new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.TICKET_NOT_FOUND, "")));
    }

    public Optional<String> confirmOnSitePayment(String ticketIdentifier) {
        Optional<String> uuid = this.findAndLockTicket(ticketIdentifier).filter(t -> t.getStatus() == Ticket.TicketStatus.TO_BE_PAID).map(Ticket::getUuid);
        uuid.ifPresent(arg_0 -> this.acquire(arg_0));
        return uuid;
    }

    public TicketAndCheckInResult checkIn(String eventShortName, String ticketIdentifier, Optional<String> ticketCode, String username, String auditUser, boolean automaticallyConfirmOnSitePayment) {
        return this.eventRepository.findOptionalByShortName(eventShortName).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository)).map(e -> {
            if (automaticallyConfirmOnSitePayment && CheckInStatus.MUST_PAY == this.evaluateTicketStatus(eventShortName, ticketIdentifier, ticketCode).getResult().getStatus()) {
                log.info("in event {} automaticallyConfirmOnSitePayment for {}", (Object)eventShortName, (Object)ticketIdentifier);
                this.confirmOnSitePayment(eventShortName, ticketIdentifier, ticketCode, username, auditUser);
            }
            return this.checkIn(e.getId(), ticketIdentifier, ticketCode, auditUser);
        }).orElseGet(() -> new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.EVENT_NOT_FOUND, "event not found")));
    }

    public TicketAndCheckInResult checkIn(String shortName, String ticketIdentifier, Optional<String> ticketCode, String username, String auditUser) {
        return this.checkIn(shortName, ticketIdentifier, ticketCode, username, auditUser, false);
    }

    public TicketAndCheckInResult checkIn(int eventId, String ticketIdentifier, Optional<String> ticketCode, String user) {
        Optional optionalEvent = this.eventRepository.findOptionalById(eventId);
        TicketAndCheckInResult descriptor = this.extractStatus(eventId, this.ticketRepository.findByUUIDForUpdate(ticketIdentifier), ticketIdentifier, ticketCode);
        CheckInStatus checkInStatus = descriptor.getResult().getStatus();
        if (checkInStatus == CheckInStatus.OK_READY_TO_BE_CHECKED_IN) {
            Event event = (Event)optionalEvent.orElseThrow();
            this.checkIn(ticketIdentifier, event);
            TicketWithCategory ticket = descriptor.getTicket();
            this.scanAuditRepository.insert(ticketIdentifier, eventId, ZonedDateTime.now(this.clockProvider.getClock()), user, CheckInStatus.SUCCESS, ScanAudit.Operation.SCAN);
            this.auditingRepository.insert(ticket.getTicketsReservationId(), (Integer)this.userRepository.findIdByUserName(user).orElse(null), Integer.valueOf(eventId), Audit.EventType.CHECK_IN, new Date(), Audit.EntityType.TICKET, Integer.toString(descriptor.getTicket().getId()));
            return new SuccessfulCheckIn(ticket, this.getAdditionalServicesForTicket((TicketInfoContainer)ticket, event), this.loadBoxColor((TicketInfoContainer)ticket));
        }
        if (checkInStatus == CheckInStatus.BADGE_SCAN_ALREADY_DONE || checkInStatus == CheckInStatus.OK_READY_FOR_BADGE_SCAN) {
            CheckInStatus auditingStatus = checkInStatus == CheckInStatus.OK_READY_FOR_BADGE_SCAN ? CheckInStatus.BADGE_SCAN_SUCCESS : checkInStatus;
            this.scanAuditRepository.insert(ticketIdentifier, eventId, ZonedDateTime.now(this.clockProvider.getClock()), user, auditingStatus, ScanAudit.Operation.SCAN);
            this.auditingRepository.insert(descriptor.getTicket().getTicketsReservationId(), (Integer)this.userRepository.findIdByUserName(user).orElse(null), Integer.valueOf(eventId), Audit.EventType.BADGE_SCAN, new Date(), Audit.EntityType.TICKET, Integer.toString(descriptor.getTicket().getId()));
            return new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(auditingStatus, checkInStatus == CheckInStatus.OK_READY_FOR_BADGE_SCAN ? "scan successful" : "already scanned"));
        }
        return descriptor;
    }

    public boolean manualCheckIn(int eventId, String ticketIdentifier, String user) {
        Optional ticket = this.findAndLockTicket(ticketIdentifier);
        return ticket.map(t -> {
            if (t.getStatus() == Ticket.TicketStatus.TO_BE_PAID) {
                this.acquire(ticketIdentifier);
            }
            this.checkIn(ticketIdentifier, this.eventRepository.findById(t.getEventId()));
            this.scanAuditRepository.insert(ticketIdentifier, eventId, ZonedDateTime.now(this.clockProvider.getClock()), user, CheckInStatus.SUCCESS, ScanAudit.Operation.SCAN);
            this.auditingRepository.insert(t.getTicketsReservationId(), (Integer)this.userRepository.findIdByUserName(user).orElse(null), Integer.valueOf(eventId), Audit.EventType.MANUAL_CHECK_IN, new Date(), Audit.EntityType.TICKET, Integer.toString(t.getId()));
            return true;
        }).orElse(false);
    }

    public boolean revertCheckIn(int eventId, String ticketIdentifier, String user) {
        return this.findAndLockTicket(ticketIdentifier).map(t -> {
            if (t.getStatus() == Ticket.TicketStatus.CHECKED_IN) {
                TicketReservation reservation = this.ticketReservationRepository.findReservationById(t.getTicketsReservationId());
                boolean onSitePayment = reservation.getPaymentMethod() == PaymentProxy.ON_SITE;
                Ticket.TicketStatus revertedStatus = onSitePayment ? Ticket.TicketStatus.TO_BE_PAID : Ticket.TicketStatus.ACQUIRED;
                this.ticketRepository.updateTicketStatusWithUUID(ticketIdentifier, revertedStatus.toString());
                Event event = this.eventRepository.findById(eventId);
                if (event.supportsLinkedAdditionalServices()) {
                    this.additionalServiceItemRepository.updateItemsStatusWithTicketId(t.getEventId(), t.getTicketsReservationId(), t.getId(), onSitePayment ? AdditionalServiceItem.AdditionalServiceItemStatus.TO_BE_PAID : AdditionalServiceItem.AdditionalServiceItemStatus.ACQUIRED);
                }
                this.scanAuditRepository.insert(ticketIdentifier, eventId, ZonedDateTime.now(this.clockProvider.getClock()), user, CheckInStatus.OK_READY_TO_BE_CHECKED_IN, ScanAudit.Operation.REVERT);
                this.auditingRepository.insert(t.getTicketsReservationId(), (Integer)this.userRepository.findIdByUserName(user).orElse(null), Integer.valueOf(eventId), Audit.EventType.REVERT_CHECK_IN, new Date(), Audit.EntityType.TICKET, Integer.toString(t.getId()));
                this.extensionManager.handleTicketRevertCheckedIn(this.ticketRepository.findByUUID(ticketIdentifier));
                return true;
            }
            return false;
        }).orElse(false);
    }

    private Optional<Ticket> findAndLockTicket(String uuid) {
        return this.ticketRepository.findByUUIDForUpdate(uuid);
    }

    public TicketAndCheckInResult evaluateTicketStatus(int eventId, String ticketIdentifier, Optional<String> ticketCode) {
        return this.extractStatus(this.eventRepository.findOptionalById(eventId), this.ticketRepository.findOptionalByUUID(ticketIdentifier), ticketIdentifier, ticketCode);
    }

    public TicketAndCheckInResult evaluateTicketStatus(String eventName, String ticketIdentifier, Optional<String> ticketCode) {
        return this.extractStatus(this.eventRepository.findOptionalByShortName(eventName), this.ticketRepository.findOptionalByUUID(ticketIdentifier), ticketIdentifier, ticketCode);
    }

    public TicketCheckInStatusResult retrieveTicketStatus(String ticketIdentifier) {
        Ticket ticket = this.ticketRepository.findByUUID(ticketIdentifier);
        return new TicketCheckInStatusResult(ticket.getUuid(), ticket.getFirstName(), ticket.getLastName(), ticket.getStatus() == Ticket.TicketStatus.CHECKED_IN ? CheckInStatus.ALREADY_CHECK_IN : CheckInStatus.OK_READY_TO_BE_CHECKED_IN);
    }

    private TicketAndCheckInResult extractStatus(int eventId, Optional<Ticket> maybeTicket, String ticketIdentifier, Optional<String> ticketCode) {
        return this.extractStatus(this.eventRepository.findOptionalById(eventId), maybeTicket, ticketIdentifier, ticketCode);
    }

    private TicketAndCheckInResult extractStatus(Optional<? extends EventCheckInInfo> maybeEvent, Optional<Ticket> maybeTicket, String ticketIdentifier, Optional<String> ticketCode) {
        if (maybeEvent.isEmpty()) {
            return new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.EVENT_NOT_FOUND, "Event not found"));
        }
        if (maybeTicket.isEmpty()) {
            return new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.TICKET_NOT_FOUND, "Ticket with uuid " + ticketIdentifier + " not found"));
        }
        Ticket ticket = maybeTicket.get();
        if (ticket.getCategoryId() == null) {
            return new TicketAndCheckInResult(new TicketWithCategory(ticket, null), (CheckInResult)new DefaultCheckInResult(CheckInStatus.INVALID_TICKET_STATE, "Invalid ticket state"));
        }
        TicketCategory tc = this.ticketCategoryRepository.getById(ticket.getCategoryId().intValue());
        EventCheckInInfo event = maybeEvent.get();
        if (ticketCode.filter(StringUtils::isNotBlank).isEmpty()) {
            if (ticket.isCheckedIn() && tc.getTicketCheckInStrategy() == TicketCategory.TicketCheckInStrategy.ONCE_PER_DAY) {
                if (!CheckInManager.isBadgeValidNow((TicketCategory)tc, (EventCheckInInfo)event)) {
                    return new TicketAndCheckInResult(new TicketWithCategory(ticket, null), (CheckInResult)new DefaultCheckInResult(CheckInStatus.INVALID_TICKET_CATEGORY_CHECK_IN_DATE, "Not allowed to check in at this time."));
                }
                String ticketsReservationId = ticket.getTicketsReservationId();
                int previousScan = this.auditingRepository.countAuditsOfTypesInTheSameDay(ticketsReservationId, Set.of(Audit.EventType.CHECK_IN.name(), Audit.EventType.MANUAL_CHECK_IN.name(), Audit.EventType.BADGE_SCAN.name()), event.now(this.clockProvider));
                if (previousScan > 0) {
                    return new TicketAndCheckInResult(new TicketWithCategory(ticket, null), (CheckInResult)new DefaultCheckInResult(CheckInStatus.BADGE_SCAN_ALREADY_DONE, "Badge scan already done"));
                }
                return new TicketAndCheckInResult(new TicketWithCategory(ticket, null), (CheckInResult)new DefaultCheckInResult(CheckInStatus.OK_READY_FOR_BADGE_SCAN, "Badge scan already done"));
            }
            return new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.EMPTY_TICKET_CODE, "Missing ticket code"));
        }
        String code = ticketCode.get();
        ZonedDateTime now = event.now(this.clockProvider);
        if (!tc.hasValidCheckIn(now, event.getZoneId())) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy - hh:mm");
            String from = tc.getValidCheckInFrom() == null ? ".." : formatter.format(tc.getValidCheckInFrom(event.getZoneId()));
            String to = tc.getValidCheckInTo() == null ? ".." : formatter.format(tc.getValidCheckInTo(event.getZoneId()));
            String formattedNow = formatter.format(now);
            return new TicketAndCheckInResult(new TicketWithCategory(ticket, tc), (CheckInResult)new DefaultCheckInResult(CheckInStatus.INVALID_TICKET_CATEGORY_CHECK_IN_DATE, String.format("Invalid check-in date: valid range for category %s is from %s to %s, current time is: %s", tc.getName(), from, to, formattedNow)));
        }
        if (!code.equals(ticket.ticketCode(event.getPrivateKey(), event.supportsQRCodeCaseInsensitive()))) {
            return new TicketAndCheckInResult(null, (CheckInResult)new DefaultCheckInResult(CheckInStatus.INVALID_TICKET_CODE, "Ticket qr code does not match"));
        }
        Ticket.TicketStatus ticketStatus = ticket.getStatus();
        if (ticketStatus == Ticket.TicketStatus.TO_BE_PAID) {
            return new TicketAndCheckInResult(new TicketWithCategory(ticket, tc), (CheckInResult)new OnSitePaymentResult(CheckInStatus.MUST_PAY, "Must pay for ticket", MonetaryUtil.centsToUnit((int)ticket.getFinalPriceCts(), (String)ticket.getCurrencyCode()), ticket.getCurrencyCode()));
        }
        if (ticketStatus == Ticket.TicketStatus.CHECKED_IN) {
            return new TicketAndCheckInResult(new TicketWithCategory(ticket, tc), (CheckInResult)new DefaultCheckInResult(CheckInStatus.ALREADY_CHECK_IN, "Error: already checked in"));
        }
        if (ticket.getStatus() != Ticket.TicketStatus.ACQUIRED) {
            return new TicketAndCheckInResult(new TicketWithCategory(ticket, tc), (CheckInResult)new DefaultCheckInResult(CheckInStatus.INVALID_TICKET_STATE, "Invalid ticket state, expected ACQUIRED state, received " + ticket.getStatus()));
        }
        return new TicketAndCheckInResult(new TicketWithCategory(ticket, tc), (CheckInResult)new DefaultCheckInResult(CheckInStatus.OK_READY_TO_BE_CHECKED_IN, "Ready to be checked in"));
    }

    private static boolean isBadgeValidNow(TicketCategory tc, EventCheckInInfo event) {
        ZoneId zoneId = event.getZoneId();
        ZonedDateTime now = ZonedDateTime.now(ClockProvider.clock().withZone(zoneId));
        return now.isAfter(CheckInManager.toZoneIdIfNotNull((ZonedDateTime)tc.getValidCheckInFrom(), (ZoneId)zoneId).orElse(event.getBegin())) && now.isAfter(CheckInManager.toZoneIdIfNotNull((ZonedDateTime)tc.getTicketValidityStart(), (ZoneId)zoneId).orElse(event.getBegin())) && now.isBefore(CheckInManager.toZoneIdIfNotNull((ZonedDateTime)tc.getTicketValidityEnd(), (ZoneId)zoneId).orElse(event.getEnd()));
    }

    private static Optional<ZonedDateTime> toZoneIdIfNotNull(ZonedDateTime in, ZoneId zoneId) {
        return Optional.ofNullable(in).map(d -> d.withZoneSameInstant(zoneId));
    }

    static Pair<Cipher, SecretKeySpec> getCypher(String key) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            int iterations = 1000;
            int keyLength = 256;
            PBEKeySpec spec = new PBEKeySpec(key.toCharArray(), key.getBytes(StandardCharsets.UTF_8), iterations, keyLength);
            SecretKey secretKey = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            return Pair.of((Object)cipher, (Object)secret);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String encrypt(String key, String payload) {
        try {
            Pair cipherAndSecret = CheckInManager.getCypher((String)key);
            Cipher cipher = (Cipher)cipherAndSecret.getKey();
            cipher.init(1, (Key)cipherAndSecret.getRight());
            byte[] data = cipher.doFinal(payload.getBytes(StandardCharsets.UTF_8));
            byte[] iv = cipher.getIV();
            return Base64.encodeBase64URLSafeString((byte[])iv) + "|" + Base64.encodeBase64URLSafeString((byte[])data);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<Integer> getAttendeesIdentifiers(EventAndOrganizationId ev, Date changedSince, String username) {
        return Optional.ofNullable(ev).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository)).filter(this.isOfflineCheckInEnabled()).map(event -> this.ticketRepository.findAllAssignedByEventIdForCheckIn(event.getId(), changedSince)).orElseGet(Collections::emptyList);
    }

    public List<Integer> getAttendeesIdentifiers(int eventId, Date changedSince, String username) {
        return this.eventRepository.findOptionalById(eventId).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository)).map(event -> this.ticketRepository.findAllAssignedByEventIdForCheckIn(event.getId(), changedSince)).orElse(Collections.emptyList());
    }

    public List<FullTicketInfo> getAttendeesInformation(int eventId, List<Integer> ids, String username) {
        return this.eventRepository.findOptionalById(eventId).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository)).map(event -> this.ticketRepository.findAllFullTicketInfoAssignedByEventId(event.getId(), ids)).orElse(Collections.emptyList());
    }

    public Predicate<EventAndOrganizationId> isOfflineCheckInEnabled() {
        return this.configurationManager.areBooleanSettingsEnabledForEvent(new ConfigurationKeys[]{ConfigurationKeys.ALFIO_PI_INTEGRATION_ENABLED, ConfigurationKeys.OFFLINE_CHECKIN_ENABLED});
    }

    public Predicate<EventAndOrganizationId> isOfflineCheckInAndLabelPrintingEnabled() {
        return this.isOfflineCheckInEnabled().and(this.configurationManager.areBooleanSettingsEnabledForEvent(new ConfigurationKeys[]{ConfigurationKeys.LABEL_PRINTING_ENABLED}));
    }

    public Map<String, String> getEncryptedAttendeesInformation(Event ev, Set<String> additionalFields, List<Integer> ids) {
        return Optional.ofNullable(ev).filter(this.isOfflineCheckInEnabled()).map(event -> {
            boolean caseInsensitiveQRCode = ev.supportsQRCodeCaseInsensitive();
            Map categories = this.ticketCategoryRepository.findByEventIdAsMap(event.getId());
            String eventKey = event.getPrivateKey();
            Function<FullTicketInfo, String> hashedHMAC = ticket -> DigestUtils.sha256Hex((String)ticket.hmacTicketInfo(eventKey, caseInsensitiveQRCode));
            CheckInOutputColorConfiguration outputColorConfiguration = CheckInManager.getOutputColorConfiguration((EventAndOrganizationId)event, (ConfigurationManager)this.configurationManager);
            List polls = this.pollRepository.findAllForEvent(event.getId());
            boolean hasPolls = !polls.isEmpty();
            List allowedTags = hasPolls ? polls.stream().flatMap(p -> p.getAllowedTags().stream()).collect(Collectors.toList()) : List.of();
            Function<FullTicketInfo, String> encryptedBody = ticket -> {
                TicketCategory tc;
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("firstName", ticket.getFirstName());
                info.put("lastName", ticket.getLastName());
                info.put("fullName", ticket.getFullName());
                info.put("email", ticket.getEmail());
                info.put("status", ticket.getStatus().toString());
                info.put("uuid", ticket.getUuid());
                if (hasPolls && (allowedTags.isEmpty() || CollectionUtils.containsAny((Collection)allowedTags, (Collection)ticket.getTags()))) {
                    info.put("pin", PinGenerator.uuidToPin((String)ticket.getUuid()));
                }
                info.put("category", ticket.getTicketCategory().getName());
                if (outputColorConfiguration != null) {
                    info.put("boxColor", CheckInManager.detectBoxColor((CheckInOutputColorConfiguration)outputColorConfiguration, (Integer)ticket.getCategoryId()));
                }
                if (!additionalFields.isEmpty()) {
                    HashMap<String, String> fields = new HashMap<String, String>();
                    fields.put("company", StringUtils.trimToEmpty((String)ticket.getBillingDetails().getCompanyName()));
                    fields.put("category", ticket.getTicketCategory().getName());
                    fields.putAll(this.purchaseContextFieldRepository.findValueForTicketId(ticket.getId(), additionalFields).stream().map(vd -> {
                        try {
                            Map description;
                            Object rv;
                            if (StringUtils.isNotBlank((CharSequence)vd.getDescription()) && (rv = (description = (Map)Json.GSON.fromJson(vd.getDescription(), new /* Unavailable Anonymous Inner Class!! */.getType())).get("restrictedValues")) instanceof Map) {
                                Map restrictedValues = (Map)rv;
                                return Pair.of((Object)vd.getName(), (Object)restrictedValues.getOrDefault(vd.getValue(), vd.getValue()));
                            }
                        }
                        catch (Exception e) {
                            log.error("cannot deserialize restricted values", (Throwable)e);
                        }
                        return Pair.of((Object)vd.getName(), (Object)vd.getValue());
                    }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
                    info.put("additionalInfoJson", Json.toJson(fields));
                }
                if ((tc = (TicketCategory)categories.get(ticket.getCategoryId())).getValidCheckInFrom() != null) {
                    info.put("validCheckInFrom", Long.toString(tc.getValidCheckInFrom(event.getZoneId()).toEpochSecond()));
                }
                if (tc.getValidCheckInTo() != null) {
                    info.put("validCheckInTo", Long.toString(tc.getValidCheckInTo(event.getZoneId()).toEpochSecond()));
                }
                if (tc.getTicketValidityStart() != null) {
                    info.put("ticketValidityStart", Long.toString(tc.getTicketValidityStart(event.getZoneId()).toEpochSecond()));
                }
                if (tc.getTicketValidityEnd() != null) {
                    info.put("ticketValidityEnd", Long.toString(tc.getTicketValidityEnd(event.getZoneId()).toEpochSecond()));
                }
                info.put("categoryCheckInStrategy", tc.getTicketCheckInStrategy().name());
                List additionalServicesInfo = this.getAdditionalServicesForTicket((TicketInfoContainer)ticket, event);
                if (!additionalServicesInfo.isEmpty()) {
                    info.put("additionalServicesInfoJson", Json.toJson((Object)additionalServicesInfo));
                }
                String key = ticket.ticketCode(eventKey, caseInsensitiveQRCode);
                return CheckInManager.encrypt((String)key, (String)Json.toJson(info));
            };
            return this.ticketRepository.findAllFullTicketInfoAssignedByEventId(event.getId(), ids).stream().collect(Collectors.toMap(hashedHMAC, encryptedBody));
        }).orElseGet(Collections::emptyMap);
    }

    static CheckInOutputColorConfiguration getOutputColorConfiguration(EventAndOrganizationId event, ConfigurationManager configurationManager) {
        return configurationManager.getFor(ConfigurationKeys.CHECK_IN_COLOR_CONFIGURATION, event.getConfigurationLevel()).getValue().flatMap(str -> Wrappers.optionally(() -> (CheckInOutputColorConfiguration)Json.fromJson((String)str, CheckInOutputColorConfiguration.class))).orElse(null);
    }

    private String loadBoxColor(TicketInfoContainer ticket) {
        EventAndOrganizationId eventAndOrganizationId = this.eventRepository.findEventAndOrganizationIdById(ticket.getEventId());
        return CheckInManager.detectBoxColor((CheckInOutputColorConfiguration)CheckInManager.getOutputColorConfiguration((EventAndOrganizationId)eventAndOrganizationId, (ConfigurationManager)this.configurationManager), (Integer)ticket.getCategoryId());
    }

    private static String detectBoxColor(CheckInOutputColorConfiguration outputColorConfiguration, Integer categoryId) {
        if (outputColorConfiguration == null) {
            return null;
        }
        return outputColorConfiguration.getConfigurations().stream().filter(cc -> cc.getCategories().contains(categoryId)).map(CheckInOutputColorConfiguration.ColorConfiguration::getColorName).findFirst().orElse(outputColorConfiguration.getDefaultColorName());
    }

    List<AdditionalServiceInfo> getAdditionalServicesForTicket(TicketInfoContainer ticket, Event event) {
        List additionalServices;
        boolean additionalServicesEmpty;
        String ticketsReservationId = ticket.getTicketsReservationId();
        if (!event.supportsLinkedAdditionalServices()) {
            int firstId = (Integer)this.ticketRepository.findFirstTicketIdInReservation(ticketsReservationId).orElseThrow();
            if (ticket.getId() != firstId) {
                return List.of();
            }
        }
        if (!(additionalServicesEmpty = (additionalServices = event.supportsLinkedAdditionalServices() ? this.additionalServiceItemRepository.getAdditionalServicesBookedForTicket(ticketsReservationId, ticket.getId(), ticket.getUserLanguage(), ticket.getEventId()) : this.additionalServiceItemRepository.getAdditionalServicesBookedForReservation(ticketsReservationId, ticket.getUserLanguage(), ticket.getEventId())).isEmpty())) {
            List additionalServiceIds = additionalServices.stream().map(BookedAdditionalService::getAdditionalServiceId).collect(Collectors.toList());
            Map<Integer, List<AdditionalServiceFieldValue>> fields = this.purchaseContextFieldRepository.loadTicketFieldsForAdditionalService(ticket.getId(), additionalServiceIds).stream().collect(Collectors.groupingBy(AdditionalServiceFieldValue::getAdditionalServiceId));
            return additionalServices.stream().map(as -> new AdditionalServiceInfo(as.getAdditionalServiceName(), as.getCount(), (List)fields.get(as.getAdditionalServiceId()))).collect(Collectors.toList());
        }
        return List.of();
    }

    public CheckInStatistics getStatistics(String eventName, String username) {
        return this.eventRepository.findOptionalByShortName(eventName).filter(arg_0 -> this.areStatsEnabled(arg_0)).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository)).map(event -> this.eventRepository.retrieveCheckInStatisticsForEvent(event.getId())).orElse(null);
    }

    public List<CheckInLogEntry> retrieveLogEntries(String eventName, String username) {
        return this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository)).map(event -> this.scanAuditRepository.loadEntries(event.getId())).orElse(List.of());
    }

    private boolean areStatsEnabled(EventAndOrganizationId event) {
        return this.configurationManager.getFor(ConfigurationKeys.CHECK_IN_STATS, event.getConfigurationLevel()).getValueAsBooleanOrDefault();
    }

    @ConstructorProperties(value={"ticketRepository", "eventRepository", "ticketReservationRepository", "purchaseContextFieldRepository", "ticketCategoryRepository", "scanAuditRepository", "auditingRepository", "configurationManager", "organizationRepository", "userRepository", "ticketReservationManager", "extensionManager", "additionalServiceItemRepository", "pollRepository", "clockProvider", "accessService"})
    @Generated
    public CheckInManager(TicketRepository ticketRepository, EventRepository eventRepository, TicketReservationRepository ticketReservationRepository, PurchaseContextFieldRepository purchaseContextFieldRepository, TicketCategoryRepository ticketCategoryRepository, ScanAuditRepository scanAuditRepository, AuditingRepository auditingRepository, ConfigurationManager configurationManager, OrganizationRepository organizationRepository, UserRepository userRepository, TicketReservationManager ticketReservationManager, ExtensionManager extensionManager, AdditionalServiceItemRepository additionalServiceItemRepository, PollRepository pollRepository, ClockProvider clockProvider, AccessService accessService) {
        this.ticketRepository = ticketRepository;
        this.eventRepository = eventRepository;
        this.ticketReservationRepository = ticketReservationRepository;
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.scanAuditRepository = scanAuditRepository;
        this.auditingRepository = auditingRepository;
        this.configurationManager = configurationManager;
        this.organizationRepository = organizationRepository;
        this.userRepository = userRepository;
        this.ticketReservationManager = ticketReservationManager;
        this.extensionManager = extensionManager;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.pollRepository = pollRepository;
        this.clockProvider = clockProvider;
        this.accessService = accessService;
    }
}

