/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.system.ConfigurationManager;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.User;
import alfio.repository.EventDeleterRepository;
import alfio.repository.EventRepository;
import alfio.repository.OrganizationDeleterRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.UserRepository;
import alfio.repository.user.join.UserOrganizationRepository;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class DemoModeDataManager {
    private static final Logger log = LoggerFactory.getLogger(DemoModeDataManager.class);
    private final UserRepository userRepository;
    private final UserOrganizationRepository userOrganizationRepository;
    private final OrganizationRepository organizationRepository;
    private final EventDeleterRepository eventDeleterRepository;
    private final EventRepository eventRepository;
    private final ConfigurationManager configurationManager;
    private final OrganizationDeleterRepository organizationDeleterRepository;

    public List<Integer> findExpiredUsers(Date date) {
        return this.userRepository.findUsersToDeleteOlderThan(date, Set.of(User.Type.DEMO.name(), User.Type.API_KEY.name()));
    }

    public void deleteAccounts(List<Integer> userIds) {
        if (!userIds.isEmpty()) {
            log.info("found {} expired users", (Object)userIds.size());
            List organizationIds = this.userOrganizationRepository.findOrganizationsForUsers(userIds);
            List disabledEventIds = this.eventRepository.disableEventsForUsers(userIds);
            log.info("found {} events to delete", (Object)disabledEventIds.size());
            disabledEventIds.forEach(arg_0 -> ((EventDeleterRepository)this.eventDeleterRepository).deleteAllForEvent(arg_0));
            userIds.forEach(arg_0 -> ((UserRepository)this.userRepository).deleteUserAndReferences(arg_0));
            this.organizationDeleterRepository.deleteEmptyOrganizations(organizationIds);
        }
    }

    @Scheduled(cron="0 0 1 * * *")
    @Profile(value={"!disable-jobs"})
    @Transactional
    public void cleanupForDemoMode() {
        log.info("########## running job cleanupForDemoMode");
        try {
            int expirationDate = this.configurationManager.getForSystem(ConfigurationKeys.DEMO_MODE_ACCOUNT_EXPIRATION_DAYS).getValueAsIntOrDefault(20);
            List userIds = this.findExpiredUsers(DateUtils.addDays((Date)new Date(), (int)(-expirationDate)));
            if (!userIds.isEmpty()) {
                this.deleteAccounts(userIds);
            }
        }
        finally {
            log.info("########## end job cleanupForDemoMode");
        }
    }

    @ConstructorProperties(value={"userRepository", "userOrganizationRepository", "organizationRepository", "eventDeleterRepository", "eventRepository", "configurationManager", "organizationDeleterRepository"})
    @Generated
    public DemoModeDataManager(UserRepository userRepository, UserOrganizationRepository userOrganizationRepository, OrganizationRepository organizationRepository, EventDeleterRepository eventDeleterRepository, EventRepository eventRepository, ConfigurationManager configurationManager, OrganizationDeleterRepository organizationDeleterRepository) {
        this.userRepository = userRepository;
        this.userOrganizationRepository = userOrganizationRepository;
        this.organizationRepository = organizationRepository;
        this.eventDeleterRepository = eventDeleterRepository;
        this.eventRepository = eventRepository;
        this.configurationManager = configurationManager;
        this.organizationDeleterRepository = organizationDeleterRepository;
    }
}

