/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.EuVatChecker;
import alfio.manager.ExtensionManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Audit;
import alfio.model.Configurable;
import alfio.model.PurchaseContext;
import alfio.model.VatDetail;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.AuditingRepository;
import alfio.util.ItalianTaxIdValidator;
import ch.digitalfondue.vatchecker.EUVatCheckResponse;
import ch.digitalfondue.vatchecker.EUVatChecker;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class EuVatChecker {
    private final ConfigurationManager configurationManager;
    private final AuditingRepository auditingRepository;
    private final EUVatChecker client = new EUVatChecker();
    private final ExtensionManager extensionManager;
    private static final Cache<Pair<String, String>, EUVatCheckResponse> validationCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(15L)).build();

    public boolean isReverseChargeEnabledFor(PurchaseContext configurable) {
        return EuVatChecker.reverseChargeEnabled((ConfigurationManager)this.configurationManager, (Configurable)configurable);
    }

    public Optional<VatDetail> checkVat(String vatNr, String countryCode, PurchaseContext purchaseContext) {
        Optional res = (Optional)EuVatChecker.performCheck((String)vatNr, (String)countryCode, (Configurable)purchaseContext).apply(this.configurationManager, this.client);
        return res.map(detail -> {
            if (!detail.isValid()) {
                String organizerCountry = EuVatChecker.organizerCountry((ConfigurationManager)this.configurationManager, (Configurable)purchaseContext);
                boolean valid = "IT".equals(organizerCountry) && "IT".equals(countryCode) && ItalianTaxIdValidator.validateVatId((String)vatNr) || this.extensionManager.handleTaxIdValidation(purchaseContext, vatNr, organizerCountry);
                return new VatDetail(detail.getVatNr(), detail.getCountry(), valid, detail.getName(), detail.getAddress(), VatDetail.Type.FORMAL, false);
            }
            return detail;
        });
    }

    static BiFunction<ConfigurationManager, EUVatChecker, Optional<VatDetail>> performCheck(String vatNr, String countryCode, Configurable configurable) {
        return (configurationManager, client) -> {
            boolean validCountryCode;
            boolean vatNrNotEmpty = StringUtils.isNotEmpty((CharSequence)vatNr);
            boolean bl = validCountryCode = StringUtils.length((CharSequence)StringUtils.trimToNull((String)countryCode)) == 2;
            if (!vatNrNotEmpty || !validCountryCode) {
                return Optional.empty();
            }
            boolean euCountryCode = configurationManager.getForSystem(ConfigurationKeys.EU_COUNTRIES_LIST).getRequiredValue().contains(countryCode);
            boolean validationEnabled = EuVatChecker.validationEnabled((ConfigurationManager)configurationManager, (Configurable)configurable);
            if (euCountryCode && validationEnabled) {
                EUVatCheckResponse validationResult = EuVatChecker.validateEUVat((String)vatNr, (String)countryCode, (EUVatChecker)client);
                return Optional.ofNullable(validationResult).map(r -> EuVatChecker.getVatDetail((boolean)EuVatChecker.reverseChargeEnabled((ConfigurationManager)configurationManager, (Configurable)configurable), (EUVatCheckResponse)r, (String)vatNr, (String)countryCode, (String)EuVatChecker.organizerCountry((ConfigurationManager)configurationManager, (Configurable)configurable)));
            }
            String organizerCountry = EuVatChecker.organizerCountry((ConfigurationManager)configurationManager, (Configurable)configurable);
            if (StringUtils.isEmpty((CharSequence)EuVatChecker.organizerCountry((ConfigurationManager)configurationManager, (Configurable)configurable))) {
                return Optional.empty();
            }
            BooleanSupplier applyVatToForeignBusiness = () -> configurationManager.getFor(ConfigurationKeys.APPLY_VAT_FOREIGN_BUSINESS, configurable.getConfigurationLevel()).getValueAsBooleanOrDefault();
            boolean vatExempt = !organizerCountry.equals(countryCode) && (euCountryCode || !applyVatToForeignBusiness.getAsBoolean());
            return Optional.of(new VatDetail(vatNr, countryCode, true, "", "", euCountryCode ? VatDetail.Type.SKIPPED : VatDetail.Type.EXTRA_EU, vatExempt));
        };
    }

    public void logSuccessfulValidation(VatDetail detail, String reservationId, PurchaseContext purchaseContext) {
        List<Map<String, VatDetail.Type>> modifications = List.of(Map.of("vatNumber", detail.getVatNr(), "country", detail.getCountry(), "validationType", detail.getType()));
        Audit.EventType eventType = switch (1.$SwitchMap$alfio$model$VatDetail$Type[detail.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2 -> Audit.EventType.VAT_VALIDATION_SUCCESSFUL;
            case 3 -> Audit.EventType.VAT_VALIDATION_SKIPPED;
            case 4 -> Audit.EventType.VAT_FORMAL_VALIDATION_SUCCESSFUL;
        };
        this.auditingRepository.insert(reservationId, null, purchaseContext, eventType, new Date(), Audit.EntityType.RESERVATION, reservationId, modifications);
    }

    static EUVatCheckResponse validateEUVat(String vat, String countryCode, EUVatChecker client) {
        if (StringUtils.isEmpty((CharSequence)vat) || StringUtils.length((CharSequence)countryCode) != 2) {
            return null;
        }
        return (EUVatCheckResponse)validationCache.get((Object)Pair.of((Object)vat, (Object)countryCode), k -> client.check(countryCode.toUpperCase(), vat));
    }

    private static VatDetail getVatDetail(boolean reverseChargeEnabled, EUVatCheckResponse response, String vatNr, String countryCode, String organizerCountryCode) {
        boolean isValid = response.isValid();
        return new VatDetail(vatNr, countryCode, isValid, response.getName(), response.getAddress(), VatDetail.Type.VIES, isValid && reverseChargeEnabled && !organizerCountryCode.equals(countryCode));
    }

    static String organizerCountry(ConfigurationManager configurationManager, Configurable configurable) {
        return configurationManager.getFor(ConfigurationKeys.COUNTRY_OF_BUSINESS, configurable.getConfigurationLevel()).getValueOrNull();
    }

    private static boolean reverseChargeEnabled(ConfigurationManager configurationManager, Configurable configurable) {
        return EuVatChecker.reverseChargeEnabled((Map)EuVatChecker.loadConfigurationForReverseChargeCheck((ConfigurationManager)configurationManager, (Configurable)configurable));
    }

    public static Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> loadConfigurationForReverseChargeCheck(ConfigurationManager configurationManager, Configurable configurable) {
        return configurationManager.getFor(Set.of(ConfigurationKeys.ENABLE_EU_VAT_DIRECTIVE, ConfigurationKeys.COUNTRY_OF_BUSINESS, ConfigurationKeys.ENABLE_REVERSE_CHARGE_IN_PERSON, ConfigurationKeys.ENABLE_REVERSE_CHARGE_ONLINE), configurable.getConfigurationLevel());
    }

    public static boolean reverseChargeEnabled(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> res) {
        Validate.isTrue((res.containsKey(ConfigurationKeys.ENABLE_EU_VAT_DIRECTIVE) && res.containsKey(ConfigurationKeys.COUNTRY_OF_BUSINESS) && res.containsKey(ConfigurationKeys.ENABLE_REVERSE_CHARGE_IN_PERSON) && res.containsKey(ConfigurationKeys.ENABLE_REVERSE_CHARGE_ONLINE) ? 1 : 0) != 0);
        return res.get(ConfigurationKeys.ENABLE_EU_VAT_DIRECTIVE).getValueAsBooleanOrDefault() && (res.get(ConfigurationKeys.ENABLE_REVERSE_CHARGE_IN_PERSON).getValueAsBooleanOrDefault() || res.get(ConfigurationKeys.ENABLE_REVERSE_CHARGE_ONLINE).getValueAsBooleanOrDefault()) && res.get(ConfigurationKeys.COUNTRY_OF_BUSINESS).isPresent();
    }

    static boolean validationEnabled(ConfigurationManager configurationManager, Configurable configurable) {
        return configurationManager.getFor(ConfigurationKeys.ENABLE_VIES_VALIDATION, configurable.getConfigurationLevel()).getValueAsBooleanOrDefault();
    }

    @ConstructorProperties(value={"configurationManager", "auditingRepository", "extensionManager"})
    @Generated
    public EuVatChecker(ConfigurationManager configurationManager, AuditingRepository auditingRepository, ExtensionManager extensionManager) {
        this.configurationManager = configurationManager;
        this.auditingRepository = auditingRepository;
        this.extensionManager = extensionManager;
    }
}

