/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.form.SearchOptions;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.CheckInManager;
import alfio.manager.ExtensionManager;
import alfio.manager.PaymentManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.support.CategoryEvaluator;
import alfio.manager.support.extension.ExtensionCapability;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventDescription;
import alfio.model.EventIdShortName;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketCategoryStatisticView;
import alfio.model.TicketWithReservationAndTransaction;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.modification.CategoryOrdinalModification;
import alfio.model.modification.DateTimeModification;
import alfio.model.modification.EventModification;
import alfio.model.modification.PromoCodeDiscountWithFormattedTimeAndAmount;
import alfio.model.modification.TicketCategoryModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.subscription.EventSubscriptionLink;
import alfio.model.subscription.LinkSubscriptionsToEventRequest;
import alfio.model.support.CheckInOutputColorConfiguration;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.PaymentProxy;
import alfio.model.user.Organization;
import alfio.repository.AuditingRepository;
import alfio.repository.EventDeleterRepository;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.EventRepository;
import alfio.repository.GroupRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.SpecialPriceRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryDescriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.system.ConfigurationRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.Json;
import alfio.util.MiscUtils;
import alfio.util.MonetaryUtil;
import alfio.util.RequestUtils;
import alfio.util.Wrappers;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional
public class EventManager {
    private static final Logger log = LoggerFactory.getLogger(EventManager.class);
    private static final Predicate<TicketCategory> IS_CATEGORY_BOUNDED = TicketCategory::isBounded;
    static final String ERROR_ONLINE_ON_SITE_NOT_COMPATIBLE = "Cannot switch to Online. Please remove On-Site payment method first.";
    private final UserManager userManager;
    private final EventRepository eventRepository;
    private final EventDescriptionRepository eventDescriptionRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final TicketCategoryDescriptionRepository ticketCategoryDescriptionRepository;
    private final TicketRepository ticketRepository;
    private final SpecialPriceRepository specialPriceRepository;
    private final PromoCodeDiscountRepository promoCodeRepository;
    private final ConfigurationManager configurationManager;
    private final EventDeleterRepository eventDeleterRepository;
    private final PurchaseContextFieldManager purchaseContextFieldManager;
    private final Flyway flyway;
    private final Environment environment;
    private final OrganizationRepository organizationRepository;
    private final AuditingRepository auditingRepository;
    private final ExtensionManager extensionManager;
    private final GroupRepository groupRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ConfigurationRepository configurationRepository;
    private final PaymentManager paymentManager;
    private final ClockProvider clockProvider;
    private final SubscriptionRepository subscriptionRepository;
    public final AdditionalServiceManager additionalServiceManager;

    public Event getSingleEvent(String eventName, String username) {
        return (Event)this.getOptionalByName(eventName, username).orElseThrow(IllegalStateException::new);
    }

    public EventAndOrganizationId getEventAndOrganizationId(String eventName, String username) {
        return (EventAndOrganizationId)this.getOptionalEventAndOrganizationIdByName(eventName, username).orElseThrow(IllegalStateException::new);
    }

    public List<Integer> getEventIdsBySlug(List<String> eventSlugs, int organizationId) {
        return this.eventRepository.findIdsByShortNames(eventSlugs, organizationId);
    }

    public Optional<Event> getOptionalByName(String eventName, String username) {
        return this.eventRepository.findOptionalByShortName(eventName).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository));
    }

    public Optional<EventAndOrganizationId> getOptionalEventAndOrganizationIdByName(String eventName, String username) {
        return this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository));
    }

    public Optional<EventAndOrganizationId> getOptionalEventIdAndOrganizationIdById(int eventId, String username) {
        return this.eventRepository.findOptionalEventAndOrganizationIdById(eventId).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository));
    }

    public Event getSingleEventById(int eventId, String username) {
        return (Event)this.eventRepository.findOptionalById(eventId).filter(EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository)).orElseThrow(IllegalStateException::new);
    }

    public void checkOwnership(EventAndOrganizationId event, String username, int organizationId) {
        Validate.isTrue((organizationId == event.getOrganizationId() ? 1 : 0) != 0, (String)"invalid organizationId", (Object[])new Object[0]);
        Validate.isTrue((boolean)EventManager.checkOwnership((String)username, (OrganizationRepository)this.organizationRepository).test(event), (String)"User is not authorized", (Object[])new Object[0]);
    }

    public static Predicate<EventAndOrganizationId> checkOwnership(String username, OrganizationRepository organizationRepository) {
        return event -> EventManager.checkOwnership((OrganizationRepository)organizationRepository, (String)username, (Integer)event.getOrganizationId());
    }

    private static IntPredicate checkOwnershipByOrgId(String username, OrganizationRepository organizationRepository) {
        return id -> EventManager.checkOwnership((OrganizationRepository)organizationRepository, (String)username, (Integer)id);
    }

    private static boolean checkOwnership(OrganizationRepository organizationRepository, String username, Integer orgId) {
        return orgId != null && organizationRepository.findOrganizationForUser(username, orgId.intValue()).isPresent();
    }

    public List<TicketCategory> loadTicketCategories(EventAndOrganizationId event) {
        return this.ticketCategoryRepository.findAllTicketCategories(event.getId());
    }

    public Organization loadOrganizer(EventAndOrganizationId event, String username) {
        return this.userManager.findOrganizationById(event.getOrganizationId(), username);
    }

    Organization loadOrganizerUsingSystemPrincipal(EventAndOrganizationId event) {
        return this.loadOrganizer(event, "admin");
    }

    public boolean eventExistsById(int eventId) {
        return this.eventRepository.existsById(eventId);
    }

    public void createEvent(EventModification em, String username) {
        Assert.isNull((Object)em.getId(), (String)"id must be null");
        Organization organization = this.organizationRepository.findAllForUser(username).stream().filter(org -> org.getId() == em.getOrganizationId()).findFirst().orElseThrow();
        this.extensionManager.handleEventValidation(em);
        int eventId = this.insertEvent(em);
        Optional srcEvent = this.getCopiedFrom(em, username);
        Event event = this.eventRepository.findById(eventId);
        this.createOrUpdateEventDescription(eventId, em);
        this.additionalServiceManager.createAllAdditionalServices(event, em.getAdditionalServices());
        this.createAdditionalFields(event, em);
        this.createCategoriesForEvent(em, event, srcEvent);
        this.createAllTicketsForEvent(event, em);
        this.createSubscriptionLinks(eventId, organization.getId(), EventManager.toSubscriptionLinkRequests((List)em.getLinkedSubscriptions()));
        srcEvent.ifPresent(eventAndOrganizationId -> this.copySettings(event, eventAndOrganizationId));
        this.extensionManager.handleEventCreation(event);
        AlfioMetadata eventMetadata = this.extensionManager.handleMetadataUpdate(event, organization, AlfioMetadata.empty());
        if (eventMetadata != null) {
            this.eventRepository.updateMetadata(eventMetadata, eventId);
        }
    }

    private Optional<EventAndOrganizationId> getCopiedFrom(EventModification em, String username) {
        if (em.getMetadata() != null && StringUtils.isNotBlank((CharSequence)em.getMetadata().getCopiedFrom())) {
            return this.getOptionalEventAndOrganizationIdByName(em.getMetadata().getCopiedFrom(), username);
        }
        return Optional.empty();
    }

    private void copySettings(Event event, EventAndOrganizationId srcEvent) {
        int count = this.configurationRepository.copyEventConfiguration(event.getId(), event.getOrganizationId(), srcEvent.getId(), srcEvent.getOrganizationId());
        log.info("copied {} settings from source event", (Object)count);
    }

    private void createSubscriptionLinks(int eventId, int organizationId, List<LinkSubscriptionsToEventRequest> linkedSubscriptions) {
        if (CollectionUtils.isNotEmpty(linkedSubscriptions)) {
            MapSqlParameterSource[] parameters = (MapSqlParameterSource[])linkedSubscriptions.stream().map(s -> new MapSqlParameterSource("eventId", (Object)eventId).addValue("subscriptionId", (Object)s.getDescriptorId()).addValue("pricePerTicket", (Object)0).addValue("organizationId", (Object)organizationId).addValue("compatibleCategories", (Object)Json.toJson((Object)s.getCategories()))).toArray(MapSqlParameterSource[]::new);
            int[] result = this.jdbcTemplate.batchUpdate("insert into subscription_event(event_id_fk, subscription_descriptor_id_fk, price_per_ticket, organization_id_fk, compatible_categories) values(:eventId, :subscriptionId, :pricePerTicket, :organizationId, :compatibleCategories::json) on conflict(subscription_descriptor_id_fk, event_id_fk) do update set price_per_ticket = excluded.price_per_ticket, compatible_categories = excluded.compatible_categories\n", (SqlParameterSource[])parameters);
            Validate.isTrue((boolean)Arrays.stream(result).allMatch(r -> r == 1), (String)"Cannot link subscription", (Object[])new Object[0]);
        }
    }

    public void toggleActiveFlag(int id, String username, boolean activate) {
        Event event = this.eventRepository.findById(id);
        this.checkOwnership((EventAndOrganizationId)event, username, event.getOrganizationId());
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"demo"}))) {
            throw new IllegalStateException("demo mode");
        }
        Event.Status status = activate ? Event.Status.PUBLIC : Event.Status.DRAFT;
        this.eventRepository.updateEventStatus(id, status);
        this.extensionManager.handleEventStatusChange(event, status);
    }

    private void createOrUpdateEventDescription(int eventId, EventModification em) {
        this.eventDescriptionRepository.delete(eventId, EventDescription.EventDescriptionType.DESCRIPTION);
        Set validLocales = ContentLanguage.findAllFor((int)em.getLocales()).stream().map(ContentLanguage::getLanguage).collect(Collectors.toSet());
        Optional.ofNullable(em.getDescription()).ifPresent(descriptions -> descriptions.forEach((locale, description) -> {
            if (validLocales.contains(locale)) {
                this.eventDescriptionRepository.insert(eventId, locale, EventDescription.EventDescriptionType.DESCRIPTION, description);
            }
        }));
    }

    private void createAdditionalFields(Event event, EventModification em) {
        if (!CollectionUtils.isEmpty((Collection)em.getTicketFields())) {
            em.getTicketFields().forEach(f -> this.purchaseContextFieldManager.insertAdditionalField((PurchaseContext)event, f, f.getOrder()));
        }
    }

    public void updateEventHeader(Event original, EventModification em, String username) {
        boolean formatUpdated;
        IntPredicate ownershipChecker = EventManager.checkOwnershipByOrgId((String)username, (OrganizationRepository)this.organizationRepository);
        boolean sameOrganization = original.getOrganizationId() == em.getOrganizationId();
        Validate.isTrue((ownershipChecker.test(original.getOrganizationId()) && (sameOrganization || ownershipChecker.test(em.getOrganizationId())) ? 1 : 0) != 0, (String)"Invalid organizationId", (Object[])new Object[0]);
        int eventId = original.getId();
        Validate.isTrue((sameOrganization || this.groupRepository.countByEventId(eventId) == 0 ? 1 : 0) != 0, (String)"Cannot change organization because there is a group linked to this event.", (Object[])new Object[0]);
        Validate.isTrue((sameOrganization || !this.subscriptionRepository.hasLinkedSubscription(eventId) ? 1 : 0) != 0, (String)"Cannot change organization because there are one or more subscriptions linked.", (Object[])new Object[0]);
        boolean bl = formatUpdated = em.getFormat() != original.getFormat();
        if (em.getFormat() == Event.EventFormat.ONLINE && formatUpdated) {
            Validate.isTrue((boolean)original.getAllowedPaymentProxies().stream().allMatch(p -> p != PaymentProxy.ON_SITE), (String)"Cannot switch to Online. Please remove On-Site payment method first.", (Object[])new Object[0]);
        }
        String timeZone = (String)ObjectUtils.firstNonNull((Object[])new String[]{em.getZoneId(), em.getGeolocation() != null ? em.getGeolocation().getTimeZone() : null});
        String latitude = (String)ObjectUtils.firstNonNull((Object[])new String[]{em.getLatitude(), em.getGeolocation() != null ? em.getGeolocation().getLatitude() : null});
        String longitude = (String)ObjectUtils.firstNonNull((Object[])new String[]{em.getLongitude(), em.getGeolocation() != null ? em.getGeolocation().getLongitude() : null});
        ZoneId zoneId = ZoneId.of(timeZone);
        ZonedDateTime begin = em.getBegin().toZonedDateTime(zoneId);
        ZonedDateTime end = em.getEnd().toZonedDateTime(zoneId);
        this.eventRepository.updateHeader(eventId, em.getDisplayName(), em.getWebsiteUrl(), em.getExternalUrl(), em.getTermsAndConditionsUrl(), em.getPrivacyPolicyUrl(), em.getImageUrl(), em.getFileBlobId(), em.getLocation(), latitude, longitude, begin, end, timeZone, em.getOrganizationId(), em.getLocales(), em.getFormat());
        this.createOrUpdateEventDescription(eventId, em);
        if (!original.getBegin().equals(begin) || !original.getEnd().equals(end)) {
            this.fixOutOfRangeCategories(em, username, zoneId, end);
        }
        if (formatUpdated) {
            TicketCategory.TicketAccessType ticketAccessType = this.evaluateTicketAccessType(original.getFormat(), em.getFormat());
            this.ticketCategoryRepository.updateTicketAccessTypeForEvent(eventId, ticketAccessType);
        }
        this.extensionManager.handleEventHeaderUpdate(this.eventRepository.findById(eventId), (Organization)this.organizationRepository.findOrganizationForUser(username, em.getOrganizationId()).orElseThrow());
    }

    private TicketCategory.TicketAccessType evaluateTicketAccessType(Event.EventFormat oldFormat, Event.EventFormat newFormat) {
        if (newFormat == Event.EventFormat.HYBRID) {
            return oldFormat == Event.EventFormat.ONLINE ? TicketCategory.TicketAccessType.ONLINE : TicketCategory.TicketAccessType.IN_PERSON;
        }
        return TicketCategory.TicketAccessType.INHERIT;
    }

    public void updateEventSeatsAndPrices(Event original, EventModification em, String username) {
        this.updateEventSeatsAndPrices(original, em, username, true);
    }

    public void updateEventSeatsAndPrices(Event original, EventModification em, String username, boolean updateSubscriptions) {
        Validate.notNull((Object)em.getAvailableSeats(), (String)"Available Seats cannot be null", (Object[])new Object[0]);
        this.checkOwnership((EventAndOrganizationId)original, username, em.getOrganizationId());
        this.extensionManager.handleEventSeatsPricesUpdateValidation(original, em);
        int eventId = original.getId();
        int seatsDifference = em.getAvailableSeats() - this.eventRepository.countExistingTickets(original.getId());
        if (seatsDifference < 0) {
            int allocatedSeats = this.ticketCategoryRepository.findAllTicketCategories(original.getId()).stream().filter(TicketCategory::isBounded).mapToInt(TicketCategory::getMaxTickets).sum();
            if (em.getAvailableSeats() < allocatedSeats) {
                throw new IllegalArgumentException(String.format("cannot reduce max tickets to %d. There are already %d tickets allocated. Try updating categories first.", em.getAvailableSeats(), allocatedSeats));
            }
        }
        this.validatePaymentProxies(em.getAllowedPaymentProxies(), em.getOrganizationId());
        String paymentProxies = this.collectPaymentProxies(em);
        BigDecimal vat = em.isFreeOfCharge() ? BigDecimal.ZERO : em.getVatPercentage();
        this.eventRepository.updatePrices(em.getCurrency(), em.getAvailableSeats().intValue(), em.isVatIncluded(), vat, paymentProxies, eventId, em.getVatStatus(), em.getPriceInCents());
        if (seatsDifference != 0) {
            Event modified = this.eventRepository.findById(eventId);
            if (seatsDifference > 0) {
                MapSqlParameterSource[] params = (MapSqlParameterSource[])EventUtil.generateEmptyTickets((EventAndOrganizationId)modified, (Date)Date.from(ZonedDateTime.now(this.clockProvider.withZone(modified.getZoneId())).toInstant()), (int)seatsDifference, (Ticket.TicketStatus)Ticket.TicketStatus.RELEASED).toArray(MapSqlParameterSource[]::new);
                this.ticketRepository.bulkTicketInitialization(params);
            } else {
                List ids = this.ticketRepository.selectNotAllocatedTicketsForUpdate(eventId, Math.abs(seatsDifference), Collections.singletonList(Ticket.TicketStatus.FREE.name()));
                Validate.isTrue((ids.size() == Math.abs(seatsDifference) ? 1 : 0) != 0, (String)"cannot lock enough tickets for deletion.", (Object[])new Object[0]);
                int invalidatedTickets = this.ticketRepository.invalidateTickets(ids);
                Validate.isTrue((ids.size() == invalidatedTickets ? 1 : 0) != 0, (String)"error during ticket invalidation: expected %d, got %d".formatted(ids.size(), invalidatedTickets), (Object[])new Object[0]);
            }
        }
        if (updateSubscriptions && em.getLinkedSubscriptions() != null) {
            List requests = EventManager.toSubscriptionLinkRequests((List)em.getLinkedSubscriptions());
            this.updateLinkedSubscriptions(requests, eventId, original.getOrganizationId());
        }
    }

    private static List<LinkSubscriptionsToEventRequest> toSubscriptionLinkRequests(List<UUID> subscriptionIds) {
        return Objects.requireNonNullElse(subscriptionIds, List.of()).stream().map(s -> new LinkSubscriptionsToEventRequest(s, List.of())).collect(Collectors.toList());
    }

    public void updateLinkedSubscriptions(List<LinkSubscriptionsToEventRequest> linkedSubscriptions, int eventId, int organizationId) {
        if (CollectionUtils.isNotEmpty(linkedSubscriptions)) {
            List descriptorIds = linkedSubscriptions.stream().map(LinkSubscriptionsToEventRequest::getDescriptorId).collect(Collectors.toList());
            int removed = this.subscriptionRepository.removeStaleSubscriptions(eventId, organizationId, descriptorIds);
            log.trace("removed {} subscription links", (Object)removed);
            this.createSubscriptionLinks(eventId, organizationId, linkedSubscriptions);
        } else if (linkedSubscriptions != null) {
            int removed = this.subscriptionRepository.removeAllSubscriptionsForEvent(eventId, organizationId);
            log.trace("removed all subscription links ({}) for event {}", (Object)removed, (Object)eventId);
        }
    }

    private void validatePaymentProxies(List<PaymentProxy> paymentProxies, int organizationId) {
        List conflicts = this.paymentManager.validateSelection(paymentProxies, organizationId);
        if (!conflicts.isEmpty()) {
            Map.Entry firstConflict = (Map.Entry)IterableUtils.get((Iterable)conflicts, (int)0);
            throw new IllegalStateException("Conflicting providers found: " + firstConflict.getValue());
        }
    }

    public void insertCategory(int eventId, TicketCategoryModification tcm, String username) {
        Event event = this.eventRepository.findById(eventId);
        Result result = this.insertCategory(event, tcm, username);
        this.failIfError(result);
    }

    public Result<Integer> insertCategory(Event event, TicketCategoryModification tcm, String username) {
        return Wrappers.optionally(() -> {
            this.checkOwnership((EventAndOrganizationId)event, username, event.getOrganizationId());
            return true;
        }).map(b -> {
            int eventId = event.getId();
            int sum = this.ticketCategoryRepository.getTicketAllocation(eventId);
            int notAllocated = this.ticketRepository.countNotAllocatedFreeAndReleasedTicket(eventId);
            int requestedTickets = tcm.isBounded() ? tcm.getMaxTickets() : 1;
            return new Result.Builder().checkPrecondition(() -> sum + requestedTickets <= this.eventRepository.countExistingTickets(eventId), (ErrorCode)ErrorCode.CategoryError.NOT_ENOUGH_SEATS).checkPrecondition(() -> requestedTickets <= notAllocated, (ErrorCode)ErrorCode.CategoryError.ALL_TICKETS_ASSIGNED).checkPrecondition(() -> tcm.getExpiration().toZonedDateTime(event.getZoneId()).isBefore(event.getEnd()), (ErrorCode)ErrorCode.CategoryError.EXPIRATION_AFTER_EVENT_END).build(() -> this.insertCategory(tcm, event));
        }).orElseGet(() -> Result.error((ErrorCode)ErrorCode.EventError.ACCESS_DENIED));
    }

    public void updateCategory(int categoryId, int eventId, TicketCategoryModification tcm, String username) {
        Event event = this.eventRepository.findById(eventId);
        this.checkOwnership((EventAndOrganizationId)event, username, event.getOrganizationId());
        Result result = this.updateCategory(categoryId, event, tcm, username);
        this.failIfError(result);
    }

    private <T> void failIfError(Result<T> result) {
        if (!result.isSuccess()) {
            Optional firstError = result.getErrors().stream().findFirst();
            if (firstError.isPresent()) {
                throw new IllegalArgumentException(((ErrorCode)firstError.get()).getDescription());
            }
            throw new IllegalArgumentException("unknown error");
        }
    }

    Result<TicketCategory> updateCategory(int categoryId, Event event, TicketCategoryModification tcm, String username, boolean resetTicketsToFree) {
        this.checkOwnership((EventAndOrganizationId)event, username, event.getOrganizationId());
        int eventId = event.getId();
        return Optional.of(this.ticketCategoryRepository.getById(categoryId)).filter(tc -> tc.getId() == categoryId).map(existing -> new Result.Builder().checkPrecondition(() -> tcm.getExpiration().toZonedDateTime(event.getZoneId()).isBefore(event.getEnd()), (ErrorCode)ErrorCode.CategoryError.EXPIRATION_AFTER_EVENT_END).checkPrecondition(() -> !existing.isBounded() || tcm.getMaxTickets() - existing.getMaxTickets() + this.ticketRepository.countAllocatedTicketsForEvent(eventId) <= this.eventRepository.countExistingTickets(eventId), (ErrorCode)ErrorCode.CategoryError.NOT_ENOUGH_SEATS).checkPrecondition(() -> tcm.isTokenGenerationRequested() == existing.isAccessRestricted() || this.ticketRepository.countConfirmedAndPendingTickets(eventId, categoryId) == 0, ErrorCode.custom((String)"", (String)"cannot update category: there are tickets already sold.")).checkPrecondition(() -> tcm.isBounded() == existing.isBounded() || this.ticketRepository.countPendingOrReleasedForCategory(eventId, existing.getId()) == 0, ErrorCode.custom((String)"", (String)"It is not safe to change allocation strategy right now because there are pending reservations.")).checkPrecondition(() -> !existing.isAccessRestricted() || tcm.isBounded() == existing.isAccessRestricted(), ErrorCode.custom((String)"", (String)"Dynamic allocation is not compatible with restricted access")).checkPrecondition(() -> {
            int addedTicket = tcm.getMaxTickets() - existing.getMaxTickets();
            return addedTicket >= 0 || !existing.isAccessRestricted() || this.specialPriceRepository.countNotSentToken(categoryId) >= Math.abs(addedTicket);
        }, (ErrorCode)ErrorCode.CategoryError.NOT_ENOUGH_FREE_TOKEN_FOR_SHRINK).checkPrecondition(() -> {
            if (tcm.isBounded() && !existing.isBounded()) {
                int confirmed;
                int newSize = tcm.getMaxTickets();
                return newSize >= (confirmed = this.ticketRepository.countConfirmedForCategory(eventId, existing.getId()).intValue());
            }
            return true;
        }, ErrorCode.custom((String)"", (String)"Not enough tickets")).build(() -> {
            this.updateCategory(tcm, event.isFreeOfCharge(), event.getZoneId(), event, resetTicketsToFree);
            return this.ticketCategoryRepository.getByIdAndActive(categoryId, eventId);
        })).orElseGet(() -> Result.error((ErrorCode)ErrorCode.CategoryError.NOT_FOUND));
    }

    Result<TicketCategory> updateCategory(int categoryId, Event event, TicketCategoryModification tcm, String username) {
        return this.updateCategory(categoryId, event, tcm, username, tcm.isSkipWaitingList());
    }

    void fixOutOfRangeCategories(EventModification em, String username, ZoneId zoneId, ZonedDateTime end) {
        EventAndOrganizationId event = this.getEventAndOrganizationId(em.getShortName(), username);
        this.ticketCategoryRepository.findAllTicketCategories(event.getId()).stream().map(tc -> Triple.of((Object)tc, (Object)tc.getInception(zoneId), (Object)tc.getExpiration(zoneId))).filter(t -> ((ZonedDateTime)t.getRight()).isAfter(end)).forEach(t -> this.fixTicketCategoryDates(end, (TicketCategory)t.getLeft(), (ZonedDateTime)t.getMiddle(), (ZonedDateTime)t.getRight()));
    }

    private void fixTicketCategoryDates(ZonedDateTime end, TicketCategory tc, ZonedDateTime inception, ZonedDateTime expiration) {
        ZonedDateTime newExpiration = (ZonedDateTime)ObjectUtils.min((Comparable[])new ZonedDateTime[]{end, expiration});
        Objects.requireNonNull(newExpiration);
        Validate.isTrue((boolean)inception.isBefore(newExpiration), (String)String.format("Cannot fix dates for category \"%s\" (id: %d), try updating that category first.", tc.getName(), tc.getId()), (Object[])new Object[0]);
        this.ticketCategoryRepository.fixDates(tc.getId(), inception, newExpiration);
    }

    public void reallocateTickets(int srcCategoryId, int targetCategoryId, EventAndOrganizationId event) {
        this.reallocateTickets(this.ticketCategoryRepository.findStatisticWithId(srcCategoryId, event.getId()), Optional.of(this.ticketCategoryRepository.getByIdAndActive(targetCategoryId, event.getId())), event);
    }

    void reallocateTickets(TicketCategoryStatisticView src, Optional<TicketCategory> target, EventAndOrganizationId event) {
        int notSoldTickets = src.getNotSoldTicketsCount();
        if (notSoldTickets == 0) {
            log.debug("since all the ticket have been sold, ticket moving is not needed anymore.");
            return;
        }
        List lockedTickets = this.ticketRepository.selectTicketInCategoryForUpdate(event.getId(), src.getId(), notSoldTickets, Collections.singletonList(Ticket.TicketStatus.FREE.name()));
        int locked = lockedTickets.size();
        if (locked != notSoldTickets) {
            throw new IllegalStateException("Expected %d free tickets, got %d.".formatted(notSoldTickets, locked));
        }
        this.ticketCategoryRepository.updateSeatsAvailability(src.getId(), src.getMaxTickets() - locked);
        if (target.isPresent()) {
            TicketCategory targetCategory = target.get();
            this.ticketCategoryRepository.updateSeatsAvailability(targetCategory.getId(), targetCategory.getMaxTickets() + locked);
            this.ticketRepository.moveToAnotherCategory(lockedTickets, targetCategory.getId(), targetCategory.getSrcPriceCts());
            if (targetCategory.isAccessRestricted()) {
                this.insertTokens(targetCategory, locked);
            } else {
                this.ticketRepository.resetTickets(lockedTickets);
            }
        } else {
            int result = this.ticketRepository.unbindTicketsFromCategory(event.getId(), src.getId(), lockedTickets);
            Validate.isTrue((result == locked ? 1 : 0) != 0, (String)"Expected %d modified tickets, got %d.".formatted(locked, result), (Object[])new Object[0]);
            this.ticketRepository.resetTickets(lockedTickets);
        }
        this.specialPriceRepository.cancelExpiredTokens(src.getId());
    }

    public void unbindTickets(String eventName, int categoryId, String username) {
        EventAndOrganizationId event = this.getEventAndOrganizationId(eventName, username);
        Validate.isTrue((this.ticketCategoryRepository.countUnboundedCategoriesByEventId(event.getId()) > 0 ? 1 : 0) != 0, (String)"cannot unbind tickets: there aren't any unbounded categories", (Object[])new Object[0]);
        TicketCategoryStatisticView ticketCategory = this.ticketCategoryRepository.findStatisticWithId(categoryId, event.getId());
        Validate.isTrue((boolean)ticketCategory.isBounded(), (String)"cannot unbind tickets from an unbounded category!", (Object[])new Object[0]);
        this.reallocateTickets(ticketCategory, Optional.empty(), event);
    }

    public List<TicketCategory> findCategoriesById(Collection<Integer> categoryIds, EventAndOrganizationId event) {
        return this.ticketCategoryRepository.getByIdsAndActive(categoryIds, event.getId());
    }

    MapSqlParameterSource[] prepareTicketsBulkInsertParameters(ZonedDateTime creation, Event event, int requestedTickets, Ticket.TicketStatus ticketStatus) {
        Date creationDate = Date.from(creation.toInstant());
        List categories = this.ticketCategoryRepository.findAllTicketCategories(event.getId());
        Stream boundedTickets = categories.stream().filter(IS_CATEGORY_BOUNDED).flatMap(tc -> this.generateTicketsForCategory(tc, event, creationDate, 0));
        int generatedTickets = categories.stream().filter(IS_CATEGORY_BOUNDED).mapToInt(TicketCategory::getMaxTickets).sum();
        if (generatedTickets >= requestedTickets) {
            return (MapSqlParameterSource[])boundedTickets.toArray(MapSqlParameterSource[]::new);
        }
        return (MapSqlParameterSource[])Stream.concat(boundedTickets, EventUtil.generateEmptyTickets((EventAndOrganizationId)event, (Date)creationDate, (int)(requestedTickets - generatedTickets), (Ticket.TicketStatus)ticketStatus)).toArray(MapSqlParameterSource[]::new);
    }

    private Stream<MapSqlParameterSource> generateTicketsForCategory(TicketCategory tc, Event event, Date creationDate, int existing) {
        Optional<TicketCategory> filteredTC = Optional.of(tc).filter(TicketCategory::isBounded);
        int missingTickets = filteredTC.map(c -> Math.abs(c.getMaxTickets() - existing)).orElseGet(() -> this.eventRepository.countExistingTickets(event.getId()) - existing);
        return EventUtil.generateStreamForTicketCreation((int)missingTickets).map(ps -> EventUtil.buildTicketParams((int)event.getId(), (Date)creationDate, (Optional)filteredTC, (int)tc.getSrcPriceCts(), (MapSqlParameterSource)ps));
    }

    private void createCategoriesForEvent(EventModification em, Event event, Optional<EventAndOrganizationId> srcEventOptional) {
        boolean freeOfCharge = em.isFreeOfCharge();
        ZoneId zoneId = TimeZone.getTimeZone(event.getTimeZone()).toZoneId();
        int eventId = event.getId();
        int requestedSeats = em.getTicketCategories().stream().filter(TicketCategoryModification::isBounded).mapToInt(TicketCategoryModification::getMaxTickets).sum();
        Validate.notNull((Object)em.getAvailableSeats(), (String)"Available Seats cannot be null", (Object[])new Object[0]);
        int notAssignedTickets = em.getAvailableSeats() - requestedSeats;
        Validate.isTrue((notAssignedTickets >= 0 ? 1 : 0) != 0, (String)"Total categories' seats cannot be more than the actual event seats", (Object[])new Object[0]);
        Validate.isTrue((notAssignedTickets > 0 || em.getTicketCategories().stream().allMatch(TicketCategoryModification::isBounded) ? 1 : 0) != 0, (String)"Cannot add an unbounded category if there aren't any free tickets", (Object[])new Object[0]);
        em.getTicketCategories().forEach(tc -> {
            int price = EventUtil.evaluatePrice((BigDecimal)tc.getPrice(), (boolean)freeOfCharge, (String)event.getCurrency());
            int maxTickets = tc.isBounded() ? tc.getMaxTickets() : 0;
            TicketCategory.TicketAccessType accessType = Objects.requireNonNullElse(tc.getTicketAccessType(), TicketCategory.TicketAccessType.INHERIT);
            if (event.getFormat() == Event.EventFormat.HYBRID && accessType == TicketCategory.TicketAccessType.INHERIT) {
                accessType = TicketCategory.TicketAccessType.IN_PERSON;
            }
            AffectedRowCountAndKey category = this.ticketCategoryRepository.insert(tc.getInception().toZonedDateTime(zoneId), tc.getExpiration().toZonedDateTime(zoneId), tc.getName(), maxTickets, tc.isTokenGenerationRequested(), eventId, tc.isBounded(), price, StringUtils.trimToNull((String)tc.getCode()), DateTimeModification.atZone((DateTimeModification)tc.getValidCheckInFrom(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getValidCheckInTo(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getTicketValidityStart(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getTicketValidityEnd(), (ZoneId)zoneId), tc.getOrdinal(), Optional.ofNullable(tc.getTicketCheckInStrategy()).orElse(TicketCategory.TicketCheckInStrategy.ONCE_PER_EVENT), Objects.requireNonNullElseGet(tc.getMetadata(), AlfioMetadata::empty), accessType);
            this.insertOrUpdateTicketCategoryDescription(((Integer)category.getKey()).intValue(), tc, event);
            if (tc.isTokenGenerationRequested()) {
                TicketCategory ticketCategory = this.ticketCategoryRepository.getByIdAndActive(((Integer)category.getKey()).intValue(), event.getId());
                this.specialPriceRepository.bulkInsert(ticketCategory, ticketCategory.getMaxTickets());
            }
            if (srcEventOptional.isPresent() && tc.getMetadata() != null && StringUtils.isNumeric((CharSequence)tc.getMetadata().getCopiedFrom())) {
                int count = this.configurationRepository.copyCategoryConfiguration(event.getId(), event.getOrganizationId(), ((Integer)category.getKey()).intValue(), ((EventAndOrganizationId)srcEventOptional.get()).getId(), ((EventAndOrganizationId)srcEventOptional.get()).getOrganizationId(), Integer.parseInt(tc.getMetadata().getCopiedFrom()));
                log.info("Copied {} settings for category {}", (Object)count, (Object)tc.getName());
            }
        });
    }

    private Integer insertCategory(TicketCategoryModification tc, Event event) {
        ZoneId zoneId = event.getZoneId();
        int eventId = event.getId();
        int price = EventUtil.evaluatePrice((BigDecimal)tc.getPrice(), (boolean)event.isFreeOfCharge(), (String)event.getCurrency());
        AffectedRowCountAndKey category = this.ticketCategoryRepository.insert(tc.getInception().toZonedDateTime(zoneId), tc.getExpiration().toZonedDateTime(zoneId), tc.getName(), tc.isBounded() ? tc.getMaxTickets() : 0, tc.isTokenGenerationRequested(), eventId, tc.isBounded(), price, StringUtils.trimToNull((String)tc.getCode()), DateTimeModification.atZone((DateTimeModification)tc.getValidCheckInFrom(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getValidCheckInTo(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getTicketValidityStart(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getTicketValidityEnd(), (ZoneId)zoneId), tc.getOrdinal(), Objects.requireNonNullElse(tc.getTicketCheckInStrategy(), TicketCategory.TicketCheckInStrategy.ONCE_PER_EVENT), Objects.requireNonNullElseGet(tc.getMetadata(), AlfioMetadata::empty), Objects.requireNonNullElse(tc.getTicketAccessType(), TicketCategory.TicketAccessType.INHERIT));
        TicketCategory ticketCategory = this.ticketCategoryRepository.getByIdAndActive(((Integer)category.getKey()).intValue(), eventId);
        if (tc.isBounded()) {
            List lockedTickets = this.ticketRepository.selectNotAllocatedTicketsForUpdate(eventId, ticketCategory.getMaxTickets(), Arrays.asList(Ticket.TicketStatus.FREE.name(), Ticket.TicketStatus.RELEASED.name()));
            this.ticketRepository.bulkTicketUpdate(lockedTickets, ticketCategory);
            if (tc.isTokenGenerationRequested()) {
                this.insertTokens(ticketCategory);
                this.ticketRepository.revertToFree(eventId, ticketCategory.getId(), lockedTickets);
            } else {
                this.ticketRepository.resetTickets(lockedTickets);
            }
        }
        this.insertOrUpdateTicketCategoryDescription(((Integer)category.getKey()).intValue(), tc, event);
        this.saveBadgeColorConfiguration(tc.getBadgeColor(), event, (Integer)category.getKey());
        return (Integer)category.getKey();
    }

    void saveBadgeColorConfiguration(String badgeColor, Event event, Integer categoryId) {
        if (StringUtils.isNotBlank((CharSequence)badgeColor)) {
            boolean existingConfiguration;
            String chosenColor = badgeColor.toLowerCase();
            CheckInOutputColorConfiguration colorConfiguration = CheckInManager.getOutputColorConfiguration((EventAndOrganizationId)event, (ConfigurationManager)this.configurationManager);
            boolean bl = existingConfiguration = colorConfiguration != null;
            if (!existingConfiguration) {
                colorConfiguration = new CheckInOutputColorConfiguration("success", List.of(new CheckInOutputColorConfiguration.ColorConfiguration(chosenColor, List.of(categoryId))));
            } else {
                List configurationWithoutCategory = colorConfiguration.getConfigurations().stream().map(cc -> new CheckInOutputColorConfiguration.ColorConfiguration(cc.getColorName(), cc.getCategories().stream().filter(c -> !c.equals(categoryId)).collect(Collectors.toUnmodifiableList()))).filter(cc -> !cc.getCategories().isEmpty()).collect(Collectors.toList());
                boolean colorExists = configurationWithoutCategory.stream().anyMatch(cc -> cc.getColorName().equals(chosenColor));
                if (colorExists) {
                    colorConfiguration = new CheckInOutputColorConfiguration(colorConfiguration.getDefaultColorName(), configurationWithoutCategory.stream().map(cc -> {
                        if (cc.getColorName().equals(chosenColor)) {
                            ArrayList<Integer> newList = new ArrayList<Integer>(cc.getCategories());
                            newList.add(categoryId);
                            return new CheckInOutputColorConfiguration.ColorConfiguration(chosenColor, newList);
                        }
                        return cc;
                    }).collect(Collectors.toUnmodifiableList()));
                } else {
                    ArrayList newList = new ArrayList(configurationWithoutCategory);
                    newList.add(new CheckInOutputColorConfiguration.ColorConfiguration(chosenColor, List.of(categoryId)));
                    colorConfiguration = new CheckInOutputColorConfiguration(colorConfiguration.getDefaultColorName(), newList);
                }
            }
            if (existingConfiguration) {
                this.configurationRepository.updateEventLevel(event.getId(), event.getOrganizationId(), ConfigurationKeys.CHECK_IN_COLOR_CONFIGURATION.name(), Json.toJson((Object)colorConfiguration));
            } else {
                this.configurationRepository.insertEventLevel(event.getOrganizationId(), event.getId(), ConfigurationKeys.CHECK_IN_COLOR_CONFIGURATION.name(), Json.toJson((Object)colorConfiguration), null);
            }
        }
    }

    private void insertTokens(TicketCategory ticketCategory) {
        this.insertTokens(ticketCategory, ticketCategory.getMaxTickets());
    }

    private void insertTokens(TicketCategory ticketCategory, int requiredTokens) {
        this.specialPriceRepository.bulkInsert(ticketCategory, requiredTokens);
    }

    private void insertOrUpdateTicketCategoryDescription(int tcId, TicketCategoryModification tc, Event event) {
        this.ticketCategoryDescriptionRepository.delete(tcId);
        Set eventLang = ContentLanguage.findAllFor((int)event.getLocales()).stream().map(ContentLanguage::getLanguage).collect(Collectors.toSet());
        Optional.ofNullable(tc.getDescription()).ifPresent(descriptions -> descriptions.forEach((locale, desc) -> {
            if (eventLang.contains(locale)) {
                this.ticketCategoryDescriptionRepository.insert(tcId, locale, desc);
            }
        }));
    }

    private void updateCategory(TicketCategoryModification tc, boolean freeOfCharge, ZoneId zoneId, Event event, boolean resetTicketsToFree) {
        int eventId = event.getId();
        int price = EventUtil.evaluatePrice((BigDecimal)tc.getPrice(), (boolean)freeOfCharge, (String)event.getCurrency());
        TicketCategory original = this.ticketCategoryRepository.getByIdAndActive(tc.getId().intValue(), eventId);
        this.ticketCategoryRepository.update(tc.getId().intValue(), tc.getName(), tc.getInception().toZonedDateTime(zoneId), tc.getExpiration().toZonedDateTime(zoneId), tc.getMaxTickets(), tc.isTokenGenerationRequested(), price, StringUtils.trimToNull((String)tc.getCode()), DateTimeModification.atZone((DateTimeModification)tc.getValidCheckInFrom(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getValidCheckInTo(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getTicketValidityStart(), (ZoneId)zoneId), DateTimeModification.atZone((DateTimeModification)tc.getTicketValidityEnd(), (ZoneId)zoneId), Objects.requireNonNullElse(tc.getTicketCheckInStrategy(), TicketCategory.TicketCheckInStrategy.ONCE_PER_EVENT), tc.getTicketAccessType());
        TicketCategory updated = this.ticketCategoryRepository.getByIdAndActive(tc.getId().intValue(), eventId);
        int addedTickets = 0;
        if (original.isBounded() ^ tc.isBounded()) {
            this.handleTicketAllocationStrategyChange((EventAndOrganizationId)event, original, tc);
        } else {
            addedTickets = updated.getMaxTickets() - original.getMaxTickets();
            this.handleTicketNumberModification(event, updated, addedTickets, resetTicketsToFree);
        }
        this.handleTokenModification(original, updated, addedTickets);
        this.handlePriceChange((EventAndOrganizationId)event, original, updated);
        this.insertOrUpdateTicketCategoryDescription(tc.getId().intValue(), tc, event);
        this.saveBadgeColorConfiguration(tc.getBadgeColor(), event, tc.getId());
        this.auditingRepository.insertUpdateTicketInCategoryId(tc.getId().intValue());
    }

    private void handleTicketAllocationStrategyChange(EventAndOrganizationId event, TicketCategory original, TicketCategoryModification updated) {
        if (updated.isBounded()) {
            int eventId = event.getId();
            int newSize = updated.getMaxTickets();
            int confirmed = this.ticketRepository.countConfirmedForCategory(eventId, original.getId());
            int addedTickets = newSize - confirmed;
            List ids = this.ticketRepository.selectNotAllocatedTicketsForUpdate(eventId, addedTickets, Collections.singletonList(Ticket.TicketStatus.FREE.name()));
            Validate.isTrue((addedTickets >= 0 ? 1 : 0) != 0, (String)("Cannot reduce capacity to " + newSize + ". Minimum size allowed is " + confirmed), (Object[])new Object[0]);
            Validate.isTrue((ids.size() >= addedTickets ? 1 : 0) != 0, (String)"not enough tickets", (Object[])new Object[0]);
            Validate.isTrue((ids.isEmpty() || this.ticketRepository.moveToAnotherCategory(ids, original.getId(), MonetaryUtil.unitToCents((BigDecimal)updated.getPrice(), (String)original.getCurrencyCode())) == ids.size() ? 1 : 0) != 0, (String)"not enough tickets", (Object[])new Object[0]);
        } else {
            this.reallocateTickets(this.ticketCategoryRepository.findStatisticWithId(original.getId(), event.getId()), Optional.empty(), event);
        }
        this.ticketCategoryRepository.updateBoundedFlag(original.getId(), updated.isBounded());
    }

    void handlePriceChange(EventAndOrganizationId event, TicketCategory original, TicketCategory updated) {
        if (original.getSrcPriceCts() == updated.getSrcPriceCts() || !original.isBounded()) {
            return;
        }
        List ids = this.ticketRepository.selectTicketInCategoryForUpdate(event.getId(), updated.getId(), updated.getMaxTickets(), Collections.singletonList(Ticket.TicketStatus.FREE.name()));
        if (ids.size() < updated.getMaxTickets()) {
            throw new IllegalStateException("Tickets have already been sold (or are in the process of being sold) for this category. Therefore price update is not allowed.");
        }
        this.ticketRepository.updateTicketPrice(updated.getId(), event.getId(), updated.getSrcPriceCts(), 0, 0, 0, original.getCurrencyCode());
    }

    void handleTokenModification(TicketCategory original, TicketCategory updated, int addedTickets) {
        if (original.isAccessRestricted() ^ updated.isAccessRestricted()) {
            if (updated.isAccessRestricted()) {
                this.specialPriceRepository.bulkInsert(updated, updated.getMaxTickets());
            } else {
                this.specialPriceRepository.cancelExpiredTokens(updated.getId());
            }
        } else if (updated.isAccessRestricted() && addedTickets != 0) {
            if (addedTickets > 0) {
                this.specialPriceRepository.bulkInsert(updated, addedTickets);
            } else {
                int absDifference = Math.abs(addedTickets);
                List ids = this.specialPriceRepository.lockNotSentTokens(updated.getId(), absDifference);
                Validate.isTrue((ids.size() - absDifference == 0 ? 1 : 0) != 0, (String)"not enough tokens", (Object[])new Object[0]);
                this.specialPriceRepository.cancelTokens(ids);
            }
        }
    }

    void handleTicketNumberModification(Event event, TicketCategory updated, int addedTickets, boolean resetToFree) {
        if (addedTickets == 0) {
            log.debug("ticket handling not required since the number of ticket wasn't modified");
            return;
        }
        log.debug("modification detected in ticket number. The difference is: {}", (Object)addedTickets);
        if (addedTickets > 0) {
            List lockedTickets = this.ticketRepository.selectNotAllocatedTicketsForUpdate(event.getId(), addedTickets, Arrays.asList(Ticket.TicketStatus.FREE.name(), Ticket.TicketStatus.RELEASED.name()));
            Validate.isTrue((addedTickets == lockedTickets.size() ? 1 : 0) != 0, (String)"Cannot add %d tickets. There are only %d free tickets.", (Object[])new Object[]{addedTickets, lockedTickets.size()});
            this.ticketRepository.bulkTicketUpdate(lockedTickets, updated);
            if (updated.isAccessRestricted()) {
                this.ticketRepository.revertToFree(event.getId(), updated.getId(), lockedTickets);
            } else if (!resetToFree) {
                this.ticketRepository.resetTickets(lockedTickets);
            }
        } else {
            int absDifference = Math.abs(addedTickets);
            List ids = this.ticketRepository.lockTicketsToInvalidate(event.getId(), updated.getId(), absDifference);
            int actualDifference = ids.size();
            if (actualDifference < absDifference) {
                throw new IllegalStateException("Cannot invalidate " + absDifference + " tickets. There are only " + actualDifference + " free tickets");
            }
            this.ticketRepository.invalidateTickets(ids);
            MapSqlParameterSource[] params = (MapSqlParameterSource[])EventUtil.generateEmptyTickets((EventAndOrganizationId)event, (Date)Date.from(event.now(this.clockProvider).toInstant()), (int)absDifference, (Ticket.TicketStatus)(resetToFree ? Ticket.TicketStatus.FREE : Ticket.TicketStatus.RELEASED)).toArray(MapSqlParameterSource[]::new);
            this.ticketRepository.bulkTicketInitialization(params);
        }
    }

    private void createAllTicketsForEvent(Event event, EventModification em) {
        Objects.requireNonNull(em.getAvailableSeats());
        MapSqlParameterSource[] params = this.prepareTicketsBulkInsertParameters(event.now(this.clockProvider), event, em.getAvailableSeats().intValue(), Ticket.TicketStatus.FREE);
        this.ticketRepository.bulkTicketInitialization(params);
    }

    private int insertEvent(EventModification em) {
        Objects.requireNonNull(em.getAvailableSeats());
        this.validatePaymentProxies(em.getAllowedPaymentProxies(), em.getOrganizationId());
        String paymentProxies = this.collectPaymentProxies(em);
        BigDecimal vat = em.isFreeOfCharge() ? BigDecimal.ZERO : em.getVatPercentage();
        String privateKey = UUID.randomUUID().toString();
        ZoneId zoneId = ZoneId.of(em.getZoneId());
        String currentVersion = this.flyway.info().current().getVersion().getVersion();
        AlfioMetadata eventMetadata = Objects.requireNonNullElseGet(em.getMetadata(), AlfioMetadata::empty);
        return (Integer)this.eventRepository.insert(em.getShortName(), em.getFormat(), em.getDisplayName(), em.getWebsiteUrl(), em.getExternalUrl(), em.getTermsAndConditionsUrl(), em.getPrivacyPolicyUrl(), em.getImageUrl(), em.getFileBlobId(), em.getLocation(), em.getLatitude(), em.getLongitude(), em.getBegin().toZonedDateTime(zoneId), em.getEnd().toZonedDateTime(zoneId), em.getZoneId(), em.getCurrency(), em.getAvailableSeats().intValue(), em.isVatIncluded(), vat, paymentProxies, privateKey, em.getOrganizationId(), em.getLocales(), em.getVatStatus(), em.getPriceInCents(), currentVersion, Event.Status.DRAFT, eventMetadata).getKey();
    }

    private String collectPaymentProxies(EventModification em) {
        return em.getAllowedPaymentProxies().stream().map(Enum::name).distinct().collect(Collectors.joining(","));
    }

    public TicketCategory getTicketCategoryById(int id, int eventId) {
        return this.ticketCategoryRepository.getByIdAndActive(id, eventId);
    }

    public boolean toggleTicketLocking(String eventName, int categoryId, int ticketId, String username) {
        EventAndOrganizationId event = this.getEventAndOrganizationId(eventName, username);
        this.checkOwnership(event, username, event.getOrganizationId());
        Optional<TicketCategory> existingCategory = this.ticketCategoryRepository.findAllTicketCategories(event.getId()).stream().filter(tc -> tc.getId() == categoryId).findFirst();
        if (existingCategory.isPresent()) {
            Ticket ticket = this.ticketRepository.findById(ticketId, categoryId);
            Validate.isTrue((this.ticketRepository.toggleTicketLocking(ticketId, categoryId, !ticket.getLockedAssignment()) == 1 ? 1 : 0) != 0, (String)"unwanted result from ticket locking", (Object[])new Object[0]);
            return true;
        }
        throw new IllegalArgumentException("Invalid category");
    }

    public void addPromoCode(String promoCode, Integer eventId, Integer organizationId, ZonedDateTime start, ZonedDateTime end, int discountAmount, PromoCodeDiscount.DiscountType discountType, List<Integer> categoriesId, Integer maxUsage, String description, String emailReference, PromoCodeDiscount.CodeType codeType, Integer hiddenCategoryId, String currencyCode) {
        Validate.isTrue((promoCode.length() >= 7 ? 1 : 0) != 0, (String)"min length is 7 chars", (Object[])new Object[0]);
        Validate.isTrue((eventId != null && organizationId == null || eventId == null && organizationId != null ? 1 : 0) != 0, (String)"eventId or organizationId must be not null", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.length((CharSequence)description) < 1025 ? 1 : 0) != 0, (String)"Description can be maximum 1024 chars", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.length((CharSequence)emailReference) < 257 ? 1 : 0) != 0, (String)"Description can be maximum 256 chars", (Object[])new Object[0]);
        Validate.isTrue((!PromoCodeDiscount.supportsCurrencyCode((PromoCodeDiscount.CodeType)codeType, (PromoCodeDiscount.DiscountType)discountType) || StringUtils.length((CharSequence)currencyCode) == 3 ? 1 : 0) != 0, (String)"Currency code is not valid", (Object[])new Object[0]);
        if (maxUsage != null) {
            Validate.isTrue((maxUsage > 0 ? 1 : 0) != 0, (String)"Invalid max usage", (Object[])new Object[0]);
        }
        if (PromoCodeDiscount.DiscountType.PERCENTAGE == discountType) {
            Validate.inclusiveBetween((long)0L, (long)100L, (long)discountAmount, (String)"percentage discount must be between 0 and 100");
        }
        if (PromoCodeDiscount.DiscountType.FIXED_AMOUNT == discountType || PromoCodeDiscount.DiscountType.FIXED_AMOUNT_RESERVATION == discountType) {
            Validate.isTrue((discountAmount >= 0 ? 1 : 0) != 0, (String)"fixed discount amount cannot be less than zero", (Object[])new Object[0]);
        }
        if (PromoCodeDiscount.CodeType.ACCESS == codeType) {
            Validate.notNull((Object)hiddenCategoryId, (String)"Hidden category is required", (Object[])new Object[0]);
        }
        categoriesId = Optional.ofNullable(categoriesId).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (organizationId == null) {
            organizationId = this.eventRepository.findOrganizationIdByEventId(eventId.intValue());
        }
        if (codeType == PromoCodeDiscount.CodeType.ACCESS) {
            discountType = PromoCodeDiscount.DiscountType.NONE;
        }
        this.promoCodeRepository.addPromoCode(promoCode, eventId, organizationId.intValue(), start, end, discountAmount, discountType, Json.GSON.toJson(categoriesId), maxUsage, description, emailReference, codeType, hiddenCategoryId, currencyCode);
    }

    public void deletePromoCode(int promoCodeId) {
        this.promoCodeRepository.deletePromoCode(promoCodeId);
    }

    public void updatePromoCode(int promoCodeId, ZonedDateTime start, ZonedDateTime end, Integer maxUsage, List<Integer> categories, String description, String emailReference, Integer hiddenCategoryId) {
        Validate.isTrue((StringUtils.length((CharSequence)description) < 1025 ? 1 : 0) != 0, (String)"Description can be maximum 1024 chars", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.length((CharSequence)emailReference) < 257 ? 1 : 0) != 0, (String)"Description can be maximum 256 chars", (Object[])new Object[0]);
        String categoriesJson = CollectionUtils.isEmpty(categories) ? null : Json.toJson(categories);
        this.promoCodeRepository.updateEventPromoCode(promoCodeId, start, end, maxUsage, categoriesJson, description, emailReference, hiddenCategoryId);
    }

    public List<PromoCodeDiscountWithFormattedTimeAndAmount> findPromoCodesInEvent(int eventId) {
        Event event = this.eventRepository.findById(eventId);
        return this.promoCodeRepository.findAllInEvent(eventId).stream().map(p -> new PromoCodeDiscountWithFormattedTimeAndAmount(p, event.getZoneId(), event.getCurrency())).collect(Collectors.toList());
    }

    public List<PromoCodeDiscountWithFormattedTimeAndAmount> findPromoCodesInOrganization(int organizationId) {
        ZoneId zoneId = ZoneId.systemDefault();
        return this.promoCodeRepository.findAllInOrganization(organizationId).stream().map(p -> new PromoCodeDiscountWithFormattedTimeAndAmount(p, zoneId, null)).collect(Collectors.toList());
    }

    public String getEventUrl(Event event) {
        String baseUrl = this.configurationManager.getFor(ConfigurationKeys.BASE_URL, event.getConfigurationLevel()).getRequiredValue();
        return StringUtils.removeEnd((String)baseUrl, (String)"/") + "/event/" + event.getShortName() + "/";
    }

    public List<TicketWithReservationAndTransaction> findAllConfirmedTicketsForCSV(String eventName, String username) {
        EventAndOrganizationId event = this.getEventAndOrganizationId(eventName, username);
        this.checkOwnership(event, username, event.getOrganizationId());
        return this.ticketRepository.findAllConfirmedForCSV(event.getId());
    }

    public List<Event> getPublishedEvents(SearchOptions searchOptions) {
        return this.eventRepository.findVisibleBySearchOptions(searchOptions.getSubscriptionCodeUUIDOrNull(), searchOptions.getOrganizer(), searchOptions.getOrganizerSlug(), searchOptions.getTags());
    }

    public List<Event> getActiveEvents() {
        return this.getActiveEventsStream(1).toList();
    }

    public List<Event> getEventsByDateRange(int days) {
        return this.getActiveEventsStream(days).toList();
    }

    private Stream<Event> getActiveEventsStream(int days) {
        return this.eventRepository.findAll().stream().filter(e -> e.getEnd().truncatedTo(ChronoUnit.DAYS).plusDays(days).isAfter(ZonedDateTime.now(this.clockProvider.withZone(e.getZoneId())).truncatedTo(ChronoUnit.DAYS)));
    }

    public Function<Ticket, Boolean> checkTicketCancellationPrerequisites() {
        return CategoryEvaluator.ticketCancellationAvailabilityChecker((TicketCategoryRepository)this.ticketCategoryRepository);
    }

    void resetReleasedTickets(EventAndOrganizationId event) {
        int reverted = this.ticketRepository.revertToFree(event.getId());
        if (reverted > 0) {
            log.debug("Reverted {} tickets to FREE for event {}", (Object)reverted, (Object)event.getId());
        }
    }

    public void deleteEvent(int eventId, String username) {
        Event event = this.eventRepository.findById(eventId);
        this.checkOwnership((EventAndOrganizationId)event, username, event.getOrganizationId());
        this.eventDeleterRepository.deleteAllForEvent(eventId);
    }

    public Optional<TicketCategory> getOptionalByIdAndActive(int ticketCategoryId, int eventId) {
        return this.ticketCategoryRepository.getOptionalByIdAndActive(ticketCategoryId, eventId);
    }

    public void deleteCategory(String eventName, int categoryId, String username) {
        Optional optionalEvent = this.getOptionalEventAndOrganizationIdByName(eventName, username);
        if (optionalEvent.isEmpty()) {
            throw new IllegalArgumentException("Event not found");
        }
        int eventId = ((EventAndOrganizationId)optionalEvent.get()).getId();
        if (this.ticketCategoryRepository.countActiveByEventId(eventId) < 2) {
            throw new IllegalArgumentException("At least one category is required");
        }
        Optional optionalCategory = this.getOptionalByIdAndActive(categoryId, eventId);
        if (optionalCategory.isEmpty()) {
            throw new IllegalArgumentException("Category not found");
        }
        TicketCategory category = (TicketCategory)optionalCategory.get();
        int result = this.ticketCategoryRepository.deleteCategoryIfEmpty(category.getId());
        if (result != 1) {
            log.debug("cannot delete category. Expected result 1, got {}", (Object)result);
            throw new IllegalStateException("Cannot delete category");
        }
        if (category.isBounded()) {
            int ticketsCount = category.getMaxTickets();
            List ticketIds = this.ticketRepository.selectTicketInCategoryForUpdate(eventId, categoryId, ticketsCount, List.of(Ticket.TicketStatus.FREE.name(), Ticket.TicketStatus.RELEASED.name()));
            Validate.isTrue((ticketIds.size() == ticketsCount ? 1 : 0) != 0, (String)"Error while deleting category. Please ensure that there is no pending reservation.", (Object[])new Object[0]);
            this.ticketRepository.resetTickets(ticketIds);
            Validate.isTrue((ticketsCount == this.ticketRepository.unbindTicketsFromCategory(eventId, categoryId, ticketIds) ? 1 : 0) != 0, (String)"Cannot remove tickets from category.", (Object[])new Object[0]);
        }
    }

    public void rearrangeCategories(String eventName, List<CategoryOrdinalModification> categories, String username) {
        Optional optionalEvent = this.getOptionalEventAndOrganizationIdByName(eventName, username);
        if (optionalEvent.isPresent()) {
            int eventId = ((EventAndOrganizationId)optionalEvent.get()).getId();
            MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])categories.stream().map(category -> new MapSqlParameterSource("ordinal", (Object)category.getOrdinal()).addValue("id", (Object)category.getId()).addValue("eventId", (Object)eventId)).toArray(MapSqlParameterSource[]::new);
            int[] results = this.jdbcTemplate.batchUpdate(this.ticketCategoryRepository.updateOrdinal(), (SqlParameterSource[])parameterSources);
            Validate.isTrue((IntStream.of(results).sum() == categories.size() ? 1 : 0) != 0, (String)"Unexpected result from update.", (Object[])new Object[0]);
        } else {
            log.warn("unauthorized access to event {}", (Object)MiscUtils.removeTabsAndNewlines((String)eventName));
        }
    }

    public Map<Integer, String> getEventNamesByIds(List<Integer> eventIds, Principal principal) {
        if (!RequestUtils.isAdmin((Principal)principal)) {
            throw new IllegalStateException("User must be admin");
        }
        return this.eventRepository.getEventNamesByIds(eventIds).stream().collect(Collectors.toMap(EventIdShortName::getId, EventIdShortName::getShortName));
    }

    public Map<Integer, String> getEventsNameInOrganization(int orgId, Principal principal) {
        if (!RequestUtils.isAdmin((Principal)principal)) {
            throw new IllegalStateException("User must be admin");
        }
        return this.eventRepository.getEventsNameInOrganization(orgId).stream().collect(Collectors.toMap(EventIdShortName::getId, EventIdShortName::getShortName));
    }

    public boolean updateMetadata(Event event, AlfioMetadata metadata) {
        AlfioMetadata existing = this.eventRepository.getMetadataForEvent(event.getId());
        AlfioMetadata updatedMetadata = this.extensionManager.handleMetadataUpdate(event, this.organizationRepository.getById(event.getOrganizationId()), metadata);
        this.eventRepository.updateMetadata(existing.merge(Objects.requireNonNullElse(updatedMetadata, metadata)), event.getId());
        return true;
    }

    public boolean updateCategoryMetadata(EventAndOrganizationId event, int categoryId, AlfioMetadata metadata) {
        AlfioMetadata existing = this.ticketCategoryRepository.getMetadata(event.getId(), categoryId);
        return this.ticketCategoryRepository.updateMetadata(existing.merge(metadata), event.getId(), categoryId) == 1;
    }

    public AlfioMetadata getMetadataForEvent(EventAndOrganizationId event) {
        return this.eventRepository.getMetadataForEvent(event.getId());
    }

    public AlfioMetadata getMetadataForCategory(EventAndOrganizationId event, int categoryId) {
        return this.ticketCategoryRepository.getMetadata(event.getId(), categoryId);
    }

    public Optional<String> executeCapability(String eventName, String username, ExtensionCapability capability, Map<String, String> requestParams) {
        return this.getOptionalByName(eventName, username).flatMap(event -> {
            if (capability == ExtensionCapability.GENERATE_MEETING_LINK) {
                Organization organization = this.organizationRepository.getById(event.getOrganizationId());
                return this.extensionManager.handleGenerateMeetingLinkCapability(event, organization, this.getMetadataForEvent((EventAndOrganizationId)event), requestParams).map(metadata -> {
                    this.eventRepository.updateMetadata(Objects.requireNonNullElseGet(metadata, AlfioMetadata::empty), event.getId());
                    return "metadata updated";
                });
            }
            if (capability == ExtensionCapability.LINK_EXTERNAL_APPLICATION) {
                return this.extensionManager.handleGenerateLinkCapability(event, this.getMetadataForEvent((EventAndOrganizationId)event), requestParams);
            }
            return this.extensionManager.executeCapability(capability, requestParams, (PurchaseContext)event, String.class);
        });
    }

    public List<UUID> getLinkedSubscriptionIds(int eventId, int organizationId) {
        return this.subscriptionRepository.findLinkedSubscriptionIds(eventId, organizationId);
    }

    public List<EventSubscriptionLink> getLinkedSubscriptions(int eventId, int organizationId) {
        return this.subscriptionRepository.findLinkedSubscriptions(eventId, organizationId);
    }

    public int getEventsCount() {
        return this.eventRepository.countEvents();
    }

    @ConstructorProperties(value={"userManager", "eventRepository", "eventDescriptionRepository", "ticketCategoryRepository", "ticketCategoryDescriptionRepository", "ticketRepository", "specialPriceRepository", "promoCodeRepository", "configurationManager", "eventDeleterRepository", "purchaseContextFieldManager", "flyway", "environment", "organizationRepository", "auditingRepository", "extensionManager", "groupRepository", "jdbcTemplate", "configurationRepository", "paymentManager", "clockProvider", "subscriptionRepository", "additionalServiceManager"})
    @Generated
    public EventManager(UserManager userManager, EventRepository eventRepository, EventDescriptionRepository eventDescriptionRepository, TicketCategoryRepository ticketCategoryRepository, TicketCategoryDescriptionRepository ticketCategoryDescriptionRepository, TicketRepository ticketRepository, SpecialPriceRepository specialPriceRepository, PromoCodeDiscountRepository promoCodeRepository, ConfigurationManager configurationManager, EventDeleterRepository eventDeleterRepository, PurchaseContextFieldManager purchaseContextFieldManager, Flyway flyway, Environment environment, OrganizationRepository organizationRepository, AuditingRepository auditingRepository, ExtensionManager extensionManager, GroupRepository groupRepository, NamedParameterJdbcTemplate jdbcTemplate, ConfigurationRepository configurationRepository, PaymentManager paymentManager, ClockProvider clockProvider, SubscriptionRepository subscriptionRepository, AdditionalServiceManager additionalServiceManager) {
        this.userManager = userManager;
        this.eventRepository = eventRepository;
        this.eventDescriptionRepository = eventDescriptionRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.ticketCategoryDescriptionRepository = ticketCategoryDescriptionRepository;
        this.ticketRepository = ticketRepository;
        this.specialPriceRepository = specialPriceRepository;
        this.promoCodeRepository = promoCodeRepository;
        this.configurationManager = configurationManager;
        this.eventDeleterRepository = eventDeleterRepository;
        this.purchaseContextFieldManager = purchaseContextFieldManager;
        this.flyway = flyway;
        this.environment = environment;
        this.organizationRepository = organizationRepository;
        this.auditingRepository = auditingRepository;
        this.extensionManager = extensionManager;
        this.groupRepository = groupRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.configurationRepository = configurationRepository;
        this.paymentManager = paymentManager;
        this.clockProvider = clockProvider;
        this.subscriptionRepository = subscriptionRepository;
        this.additionalServiceManager = additionalServiceManager;
    }
}

