/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.repository.EventAdminRepository;
import java.beans.ConstructorProperties;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.RandomStringGenerator;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class EventNameManager {
    private static final Pattern NUMBER_MATCHER = Pattern.compile("^\\d+$");
    private static final String SPACES_AND_PUNCTUATION = "[\\s\\p{Punct}]";
    private static final String FIND_EVIL_CHARACTERS = "[^\\sA-Z\\-a-z0-9]";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final RandomStringGenerator RANDOM_STRING_GENERATOR = new RandomStringGenerator.Builder().withinRange((char[][])new char[][]{{'a', 'z'}, {'A', 'Z'}, {'0', '9'}}).usingRandom(RANDOM::nextInt).get();
    private final EventAdminRepository eventAdminRepository;

    public String generateShortName(String displayName) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)displayName));
        String cleanDisplayName = StringUtils.stripAccents((String)StringUtils.normalizeSpace((String)displayName)).toLowerCase(Locale.ENGLISH).replaceAll(FIND_EVIL_CHARACTERS, "-");
        if (!StringUtils.containsWhitespace((CharSequence)cleanDisplayName) && this.isUnique(cleanDisplayName)) {
            return cleanDisplayName;
        }
        Optional dashedName = this.getDashedName(cleanDisplayName);
        if (dashedName.isPresent()) {
            return (String)dashedName.get();
        }
        Optional croppedName = this.getCroppedName(cleanDisplayName);
        return croppedName.orElseGet(() -> this.generateRandomName());
    }

    private String generateRandomName() {
        return IntStream.range(0, 5).mapToObj(i -> RANDOM_STRING_GENERATOR.generate(15)).filter(arg_0 -> this.isUnique(arg_0)).limit(1L).findFirst().orElse("");
    }

    private Optional<String> getCroppedName(String cleanDisplayName) {
        String candidate = Arrays.stream(cleanDisplayName.split(SPACES_AND_PUNCTUATION)).map(w -> Pair.of((Object)NUMBER_MATCHER.matcher((CharSequence)w).matches(), (Object)w)).map(p -> Boolean.TRUE.equals(p.getKey()) ? (String)p.getValue() : StringUtils.left((String)((String)p.getValue()), (int)1)).collect(Collectors.joining());
        if (this.isUnique(candidate)) {
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    private Optional<String> getDashedName(String cleanDisplayName) {
        String candidate;
        if (cleanDisplayName.length() < 15 && this.isUnique(candidate = cleanDisplayName.replaceAll(SPACES_AND_PUNCTUATION, "-"))) {
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    public boolean isUnique(String shortName) {
        return !this.eventAdminRepository.existsBySlug(shortName);
    }

    @ConstructorProperties(value={"eventAdminRepository"})
    @Generated
    public EventNameManager(EventAdminRepository eventAdminRepository) {
        this.eventAdminRepository = eventAdminRepository;
    }
}

