/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.AdditionalServiceManager;
import alfio.manager.ExtensionManager;
import alfio.manager.GroupManager;
import alfio.model.AdditionalServiceItem;
import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.ReservationIdAndEventId;
import alfio.model.system.command.CleanupReservations;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.BillingDocumentRepository;
import alfio.repository.EventRepository;
import alfio.repository.SpecialPriceRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;

@Component
public class EventReservationManager {
    private static final Logger log = LoggerFactory.getLogger(EventReservationManager.class);
    private final SpecialPriceRepository specialPriceRepository;
    private final GroupManager groupManager;
    private final TicketRepository ticketRepository;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final AdditionalServiceManager additionalServiceManager;
    private final TicketReservationRepository ticketReservationRepository;
    private final EventRepository eventRepository;
    private final ExtensionManager extensionManager;
    private final BillingDocumentRepository billingDocumentRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public EventReservationManager(SpecialPriceRepository specialPriceRepository, GroupManager groupManager, TicketRepository ticketRepository, AdditionalServiceItemRepository additionalServiceItemRepository, AdditionalServiceManager additionalServiceManager, TicketReservationRepository ticketReservationRepository, EventRepository eventRepository, ExtensionManager extensionManager, BillingDocumentRepository billingDocumentRepository, NamedParameterJdbcTemplate jdbcTemplate) {
        this.specialPriceRepository = specialPriceRepository;
        this.groupManager = groupManager;
        this.ticketRepository = ticketRepository;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.additionalServiceManager = additionalServiceManager;
        this.ticketReservationRepository = ticketReservationRepository;
        this.eventRepository = eventRepository;
        this.extensionManager = extensionManager;
        this.billingDocumentRepository = billingDocumentRepository;
        this.jdbcTemplate = jdbcTemplate;
    }

    @EventListener(value={CleanupReservations.class})
    public void cleanupReservations(CleanupReservations cleanupReservations) {
        if (cleanupReservations.purchaseContext() != null && !cleanupReservations.purchaseContext().ofType(PurchaseContext.PurchaseContextType.event)) {
            return;
        }
        this.specialPriceRepository.resetToFreeAndCleanupForReservation(cleanupReservations.reservationIds());
        this.ticketRepository.resetCategoryIdForUnboundedCategories(cleanupReservations.reservationIds());
        PurchaseContext purchaseContext = cleanupReservations.purchaseContext();
        if (purchaseContext instanceof Event) {
            Event event = (Event)purchaseContext;
            for (String reservationId : cleanupReservations.reservationIds()) {
                this.cleanupReferences(cleanupReservations.expired(), reservationId, event);
            }
            this.notifyExtensions(event, cleanupReservations.reservationIds(), cleanupReservations.expired());
        } else {
            Map<Integer, List<ReservationIdAndEventId>> reservationIdsByEvent = this.ticketReservationRepository.getReservationIdAndEventId((Collection)cleanupReservations.reservationIds()).stream().collect(Collectors.groupingBy(ReservationIdAndEventId::getEventId));
            reservationIdsByEvent.forEach((eventId, reservations) -> {
                Event event = this.eventRepository.findById(eventId.intValue());
                List<String> reservationIds = reservations.stream().map(ReservationIdAndEventId::getId).toList();
                for (String reservationId : reservationIds) {
                    this.cleanupReferences(cleanupReservations.expired(), reservationId, event);
                }
                this.notifyExtensions(event, reservationIds, cleanupReservations.expired());
                this.billingDocumentRepository.deleteForReservations(reservationIds, eventId.intValue());
            });
        }
    }

    private void cleanupReferences(boolean expired, String reservationId, Event event) {
        this.groupManager.deleteWhitelistedTicketsForReservation(reservationId);
        int deletedItems = this.additionalServiceItemRepository.deleteAdditionalServiceItemsByReservationId(event.getId(), reservationId);
        int updatedItems = this.additionalServiceItemRepository.revertAdditionalServiceItemsByReservationId(event.getId(), reservationId);
        log.debug("Deleted {} and updated {} additionalServiceItems for reservation {}", new Object[]{deletedItems, updatedItems, reservationId});
        int updatedAS = this.additionalServiceManager.updateStatusForReservationId(event.getId(), reservationId, expired ? AdditionalServiceItem.AdditionalServiceItemStatus.EXPIRED : AdditionalServiceItem.AdditionalServiceItemStatus.CANCELLED);
        SqlParameterSource[] batchUpdate = (SqlParameterSource[])this.ticketRepository.findTicketIdsInReservation(reservationId).stream().map(id -> new MapSqlParameterSource("ticketId", id).addValue("reservationId", (Object)reservationId).addValue("eventId", (Object)event.getId()).addValue("newUuid", (Object)UUID.randomUUID().toString()).addValue("newPublicUuid", (Object)UUID.randomUUID())).toArray(SqlParameterSource[]::new);
        int updatedTickets = Arrays.stream(this.jdbcTemplate.batchUpdate(this.ticketRepository.batchReleaseTickets(), batchUpdate)).sum();
        Validate.isTrue((updatedTickets + updatedAS > 0 ? 1 : 0) != 0, (String)"no items have been updated", (Object[])new Object[0]);
    }

    private void notifyExtensions(Event event, List<String> reservationIds, boolean expired) {
        if (expired) {
            this.extensionManager.handleReservationsExpired((PurchaseContext)event, reservationIds);
        } else {
            this.extensionManager.handleReservationsCancelled((PurchaseContext)event, reservationIds);
        }
    }
}

