/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.ExtensionManager;
import alfio.manager.support.extension.ExtensionCapability;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventStatistic;
import alfio.model.EventStatisticView;
import alfio.model.EventWithAdditionalInfo;
import alfio.model.PurchaseContext;
import alfio.model.TicketCategory;
import alfio.model.TicketCategoryStatisticView;
import alfio.model.TicketCategoryWithAdditionalInfo;
import alfio.model.TicketsByDateStatistic;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.modification.TicketWithStatistic;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.EventRepository;
import alfio.repository.SpecialPriceRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryDescriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TicketSearchRepository;
import alfio.util.EventUtil;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional(readOnly=true)
public class EventStatisticsManager {
    private final EventRepository eventRepository;
    private final EventDescriptionRepository eventDescriptionRepository;
    private final TicketSearchRepository ticketSearchRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final TicketCategoryDescriptionRepository ticketCategoryDescriptionRepository;
    private final TicketReservationRepository ticketReservationRepository;
    private final SpecialPriceRepository specialPriceRepository;
    private final ConfigurationManager configurationManager;
    private final UserManager userManager;
    private final SubscriptionRepository subscriptionRepository;
    private final ExtensionManager extensionManager;

    private List<Event> getAllEvents(String username) {
        List orgIds = this.userManager.findUserOrganizations(username).stream().map(Organization::getId).collect(Collectors.toList());
        return orgIds.isEmpty() ? Collections.emptyList() : this.eventRepository.findByOrganizationIds(orgIds);
    }

    public List<EventStatistic> getAllEventsWithStatisticsFilteredBy(String username, Predicate<Event> predicate) {
        List events = this.getAllEvents(username).stream().filter(predicate).collect(Collectors.toList());
        Map mappedEvent = events.stream().collect(Collectors.toMap(EventAndOrganizationId::getId, Function.identity()));
        if (!mappedEvent.isEmpty()) {
            boolean isOwner = this.userManager.isOwner(this.userManager.findUserByUsername(username));
            Set<Integer> ids = mappedEvent.keySet();
            Stream<Object> stats = isOwner ? this.eventRepository.findStatisticsFor(ids).stream() : ids.stream().map(EventStatisticView::empty);
            return stats.map(stat -> {
                Event event = (Event)mappedEvent.get(stat.getEventId());
                return new EventStatistic(event, stat, this.displayStatisticsForEvent((EventAndOrganizationId)event));
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean displayStatisticsForEvent(EventAndOrganizationId event) {
        return this.configurationManager.getFor(ConfigurationKeys.DISPLAY_STATS_IN_EVENT_DETAIL, event.getConfigurationLevel()).getValueAsBooleanOrDefault();
    }

    public List<EventStatistic> getAllEventsWithStatistics(String username) {
        return this.getAllEventsWithStatisticsFilteredBy(username, e -> true);
    }

    public EventWithAdditionalInfo getEventWithAdditionalInfo(String eventName, String username) {
        Event event = this.getEventAndCheckOwnership(eventName, username);
        Map description = this.eventDescriptionRepository.findByEventIdAsMap(event.getId());
        boolean owner = this.userManager.isOwner(this.userManager.findUserByUsername(username));
        EventStatisticView statistics = owner ? this.eventRepository.findStatisticsFor(event.getId()) : EventStatisticView.empty((int)event.getId());
        EventStatistic eventStatistic = new EventStatistic(event, statistics, this.displayStatisticsForEvent((EventAndOrganizationId)event));
        BigDecimal grossIncome = owner ? MonetaryUtil.centsToUnit((long)this.eventRepository.getGrossIncome(event.getId()), (String)event.getCurrency()) : BigDecimal.ZERO;
        List ticketCategories = this.ticketCategoryRepository.findAllTicketCategories(event.getId());
        List ticketCategoriesIds = ticketCategories.stream().map(TicketCategory::getId).collect(Collectors.toList());
        Map descriptions = this.ticketCategoryDescriptionRepository.descriptionsByTicketCategory(ticketCategoriesIds);
        Map ticketCategoriesStatistics = owner ? this.ticketCategoryRepository.findStatisticsForEventIdByCategoryId(event.getId()) : ticketCategoriesIds.stream().collect(Collectors.toMap(Function.identity(), id -> TicketCategoryStatisticView.empty((int)id, (int)event.getId())));
        Map specialPrices = ticketCategoriesIds.isEmpty() ? Collections.emptyMap() : this.specialPriceRepository.findAllByCategoriesIdsMapped(ticketCategoriesIds);
        Map metadata = this.ticketCategoryRepository.findCategoryMetadataForEventGroupByCategoryId(event.getId());
        List tWithInfo = ticketCategories.stream().map(t -> new TicketCategoryWithAdditionalInfo(event, t, (TicketCategoryStatisticView)ticketCategoriesStatistics.get(t.getId()), (Map)descriptions.get(t.getId()), (List)specialPrices.get(t.getId()), (AlfioMetadata)metadata.get(t.getId()))).collect(Collectors.toList());
        Set supportedCapabilities = this.extensionManager.getSupportedCapabilities(EnumSet.allOf(ExtensionCapability.class), (PurchaseContext)event);
        return new EventWithAdditionalInfo(event, tWithInfo, eventStatistic, description, grossIncome, this.eventRepository.getMetadataForEvent(event.getId()), this.subscriptionRepository.findLinkedSubscriptionIds(event.getId(), event.getOrganizationId()), supportedCapabilities);
    }

    private Event getEventAndCheckOwnership(String eventName, String username) {
        Event event = this.eventRepository.findByShortName(eventName);
        this.userManager.findOrganizationById(event.getOrganizationId(), username);
        return event;
    }

    private static String prepareSearchTerm(String search) {
        String toSearch = StringUtils.trimToNull((String)search);
        return toSearch == null ? null : "%" + toSearch + "%";
    }

    public List<TicketWithStatistic> loadModifiedTickets(int eventId, int categoryId, int page, String search) {
        Event event = this.eventRepository.findById(eventId);
        String toSearch = EventStatisticsManager.prepareSearchTerm((String)search);
        int pageSize = 30;
        return this.ticketSearchRepository.findAllModifiedTicketsWithReservationAndTransaction(eventId, categoryId, page * 30, 30, toSearch).stream().map(t -> new TicketWithStatistic(t.getTicket(), t.getTicketReservation(), event.getZoneId(), t.getTransaction(), (String)ObjectUtils.firstNonNull((Object[])new String[]{t.getPromoCode(), t.getSpecialPriceToken()}))).sorted().collect(Collectors.toList());
    }

    public Integer countModifiedTicket(int eventId, int categoryId, String search) {
        String toSearch = EventStatisticsManager.prepareSearchTerm((String)search);
        return this.ticketSearchRepository.countAllModifiedTicketsWithReservationAndTransaction(eventId, categoryId, toSearch);
    }

    public Predicate<EventAndOrganizationId> noSeatsAvailable() {
        return event -> {
            Map stats = this.ticketCategoryRepository.findStatisticsForEventIdByCategoryId(event.getId());
            EventStatisticView eventStatisticView = this.eventRepository.findStatisticsFor(event.getId());
            return this.ticketCategoryRepository.findAllTicketCategories(event.getId()).stream().filter(tc -> !tc.isAccessRestricted()).allMatch(tc -> EventUtil.determineAvailableSeats((TicketCategoryStatisticView)((TicketCategoryStatisticView)stats.get(tc.getId())), (EventStatisticView)eventStatisticView) == 0);
        };
    }

    public Optional<ZonedDateTime> getFirstReservationConfirmedTimestamp(int eventId) {
        return this.ticketReservationRepository.getFirstConfirmationTimestampForEvent(eventId);
    }

    public Optional<ZonedDateTime> getFirstReservationCreatedTimestamp(int eventId) {
        return this.ticketReservationRepository.getFirstReservationCreatedTimestampForEvent(eventId);
    }

    public List<TicketsByDateStatistic> getTicketSoldStatistics(int eventId, ZonedDateTime from, ZonedDateTime to, String granularity) {
        return this.ticketReservationRepository.getSoldStatistic(eventId, from, to, granularity);
    }

    public List<TicketsByDateStatistic> getTicketReservedStatistics(int eventId, ZonedDateTime from, ZonedDateTime to, String granularity) {
        return this.ticketReservationRepository.getReservedStatistic(eventId, from, to, granularity);
    }

    @ConstructorProperties(value={"eventRepository", "eventDescriptionRepository", "ticketSearchRepository", "ticketCategoryRepository", "ticketCategoryDescriptionRepository", "ticketReservationRepository", "specialPriceRepository", "configurationManager", "userManager", "subscriptionRepository", "extensionManager"})
    @Generated
    public EventStatisticsManager(EventRepository eventRepository, EventDescriptionRepository eventDescriptionRepository, TicketSearchRepository ticketSearchRepository, TicketCategoryRepository ticketCategoryRepository, TicketCategoryDescriptionRepository ticketCategoryDescriptionRepository, TicketReservationRepository ticketReservationRepository, SpecialPriceRepository specialPriceRepository, ConfigurationManager configurationManager, UserManager userManager, SubscriptionRepository subscriptionRepository, ExtensionManager extensionManager) {
        this.eventRepository = eventRepository;
        this.eventDescriptionRepository = eventDescriptionRepository;
        this.ticketSearchRepository = ticketSearchRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.ticketCategoryDescriptionRepository = ticketCategoryDescriptionRepository;
        this.ticketReservationRepository = ticketReservationRepository;
        this.specialPriceRepository = specialPriceRepository;
        this.configurationManager = configurationManager;
        this.userManager = userManager;
        this.subscriptionRepository = subscriptionRepository;
        this.extensionManager = extensionManager;
    }
}

