/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.user.UserManager;
import alfio.model.ReservationsByEvent;
import alfio.model.user.Organization;
import alfio.repository.ExportRepository;
import alfio.util.ClockProvider;
import java.security.Principal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ExportManager {
    private final ExportRepository exportRepository;
    private final ClockProvider clockProvider;
    private final UserManager userManager;

    public ExportManager(ExportRepository exportRepository, ClockProvider clockProvider, UserManager userManager) {
        this.exportRepository = exportRepository;
        this.clockProvider = clockProvider;
        this.userManager = userManager;
    }

    public List<ReservationsByEvent> reservationsForInterval(LocalDate from, LocalDate to, Principal principal) {
        if (from.isAfter(to)) {
            throw new IllegalArgumentException("Wrong interval");
        }
        List orgIds = this.userManager.findUserOrganizations(Objects.requireNonNull(principal).getName());
        if (orgIds.isEmpty()) {
            throw new IllegalArgumentException("Wrong user");
        }
        ZoneId zoneId = this.clockProvider.getClock().getZone();
        ZonedDateTime zonedFrom = from.atStartOfDay().atZone(zoneId);
        ZonedDateTime zonedTo = to.plusDays(1L).atStartOfDay().minusSeconds(1L).atZone(zoneId);
        return this.exportRepository.allReservationsForInterval(zonedFrom, zonedTo, orgIds.stream().map(Organization::getId).collect(Collectors.toList()));
    }
}

