/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.form.ContactAndTicketsForm;
import alfio.controller.form.UpdateTicketOwnerForm;
import alfio.extension.ExtensionService;
import alfio.extension.exception.AlfioScriptingException;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.extension.ExtensionCapability;
import alfio.manager.support.extension.ExtensionEvent;
import alfio.manager.support.extension.ValidationErrorNotifier;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.BillingDetails;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventCheckInInfo;
import alfio.model.ExtensionCapabilitySummary;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldValue;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationAdditionalInfo;
import alfio.model.TicketReservationInfo;
import alfio.model.TicketWithMetadataAttributes;
import alfio.model.TotalPrice;
import alfio.model.TransactionAndPaymentInfo;
import alfio.model.WaitingQueueSubscription;
import alfio.model.checkin.EventWithCheckInInfo;
import alfio.model.extension.AdditionalInfoFilterResult;
import alfio.model.extension.AdditionalInfoItem;
import alfio.model.extension.AttendeeResourcesContainer;
import alfio.model.extension.CreditNoteGeneration;
import alfio.model.extension.CustomEmailText;
import alfio.model.extension.CustomTaxPolicy;
import alfio.model.extension.DynamicDiscount;
import alfio.model.extension.InvoiceGeneration;
import alfio.model.extension.PdfGenerationResult;
import alfio.model.extension.QuantityByCategoryId;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.metadata.TicketMetadata;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.modification.AttendeeResources;
import alfio.model.modification.EventModification;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.model.user.PublicUserProfile;
import alfio.model.user.User;
import alfio.repository.EventRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;

@Component
public class ExtensionManager {
    private static final Logger log = LoggerFactory.getLogger(ExtensionManager.class);
    private static final String TICKET = "ticket";
    private static final String EVENT_METADATA = "eventMetadata";
    private static final String ORGANIZATION = "organization";
    private static final String RESERVATION = "reservation";
    private static final String BILLING_DETAILS = "billingDetails";
    private static final String ADDITIONAL_INFO = "additionalInfo";
    private static final String RESERVATIONS = "reservations";
    private static final String RESERVATION_IDS = "reservationIds";
    private static final String ORGANIZATION_ID = "organizationId";
    private static final String RESERVATION_ID = "reservationId";
    private static final String EVENT = "event";
    private static final String REQUEST = "request";
    private static final String METADATA = "metadata";
    public static final String TICKET_METADATA = "ticketMetadata";
    private final ExtensionService extensionService;
    private final EventRepository eventRepository;
    private final TicketReservationRepository ticketReservationRepository;
    private final TicketRepository ticketRepository;
    private final ConfigurationManager configurationManager;
    private final TransactionRepository transactionRepository;
    private final TicketCategoryRepository ticketCategoryRepository;

    boolean isSupported(ExtensionCapability extensionCapability, PurchaseContext purchaseContext) {
        return this.extensionService.isCapabilitySupported(extensionCapability, purchaseContext);
    }

    Set<ExtensionCapabilitySummary> getSupportedCapabilities(Set<ExtensionCapability> requested, PurchaseContext purchaseContext) {
        return this.extensionService.getSupportedCapabilities(requested, purchaseContext);
    }

    void handleEventValidation(EventModification request) {
        Map<String, EventModification> payload = Map.of(REQUEST, request);
        this.syncCall(ExtensionEvent.EVENT_VALIDATE_CREATION, null, payload, Boolean.class, false);
    }

    void handleEventSeatsUpdateValidation(Event event, int seatsNumber) {
        EventModification request = new EventModification(Integer.valueOf(event.getId()), null, null, null, null, null, null, null, null, null, event.getOrganizationId(), null, null, null, null, null, null, null, event.getRegularPrice(), event.getCurrency(), Integer.valueOf(seatsNumber), event.getVat(), event.isVatIncluded(), event.getAllowedPaymentProxies(), null, event.isFreeOfCharge(), null, event.getLocales(), null, null, null, null);
        Map<String, EventModification> payload = Map.of(REQUEST, request);
        this.syncCall(ExtensionEvent.EVENT_VALIDATE_SEATS_PRICES_UPDATE, (PurchaseContext)event, payload, Boolean.class, false);
    }

    void handleEventSeatsPricesUpdateValidation(Event event, EventModification request) {
        Map<String, EventModification> payload = Map.of(REQUEST, request);
        this.syncCall(ExtensionEvent.EVENT_VALIDATE_SEATS_PRICES_UPDATE, (PurchaseContext)event, payload, Boolean.class, false);
    }

    void handleEventCreation(Event event) {
        Map payload = Collections.emptyMap();
        this.syncCall(ExtensionEvent.EVENT_CREATED, (PurchaseContext)event, payload, Boolean.class);
        this.asyncCall(ExtensionEvent.EVENT_CREATED, (PurchaseContext)event, payload);
    }

    void handleEventStatusChange(Event event, Event.Status status) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("status", status.name());
        this.syncCall(ExtensionEvent.EVENT_STATUS_CHANGE, (PurchaseContext)event, payload, Boolean.class);
        this.asyncCall(ExtensionEvent.EVENT_STATUS_CHANGE, (PurchaseContext)event, payload);
    }

    AlfioMetadata handleMetadataUpdate(Event event, Organization organization, AlfioMetadata metadata) {
        Map payload = this.buildMetadataUpdatePayload(organization, metadata);
        return (AlfioMetadata)this.syncCall(ExtensionEvent.EVENT_METADATA_UPDATE, (PurchaseContext)event, payload, AlfioMetadata.class, false);
    }

    Optional<AlfioMetadata> handleGenerateMeetingLinkCapability(Event event, Organization organization, AlfioMetadata existingMetadata, Map<String, String> requestParams) {
        Map context = this.buildMetadataUpdatePayload(organization, existingMetadata);
        context.put(REQUEST, requestParams);
        return this.internalExecuteCapability(ExtensionCapability.GENERATE_MEETING_LINK, context, (PurchaseContext)event, AlfioMetadata.class);
    }

    Optional<String> handleGenerateLinkCapability(Event event, AlfioMetadata existingMetadata, Map<String, String> requestParams) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(METADATA, existingMetadata);
        context.put(REQUEST, requestParams);
        return this.internalExecuteCapability(ExtensionCapability.LINK_EXTERNAL_APPLICATION, context, (PurchaseContext)event, String.class);
    }

    private Map<String, Object> buildMetadataUpdatePayload(Organization organization, AlfioMetadata metadata) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(METADATA, metadata);
        payload.put(ORGANIZATION, organization);
        payload.put("baseUrl", this.configurationManager.getFor(ConfigurationKeys.BASE_URL, ConfigurationLevel.organization((int)organization.getId())).getRequiredValue());
        return payload;
    }

    void handleReservationConfirmation(TicketReservation reservation, BillingDetails billingDetails, PurchaseContext purchaseContext) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(RESERVATION, reservation);
        payload.put(BILLING_DETAILS, billingDetails);
        payload.put(ADDITIONAL_INFO, Map.of());
        this.transactionRepository.loadOptionalByReservationId(reservation.getId()).ifPresent(tr -> payload.put("transaction", tr));
        this.asyncCall(ExtensionEvent.RESERVATION_CONFIRMED, purchaseContext, payload);
    }

    public void handleTicketAssignment(Ticket ticket, TicketCategory category, Map<String, List<String>> additionalInfo) {
        if (!ticket.hasBeenSold()) {
            return;
        }
        int eventId = ticket.getEventId();
        Event event = this.eventRepository.findById(eventId);
        this.asyncCall(ExtensionEvent.TICKET_ASSIGNED, (PurchaseContext)event, Map.of(TICKET, ticket, ADDITIONAL_INFO, Objects.requireNonNullElse(additionalInfo, Map.of()), EVENT_METADATA, Objects.requireNonNullElseGet(this.eventRepository.getMetadataForEvent(event.getId()), AlfioMetadata::empty), "onlineAccessTicket", EventUtil.isAccessOnline((TicketCategory)category, (EventCheckInInfo)event)));
    }

    void handleWaitingQueueSubscription(WaitingQueueSubscription waitingQueueSubscription) {
        Event event = this.eventRepository.findById(waitingQueueSubscription.getEventId());
        this.asyncCall(ExtensionEvent.WAITING_QUEUE_SUBSCRIBED, (PurchaseContext)event, Map.of("waitingQueueSubscription", waitingQueueSubscription, ADDITIONAL_INFO, Map.of()));
    }

    void handleReservationsExpired(PurchaseContext purchaseContext, Collection<String> reservationIdsToRemove) {
        this.handleReservationRemoval(purchaseContext, reservationIdsToRemove, ExtensionEvent.RESERVATION_EXPIRED);
    }

    void handleReservationsCancelled(PurchaseContext purchaseContext, Collection<String> reservationIdsToRemove) {
        this.handleReservationRemoval(purchaseContext, reservationIdsToRemove, ExtensionEvent.RESERVATION_CANCELLED);
    }

    void handleTicketCancelledForEvent(Event event, Collection<String> ticketUUIDs) {
        HashMap<String, Collection<String>> payload = new HashMap<String, Collection<String>>();
        payload.put("ticketUUIDs", ticketUUIDs);
        payload.put(EVENT_METADATA, (Collection<String>)this.eventRepository.getMetadataForEvent(event.getId()));
        this.syncCall(ExtensionEvent.TICKET_CANCELLED, (PurchaseContext)event, payload, Boolean.class);
    }

    void handleOfflineReservationsWillExpire(Event event, List<TicketReservationInfo> reservations) {
        HashMap<String, List<TicketReservationInfo>> payload = new HashMap<String, List<TicketReservationInfo>>();
        payload.put(RESERVATIONS, reservations);
        this.asyncCall(ExtensionEvent.OFFLINE_RESERVATIONS_WILL_EXPIRE, (PurchaseContext)event, payload);
    }

    void handleStuckReservations(Event event, List<String> stuckReservationsId) {
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        payload.put(RESERVATION_IDS, stuckReservationsId);
        this.asyncCall(ExtensionEvent.STUCK_RESERVATIONS, (PurchaseContext)event, payload);
    }

    public Optional<CustomEmailText> handleReservationEmailCustomText(PurchaseContext purchaseContext, TicketReservation reservation, TicketReservationAdditionalInfo additionalInfo) {
        Map<String, TicketReservationAdditionalInfo> payload = Map.of(RESERVATION, reservation, "purchaseContext", purchaseContext, "billingData", additionalInfo);
        try {
            return Optional.ofNullable((CustomEmailText)this.syncCall(ExtensionEvent.CONFIRMATION_MAIL_CUSTOM_TEXT, purchaseContext, payload, CustomEmailText.class));
        }
        catch (Exception ex) {
            log.warn("Cannot get confirmation mail additional text", (Throwable)ex);
            return Optional.empty();
        }
    }

    public Optional<CustomEmailText> handleTicketEmailCustomText(Event event, TicketReservation reservation, TicketReservationAdditionalInfo additionalInfo, List<PurchaseContextFieldValue> fields) {
        Map<String, List<PurchaseContextFieldValue>> payload = Map.of(RESERVATION, reservation, EVENT, event, "billingData", additionalInfo, "additionalFields", fields);
        try {
            return Optional.ofNullable((CustomEmailText)this.syncCall(ExtensionEvent.TICKET_MAIL_CUSTOM_TEXT, (PurchaseContext)event, payload, CustomEmailText.class));
        }
        catch (Exception ex) {
            log.warn("Cannot get ticket mail additional text", (Throwable)ex);
            return Optional.empty();
        }
    }

    private void handleReservationRemoval(PurchaseContext purchaseContext, Collection<String> reservationIds, ExtensionEvent extensionEvent) {
        HashMap<String, Collection<String>> payload = new HashMap<String, Collection<String>>();
        payload.put(RESERVATION_IDS, reservationIds);
        payload.put(RESERVATIONS, this.ticketReservationRepository.findByIds(reservationIds));
        this.syncCall(extensionEvent, purchaseContext, payload, Boolean.class);
    }

    public void handleCreditNoteGenerated(TicketReservation reservation, PurchaseContext purchaseContext, TotalPrice cost, Long billingDocumentId, Map<String, Object> contextData) {
        HashMap<String, Object> payload = new HashMap<String, Object>(contextData);
        payload.put(RESERVATION_ID, reservation.getId());
        payload.put(RESERVATION, reservation);
        payload.put(BILLING_DETAILS, this.ticketReservationRepository.getBillingDetailsForReservation(reservation.getId()));
        payload.put("reservationCost", cost);
        payload.put("billingDocumentId", billingDocumentId);
        this.asyncCall(ExtensionEvent.CREDIT_NOTE_GENERATED, purchaseContext, payload);
    }

    public Optional<InvoiceGeneration> handleInvoiceGeneration(PaymentSpecification spec, TotalPrice reservationCost, BillingDetails billingDetails, Map<String, Object> contextData) {
        HashMap<String, Object> payload = new HashMap<String, Object>(contextData);
        payload.put(RESERVATION_ID, spec.getReservationId());
        payload.put("email", spec.getEmail());
        payload.put("customerName", spec.getCustomerName());
        payload.put("userLanguage", spec.getLocale().getLanguage());
        payload.put("billingAddress", spec.getBillingAddress());
        payload.put(BILLING_DETAILS, billingDetails);
        payload.put("customerReference", spec.getCustomerReference());
        payload.put("reservationCost", reservationCost);
        payload.put("invoiceRequested", spec.isInvoiceRequested());
        payload.put("vatCountryCode", billingDetails.getCountry());
        payload.put("vatNr", billingDetails.getTaxId());
        payload.put("vatStatus", spec.getVatStatus());
        return Optional.ofNullable((InvoiceGeneration)this.syncCall(ExtensionEvent.INVOICE_GENERATION, spec.getPurchaseContext(), payload, InvoiceGeneration.class, false));
    }

    public Optional<CreditNoteGeneration> handleCreditNoteGeneration(PurchaseContext purchaseContext, String reservationId, String invoiceNumber, Organization organization) {
        return Optional.ofNullable((CreditNoteGeneration)this.syncCall(ExtensionEvent.CREDIT_NOTE_GENERATION, purchaseContext, Map.of(RESERVATION_ID, reservationId, "invoiceNumber", invoiceNumber, ORGANIZATION, organization), CreditNoteGeneration.class));
    }

    public Optional<String> handleOnlineCheckInLink(String originalUrl, Ticket ticket, EventWithCheckInInfo event, Map<String, List<String>> additionalInfo) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(EVENT, event);
        payload.put("eventId", event.getId());
        payload.put(ORGANIZATION_ID, event.getOrganizationId());
        payload.put(TICKET, ticket);
        payload.put("originalURL", originalUrl);
        payload.put(ADDITIONAL_INFO, Objects.requireNonNullElse(additionalInfo, Map.of()));
        return Optional.ofNullable((String)this.extensionService.executeScriptsForEvent(ExtensionEvent.ONLINE_CHECK_IN_REDIRECT.name(), ExtensionService.toPath((EventAndOrganizationId)event), payload, String.class));
    }

    boolean handleTaxIdValidation(PurchaseContext purchaseContext, String taxIdNumber, String countryCode) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("taxIdNumber", taxIdNumber);
        payload.put("countryCode", countryCode);
        return Optional.ofNullable((Boolean)this.syncCall(ExtensionEvent.TAX_ID_NUMBER_VALIDATION, purchaseContext, payload, Boolean.class)).orElse(false);
    }

    void handleTicketCheckedIn(Ticket ticket) {
        HashMap<String, Ticket> payload = new HashMap<String, Ticket>();
        Event event = this.eventRepository.findById(ticket.getEventId());
        payload.put(TICKET, ticket);
        this.asyncCall(ExtensionEvent.TICKET_CHECKED_IN, (PurchaseContext)event, payload);
    }

    void handleTicketRevertCheckedIn(Ticket ticket) {
        HashMap<String, Ticket> payload = new HashMap<String, Ticket>();
        Event event = this.eventRepository.findById(ticket.getEventId());
        payload.put(TICKET, ticket);
        this.asyncCall(ExtensionEvent.TICKET_REVERT_CHECKED_IN, (PurchaseContext)event, payload);
    }

    public void handleReservationValidation(PurchaseContext purchaseContext, TicketReservation reservation, Object clientForm, BindingResult bindingResult) {
        Map<String, BindingResult> payload = Map.of(RESERVATION_ID, reservation.getId(), RESERVATION, reservation, "form", clientForm, "bindingResult", bindingResult);
        this.syncCall(ExtensionEvent.RESERVATION_VALIDATION, purchaseContext, payload, Void.class);
    }

    public void handleTicketUpdateValidation(PurchaseContext purchaseContext, UpdateTicketOwnerForm form, BindingResult bindingResult, String keyPrefix) {
        Map<String, ValidationErrorNotifier> payload = Map.of("form", form, "validationErrorNotifier", new ValidationErrorNotifier(bindingResult, keyPrefix));
        this.syncCall(ExtensionEvent.TICKET_UPDATE_VALIDATION, purchaseContext, payload, Void.class);
    }

    public void handleUserProfileValidation(Object clientForm, BindingResult bindingResult) {
        Map<String, BindingResult> payload = Map.of("form", clientForm, "bindingResult", bindingResult);
        this.syncCall(ExtensionEvent.PUBLIC_USER_PROFILE_VALIDATION, null, payload, Void.class);
    }

    void handleEventHeaderUpdate(Event event, Organization organization) {
        Map<String, Organization> payload = Map.of(EVENT_METADATA, this.eventRepository.getMetadataForEvent(event.getId()), ORGANIZATION, organization);
        this.asyncCall(ExtensionEvent.EVENT_HEADER_UPDATED, (PurchaseContext)event, payload);
    }

    void handleReservationsCreditNoteIssuedForEvent(Event event, List<String> reservationIds) {
        HashMap<String, List> payload = new HashMap<String, List>();
        payload.put(RESERVATION_IDS, reservationIds);
        payload.put(RESERVATIONS, this.ticketReservationRepository.findByIds(reservationIds));
        this.syncCall(ExtensionEvent.RESERVATION_CREDIT_NOTE_ISSUED, (PurchaseContext)event, payload, Boolean.class);
    }

    void handleRefund(PurchaseContext purchaseContext, TicketReservation reservation, TransactionAndPaymentInfo info) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put(RESERVATION, reservation);
        payload.put("transaction", info.getTransaction());
        payload.put("paymentInfo", info.getPaymentInformation());
        this.asyncCall(ExtensionEvent.REFUND_ISSUED, purchaseContext, payload);
    }

    public Optional<List<AdditionalInfoItem>> filterAdditionalInfoToSave(PurchaseContext purchaseContext, Map<String, List<String>> userAdditionalData, PublicUserProfile userProfile) {
        HashMap<String, Map<String, List<String>>> payload = new HashMap<String, Map<String, List<String>>>();
        payload.put("userAdditionalData", userAdditionalData);
        payload.put("userProfile", (Map<String, List<String>>)userProfile);
        AdditionalInfoFilterResult result = (AdditionalInfoFilterResult)this.syncCall(ExtensionEvent.USER_ADDITIONAL_INFO_FILTER, purchaseContext, payload, AdditionalInfoFilterResult.class);
        if (result != null) {
            return Optional.of(result.getItems());
        }
        return Optional.empty();
    }

    public boolean handlePdfTransformation(String html, PurchaseContext purchaseContext, OutputStream outputStream) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("html", html);
        try {
            PdfGenerationResult response = (PdfGenerationResult)this.syncCall(ExtensionEvent.PDF_GENERATION, purchaseContext, payload, PdfGenerationResult.class);
            if (response == null || response.isEmpty()) {
                return false;
            }
            Path tempFilePath = Paths.get(response.getTempFilePath(), new String[0]);
            if (Files.exists(tempFilePath, new LinkOption[0])) {
                Files.copy(tempFilePath, outputStream);
                Files.delete(tempFilePath);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Optional<String> generateOAuth2StateParam(int organizationId) {
        try {
            return Optional.ofNullable((String)this.extensionService.executeScriptsForEvent(ExtensionEvent.OAUTH2_STATE_GENERATION.name(), "-" + organizationId, Map.of("baseUrl", this.configurationManager.getFor(ConfigurationKeys.BASE_URL, ConfigurationLevel.organization((int)organizationId)).getRequiredValue(), ORGANIZATION_ID, organizationId), String.class));
        }
        catch (Exception ex) {
            log.error("got exception while generating OAuth2 State Param", (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public Optional<PromoCodeDiscount> handleDynamicDiscount(Event event, Map<Integer, Long> quantityByCategory, String reservationId) {
        try {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("quantityByCategory", quantityByCategory.entrySet().stream().map(entry -> new QuantityByCategoryId(((Integer)entry.getKey()).intValue(), ((Long)entry.getValue()).intValue())).collect(Collectors.toList()));
            values.put(RESERVATION_ID, reservationId);
            DynamicDiscount dynamicDiscountResult = (DynamicDiscount)this.syncCall(ExtensionEvent.DYNAMIC_DISCOUNT_APPLICATION, (PurchaseContext)event, values, DynamicDiscount.class);
            if (dynamicDiscountResult == null || dynamicDiscountResult.getDiscountType() == PromoCodeDiscount.DiscountType.NONE) {
                return Optional.empty();
            }
            ZonedDateTime now = ZonedDateTime.now(ClockProvider.clock());
            BigDecimal discountAmount = new BigDecimal(dynamicDiscountResult.getAmount());
            int discountAmountInCents = dynamicDiscountResult.getDiscountType() == PromoCodeDiscount.DiscountType.PERCENTAGE ? discountAmount.intValue() : MonetaryUtil.unitToCents((BigDecimal)discountAmount, (String)event.getCurrency());
            return Optional.of(new PromoCodeDiscount(Integer.MIN_VALUE, dynamicDiscountResult.getCode(), Integer.valueOf(event.getId()), Integer.valueOf(event.getOrganizationId()), now.minusSeconds(1L), event.getBegin().withZoneSameInstant(now.getZone()), discountAmountInCents, dynamicDiscountResult.getDiscountType(), null, null, null, null, PromoCodeDiscount.CodeType.DYNAMIC, null, event.getCurrency()));
        }
        catch (Exception ex) {
            log.warn("got exception while firing DYNAMIC_DISCOUNT_APPLICATION event", (Throwable)ex);
            return Optional.empty();
        }
    }

    private void asyncCall(ExtensionEvent extensionEvent, PurchaseContext event, Map<String, Object> payload) {
        this.extensionService.executeScriptAsync(extensionEvent.name(), ExtensionService.toPath((PurchaseContext)event), this.fillWithBasicInfo(payload, event));
    }

    private <T> T syncCall(ExtensionEvent extensionEvent, PurchaseContext purchaseContext, Map<String, Object> payload, Class<T> clazz) {
        return (T)this.syncCall(extensionEvent, purchaseContext, payload, clazz, true);
    }

    private <T> T syncCall(ExtensionEvent extensionEvent, PurchaseContext purchaseContext, Map<String, Object> payload, Class<T> clazz, boolean ignoreErrors) {
        try {
            return (T)this.extensionService.executeScriptsForEvent(extensionEvent.name(), ExtensionService.toPath((PurchaseContext)purchaseContext), this.fillWithBasicInfo(payload, purchaseContext), clazz);
        }
        catch (AlfioScriptingException ex) {
            log.warn("Unexpected exception while executing script:", (Throwable)ex);
            if (!ignoreErrors) {
                throw new IllegalStateException(ex);
            }
            return null;
        }
    }

    private Map<String, Object> fillWithBasicInfo(Map<String, ?> payload, PurchaseContext purchaseContext) {
        HashMap<String, Object> payloadCopy = new HashMap<String, Object>(payload);
        if (purchaseContext != null) {
            purchaseContext.event().ifPresent(event -> {
                payloadCopy.put(EVENT, event);
                payloadCopy.put("eventId", event.getId());
            });
            payloadCopy.put("purchaseContext", purchaseContext);
            payloadCopy.put(ORGANIZATION_ID, purchaseContext.getOrganizationId());
        }
        return payloadCopy;
    }

    public <T> Optional<T> executeCapability(ExtensionCapability capability, Map<String, String> params, PurchaseContext purchaseContext, Class<T> resultType) {
        HashMap<String, Map<String, String>> contextParams = new HashMap<String, Map<String, String>>();
        contextParams.put(REQUEST, params);
        return this.internalExecuteCapability(capability, contextParams, purchaseContext, resultType);
    }

    private <T> Optional<T> internalExecuteCapability(ExtensionCapability capability, Map<String, Object> contextParams, PurchaseContext purchaseContext, Class<T> resultType) {
        return this.extensionService.executeCapability(capability, ExtensionService.toPath((PurchaseContext)purchaseContext), this.fillWithBasicInfo(contextParams, purchaseContext), resultType);
    }

    public void handlePublicUserSignUp(User user) {
        this.asyncCall(ExtensionEvent.PUBLIC_USER_SIGN_UP, null, Map.of("user", user));
    }

    public void handlePublicUserDelete(OAuth2AuthenticationToken authentication, User user) {
        this.syncCall(ExtensionEvent.PUBLIC_USER_DELETE, null, Map.of("user", user, "subject", authentication.getPrincipal()), Void.class);
    }

    public Optional<TicketMetadata> handleCustomOnlineJoinUrl(Event event, Ticket ticket, Map<String, List<String>> ticketAdditionalInfo) {
        TicketMetadataContainer ticketMetadataContainer = Objects.requireNonNullElseGet(this.ticketRepository.getTicketMetadata(ticket.getId()), TicketMetadataContainer::empty);
        HashMap<String, Object> context = new HashMap<String, Object>();
        String key = ExtensionEvent.CUSTOM_ONLINE_JOIN_URL.name();
        context.put(TICKET, ticket);
        context.put(ADDITIONAL_INFO, ticketAdditionalInfo);
        Optional existingMetadata = ticketMetadataContainer.getMetadataForKey(key);
        existingMetadata.ifPresent(m -> context.put(TICKET_METADATA, m));
        Optional<TicketMetadata> result = Optional.ofNullable((TicketMetadata)this.syncCall(ExtensionEvent.CUSTOM_ONLINE_JOIN_URL, (PurchaseContext)event, context, TicketMetadata.class, false));
        result.ifPresent(m -> {
            boolean changed;
            boolean bl = changed = existingMetadata.isEmpty() || !((TicketMetadata)existingMetadata.get()).equals(m);
            if (changed && ticketMetadataContainer.putMetadata(key, m)) {
                this.ticketRepository.updateTicketMetadata(ticket.getId(), ticketMetadataContainer);
            }
        });
        return result.or(() -> existingMetadata);
    }

    public Optional<TicketMetadata> handleTicketAssignmentMetadata(TicketWithMetadataAttributes ticketWithMetadata, Event event, Map<String, List<String>> additionalInfo) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(TICKET, ticketWithMetadata.getTicket());
        context.put(TICKET_METADATA, ticketWithMetadata.getMetadata().getMetadataForKey("general").orElseGet(TicketMetadata::empty));
        context.put(ADDITIONAL_INFO, Objects.requireNonNullElse(additionalInfo, Map.of()));
        context.put("attendeeResources", new AttendeeResourcesContainer(AttendeeResources.fromTicket((Ticket)ticketWithMetadata.getTicket(), (PurchaseContext)event, (Map)this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.ENABLE_WALLET, ConfigurationKeys.ENABLE_PASS, ConfigurationKeys.BASE_URL), event.getConfigurationLevel()), (boolean)true)));
        return Optional.ofNullable((TicketMetadata)this.syncCall(ExtensionEvent.TICKET_ASSIGNED_GENERATE_METADATA, (PurchaseContext)event, context, TicketMetadata.class, false));
    }

    public Optional<SubscriptionMetadata> handleSubscriptionAssignmentMetadata(Subscription subscription, SubscriptionDescriptor descriptor, SubscriptionMetadata subscriptionMetadata, Map<String, List<String>> additionalInfo) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("subscription", subscription);
        context.put(METADATA, Objects.requireNonNullElseGet(subscriptionMetadata, SubscriptionMetadata::empty));
        context.put("subscriptionDescriptor", descriptor);
        context.put(ADDITIONAL_INFO, additionalInfo);
        return Optional.ofNullable((SubscriptionMetadata)this.syncCall(ExtensionEvent.SUBSCRIPTION_ASSIGNED_GENERATE_METADATA, (PurchaseContext)descriptor, context, SubscriptionMetadata.class, false));
    }

    public Optional<CustomTaxPolicy> handleCustomTaxPolicy(PurchaseContext purchaseContext, String reservationId, ContactAndTicketsForm form, TotalPrice reservationCost) {
        if (!purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) || !reservationCost.requiresPayment()) {
            return Optional.empty();
        }
        Event event = (Event)purchaseContext;
        Map categoriesById = this.ticketCategoryRepository.findCategoriesInReservation(reservationId).stream().collect(Collectors.toMap(TicketCategory::getId, Function.identity()));
        Map ticketInfoById = this.ticketRepository.findBasicTicketInfoForReservation(event.getId(), reservationId).stream().collect(Collectors.toMap(ti -> ti.getTicketPublicUUID().toString(), Function.identity()));
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(EVENT, event);
        context.put(RESERVATION_ID, reservationId);
        context.put("reservationForm", form);
        context.put("categoriesById", categoriesById);
        context.put("ticketInfoByUuid", ticketInfoById);
        return Optional.ofNullable((CustomTaxPolicy)this.syncCall(ExtensionEvent.CUSTOM_TAX_POLICY_APPLICATION, (PurchaseContext)event, context, CustomTaxPolicy.class, false));
    }

    @ConstructorProperties(value={"extensionService", "eventRepository", "ticketReservationRepository", "ticketRepository", "configurationManager", "transactionRepository", "ticketCategoryRepository"})
    @Generated
    public ExtensionManager(ExtensionService extensionService, EventRepository eventRepository, TicketReservationRepository ticketReservationRepository, TicketRepository ticketRepository, ConfigurationManager configurationManager, TransactionRepository transactionRepository, TicketCategoryRepository ticketCategoryRepository) {
        this.extensionService = extensionService;
        this.eventRepository = eventRepository;
        this.ticketReservationRepository = ticketReservationRepository;
        this.ticketRepository = ticketRepository;
        this.configurationManager = configurationManager;
        this.transactionRepository = transactionRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
    }
}

