/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class FileBlobCacheManager {
    private static final Logger log = LoggerFactory.getLogger(FileBlobCacheManager.class);
    private final String cacheDir;

    public FileBlobCacheManager(Environment environment) {
        this.cacheDir = environment.getProperty("alfio.cache-dir", System.getProperty("java.io.tmpdir"));
    }

    private Path getBlobDir(String section) {
        return Paths.get(this.cacheDir, "alfio-blob").resolve(section);
    }

    private void checkPath(Path resourcePath, String section) {
        Path parentPath = this.getBlobDir(section).normalize();
        Path childPath = resourcePath.normalize();
        Assert.isTrue((boolean)childPath.startsWith(parentPath), () -> "Resource path " + childPath + "must be inside the blob path " + parentPath);
    }

    public boolean fileExists(String section, String id) {
        Path resourcePath = this.getBlobDir(section).resolve(id);
        this.checkPath(resourcePath, section);
        return Files.exists(resourcePath, new LinkOption[0]);
    }

    public File getFile(String section, String id, Supplier<File> supplier) {
        Path resourcePath = this.getBlobDir(section).resolve(id);
        this.checkPath(resourcePath, section);
        if (Files.exists(resourcePath, new LinkOption[0])) {
            return resourcePath.toFile();
        }
        log.debug("Cache not hit for file {}", (Object)id);
        File tmpFile = supplier.get();
        Path dir = this.getBlobDir(section);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.move(tmpFile.toPath(), resourcePath, StandardCopyOption.ATOMIC_MOVE);
            return resourcePath.toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Was not able to cache file for section " + section + " id " + id);
        }
    }

    public void ensureFileExists(String section, String id, Supplier<byte[]> supplier) {
        Path resourcePath = this.getBlobDir(section).resolve(id);
        this.checkPath(resourcePath, section);
        if (Files.exists(resourcePath, new LinkOption[0])) {
            return;
        }
        try {
            Path dir = this.getBlobDir(section);
            Files.createDirectories(dir, new FileAttribute[0]);
            Path tmpFile = Files.createTempFile(dir, "tmp", "fileblob", new FileAttribute[0]);
            Files.write(tmpFile, supplier.get(), new OpenOption[0]);
            Files.move(tmpFile, dir.resolve(id), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            log.warn("was not able to ensure file presence with section {} and id {}", new Object[]{section, id, e});
        }
    }
}

