/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.FileDownloadManager;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadManager {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadManager.class);
    private final HttpClient httpClient;

    public FileDownloadManager(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public DownloadedFile downloadFile(String url) {
        HttpResponse<byte[]> response;
        HttpRequest httpRequest = HttpRequest.newBuilder(URI.create(Objects.requireNonNull(StringUtils.trimToNull((String)url)))).GET().build();
        try {
            response = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
        }
        catch (IOException exception) {
            this.logWarning((Throwable)exception);
            return null;
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            this.logWarning((Throwable)exception);
            return null;
        }
        if (this.callSuccessful(response)) {
            String[] parts = Pattern.compile("/").split(url);
            String name = parts[parts.length - 1];
            if (Objects.nonNull(response.body())) {
                return new DownloadedFile(response.body(), name, response.headers().firstValue("Content-Type").orElse("application/octet-stream"));
            }
            return null;
        }
        log.warn("downloading file not successful:" + response);
        return null;
    }

    private void logWarning(Throwable exception) {
        log.warn("error while downloading file", exception);
    }

    private boolean callSuccessful(HttpResponse<?> response) {
        return response.statusCode() >= 200 && response.statusCode() < 300;
    }
}

