/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.FileBlobCacheManager;
import alfio.model.FileBlobMetadata;
import alfio.model.modification.UploadBase64FileModification;
import alfio.repository.FileUploadRepository;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

@Component
public class FileUploadManager {
    static final int IMAGE_THUMB_MAX_WIDTH_PX = 300;
    static final int IMAGE_THUMB_MAX_HEIGHT_PX = 200;
    private static final Logger log = LoggerFactory.getLogger(FileUploadManager.class);
    private static final String FILE_SECTION = "file-upload-manager";
    private static final int MAXIMUM_ALLOWED_SIZE = 204800;
    private static final MimeType IMAGE_TYPE = MimeType.valueOf((String)"image/*");
    private final FileUploadRepository repository;
    private final FileBlobCacheManager fileBlobCacheManager;
    private static final Pattern IS_HEX = Pattern.compile("^\\p{XDigit}+$");

    public FileUploadManager(FileUploadRepository repository, FileBlobCacheManager fileBlobCacheManager) {
        this.repository = repository;
        this.fileBlobCacheManager = fileBlobCacheManager;
    }

    @Transactional(readOnly=true)
    public Optional<FileBlobMetadata> findMetadata(String id) {
        return this.repository.findById(id);
    }

    public boolean hasCached(String digest) {
        Assert.isTrue((boolean)IS_HEX.matcher(digest).matches(), (String)"id must be an hex value");
        return this.fileBlobCacheManager.fileExists(FILE_SECTION, digest);
    }

    public void outputFile(String id, OutputStream out) {
        Assert.isTrue((boolean)IS_HEX.matcher(id).matches(), (String)"id must be an hex value");
        try (InputStream fis = this.ensureFilePresence(id);){
            fis.transferTo(out);
        }
        catch (EOFException ex) {
            log.trace("got EOFException", (Throwable)ex);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while copying data", e);
        }
    }

    public File getFile(String id) {
        return this.fileBlobCacheManager.getFile(FILE_SECTION, id, () -> this.repository.file(id));
    }

    public File getFile(String section, String id, Supplier<File> supplier) {
        return this.fileBlobCacheManager.getFile(section, id, supplier);
    }

    private InputStream ensureFilePresence(String id) throws IOException {
        return new FileInputStream(this.fileBlobCacheManager.getFile(FILE_SECTION, id, () -> this.repository.file(id)));
    }

    private void ensureFilePresence(String id, byte[] content) {
        this.fileBlobCacheManager.ensureFileExists(FILE_SECTION, id, () -> content);
    }

    @Transactional
    public String insertFile(UploadBase64FileModification file) {
        MimeType mimeType = MimeTypeUtils.parseMimeType((String)file.getType());
        UploadBase64FileModification upload = this.resizeIfNeeded(file, mimeType);
        Validate.exclusiveBetween((long)1L, (long)204800L, (long)upload.getFile().length);
        String digest = DigestUtils.sha256Hex((byte[])upload.getFile());
        if (!this.repository.isPresent(digest)) {
            this.repository.upload(upload, digest, this.getAttributes(upload));
        }
        this.ensureFilePresence(digest, upload.getFile());
        return digest;
    }

    @Transactional
    public void cleanupUnreferencedBlobFiles(Date date) {
        int deleted = this.repository.cleanupUnreferencedBlobFiles(date);
        log.debug("removed {} unused file_blob", (Object)deleted);
    }

    private UploadBase64FileModification resizeIfNeeded(UploadBase64FileModification upload, MimeType mimeType) {
        if (!mimeType.isCompatibleWith(IMAGE_TYPE)) {
            return upload;
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(upload.getFile()));
            if (image.getWidth() > 300 || image.getHeight() > 200) {
                UploadBase64FileModification resized = new UploadBase64FileModification();
                BufferedImage thumbImg = Scalr.resize((BufferedImage)image, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)300, (int)200, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    ImageIO.write((RenderedImage)thumbImg, mimeType.getSubtype(), baos);
                    resized.setFile(baos.toByteArray());
                }
                resized.setAttributes(upload.getAttributes());
                resized.setName(upload.getName());
                resized.setType(upload.getType());
                return resized;
            }
            return upload;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Map<String, String> getAttributes(UploadBase64FileModification file) {
        if (!StringUtils.startsWith((CharSequence)file.getType(), (CharSequence)"image/")) {
            return Collections.emptyMap();
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(file.getFile()));
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("width", String.valueOf(image.getWidth()));
            attributes.put("height", String.valueOf(image.getHeight()));
            return attributes;
        }
        catch (IOException e) {
            log.error("error while processing image: ", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

