/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.GroupManager;
import alfio.model.Audit;
import alfio.model.Ticket;
import alfio.model.group.Group;
import alfio.model.group.GroupMember;
import alfio.model.group.LinkedGroup;
import alfio.model.modification.GroupMemberModification;
import alfio.model.modification.GroupModification;
import alfio.model.modification.LinkedGroupModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.repository.AuditingRepository;
import alfio.repository.GroupRepository;
import alfio.repository.TicketRepository;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class GroupManager {
    private static final Logger log = LoggerFactory.getLogger(GroupManager.class);
    private final GroupRepository groupRepository;
    private final TicketRepository ticketRepository;
    private final AuditingRepository auditingRepository;
    private final TransactionTemplate requiresNewTransactionTemplate;

    public GroupManager(GroupRepository groupRepository, TicketRepository ticketRepository, AuditingRepository auditingRepository, PlatformTransactionManager transactionManager) {
        this.groupRepository = groupRepository;
        this.ticketRepository = ticketRepository;
        this.auditingRepository = auditingRepository;
        this.requiresNewTransactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(3));
    }

    public Result<Integer> createNew(GroupModification input) {
        return (Result)this.requiresNewTransactionTemplate.execute(status -> {
            Group wl = this.createNew(input.getName(), input.getDescription(), input.getOrganizationId());
            Result insertMembers = this.insertMembers(wl.getId(), input.getItems());
            if (!insertMembers.isSuccess()) {
                status.setRollbackOnly();
            }
            return insertMembers;
        });
    }

    Group createNew(String name, String description, int organizationId) {
        AffectedRowCountAndKey insert = this.groupRepository.insert(StringEscapeUtils.escapeHtml4((String)name), StringEscapeUtils.escapeHtml4((String)description), organizationId);
        return this.groupRepository.getById(((Integer)insert.getKey()).intValue());
    }

    @Transactional
    public LinkedGroup createLink(int groupId, int eventId, LinkedGroupModification modification) {
        Objects.requireNonNull(this.groupRepository.getById(groupId), "Group not found");
        Validate.isTrue((modification.getType() != LinkedGroup.Type.LIMITED_QUANTITY || modification.getMaxAllocation() != null ? 1 : 0) != 0, (String)"Missing max allocation", (Object[])new Object[0]);
        AffectedRowCountAndKey configuration = this.groupRepository.createConfiguration(groupId, eventId, modification.getTicketCategoryId(), modification.getType(), modification.getMatchType(), modification.getMaxAllocation());
        return this.groupRepository.getConfiguration(((Integer)configuration.getKey()).intValue());
    }

    @Transactional
    public LinkedGroup updateLink(int id, LinkedGroupModification modification) {
        LinkedGroup original = this.groupRepository.getConfigurationForUpdate(id);
        if (this.requiresCleanState(modification, original)) {
            Validate.isTrue((this.groupRepository.countWhitelistedTicketsForConfiguration(original.getId()) == 0 ? 1 : 0) != 0, (String)"Cannot update as there are already confirmed tickets.", (Object[])new Object[0]);
        }
        Validate.isTrue((this.groupRepository.updateConfiguration(id, modification.getGroupId(), original.getEventId().intValue(), modification.getTicketCategoryId(), modification.getType(), modification.getMatchType(), modification.getMaxAllocation()) == 1 ? 1 : 0) != 0);
        return this.groupRepository.getConfiguration(id);
    }

    private boolean requiresCleanState(LinkedGroupModification modification, LinkedGroup original) {
        return original.getType() == LinkedGroup.Type.UNLIMITED && modification.getType() != LinkedGroup.Type.UNLIMITED || original.getGroupId() != modification.getGroupId() || modification.getType() == LinkedGroup.Type.LIMITED_QUANTITY && modification.getMaxAllocation() != null && original.getMaxAllocation() != null && modification.getMaxAllocation().compareTo(original.getMaxAllocation()) < 0;
    }

    boolean isGroupLinked(int eventId, int categoryId) {
        return CollectionUtils.isNotEmpty((Collection)this.findLinks(eventId, categoryId));
    }

    @Transactional(readOnly=true)
    public List<Group> getAllActiveForOrganization(int organizationId) {
        return this.groupRepository.getAllActiveForOrganization(organizationId);
    }

    @Transactional(readOnly=true)
    public List<Group> getAllForOrganization(int organizationId) {
        return this.groupRepository.getAllForOrganization(organizationId);
    }

    @Transactional
    public Optional<GroupModification> loadComplete(int id) {
        return this.groupRepository.getOptionalById(id).map(wl -> {
            List items = this.groupRepository.getItems(wl.getId()).stream().map(i -> new GroupMemberModification(Integer.valueOf(i.getId()), i.getValue(), i.getDescription())).collect(Collectors.toList());
            return new GroupModification(Integer.valueOf(wl.getId()), wl.getName(), wl.getDescription(), wl.getOrganizationId().intValue(), items);
        });
    }

    @Transactional
    public Optional<Group> findById(int groupId, int organizationId) {
        return this.groupRepository.getOptionalById(groupId).filter(w -> w.getOrganizationId() == organizationId);
    }

    @Transactional
    public boolean isAllowed(String value, int eventId, int categoryId) {
        List configurations = this.findLinks(eventId, categoryId);
        if (CollectionUtils.isEmpty((Collection)configurations)) {
            return true;
        }
        LinkedGroup configuration = (LinkedGroup)configurations.get(0);
        return this.getMatchingMember(configuration, value).isPresent();
    }

    @Transactional
    public List<LinkedGroup> getLinksForEvent(int eventId) {
        return this.groupRepository.findActiveConfigurationsForEvent(eventId);
    }

    @Transactional
    public List<LinkedGroup> findLinks(int eventId, int categoryId) {
        return this.groupRepository.findActiveConfigurationsFor(eventId, categoryId);
    }

    Result<Integer> insertMembers(int groupId, List<GroupMemberModification> members) {
        Map<String, List<GroupMemberModification>> grouped = members.stream().collect(Collectors.groupingBy(GroupMemberModification::getValue));
        List duplicates = grouped.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        return new Result.Builder().checkPrecondition(duplicates::isEmpty, ErrorCode.lazy(() -> ErrorCode.custom((String)"value.duplicate", (String)duplicates.stream().limit(10L).collect(Collectors.joining(", "))))).build(() -> Arrays.stream(this.groupRepository.insert(groupId, members)).sum());
    }

    @Transactional
    public boolean acquireMemberForTicket(Ticket ticket) {
        boolean limitAssignments;
        List configurations = this.findLinks(ticket.getEventId(), ticket.getCategoryId().intValue());
        if (CollectionUtils.isEmpty((Collection)configurations)) {
            return true;
        }
        LinkedGroup configuration = (LinkedGroup)configurations.get(0);
        Optional optionalItem = this.getMatchingMember(configuration, ticket.getEmail());
        if (optionalItem.isEmpty()) {
            return false;
        }
        GroupMember item = (GroupMember)optionalItem.get();
        boolean preventDuplication = configuration.getType() == LinkedGroup.Type.ONCE_PER_VALUE;
        boolean bl = limitAssignments = preventDuplication || configuration.getType() == LinkedGroup.Type.LIMITED_QUANTITY;
        if (limitAssignments) {
            int expected;
            configuration = this.groupRepository.getConfigurationForUpdate(configuration.getId());
            int existing = this.groupRepository.countExistingWhitelistedTickets(item.getId(), configuration.getId());
            int n = expected = preventDuplication ? 1 : Optional.ofNullable(configuration.getMaxAllocation()).orElse(0);
            if (existing >= expected) {
                return false;
            }
        }
        this.groupRepository.insertWhitelistedTicket(item.getId(), configuration.getId(), ticket.getId(), preventDuplication ? Boolean.TRUE : null);
        HashMap<String, Integer> modifications = new HashMap<String, Integer>();
        modifications.put("itemId", item.getId());
        modifications.put("configurationId", configuration.getId());
        modifications.put("ticketId", ticket.getId());
        this.auditingRepository.insert(ticket.getTicketsReservationId(), null, Integer.valueOf(ticket.getEventId()), Audit.EventType.GROUP_MEMBER_ACQUIRED, new Date(), Audit.EntityType.TICKET, String.valueOf(ticket.getId()), Collections.singletonList(modifications));
        return true;
    }

    private Optional<GroupMember> getMatchingMember(LinkedGroup configuration, String email) {
        String trimmed = StringUtils.trimToEmpty((String)email);
        Optional exactMatch = this.groupRepository.findItemByValueExactMatch(configuration.getGroupId(), trimmed);
        if (exactMatch.isPresent() || configuration.getMatchType() == LinkedGroup.MatchType.FULL) {
            return exactMatch;
        }
        String partial = StringUtils.substringAfterLast((String)trimmed, (String)"@");
        return partial.length() > 0 ? this.groupRepository.findItemEndsWith(configuration.getId(), configuration.getGroupId(), "%@" + partial) : Optional.empty();
    }

    @Transactional
    public void deleteWhitelistedTicketsForReservation(String reservationId) {
        List tickets = this.ticketRepository.findTicketsInReservation(reservationId).stream().map(Ticket::getId).collect(Collectors.toList());
        if (!tickets.isEmpty()) {
            int result = this.groupRepository.deleteExistingWhitelistedTickets(tickets);
            log.trace("deleted {} whitelisted tickets for reservation {}", (Object)result, (Object)reservationId);
        }
    }

    @Transactional
    public void disableLink(int linkId) {
        Validate.isTrue((this.groupRepository.disableLink(linkId) == 1 ? 1 : 0) != 0, (String)"Error while disabling link", (Object[])new Object[0]);
    }

    @Transactional
    public Optional<GroupModification> update(int listId, GroupModification modification) {
        Result insertResult;
        if (this.groupRepository.getOptionalById(listId).isEmpty() || CollectionUtils.isEmpty((Collection)modification.getItems())) {
            return Optional.empty();
        }
        List existingValues = this.groupRepository.getAllValuesIncludingNotActive(listId);
        List notPresent = modification.getItems().stream().filter(i -> i.getId() == null && !existingValues.contains(i.getValue().strip().toLowerCase())).distinct().collect(Collectors.toList());
        if (!notPresent.isEmpty() && !(insertResult = this.insertMembers(listId, notPresent)).isSuccess()) {
            ErrorCode error = Objects.requireNonNull(insertResult.getFirstErrorOrNull());
            throw new DuplicateGroupItemException(error.getDescription());
        }
        this.groupRepository.update(listId, StringEscapeUtils.escapeHtml4((String)modification.getName()), StringEscapeUtils.escapeHtml4((String)modification.getDescription()));
        return this.loadComplete(listId);
    }

    @Transactional
    public boolean deactivateMembers(List<Integer> memberIds, int groupId) {
        if (memberIds.isEmpty()) {
            return false;
        }
        this.groupRepository.deactivateGroupMember(memberIds, groupId);
        return true;
    }

    @Transactional
    public boolean deactivateGroup(int groupId) {
        List members = this.groupRepository.getItems(groupId).stream().map(GroupMember::getId).collect(Collectors.toList());
        if (!members.isEmpty()) {
            Validate.isTrue((boolean)this.deactivateMembers(members, groupId), (String)"error while disabling group members", (Object[])new Object[0]);
        }
        this.groupRepository.disableAllLinks(groupId);
        Validate.isTrue((this.groupRepository.deactivateGroup(groupId) == 1 ? 1 : 0) != 0, (String)"unexpected error while disabling group", (Object[])new Object[0]);
        return true;
    }
}

