/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.support.TemplateProcessor;
import alfio.manager.ExtensionManager;
import alfio.manager.FileUploadManager;
import alfio.manager.NotificationManager;
import alfio.manager.PassKitManager;
import alfio.manager.PurchaseContextFieldManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.support.AdditionalServiceHelper;
import alfio.manager.support.CustomMessageManager;
import alfio.manager.support.PartialTicketTextGenerator;
import alfio.manager.support.TemplateGenerator;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.Mailer;
import alfio.model.Configurable;
import alfio.model.EmailMessage;
import alfio.model.Event;
import alfio.model.EventCheckInInfo;
import alfio.model.EventDescription;
import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.LightweightMailMessage;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketWithMetadataAttributes;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.metadata.TicketMetadata;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.EmailMessageRepository;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.EventRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.Json;
import alfio.util.LocaleUtil;
import alfio.util.MiscUtils;
import alfio.util.MustacheCustomTag;
import alfio.util.RenderedTemplate;
import alfio.util.TemplateManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class NotificationManager {
    public static final String SEND_TICKET_CC = "sendTicketCc";
    private static final String EVENT_ID = "eventId";
    private static final Logger log = LoggerFactory.getLogger(NotificationManager.class);
    private final Mailer mailer;
    private final MessageSourceManager messageSourceManager;
    private final EmailMessageRepository emailMessageRepository;
    private final TransactionTemplate tx;
    private final OrganizationRepository organizationRepository;
    private final ConfigurationManager configurationManager;
    private final Gson gson;
    private final ClockProvider clockProvider;
    private final PurchaseContextManager purchaseContextManager;
    private final TicketRepository ticketRepository;
    private final EnumMap<Mailer.AttachmentIdentifier, Function<Map<String, String>, byte[]>> attachmentTransformer;

    public NotificationManager(Mailer mailer, MessageSourceManager messageSourceManager, PlatformTransactionManager transactionManager, EmailMessageRepository emailMessageRepository, EventRepository eventRepository, EventDescriptionRepository eventDescriptionRepository, OrganizationRepository organizationRepository, ConfigurationManager configurationManager, FileUploadManager fileUploadManager, TemplateManager templateManager, TicketReservationRepository ticketReservationRepository, TicketCategoryRepository ticketCategoryRepository, PassKitManager passKitManager, TicketRepository ticketRepository, PurchaseContextFieldRepository purchaseContextFieldRepository, AdditionalServiceItemRepository additionalServiceItemRepository, ExtensionManager extensionManager, ClockProvider clockProvider, PurchaseContextManager purchaseContextManager, SubscriptionRepository subscriptionRepository, AdditionalServiceHelper additionalServiceHelper, PurchaseContextFieldManager purchaseContextFieldManager) {
        this.messageSourceManager = messageSourceManager;
        this.mailer = mailer;
        this.emailMessageRepository = emailMessageRepository;
        this.organizationRepository = organizationRepository;
        this.ticketRepository = ticketRepository;
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(6);
        this.tx = new TransactionTemplate(transactionManager, (TransactionDefinition)definition);
        this.configurationManager = configurationManager;
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Mailer.Attachment.class, (Object)new AttachmentConverter());
        this.gson = builder.create();
        this.clockProvider = clockProvider;
        this.purchaseContextManager = purchaseContextManager;
        this.attachmentTransformer = new EnumMap(Mailer.AttachmentIdentifier.class);
        this.attachmentTransformer.put(Mailer.AttachmentIdentifier.CALENDAR_ICS, NotificationManager.generateICS((EventRepository)eventRepository, (EventDescriptionRepository)eventDescriptionRepository, (TicketCategoryRepository)ticketCategoryRepository, (OrganizationRepository)organizationRepository, (MessageSourceManager)messageSourceManager, (ConfigurationManager)configurationManager));
        this.attachmentTransformer.put(Mailer.AttachmentIdentifier.RECEIPT_PDF, NotificationManager.receiptOrInvoiceFactory((PurchaseContextManager)purchaseContextManager, (EventRepository)eventRepository, (T payload) -> TemplateProcessor.buildReceiptPdf((PurchaseContext)((PurchaseContext)payload.getLeft()), (FileUploadManager)fileUploadManager, (Locale)((Locale)payload.getMiddle()), (TemplateManager)templateManager, (Map)((Map)payload.getRight()), (ExtensionManager)extensionManager)));
        this.attachmentTransformer.put(Mailer.AttachmentIdentifier.INVOICE_PDF, NotificationManager.receiptOrInvoiceFactory((PurchaseContextManager)purchaseContextManager, (EventRepository)eventRepository, (T payload) -> TemplateProcessor.buildInvoicePdf((PurchaseContext)((PurchaseContext)payload.getLeft()), (FileUploadManager)fileUploadManager, (Locale)((Locale)payload.getMiddle()), (TemplateManager)templateManager, (Map)((Map)payload.getRight()), (ExtensionManager)extensionManager)));
        this.attachmentTransformer.put(Mailer.AttachmentIdentifier.CREDIT_NOTE_PDF, NotificationManager.receiptOrInvoiceFactory((PurchaseContextManager)purchaseContextManager, (EventRepository)eventRepository, (T payload) -> TemplateProcessor.buildCreditNotePdf((PurchaseContext)((PurchaseContext)payload.getLeft()), (FileUploadManager)fileUploadManager, (Locale)((Locale)payload.getMiddle()), (TemplateManager)templateManager, (Map)((Map)payload.getRight()), (ExtensionManager)extensionManager)));
        this.attachmentTransformer.put(Mailer.AttachmentIdentifier.PASSBOOK, arg_0 -> ((PassKitManager)passKitManager).getPass(arg_0));
        BiFunction retrieveFieldValues = EventUtil.retrieveFieldValues((TicketRepository)ticketRepository, (PurchaseContextFieldManager)purchaseContextFieldManager, (AdditionalServiceItemRepository)additionalServiceItemRepository, (boolean)true);
        this.attachmentTransformer.put(Mailer.AttachmentIdentifier.TICKET_PDF, NotificationManager.generateTicketPDF((EventRepository)eventRepository, (OrganizationRepository)organizationRepository, (ConfigurationManager)configurationManager, (FileUploadManager)fileUploadManager, (TemplateManager)templateManager, (TicketReservationRepository)ticketReservationRepository, (BiFunction)retrieveFieldValues, (ExtensionManager)extensionManager, (TicketRepository)ticketRepository, (SubscriptionRepository)subscriptionRepository, (AdditionalServiceHelper)additionalServiceHelper));
        this.attachmentTransformer.put(Mailer.AttachmentIdentifier.SUBSCRIPTION_PDF, NotificationManager.generateSubscriptionPDF((OrganizationRepository)organizationRepository, (ConfigurationManager)configurationManager, (FileUploadManager)fileUploadManager, (TemplateManager)templateManager, (TicketReservationRepository)ticketReservationRepository, (ExtensionManager)extensionManager, (SubscriptionRepository)subscriptionRepository, (PurchaseContextFieldManager)purchaseContextFieldManager));
    }

    private static Function<Map<String, String>, byte[]> generateTicketPDF(EventRepository eventRepository, OrganizationRepository organizationRepository, ConfigurationManager configurationManager, FileUploadManager fileUploadManager, TemplateManager templateManager, TicketReservationRepository ticketReservationRepository, BiFunction<Ticket, Event, List<FieldConfigurationDescriptionAndValue>> retrieveFieldValues, ExtensionManager extensionManager, TicketRepository ticketRepository, SubscriptionRepository subscriptionRepository, AdditionalServiceHelper additionalServiceHelper) {
        return model -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Ticket ticket = (Ticket)Json.fromJson((String)((String)model.get("ticket")), Ticket.class);
            try {
                TicketReservation reservation = ticketReservationRepository.findReservationById(ticket.getTicketsReservationId());
                TicketCategory ticketCategory = (TicketCategory)Json.fromJson((String)((String)model.get("ticketCategory")), TicketCategory.class);
                Event event = eventRepository.findById(ticket.getEventId());
                Organization organization = organizationRepository.getById(Integer.valueOf((String)model.get("organizationId"), 10).intValue());
                TicketWithMetadataAttributes ticketWithMetadata = TicketWithMetadataAttributes.build((Ticket)ticket, (TicketMetadataContainer)ticketRepository.getTicketMetadata(ticket.getId()));
                Locale locale = LocaleUtil.forLanguageTag((String)ticket.getUserLanguage());
                TemplateProcessor.renderPDFTicket((Locale)locale, (Event)event, (TicketReservation)reservation, (TicketWithMetadataAttributes)ticketWithMetadata, (TicketCategory)ticketCategory, (Organization)organization, (TemplateManager)templateManager, (FileUploadManager)fileUploadManager, (String)configurationManager.getShortReservationID((Configurable)event, reservation), (OutputStream)baos, (BiFunction)retrieveFieldValues, (ExtensionManager)extensionManager, (Map)TemplateProcessor.getSubscriptionDetailsModelForTicket((Ticket)ticket, arg_0 -> ((SubscriptionRepository)subscriptionRepository).findDescriptorBySubscriptionId(arg_0), (Locale)locale), (List)additionalServiceHelper.findForTicket(ticket, event));
            }
            catch (IOException e) {
                log.warn("was not able to generate ticket pdf for ticket with id" + ticket.getId(), (Throwable)e);
            }
            return baos.toByteArray();
        };
    }

    private static Function<Map<String, String>, byte[]> generateICS(EventRepository eventRepository, EventDescriptionRepository eventDescriptionRepository, TicketCategoryRepository ticketCategoryRepository, OrganizationRepository organizationRepository, MessageSourceManager messageSourceManager, ConfigurationManager configurationManager) {
        return model -> {
            Integer categoryId;
            Locale locale;
            Event event;
            if (model.containsKey("eventId")) {
                event = eventRepository.findById(Integer.valueOf((String)model.get("eventId"), 10).intValue());
                locale = (Locale)Json.fromJson((String)((String)model.get("locale")), Locale.class);
                categoryId = null;
            } else {
                Ticket ticket = (Ticket)Json.fromJson((String)((String)model.get("ticket")), Ticket.class);
                event = eventRepository.findById(ticket.getEventId());
                locale = LocaleUtil.forLanguageTag((String)ticket.getUserLanguage());
                categoryId = ticket.getCategoryId();
            }
            Organization organization = organizationRepository.getById(event.getOrganizationId());
            TicketCategory category = Optional.ofNullable(categoryId).map(arg_0 -> ((TicketCategoryRepository)ticketCategoryRepository).getById(arg_0)).orElse(null);
            Object description = eventDescriptionRepository.findDescriptionByEventIdTypeAndLocale(event.getId(), EventDescription.EventDescriptionType.DESCRIPTION, locale.getLanguage()).orElse("");
            if (model.containsKey("onlineCheckInUrl") && configurationManager.getFor(ConfigurationKeys.INCLUDE_CHECK_IN_URL_ICAL, event.getConfigurationLevel()).getValueAsBooleanOrDefault()) {
                MessageSource messageSource = messageSourceManager.getMessageSourceFor((PurchaseContext)event);
                description = (String)description + "\n```\n" + (String)NotificationManager.buildOnlineCheckInInformation((MessageSource)messageSource).apply(model, locale) + "\n```\n";
            }
            return EventUtil.getIcalForEvent((Event)event, (TicketCategory)category, (String)description, (Organization)organization).orElse(null);
        };
    }

    private static BiFunction<Map<String, String>, Locale, String> buildOnlineCheckInInformation(MessageSource messageSource) {
        return (model, locale) -> {
            String body = model.containsKey("customCheckInUrl") ? Objects.requireNonNullElseGet((String)model.get("customCheckInUrlText"), () -> messageSource.getMessage("email.event.online.check-in", null, locale)) + "\n" + (String)model.get("onlineCheckInUrl") + "\n" + model.getOrDefault("customCheckInUrlDescription", "") + "\n" : messageSource.getMessage("email.event.online.check-in", null, locale) + "\n" + (String)model.get("onlineCheckInUrl") + "\n \n";
            return "\n******************************************\n" + messageSource.getMessage("event.location.online", null, locale) + "\n\n" + messageSource.getMessage("email.event.online.important-information", null, locale) + "\n\n" + body + "\n" + MustacheCustomTag.renderToTextCommonmark((String)model.getOrDefault("prerequisites", ""));
        };
    }

    public String buildOnlineCheckInText(Map<String, String> model, Locale locale, MessageSource messageSource) {
        return (String)NotificationManager.buildOnlineCheckInInformation((MessageSource)messageSource).apply(model, locale);
    }

    private static Function<Map<String, String>, byte[]> receiptOrInvoiceFactory(PurchaseContextManager purchaseContextManager, EventRepository eventRepository, Function<Triple<PurchaseContext, Locale, Map<String, Object>>, Optional<byte[]>> pdfGenerator) {
        return model -> {
            Event purchaseContext;
            String reservationId = (String)model.get("reservationId");
            Map reservationEmailModel = (Map)Json.fromJson((String)((String)model.get("reservationEmailModel")), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (reservationEmailModel.get("purchaseContext") != null) {
                Map purchaseContextModel = (Map)reservationEmailModel.get("purchaseContext");
                PurchaseContext.PurchaseContextType purchaseContextType = model.get("eventId") != null ? PurchaseContext.PurchaseContextType.event : PurchaseContext.PurchaseContextType.subscription;
                purchaseContext = (PurchaseContext)purchaseContextManager.findBy(purchaseContextType, (String)purchaseContextModel.get("publicIdentifier")).orElseThrow();
            } else {
                purchaseContext = eventRepository.findById(Integer.valueOf((String)model.get("eventId"), 10).intValue());
            }
            Locale language = (Locale)Json.fromJson((String)((String)model.get("language")), Locale.class);
            Optional receipt = (Optional)pdfGenerator.apply(Triple.of((Object)purchaseContext, (Object)language, (Object)reservationEmailModel));
            reservationEmailModel.put("event", purchaseContext);
            if (receipt.isEmpty()) {
                log.warn("was not able to generate the receipt for reservation id " + reservationId + " for locale " + language);
            }
            return receipt.orElse(null);
        };
    }

    public void sendTicketByEmail(Ticket ticket, Event event, Locale locale, PartialTicketTextGenerator textBuilder, TicketReservation reservation, TicketCategory ticketCategory, Supplier<Map<String, List<String>>> ticketAdditionalInfoSupplier) {
        Organization organization = this.organizationRepository.getById(event.getOrganizationId());
        boolean htmlEmailEnabled = this.configurationManager.getFor(ConfigurationKeys.ENABLE_HTML_EMAILS, event.getConfigurationLevel()).getValueAsBooleanOrDefault();
        RenderedTemplate renderedTemplate = textBuilder.generate(ticket);
        ArrayList<Mailer.Attachment> attachments = new ArrayList<Mailer.Attachment>();
        if (EventUtil.isAccessOnline((TicketCategory)ticketCategory, (EventCheckInInfo)event)) {
            HashMap attachmentModel = new HashMap();
            renderedTemplate.getSrcModel().forEach((k, v) -> {
                if (v instanceof String) {
                    String string = (String)v;
                    attachmentModel.put(k, string);
                } else {
                    attachmentModel.put(k, Json.toJson((Object)v));
                }
            });
            attachments.add(CustomMessageManager.generateCalendarAttachmentForOnlineEvent(attachmentModel));
        } else {
            attachments.add(CustomMessageManager.generateTicketAttachment((Ticket)ticket, (TicketReservation)reservation, (TicketCategory)ticketCategory, (Organization)organization, (boolean)htmlEmailEnabled));
        }
        String displayName = event.getDisplayName();
        String subject = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event).getMessage("ticket-email-subject", new Object[]{displayName}, locale);
        String encodedAttachments = this.encodeAttachments(attachments.toArray(new Mailer.Attachment[0]));
        String checksum = NotificationManager.calculateChecksum((String)ticket.getEmail(), (String)encodedAttachments, (String)subject, (RenderedTemplate)renderedTemplate);
        String recipient = ticket.getEmail();
        String cc = this.getCCForTicket(ticket);
        this.tx.execute(status -> {
            this.emailMessageRepository.findIdByEventIdAndChecksum(event.getId(), checksum).ifPresentOrElse(id -> this.emailMessageRepository.updateStatusToWaitingWithHtml(id.intValue(), renderedTemplate.getHtmlPart()), () -> this.emailMessageRepository.insert(Integer.valueOf(event.getId()), null, reservation.getId(), recipient, cc, subject, renderedTemplate.getTextPart(), renderedTemplate.getHtmlPart(), encodedAttachments, checksum, ZonedDateTime.now(this.clockProvider.getClock()), event.getOrganizationId()));
            return null;
        });
    }

    private String getCCForTicket(Ticket ticket) {
        TicketMetadataContainer metadata = this.ticketRepository.getTicketMetadata(ticket.getId());
        if (metadata != null) {
            Optional key = metadata.getMetadataForKey("general");
            if (key.isEmpty()) {
                return null;
            }
            return (String)((TicketMetadata)key.get()).getAttributes().get("sendTicketCc");
        }
        return null;
    }

    public void sendSimpleEmail(PurchaseContext purchaseContext, String reservationId, String recipient, List<String> cc, String subject, TemplateGenerator textBuilder) {
        this.sendSimpleEmail(purchaseContext, reservationId, recipient, cc, subject, textBuilder, Collections.emptyList());
    }

    public List<String> getCCForEventOrganizer(PurchaseContext purchaseContext) {
        String systemNotificationCC = this.configurationManager.getFor(ConfigurationKeys.MAIL_SYSTEM_NOTIFICATION_CC, purchaseContext.getConfigurationLevel()).getValueOrDefault("");
        return Stream.of(StringUtils.split((String)systemNotificationCC, (char)',')).filter(Objects::nonNull).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public void sendSimpleEmail(PurchaseContext event, String reservationId, String recipient, String subject, TemplateGenerator textBuilder) {
        this.sendSimpleEmail(event, reservationId, recipient, Collections.emptyList(), subject, textBuilder);
    }

    public void sendSimpleEmail(PurchaseContext purchaseContext, String reservationId, String recipient, String subject, TemplateGenerator textBuilder, List<Mailer.Attachment> attachments) {
        this.sendSimpleEmail(purchaseContext, reservationId, recipient, Collections.emptyList(), subject, textBuilder, attachments);
    }

    public void sendSimpleEmail(PurchaseContext purchaseContext, String reservationId, String recipient, List<String> cc, String subject, TemplateGenerator textBuilder, List<Mailer.Attachment> attachments) {
        if (recipient == null) {
            log.warn("No recipient provided, mail for reservation id {} with subject {} will be ignored", (Object)MiscUtils.removeTabsAndNewlines((String)reservationId), (Object)MiscUtils.removeTabsAndNewlines((String)subject));
            return;
        }
        String encodedAttachments = attachments.isEmpty() ? null : this.encodeAttachments(attachments.toArray(new Mailer.Attachment[0]));
        String encodedCC = Json.toJson(cc);
        RenderedTemplate renderedTemplate = textBuilder.generate();
        String checksum = NotificationManager.calculateChecksum((String)recipient, (String)encodedAttachments, (String)subject, (RenderedTemplate)renderedTemplate);
        Optional existing = this.emailMessageRepository.findIdByPurchaseContextAndChecksum(purchaseContext, checksum);
        existing.ifPresentOrElse(id -> this.emailMessageRepository.updateStatusToWaitingWithHtml(id.intValue(), renderedTemplate.getHtmlPart()), () -> {
            Pair pair = NotificationManager.getEventIdSubscriptionId((PurchaseContext)purchaseContext);
            this.emailMessageRepository.insert((Integer)pair.getLeft(), (UUID)pair.getRight(), reservationId, recipient, encodedCC, subject, renderedTemplate.getTextPart(), renderedTemplate.getHtmlPart(), encodedAttachments, checksum, ZonedDateTime.now(this.clockProvider.getClock()), purchaseContext.getOrganizationId());
        });
    }

    private static Pair<Integer, UUID> getEventIdSubscriptionId(PurchaseContext purchaseContext) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return Pair.of((Object)((Event)purchaseContext).getId(), null);
        }
        return Pair.of(null, (Object)((SubscriptionDescriptor)purchaseContext).getId());
    }

    public Pair<Integer, List<LightweightMailMessage>> loadAllMessagesForPurchaseContext(PurchaseContext purchaseContext, Integer page, String search) {
        int pageSize = 50;
        int offset = page == null ? 0 : page * 50;
        Object toSearch = StringUtils.trimToNull((String)search);
        Object object = toSearch = toSearch == null ? null : "%" + (String)toSearch + "%";
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            int eventId = ((Event)purchaseContext).getId();
            return Pair.of((Object)this.emailMessageRepository.countFindByEventId(eventId, (String)toSearch), (Object)this.emailMessageRepository.findByEventId(eventId, offset, 50, (String)toSearch));
        }
        UUID subscriptionDescriptorId = ((SubscriptionDescriptor)purchaseContext).getId();
        return Pair.of((Object)this.emailMessageRepository.countFindBySubscriptionDescriptorId(subscriptionDescriptorId, (String)toSearch), (Object)this.emailMessageRepository.findBySubscriptionDescriptorId(subscriptionDescriptorId, offset, 50, (String)toSearch));
    }

    public List<LightweightMailMessage> loadAllMessagesForReservationId(PurchaseContext purchaseContext, String reservationId) {
        return this.emailMessageRepository.findByPurchaseContextAndReservationId(purchaseContext, reservationId);
    }

    public Optional<LightweightMailMessage> loadSingleMessageForPurchaseContext(PurchaseContext purchaseContext, int messageId) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return this.emailMessageRepository.findByEventIdAndMessageId(((Event)purchaseContext).getId(), messageId);
        }
        return this.emailMessageRepository.findBySubscriptionDescriptorIdAndMessageId(((SubscriptionDescriptor)purchaseContext).getId(), messageId);
    }

    @Transactional
    public int sendWaitingMessages() {
        this.emailMessageRepository.setToRetryOldInProcess(ZonedDateTime.now(this.clockProvider.getClock()).minusHours(1L));
        return this.emailMessageRepository.loadAllWaitingForProcessing().stream().collect(Collectors.groupingBy(NotificationManager::purchaseContextCacheKey)).entrySet().stream().flatMapToInt(entry -> {
            String[] splitKey = ((String)entry.getKey()).split("//");
            PurchaseContext purchaseContext = (PurchaseContext)this.purchaseContextManager.findById(PurchaseContext.PurchaseContextType.from((String)splitKey[0]), splitKey[1]).orElseThrow();
            return ((List)entry.getValue()).stream().mapToInt(message -> this.processMessage(message, purchaseContext));
        }).sum();
    }

    private int processMessage(EmailMessage message, PurchaseContext purchaseContext) {
        int messageId = message.getId();
        ConfigurationLevel configurationLevel = ConfigurationLevel.purchaseContext((PurchaseContext)purchaseContext);
        if (message.getAttempts() >= this.configurationManager.getFor(ConfigurationKeys.MAIL_ATTEMPTS_COUNT, configurationLevel).getValueAsIntOrDefault(10)) {
            this.tx.execute(status -> this.emailMessageRepository.updateStatusAndAttempts(messageId, EmailMessage.Status.ERROR.name(), message.getAttempts(), Arrays.asList(EmailMessage.Status.IN_PROCESS.name(), EmailMessage.Status.WAITING.name(), EmailMessage.Status.RETRY.name())));
            log.warn("Message with id {} will be discarded", (Object)messageId);
            return 0;
        }
        try {
            int result = Optional.ofNullable((Integer)this.tx.execute(status -> this.emailMessageRepository.updateStatus(messageId, message.getChecksum(), EmailMessage.Status.IN_PROCESS.name(), Arrays.asList(EmailMessage.Status.WAITING.name(), EmailMessage.Status.RETRY.name())))).orElse(0);
            if (result > 0) {
                return Optional.ofNullable((Integer)this.tx.execute(status -> {
                    this.sendMessage(purchaseContext, message);
                    return 1;
                })).orElse(0);
            }
            log.debug("no messages have been updated on DB for the following criteria: id: {}, checksum: {}", (Object)messageId, (Object)message.getChecksum());
        }
        catch (Exception e) {
            this.tx.execute(status -> this.emailMessageRepository.updateStatusAndAttempts(message.getId(), EmailMessage.Status.RETRY.name(), ZonedDateTime.now(this.clockProvider.getClock()).plusMinutes((long)message.getAttempts() + 1L), message.getAttempts() + 1, Arrays.asList(EmailMessage.Status.IN_PROCESS.name(), EmailMessage.Status.WAITING.name(), EmailMessage.Status.RETRY.name())));
            log.warn("could not send message: ", (Throwable)e);
        }
        return 0;
    }

    private void sendMessage(PurchaseContext purchaseContext, EmailMessage message) {
        this.mailer.send((Configurable)purchaseContext, purchaseContext.getDisplayName(), message.getRecipient(), message.getCc(), message.getSubject(), message.getMessage(), Optional.ofNullable(message.getHtmlMessage()), this.decodeAttachments(message.getAttachments()));
        this.emailMessageRepository.updateStatusToSent(message.getId(), message.getChecksum(), ZonedDateTime.now(this.clockProvider.getClock()), Collections.singletonList(EmailMessage.Status.IN_PROCESS.name()));
    }

    private String encodeAttachments(Mailer.Attachment ... files) {
        return this.gson.toJson((Object)files);
    }

    private Mailer.Attachment[] decodeAttachments(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return new Mailer.Attachment[0];
        }
        Mailer.Attachment[] attachments = (Mailer.Attachment[])this.gson.fromJson(input, Mailer.Attachment[].class);
        Set alreadyPresents = Arrays.stream(attachments).map(Mailer.Attachment::getIdentifier).filter(Objects::nonNull).collect(Collectors.toSet());
        List<Mailer.Attachment> toReinterpret = Arrays.stream(attachments).filter(attachment -> attachment.getIdentifier() != null && !attachment.getIdentifier().reinterpretAs().isEmpty()).collect(Collectors.toList());
        List<Mailer.Attachment> generated = Arrays.stream(attachments).map(attachment -> this.transformAttachment(attachment, attachment.getIdentifier())).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList reinterpreted = new ArrayList();
        toReinterpret.forEach(attachment -> attachment.getIdentifier().reinterpretAs().stream().filter(identifier -> !alreadyPresents.contains(identifier)).forEach(identifier -> reinterpreted.add(this.transformAttachment(attachment, identifier))));
        generated.addAll(reinterpreted.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        return generated.toArray(new Mailer.Attachment[0]);
    }

    private Mailer.Attachment transformAttachment(Mailer.Attachment attachment, Mailer.AttachmentIdentifier identifier) {
        if (identifier != null) {
            byte[] result = (byte[])((Function)this.attachmentTransformer.get(identifier)).apply(attachment.getModel());
            return result == null ? null : new Mailer.Attachment(identifier.fileName(attachment.getFilename()), result, identifier.contentType(attachment.getContentType()), null, null);
        }
        return attachment;
    }

    private static String calculateChecksum(String recipient, String attachments, String subject, RenderedTemplate renderedTemplate) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(recipient.getBytes(StandardCharsets.UTF_8));
            digest.update(subject.getBytes(StandardCharsets.UTF_8));
            Optional.ofNullable(attachments).ifPresent(v -> digest.update(v.getBytes(StandardCharsets.UTF_8)));
            digest.update(renderedTemplate.getTextPart().getBytes(StandardCharsets.UTF_8));
            if (renderedTemplate.isMultipart()) {
                digest.update(renderedTemplate.getHtmlPart().getBytes(StandardCharsets.UTF_8));
            }
            return new String(Hex.encode((byte[])digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Function<Map<String, String>, byte[]> generateSubscriptionPDF(OrganizationRepository organizationRepository, ConfigurationManager configurationManager, FileUploadManager fileUploadManager, TemplateManager templateManager, TicketReservationRepository ticketReservationRepository, ExtensionManager extensionManager, SubscriptionRepository subscriptionRepository, PurchaseContextFieldManager purchaseContextFieldManager) {
        return model -> {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            UUID subscriptionId = UUID.fromString((String)model.get("subscriptionId"));
            Subscription subscription = subscriptionRepository.findSubscriptionById(subscriptionId);
            try {
                SubscriptionDescriptor subscriptionDescriptor = subscriptionRepository.findDescriptorBySubscriptionId(subscriptionId);
                TicketReservation reservation = ticketReservationRepository.findReservationById(subscription.getReservationId());
                Organization organization = organizationRepository.getById(subscriptionDescriptor.getOrganizationId());
                SubscriptionMetadata metadata = Objects.requireNonNullElseGet(subscriptionRepository.getSubscriptionMetadata(subscription.getId()), SubscriptionMetadata::empty);
                TemplateProcessor.renderSubscriptionPDF((Subscription)subscription, (Locale)LocaleUtil.forLanguageTag((String)reservation.getUserLanguage()), (SubscriptionDescriptor)subscriptionDescriptor, (TicketReservation)reservation, (SubscriptionMetadata)metadata, (Organization)organization, (TemplateManager)templateManager, (FileUploadManager)fileUploadManager, (String)configurationManager.getShortReservationID((Configurable)subscriptionDescriptor, reservation), (ByteArrayOutputStream)baos, (ExtensionManager)extensionManager, (PurchaseContextFieldManager)purchaseContextFieldManager);
            }
            catch (IOException e) {
                log.warn("was not able to generate subscription pdf for " + subscription.getId(), (Throwable)e);
            }
            return baos.toByteArray();
        };
    }

    private static String purchaseContextCacheKey(EmailMessage message) {
        return message.getPurchaseContextType() + "//" + Objects.requireNonNullElse(message.getEventId(), message.getSubscriptionDescriptorId());
    }
}

