/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.model.user.Organization;
import alfio.repository.EventDeleterRepository;
import alfio.repository.EventRepository;
import alfio.repository.OrganizationDeleterRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.join.UserOrganizationRepository;
import alfio.util.RequestUtils;
import java.security.Principal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class OrganizationDeleter {
    private static final Logger log = LoggerFactory.getLogger(OrganizationDeleter.class);
    private final UserOrganizationRepository userOrganizationRepository;
    private final OrganizationRepository organizationRepository;
    private final EventRepository eventRepository;
    private final EventDeleterRepository eventDeleterRepository;
    private final OrganizationDeleterRepository organizationDeleterRepository;

    public OrganizationDeleter(UserOrganizationRepository userOrganizationRepository, OrganizationRepository organizationRepository, EventRepository eventRepository, EventDeleterRepository eventDeleterRepository, OrganizationDeleterRepository organizationDeleterRepository) {
        this.userOrganizationRepository = userOrganizationRepository;
        this.organizationRepository = organizationRepository;
        this.eventRepository = eventRepository;
        this.eventDeleterRepository = eventDeleterRepository;
        this.organizationDeleterRepository = organizationDeleterRepository;
    }

    public boolean deleteOrganization(int organizationId, Principal principal) {
        boolean isAdmin;
        boolean bl = isAdmin = RequestUtils.isAdmin((Principal)principal) || RequestUtils.isSystemApiKey((Principal)principal);
        if (isAdmin) {
            Organization originalOrg = this.organizationRepository.getById(organizationId);
            log.warn("Delete organization {} ({}) initiated by user {}", new Object[]{organizationId, originalOrg.getName(), principal.getName()});
            List disabledEventIds = this.eventRepository.disableEventsForOrganization(organizationId);
            if (!disabledEventIds.isEmpty()) {
                log.warn("deleting {} events linked to organization {}", (Object)disabledEventIds.size(), (Object)organizationId);
                disabledEventIds.forEach(arg_0 -> ((EventDeleterRepository)this.eventDeleterRepository).deleteAllForEvent(arg_0));
            }
            List<Integer> organizationIds = List.of(Integer.valueOf(organizationId));
            this.organizationDeleterRepository.deleteFieldValues(organizationIds);
            this.organizationDeleterRepository.deleteFieldDescription(organizationIds);
            this.organizationDeleterRepository.deleteFieldConfiguration(organizationIds);
            int users = this.userOrganizationRepository.cleanupOrganization(organizationId);
            log.warn("removed {} user(s) from organization {}", (Object)users, (Object)organizationId);
            this.organizationDeleterRepository.deleteEmptyOrganizations(organizationIds);
            return true;
        }
        return false;
    }
}

