/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.FileBlobCacheManager;
import alfio.manager.FileUploadManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventDescription;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.EventDescriptionRepository;
import alfio.repository.EventRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.util.Json;
import alfio.util.LocaleUtil;
import alfio.util.MiscUtils;
import alfio.util.MustacheCustomTag;
import com.ryantenney.passkit4j.Pass;
import com.ryantenney.passkit4j.PassResource;
import com.ryantenney.passkit4j.PassSerializer;
import com.ryantenney.passkit4j.io.NamedInputStreamSupplier;
import com.ryantenney.passkit4j.model.Barcode;
import com.ryantenney.passkit4j.model.BarcodeFormat;
import com.ryantenney.passkit4j.model.Color;
import com.ryantenney.passkit4j.model.EventTicket;
import com.ryantenney.passkit4j.model.Field;
import com.ryantenney.passkit4j.model.Location;
import com.ryantenney.passkit4j.model.TextField;
import com.ryantenney.passkit4j.sign.PassSigner;
import com.ryantenney.passkit4j.sign.PassSignerImpl;
import com.ryantenney.passkit4j.sign.PassSigningException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.imgscalr.Scalr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class PassKitManager {
    private static final Logger log = LoggerFactory.getLogger(PassKitManager.class);
    private static final String APPLE_PASS = "ApplePass";
    private static final String PASSKIT_SECTION = "passkit";
    private final EventRepository eventRepository;
    private final OrganizationRepository organizationRepository;
    private final ConfigurationManager configurationManager;
    private final FileUploadManager fileUploadManager;
    private final EventDescriptionRepository eventDescriptionRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final TicketRepository ticketRepository;
    private final FileBlobCacheManager fileBlobCacheManager;

    public boolean writePass(Ticket ticket, EventAndOrganizationId event, OutputStream out) throws IOException, PassSigningException {
        Organization organization = this.organizationRepository.getById(event.getOrganizationId());
        Map passConf = this.getConfigurationKeys(event);
        if (!passConf.isEmpty()) {
            this.buildPass(ticket, this.eventRepository.findById(event.getId()), organization, passConf, out);
            return true;
        }
        log.trace("Cannot generate Pass. Missing configuration keys, check if all 5 are presents");
        return false;
    }

    byte[] getPass(Map<String, String> model) {
        byte[] byArray;
        if ("true".equals(model.get("skipPassbook"))) {
            log.trace("HTML email enabled. Skipping passbook generation");
            return null;
        }
        Ticket ticket = (Ticket)Json.fromJson((String)model.get("ticket"), Ticket.class);
        int eventId = ticket.getEventId();
        Event event = this.eventRepository.findById(eventId);
        Organization organization = this.organizationRepository.getById(Integer.valueOf(model.get("organizationId"), 10).intValue());
        Map passConf = this.getConfigurationKeys((EventAndOrganizationId)event);
        if (passConf.isEmpty()) {
            log.trace("Cannot generate Passbook. Missing configuration keys, check if all 5 are presents");
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.buildPass(ticket, event, organization, passConf, (OutputStream)out);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                log.warn("Got Exception while generating Passbook. Please check configuration.", (Throwable)ex);
                return null;
            }
        }
        out.close();
        return byArray;
    }

    private Map<ConfigurationKeys, String> getConfigurationKeys(EventAndOrganizationId event) {
        Map conf = this.configurationManager.getFor(Set.of(ConfigurationKeys.ENABLE_PASS, ConfigurationKeys.PASSBOOK_TYPE_IDENTIFIER, ConfigurationKeys.PASSBOOK_KEYSTORE, ConfigurationKeys.PASSBOOK_KEYSTORE_PASSWORD, ConfigurationKeys.PASSBOOK_TEAM_IDENTIFIER, ConfigurationKeys.PASSBOOK_PRIVATE_KEY_ALIAS), event.getConfigurationLevel());
        if (!((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.ENABLE_PASS)).getValueAsBooleanOrDefault()) {
            return Map.of();
        }
        Map<ConfigurationKeys, Optional> configValues = Map.of(ConfigurationKeys.PASSBOOK_TYPE_IDENTIFIER, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.PASSBOOK_TYPE_IDENTIFIER)).getValue(), ConfigurationKeys.PASSBOOK_KEYSTORE, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.PASSBOOK_KEYSTORE)).getValue(), ConfigurationKeys.PASSBOOK_KEYSTORE_PASSWORD, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.PASSBOOK_KEYSTORE_PASSWORD)).getValue(), ConfigurationKeys.PASSBOOK_TEAM_IDENTIFIER, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.PASSBOOK_TEAM_IDENTIFIER)).getValue(), ConfigurationKeys.PASSBOOK_PRIVATE_KEY_ALIAS, ((ConfigurationManager.MaybeConfiguration)conf.get(ConfigurationKeys.PASSBOOK_PRIVATE_KEY_ALIAS)).getValue());
        if (configValues.values().stream().anyMatch(Optional::isEmpty)) {
            return Map.of();
        }
        return configValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((Optional)e.getValue()).orElseThrow()));
    }

    private void buildPass(Ticket ticket, Event event, Organization organization, Map<ConfigurationKeys, String> config, OutputStream out) throws IOException, PassSigningException {
        Locale ticketLocale = LocaleUtil.forLanguageTag((String)ticket.getUserLanguage());
        String teamIdentifier = config.get(ConfigurationKeys.PASSBOOK_TEAM_IDENTIFIER);
        String typeIdentifier = config.get(ConfigurationKeys.PASSBOOK_TYPE_IDENTIFIER);
        byte[] keystoreRaw = Base64.getDecoder().decode(config.get(ConfigurationKeys.PASSBOOK_KEYSTORE));
        String keystorePwd = config.get(ConfigurationKeys.PASSBOOK_KEYSTORE_PASSWORD);
        String privateKeyAlias = config.get(ConfigurationKeys.PASSBOOK_PRIVATE_KEY_ALIAS);
        String eventDescription = MustacheCustomTag.renderToTextCommonmark((String)this.eventDescriptionRepository.findDescriptionByEventIdTypeAndLocale(event.getId(), EventDescription.EventDescriptionType.DESCRIPTION, ticket.getUserLanguage()).orElse(""));
        TicketCategory category = this.ticketCategoryRepository.getById(ticket.getCategoryId().intValue());
        ZonedDateTime ticketValidityStart = Optional.ofNullable(category.getTicketValidityStart(event.getZoneId())).orElse(event.getBegin());
        Pass pass = new Pass().teamIdentifier(teamIdentifier).passTypeIdentifier(typeIdentifier).organizationName(organization.getName()).groupingIdentifier(organization.getEmail()).description(event.getDisplayName()).serialNumber(ticket.getUuid()).relevantDate(Date.from(ticketValidityStart.toInstant())).expirationDate(Date.from(Optional.ofNullable(category.getTicketValidityEnd(event.getZoneId())).orElse(event.getEnd()).toInstant())).barcode(new Barcode(BarcodeFormat.QR, ticket.ticketCode(event.getPrivateKey(), event.supportsQRCodeCaseInsensitive()))).labelColor(Color.BLACK).foregroundColor(Color.BLACK).backgroundColor(Color.WHITE).passInformation(new EventTicket().headerFields(List.of(new TextField("eventStartDate", "Date", ticketValidityStart.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(ticketLocale))))).primaryFields(List.of(new TextField("categoryId", event.getDisplayName(), category.getName()))).secondaryFields(new Field[]{new TextField("location", "Venue", event.getLocation())}).auxiliaryFields(this.getAuxiliaryFields(ticket)).backFields(new Field[]{new TextField("desc", "Event Description", eventDescription), new TextField("credits", "Powered by", "Alf.io, the Open Source ticket reservation System.")}));
        if (event.getLatitude() != null && event.getLongitude() != null) {
            pass.locations(new Location[]{new Location(Double.parseDouble(event.getLatitude()), Double.parseDouble(event.getLongitude())).altitude(0.0)});
        }
        ArrayList<PassResource> passResources = new ArrayList<PassResource>(6);
        passResources.add(new PassResource("icon.png", () -> new ClassPathResource("/alfio/icon/icon.png").getInputStream()));
        passResources.add(new PassResource("icon@2x.png", () -> new ClassPathResource("/alfio/icon/icon@2x.png").getInputStream()));
        passResources.add(new PassResource("icon@3x.png", () -> new ClassPathResource("/alfio/icon/icon@3x.png").getInputStream()));
        this.fileUploadManager.findMetadata(event.getFileBlobId()).ifPresent(metadata -> {
            if (metadata.getContentType().equals("image/png") || metadata.getContentType().equals("image/jpeg")) {
                File fullSizeLogo = this.fileUploadManager.getFile(event.getFileBlobId());
                String id = event.getFileBlobId();
                try {
                    File logo1x = this.fileBlobCacheManager.getFile("passkit", id + "scale-1", () -> PassKitManager.scaleLogo((File)fullSizeLogo, (int)1));
                    File logo2x = this.fileBlobCacheManager.getFile("passkit", id + "scale-2", () -> PassKitManager.scaleLogo((File)fullSizeLogo, (int)2));
                    File logo3x = this.fileBlobCacheManager.getFile("passkit", id + "scale-3", () -> PassKitManager.scaleLogo((File)fullSizeLogo, (int)3));
                    passResources.add(new PassResource("logo.png", logo1x));
                    passResources.add(new PassResource("logo@2x.png", logo2x));
                    passResources.add(new PassResource("logo@3x.png", logo3x));
                }
                catch (IllegalStateException e) {
                    log.warn("was not able to add the logo to the passkit for ticket {} in event {}", new Object[]{ticket.getUuid(), event.getShortName(), e});
                }
            }
        });
        pass.files((NamedInputStreamSupplier[])passResources.toArray(new PassResource[0]));
        try (InputStream appleCert = new ClassPathResource("/alfio/certificates/AppleWWDRCAG4.cer").getInputStream();){
            PassSigner signer = PassSignerImpl.builder().keystore((InputStream)new ByteArrayInputStream(keystoreRaw), keystorePwd).alias(privateKeyAlias).intermediateCertificate(appleCert).build();
            PassSerializer.writePkPassArchive((Pass)pass, (PassSigner)signer, (OutputStream)out);
        }
    }

    private String buildAuthenticationToken(Ticket ticket, EventAndOrganizationId event, String privateKey) {
        String code = event.getId() + "/" + ticket.getTicketsReservationId() + "/" + ticket.getUuid();
        return Ticket.hmacSHA256Base64((String)privateKey, (String)code);
    }

    public Optional<Pair<EventAndOrganizationId, Ticket>> retrieveTicketDetails(String eventName, String ticketUuid) {
        return this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName).flatMap(e -> this.ticketRepository.findOptionalByPublicUUID(UUID.fromString(ticketUuid)).filter(t -> e.getId() == t.getEventId()).map(t -> Pair.of((Object)e, (Object)t)));
    }

    public Optional<Pair<EventAndOrganizationId, Ticket>> validateToken(String eventName, String typeIdentifier, String ticketUuid, String authorizationHeader) {
        if (!authorizationHeader.startsWith("ApplePass")) {
            log.trace("Authorization Header does not start with ApplePass");
            return Optional.empty();
        }
        String token = authorizationHeader.substring("ApplePass".length() + 1);
        Optional eventOptional = this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName);
        if (eventOptional.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("event {} not found", (Object)MiscUtils.removeTabsAndNewlines((String)eventName));
            }
            return Optional.empty();
        }
        EventAndOrganizationId event = (EventAndOrganizationId)eventOptional.get();
        ConfigurationManager.MaybeConfiguration typeIdentifierOptional = this.configurationManager.getFor(ConfigurationKeys.PASSBOOK_TYPE_IDENTIFIER, event.getConfigurationLevel());
        if (!typeIdentifierOptional.isPresent() || !typeIdentifier.equals(typeIdentifierOptional.getValueOrNull())) {
            if (log.isTraceEnabled()) {
                log.trace("typeIdentifier does not match. Expected {}, got {}", (Object)typeIdentifierOptional.getValueOrDefault("not-found"), (Object)MiscUtils.removeTabsAndNewlines((String)typeIdentifier));
            }
            return Optional.empty();
        }
        return this.ticketRepository.findOptionalByUUID(ticketUuid).filter(t -> t.getEventId() == event.getId()).filter(t -> this.buildAuthenticationToken(t, event, this.eventRepository.getPrivateKey(event.getId())).equals(token)).map(t -> Pair.of((Object)event, (Object)t));
    }

    private List<Field<?>> getAuxiliaryFields(Ticket ticket) {
        return null;
    }

    private static File scaleLogo(File sourceImage, int factor) {
        try {
            int finalWidth = 160 * factor;
            int finalHeight = 50 * factor;
            BufferedImage thumbImg = Scalr.resize((BufferedImage)ImageIO.read(sourceImage), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)finalWidth, (int)finalHeight, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            File tmpFile = File.createTempFile("passkit", "" + factor);
            ImageIO.write((RenderedImage)thumbImg, "png", tmpFile);
            return tmpFile;
        }
        catch (IOException e) {
            throw new IllegalStateException("was not able to scale logo from file " + sourceImage + " with factor " + factor, e);
        }
    }

    @ConstructorProperties(value={"eventRepository", "organizationRepository", "configurationManager", "fileUploadManager", "eventDescriptionRepository", "ticketCategoryRepository", "ticketRepository", "fileBlobCacheManager"})
    @Generated
    public PassKitManager(EventRepository eventRepository, OrganizationRepository organizationRepository, ConfigurationManager configurationManager, FileUploadManager fileUploadManager, EventDescriptionRepository eventDescriptionRepository, TicketCategoryRepository ticketCategoryRepository, TicketRepository ticketRepository, FileBlobCacheManager fileBlobCacheManager) {
        this.eventRepository = eventRepository;
        this.organizationRepository = organizationRepository;
        this.configurationManager = configurationManager;
        this.fileUploadManager = fileUploadManager;
        this.eventDescriptionRepository = eventDescriptionRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.ticketRepository = ticketRepository;
        this.fileBlobCacheManager = fileBlobCacheManager;
    }
}

