/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.ExtensionManager;
import alfio.manager.PaymentManager;
import alfio.manager.support.PaymentResult;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Audit;
import alfio.model.PaymentInformation;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.TransactionAndPaymentInfo;
import alfio.model.system.ConfigurationKeys;
import alfio.model.transaction.Capability;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.PaymentToken;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionRequest;
import alfio.model.transaction.capabilities.ClientServerTokenRequest;
import alfio.model.transaction.capabilities.ExtractPaymentTokenFromTransaction;
import alfio.model.transaction.capabilities.PaymentInfo;
import alfio.model.transaction.capabilities.RefundRequest;
import alfio.repository.AuditingRepository;
import alfio.repository.TransactionRepository;
import alfio.repository.user.UserRepository;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class PaymentManager {
    public static final String PAYMENT_TOKEN = "PAYMENT_TOKEN";
    private static final Logger log = LoggerFactory.getLogger(PaymentManager.class);
    private final TransactionRepository transactionRepository;
    private final ConfigurationManager configurationManager;
    private final AuditingRepository auditingRepository;
    private final UserRepository userRepository;
    private final ExtensionManager extensionManager;
    private final List<PaymentProvider> paymentProviders;

    public Optional<PaymentProvider> lookupProviderByTransactionAndCapabilities(Transaction transaction, List<Class<? extends Capability>> capabilities) {
        return this.paymentProviders.stream().filter(PaymentManager.filterByCapabilities(capabilities)).filter(paymentProvider -> paymentProvider.accept(transaction)).findFirst();
    }

    Optional<PaymentProvider> lookupProviderByMethodAndCapabilities(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest, List<Class<? extends Capability>> capabilities) {
        return this.compatibleStream(paymentMethod, context, transactionRequest).filter(p -> Objects.requireNonNull(capabilities).stream().allMatch(c -> c.isInstance(p))).findFirst();
    }

    public Stream<PaymentProvider> streamActiveProvidersByProxy(PaymentProxy paymentProxy, PaymentContext paymentContext) {
        return this.streamActiveProvidersByProxyAndCapabilities(paymentProxy, paymentContext, List.of());
    }

    List<Map.Entry<PaymentMethod, Set<PaymentProxy>>> validateSelection(List<PaymentProxy> paymentProxies, int organizationId) {
        PaymentContext paymentContext = new PaymentContext(null, ConfigurationLevel.organization((int)organizationId));
        Map proxiesByMethod = paymentProxies.stream().flatMap(proxy -> this.streamProvidersByProxyAndCapabilities(proxy, List.of())).map(provider -> Pair.of((Object)provider.getPaymentProxy(), (Object)provider.getSupportedPaymentMethods(paymentContext, TransactionRequest.empty()))).flatMap(pair -> ((Set)pair.getValue()).stream().map(pm -> Pair.of((Object)pm, (Object)((PaymentProxy)pair.getKey())))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
        return proxiesByMethod.entrySet().stream().filter(e -> ((Set)e.getValue()).size() > 1).collect(Collectors.toList());
    }

    private Stream<PaymentProvider> streamProvidersByProxyAndCapabilities(PaymentProxy paymentProxy, List<Class<? extends Capability>> capabilities) {
        return this.paymentProviders.stream().filter(pp -> pp.getPaymentProxy() == paymentProxy).filter(PaymentManager.filterByCapabilities(capabilities));
    }

    Stream<PaymentProvider> streamActiveProvidersByProxyAndCapabilities(PaymentProxy paymentProxy, PaymentContext paymentContext, List<Class<? extends Capability>> capabilities) {
        return this.streamProvidersByProxyAndCapabilities(paymentProxy, capabilities).filter(pp -> pp.isActive(paymentContext));
    }

    private static Predicate<PaymentProvider> filterByCapabilities(List<Class<? extends Capability>> capabilities) {
        return p -> capabilities.isEmpty() || capabilities.stream().allMatch(c -> c.isInstance(p));
    }

    private Stream<PaymentProvider> compatibleStream(PaymentMethod paymentMethod, PaymentContext context, TransactionRequest transactionRequest) {
        return this.paymentProviders.stream().filter(p -> p.accept(paymentMethod, context, transactionRequest));
    }

    private List<PaymentMethodDTO> getPaymentMethods(PaymentContext context, TransactionRequest transactionRequest) {
        String blacklist = this.configurationManager.getFor(ConfigurationKeys.PAYMENT_METHODS_BLACKLIST, context.getConfigurationLevel()).getValueOrDefault("");
        List proxies = Optional.ofNullable(context.getPurchaseContext()).map(PurchaseContext::getAllowedPaymentProxies).orElseGet(PaymentProxy::availableProxies);
        return proxies.stream().filter(p -> !blacklist.contains(p.getKey())).map(proxy -> Pair.of((Object)proxy, (Object)this.paymentMethodsByProxy(context, transactionRequest, proxy))).flatMap(pair -> ((Set)pair.getRight()).stream().map(pm -> new PaymentMethodDTO((PaymentProxy)pair.getLeft(), pm, PaymentMethodDTO.PaymentMethodStatus.ACTIVE))).collect(Collectors.toList());
    }

    private Set<PaymentMethod> paymentMethodsByProxy(PaymentContext context, TransactionRequest transactionRequest, PaymentProxy proxy) {
        return this.paymentProviders.stream().filter(pp -> pp.getPaymentProxy() == proxy).flatMap(pp -> pp.getSupportedPaymentMethods(context, transactionRequest).stream()).collect(Collectors.toSet());
    }

    public List<PaymentMethodDTO> getPaymentMethods(PurchaseContext purchaseContext, TransactionRequest transactionRequest) {
        return this.getPaymentMethods(new PaymentContext(purchaseContext), transactionRequest);
    }

    public List<PaymentMethodDTO> getPaymentMethods(int organizationId) {
        return this.getPaymentMethods(new PaymentContext(null, ConfigurationLevel.organization((int)organizationId)), TransactionRequest.empty());
    }

    public boolean refund(TicketReservation reservation, PurchaseContext purchaseContext, Integer amount, String username) {
        Transaction transaction = this.transactionRepository.loadByReservationId(reservation.getId());
        boolean res = this.lookupProviderByTransactionAndCapabilities(transaction, List.of(RefundRequest.class)).map(paymentProvider -> ((RefundRequest)paymentProvider).refund(transaction, purchaseContext, amount)).orElse(false);
        Map<String, String> changes = Map.of("refund", amount != null ? amount.toString() : "full", "paymentMethod", reservation.getPaymentMethod().toString());
        if (res) {
            this.auditingRepository.insert(reservation.getId(), (Integer)this.userRepository.findIdByUserName(username).orElse(null), purchaseContext, Audit.EventType.REFUND, new Date(), Audit.EntityType.RESERVATION, reservation.getId(), Collections.singletonList(changes));
            this.extensionManager.handleRefund(purchaseContext, reservation, this.getInfo(reservation, purchaseContext));
        } else {
            this.auditingRepository.insert(reservation.getId(), (Integer)this.userRepository.findIdByUserName(username).orElse(null), purchaseContext, Audit.EventType.REFUND_ATTEMPT_FAILED, new Date(), Audit.EntityType.RESERVATION, reservation.getId(), Collections.singletonList(changes));
        }
        return res;
    }

    public TransactionAndPaymentInfo getInfo(TicketReservation reservation, PurchaseContext purchaseContext) {
        Optional<TransactionAndPaymentInfo> maybeTransaction = this.transactionRepository.loadOptionalByReservationId(reservation.getId()).map(transaction -> this.internalGetInfo(reservation, purchaseContext, transaction));
        maybeTransaction.ifPresent(info -> {
            try {
                Transaction transaction = info.getTransaction();
                String transactionId = transaction.getTransactionId();
                PaymentInformation paymentInformation = info.getPaymentInformation();
                if (paymentInformation != null && this.feesUpdated(transaction, paymentInformation)) {
                    this.transactionRepository.updateFees(transactionId, reservation.getId(), PaymentManager.safeParseLong((String)paymentInformation.getPlatformFee()), PaymentManager.safeParseLong((String)paymentInformation.getFee()));
                }
            }
            catch (Exception e) {
                log.warn("cannot update fees", (Throwable)e);
            }
        });
        return maybeTransaction.orElseGet(() -> new TransactionAndPaymentInfo(reservation.getPaymentMethod(), null, new PaymentInformation(reservation.getPaidAmount(), null, null, null)));
    }

    public void updateTransactionDetails(String reservationId, String notes, ZonedDateTime timestamp, Principal principal) {
        Transaction existingTransaction = this.transactionRepository.loadByReservationId(reservationId);
        Validate.isTrue((existingTransaction.isTimestampEditable() || timestamp == null ? 1 : 0) != 0, (String)"Cannot modify timestamp", (Object[])new Object[0]);
        HashMap<String, String> existingMetadata = new HashMap<String, String>(existingTransaction.getMetadata());
        existingMetadata.put("transactionNotes", notes);
        int result = this.transactionRepository.updateDetailsById(existingTransaction.getId(), existingMetadata, Objects.requireNonNullElse(timestamp, existingTransaction.getTimestamp()));
        Validate.isTrue((result == 1 ? 1 : 0) != 0, (String)("Expected 1, got " + result), (Object[])new Object[0]);
    }

    private boolean feesUpdated(Transaction transaction, PaymentInformation paymentInformation) {
        return transaction.getPlatformFee() != PaymentManager.safeParseLong((String)paymentInformation.getPlatformFee()) || transaction.getGatewayFee() != PaymentManager.safeParseLong((String)paymentInformation.getFee());
    }

    private TransactionAndPaymentInfo internalGetInfo(TicketReservation reservation, PurchaseContext purchaseContext, Transaction transaction) {
        return this.lookupProviderByTransactionAndCapabilities(transaction, List.of(PaymentInfo.class)).map(provider -> {
            Optional info = ((PaymentInfo)provider).getInfo(transaction, purchaseContext);
            return new TransactionAndPaymentInfo(reservation.getPaymentMethod(), transaction, (PaymentInformation)info.orElse(null));
        }).orElseGet(() -> new TransactionAndPaymentInfo(reservation.getPaymentMethod(), transaction, new PaymentInformation(reservation.getPaidAmount(), null, String.valueOf(transaction.getGatewayFee()), String.valueOf(transaction.getPlatformFee()))));
    }

    private static long safeParseLong(String src) {
        return Optional.ofNullable(src).map(Long::parseLong).orElse(0L);
    }

    public Map<String, ?> loadModelOptionsFor(List<PaymentProxy> activePaymentMethods, PurchaseContext purchaseContext) {
        PaymentContext context = new PaymentContext(purchaseContext);
        return activePaymentMethods.stream().flatMap(pp -> this.getProviderOptions(context, pp)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Stream<? extends Map.Entry<String, ?>> getProviderOptions(PaymentContext context, PaymentProxy pp) {
        return this.streamActiveProvidersByProxy(pp, context).flatMap(it -> it.getModelOptions(context).entrySet().stream().filter(kv -> kv.getValue() != null));
    }

    public PaymentToken buildPaymentToken(String gatewayToken, PaymentProxy proxy, PaymentContext context) {
        return this.streamActiveProvidersByProxyAndCapabilities(proxy, context, List.of(ClientServerTokenRequest.class)).map(ClientServerTokenRequest.class::cast).map(pp -> pp.buildPaymentToken(gatewayToken, context)).findFirst().orElse(null);
    }

    public Optional<PaymentResult> getTransactionStatus(TicketReservation reservation, PaymentMethod paymentMethod) {
        return this.transactionRepository.loadOptionalByReservationId(reservation.getId()).filter(transaction -> transaction.getPaymentProxy().getPaymentMethod() == paymentMethod).map(transaction -> switch (1.$SwitchMap$alfio$model$transaction$Transaction$Status[transaction.getStatus().ordinal()]) {
            case 1 -> PaymentResult.successful((String)transaction.getPaymentId());
            case 2 -> PaymentResult.failed(null);
            default -> PaymentResult.initialized((String)transaction.getPaymentId());
        });
    }

    public Optional<PaymentToken> getPaymentToken(String reservationId) {
        return this.transactionRepository.loadOptionalByReservationId(reservationId).filter(t -> t.getStatus() == Transaction.Status.PENDING).flatMap(t -> {
            if (t.getMetadata().containsKey("PAYMENT_TOKEN")) {
                return this.lookupProviderByTransactionAndCapabilities(t, List.of(ExtractPaymentTokenFromTransaction.class)).map(ExtractPaymentTokenFromTransaction.class::cast).flatMap(paymentProvider -> paymentProvider.extractToken(t));
            }
            return Optional.empty();
        });
    }

    public boolean removePaymentTokenReservation(String reservationId) {
        return this.transactionRepository.loadOptionalByReservationId(reservationId).filter(t -> t.getStatus() == Transaction.Status.PENDING).map(t -> {
            if (t.getMetadata().containsKey("PAYMENT_TOKEN")) {
                return this.transactionRepository.invalidateById(t.getId()) == 1;
            }
            return false;
        }).orElse(false);
    }

    @ConstructorProperties(value={"transactionRepository", "configurationManager", "auditingRepository", "userRepository", "extensionManager", "paymentProviders"})
    @Generated
    public PaymentManager(TransactionRepository transactionRepository, ConfigurationManager configurationManager, AuditingRepository auditingRepository, UserRepository userRepository, ExtensionManager extensionManager, List<PaymentProvider> paymentProviders) {
        this.transactionRepository = transactionRepository;
        this.configurationManager = configurationManager;
        this.auditingRepository = auditingRepository;
        this.userRepository = userRepository;
        this.extensionManager = extensionManager;
        this.paymentProviders = paymentProviders;
    }
}

