/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.model.EventAndOrganizationId;
import alfio.model.Ticket;
import alfio.model.modification.PollModification;
import alfio.model.modification.PollOptionModification;
import alfio.model.poll.Poll;
import alfio.model.poll.PollOptionStatistics;
import alfio.model.poll.PollParticipant;
import alfio.model.poll.PollStatistics;
import alfio.model.poll.PollWithOptions;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.repository.AuditingRepository;
import alfio.repository.EventRepository;
import alfio.repository.PollRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketSearchRepository;
import alfio.util.Json;
import alfio.util.PinGenerator;
import ch.digitalfondue.npjt.AffectedRowCountAndKey;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PollManager {
    private final PollRepository pollRepository;
    private final EventRepository eventRepository;
    private final TicketRepository ticketRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final TicketSearchRepository ticketSearchRepository;
    private final AuditingRepository auditingRepository;

    public Result<List<Poll>> getActiveForEvent(String eventName, String pin) {
        return this.validatePinAndEvent(pin, eventName).flatMap(eventAndTicket -> Result.success((Object)this.pollRepository.findActiveForEvent(((EventAndOrganizationId)eventAndTicket.getLeft()).getId())));
    }

    public Result<PollWithOptions> getSingleActiveForEvent(String eventName, Long id, String pin) {
        return this.validatePinAndEvent(pin, eventName).flatMap(eventAndTicket -> {
            Optional optionalPoll = this.pollRepository.findSingleActiveForEvent(((EventAndOrganizationId)eventAndTicket.getLeft()).getId(), id);
            if (optionalPoll.isEmpty()) {
                return Result.error((ErrorCode)ErrorCode.custom((String)"not_found", (String)""));
            }
            return Result.success((Object)new PollWithOptions((Poll)optionalPoll.get(), this.pollRepository.getOptionsForPoll(id.longValue())));
        });
    }

    public Result<Boolean> registerAnswer(String eventName, Long pollId, Long optionId, String pin) {
        if (pollId == null || optionId == null) {
            return Result.error((ErrorCode)ErrorCode.custom((String)"not_found", (String)""));
        }
        return this.validatePinAndEvent(pin, eventName).flatMap(eventAndTicket -> {
            EventAndOrganizationId event = (EventAndOrganizationId)eventAndTicket.getLeft();
            Ticket ticket = (Ticket)eventAndTicket.getRight();
            Validate.isTrue((this.pollRepository.checkPollOption(optionId.longValue(), pollId.longValue(), event.getId()) == 1 ? 1 : 0) != 0, (String)"Invalid selection", (Object[])new Object[0]);
            Validate.isTrue((this.pollRepository.registerAnswer(pollId.longValue(), optionId.longValue(), ticket.getId(), event.getOrganizationId()) == 1 ? 1 : 0) != 0, (String)"Unexpected error while inserting answer", (Object[])new Object[0]);
            return Result.success((Object)true);
        });
    }

    public List<Poll> getAllForEvent(String eventName) {
        Optional eventOptional = this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName);
        if (eventOptional.isEmpty()) {
            return List.of();
        }
        return this.pollRepository.findAllForEvent(((EventAndOrganizationId)eventOptional.get()).getId());
    }

    public Optional<PollWithOptions> getSingleForEvent(Long pollId, String eventName) {
        return this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName).flatMap(event -> this.getSingleForEvent(pollId, event));
    }

    private Optional<PollWithOptions> getSingleForEvent(Long pollId, EventAndOrganizationId event) {
        return this.pollRepository.findSingleForEvent(event.getId(), Objects.requireNonNull(pollId)).map(poll -> new PollWithOptions(poll, this.pollRepository.getOptionsForPoll(pollId.longValue())));
    }

    public Optional<Long> createNewPoll(String eventName, PollModification form) {
        Validate.isTrue((boolean)form.isValid());
        return this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName).map(event -> {
            List tags = form.isAccessRestricted() ? List.of(UUID.randomUUID().toString()) : List.of();
            AffectedRowCountAndKey pollKey = this.pollRepository.insert(form.getTitle(), Objects.requireNonNullElse(form.getDescription(), Map.of()), tags, form.getOrder(), event.getId(), event.getOrganizationId());
            Validate.isTrue((pollKey.getAffectedRowCount() == 1 ? 1 : 0) != 0);
            this.insertOptions(form.getOptions(), event, (Long)pollKey.getKey());
            return (Long)pollKey.getKey();
        });
    }

    public boolean deletePoll(EventAndOrganizationId event, Long pollId) {
        Validate.isTrue((pollId != null ? 1 : 0) != 0);
        Validate.isTrue((this.pollRepository.deletePoll(pollId.longValue(), event.getId(), event.getOrganizationId()) == 1 ? 1 : 0) != 0);
        return true;
    }

    public Optional<PollWithOptions> updatePoll(String eventName, PollModification form) {
        Validate.isTrue((boolean)form.isValid(form.getId()));
        return this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName).flatMap(event -> {
            List existingOptions;
            Long pollId = form.getId();
            PollWithOptions existingPollWithOptions = (PollWithOptions)this.getSingleForEvent(pollId, event).orElseThrow();
            Poll existingPoll = existingPollWithOptions.getPoll();
            List tags = existingPoll.getAllowedTags();
            if (form.isAccessRestricted() == existingPoll.getAllowedTags().isEmpty()) {
                tags = form.isAccessRestricted() ? List.of(UUID.randomUUID().toString()) : List.of();
            }
            Validate.isTrue((this.pollRepository.update(form.getTitle(), form.getDescription(), tags, form.getOrder(), pollId.longValue(), event.getId()) == 1 ? 1 : 0) != 0);
            List newOptions = form.getOptions().stream().filter(pm -> pm.getId() == null).collect(Collectors.toList());
            if (!newOptions.isEmpty()) {
                this.insertOptions(newOptions, event, pollId);
            }
            if (!(existingOptions = form.getOptions().stream().filter(pm -> pm.getId() != null).collect(Collectors.toList())).isEmpty()) {
                this.updateOptions(existingOptions, event, pollId);
            }
            return this.getSingleForEvent(pollId, event);
        });
    }

    public Optional<PollWithOptions> updateStatus(Long pollId, EventAndOrganizationId event, Poll.PollStatus newStatus) {
        Validate.isTrue((newStatus != Poll.PollStatus.DRAFT ? 1 : 0) != 0, (String)"can't revert to draft", (Object[])new Object[0]);
        Validate.isTrue((this.pollRepository.updateStatus(newStatus, pollId, event.getId()) == 1 ? 1 : 0) != 0, (String)"Error while updating status", (Object[])new Object[0]);
        return this.getSingleForEvent(pollId, event);
    }

    public Optional<List<PollParticipant>> searchTicketsToAllow(EventAndOrganizationId event, Long pollId, String filter) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)filter));
        return this.pollRepository.findSingleForEvent(event.getId(), pollId).map(p -> this.ticketSearchRepository.filterConfirmedTicketsInEventForPoll(event.getId(), 20, "%" + filter + "%", p.getAllowedTags()));
    }

    public boolean allowTicketsToVote(EventAndOrganizationId event, List<Integer> ids, long pollId) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids));
        Poll poll = (Poll)this.pollRepository.findSingleForEvent(event.getId(), Long.valueOf(pollId)).orElseThrow();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)poll.getAllowedTags()));
        String tag = (String)poll.getAllowedTags().get(0);
        int result = this.ticketRepository.tagTickets(ids, event.getId(), tag);
        Validate.isTrue((ids.size() == result ? 1 : 0) != 0, (String)"Unable to tag tickets", (Object[])new Object[0]);
        int auditingResults = this.auditingRepository.registerTicketTag(ids, List.of(Map.of("tag", tag)));
        Validate.isTrue((auditingResults == ids.size() ? 1 : 0) != 0, (String)"Error while writing auditing", (Object[])new Object[0]);
        return true;
    }

    public List<PollParticipant> removeParticipants(EventAndOrganizationId event, List<Integer> ticketIds, long pollId) {
        Poll poll = (Poll)this.pollRepository.findSingleForEvent(event.getId(), Long.valueOf(pollId)).orElseThrow();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)poll.getAllowedTags()));
        String tag = (String)poll.getAllowedTags().get(0);
        int result = this.ticketRepository.untagTickets(ticketIds, event.getId(), tag);
        Validate.isTrue((result == 1 ? 1 : 0) != 0, (String)"Error while removing tag", (Object[])new Object[0]);
        int auditingResults = this.auditingRepository.registerTicketUntag(ticketIds, List.of(Map.of("tag", tag)));
        Validate.isTrue((auditingResults == ticketIds.size() ? 1 : 0) != 0, (String)"Error while writing auditing", (Object[])new Object[0]);
        return this.ticketRepository.getTicketsForEventByTags(event.getId(), poll.getAllowedTags());
    }

    public Optional<PollWithOptions> removeOption(EventAndOrganizationId event, Long pollId, Long optionId) {
        Poll poll = (Poll)this.pollRepository.findSingleForEvent(event.getId(), pollId).orElseThrow();
        Validate.isTrue((this.pollRepository.deleteOption(pollId.longValue(), optionId.longValue()) == 1 ? 1 : 0) != 0, (String)"Error while deleting option", (Object[])new Object[0]);
        return this.getSingleForEvent(Long.valueOf(poll.getId()), event);
    }

    public List<PollParticipant> fetchAllowedTickets(EventAndOrganizationId event, long pollId) {
        Poll poll = (Poll)this.pollRepository.findSingleForEvent(event.getId(), Long.valueOf(pollId)).orElseThrow();
        return this.ticketRepository.getTicketsForEventByTags(event.getId(), poll.getAllowedTags());
    }

    public Optional<PollStatistics> getStatisticsFor(EventAndOrganizationId event, long pollId) {
        return this.pollRepository.findSingleForEvent(event.getId(), Long.valueOf(pollId)).map(p -> {
            int allowedParticipants = p.getAllowedTags().isEmpty() ? this.eventRepository.findStatisticsFor(event.getId()).getCheckedInTickets() : this.ticketRepository.countTicketsMatchingTagsAndStatus(event.getId(), p.getAllowedTags(), List.of(Ticket.TicketStatus.CHECKED_IN.name())).intValue();
            List statistics = this.pollRepository.getStatisticsFor(Long.valueOf(p.getId()), event.getId());
            return new PollStatistics(statistics.stream().mapToInt(PollOptionStatistics::getVotes).sum(), allowedParticipants, statistics);
        });
    }

    private void insertOptions(List<PollOptionModification> options, EventAndOrganizationId event, Long pollId) {
        if (options.size() == 1) {
            PollOptionModification option2 = options.get(0);
            this.pollRepository.insertOption(pollId, option2.getTitle(), Objects.requireNonNullElse(option2.getDescription(), Map.of()), Integer.valueOf(event.getOrganizationId()));
        } else {
            MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])options.stream().map(option -> new MapSqlParameterSource("pollId", (Object)pollId).addValue("title", (Object)Json.toJson(Objects.requireNonNullElse(option.getTitle(), Map.of()))).addValue("description", (Object)Json.toJson(Objects.requireNonNullElse(option.getDescription(), Map.of()))).addValue("organizationId", (Object)event.getOrganizationId())).toArray(MapSqlParameterSource[]::new);
            int[] results = this.jdbcTemplate.batchUpdate(this.pollRepository.bulkInsertOptions(), (SqlParameterSource[])parameterSources);
            Validate.isTrue((IntStream.of(results).sum() == options.size() ? 1 : 0) != 0, (String)"Unexpected result from update.", (Object[])new Object[0]);
        }
    }

    private void updateOptions(List<PollOptionModification> existingOptions, EventAndOrganizationId event, Long pollId) {
        MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])existingOptions.stream().map(option -> new MapSqlParameterSource("pollId", (Object)pollId).addValue("title", (Object)Json.toJson(Objects.requireNonNullElse(option.getTitle(), Map.of()))).addValue("description", (Object)Json.toJson(Objects.requireNonNullElse(option.getDescription(), Map.of()))).addValue("id", (Object)option.getId())).toArray(MapSqlParameterSource[]::new);
        int[] results = this.jdbcTemplate.batchUpdate(this.pollRepository.bulkUpdateOptions(), (SqlParameterSource[])parameterSources);
        Validate.isTrue((IntStream.of(results).sum() == existingOptions.size() ? 1 : 0) != 0, (String)"Unexpected result from update.", (Object[])new Object[0]);
    }

    private Result<Pair<EventAndOrganizationId, Ticket>> validatePinAndEvent(String pin, String eventName) {
        Optional eventOptional = this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName);
        return new Result.Builder().checkPrecondition(eventOptional::isPresent, (ErrorCode)ErrorCode.EventError.NOT_FOUND).checkPrecondition(() -> PinGenerator.isPinValid((String)pin), ErrorCode.custom((String)"pin.invalid", (String)"")).build(eventOptional::get).flatMap(event -> {
            String partialUuid = PinGenerator.pinToPartialUuid((String)pin);
            List tickets = this.ticketRepository.findByEventIdAndPartialUUIDForUpdate(event.getId(), partialUuid + "%", Ticket.TicketStatus.CHECKED_IN);
            int numResults = tickets.size();
            if (numResults != 1) {
                return Result.error((ErrorCode)ErrorCode.custom((String)(numResults > 1 ? "pin.duplicate" : "pin.invalid"), (String)""));
            }
            return Result.success((Object)Pair.of((Object)event, (Object)((Ticket)tickets.get(0))));
        });
    }

    @ConstructorProperties(value={"pollRepository", "eventRepository", "ticketRepository", "jdbcTemplate", "ticketSearchRepository", "auditingRepository"})
    @Generated
    public PollManager(PollRepository pollRepository, EventRepository eventRepository, TicketRepository ticketRepository, NamedParameterJdbcTemplate jdbcTemplate, TicketSearchRepository ticketSearchRepository, AuditingRepository auditingRepository) {
        this.pollRepository = pollRepository;
        this.eventRepository = eventRepository;
        this.ticketRepository = ticketRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.ticketSearchRepository = ticketSearchRepository;
        this.auditingRepository = auditingRepository;
    }
}

