/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.form.ReservationCreate;
import alfio.controller.form.ReservationForm;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.EventManager;
import alfio.manager.PromoCodeRequestManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.support.response.ValidatedResponse;
import alfio.model.Event;
import alfio.model.PromoCodeDiscount;
import alfio.model.PromoCodeUsageResult;
import alfio.model.PurchaseContext;
import alfio.model.SpecialPrice;
import alfio.model.TicketCategory;
import alfio.model.modification.TicketReservationModification;
import alfio.model.result.ValidationResult;
import alfio.repository.EventRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.SpecialPriceRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.util.ClockProvider;
import alfio.util.RequestUtils;
import alfio.util.ReservationUtil;
import java.beans.ConstructorProperties;
import java.security.Principal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.stereotype.Component;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.context.request.ServletWebRequest;

@Component
public class PromoCodeRequestManager {
    private final SpecialPriceRepository specialPriceRepository;
    private final PromoCodeDiscountRepository promoCodeRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final EventManager eventManager;
    private final EventRepository eventRepository;
    private final TicketReservationManager ticketReservationManager;
    private final ClockProvider clockProvider;
    private final AdditionalServiceManager additionalServiceManager;

    public Optional<String> createReservationFromPromoCode(String eventName, String code, BiConsumer<String, String> queryStringHandler, Function<Pair<Optional<String>, BindingResult>, Optional<String>> handleErrors, ServletWebRequest request, Principal principal) {
        String trimmedCode = StringUtils.trimToNull((String)code);
        if (trimmedCode == null) {
            return Optional.empty();
        }
        return this.eventRepository.findOptionalByShortName(eventName).flatMap(e -> {
            ValidatedResponse checkedCode = this.checkCode(e, trimmedCode);
            PromoCodeType codeType = this.checkPromoCodeType(e.getId(), trimmedCode);
            Optional maybePromoCodeDiscount = (Optional)((Pair)checkedCode.getValue()).getRight();
            if (checkedCode.isSuccess() && codeType == PromoCodeType.PROMO_CODE_DISCOUNT) {
                queryStringHandler.accept("code", trimmedCode);
                return Optional.empty();
            }
            if (codeType == PromoCodeType.TICKET_CATEGORY_CODE) {
                TicketCategory category = (TicketCategory)this.ticketCategoryRepository.findCodeInEvent(e.getId(), trimmedCode).orElseThrow();
                if (!category.isAccessRestricted()) {
                    Pair res = this.makeSimpleReservation(e, category.getId(), trimmedCode, request, maybePromoCodeDiscount, principal);
                    return (Optional)handleErrors.apply(res);
                }
                Optional specialPrice = this.specialPriceRepository.findActiveNotAssignedByCategoryId(category.getId(), 1).stream().findFirst();
                if (specialPrice.isEmpty()) {
                    queryStringHandler.accept("errors", "error.STEP_1_CODE_NOT_FOUND");
                    return Optional.empty();
                }
                Pair res = this.makeSimpleReservation(e, category.getId(), ((SpecialPrice)specialPrice.get()).getCode(), request, maybePromoCodeDiscount, principal);
                return (Optional)handleErrors.apply(res);
            }
            if (checkedCode.isSuccess() && codeType == PromoCodeType.SPECIAL_PRICE) {
                int ticketCategoryId = ((SpecialPrice)this.specialPriceRepository.getByCode(trimmedCode).orElseThrow()).getTicketCategoryId();
                Pair res = this.makeSimpleReservation(e, ticketCategoryId, trimmedCode, request, maybePromoCodeDiscount, principal);
                return (Optional)handleErrors.apply(res);
            }
            queryStringHandler.accept("errors", "error.STEP_1_CODE_NOT_FOUND");
            return Optional.empty();
        });
    }

    public ValidatedResponse<Triple<Optional<SpecialPrice>, Event, Optional<PromoCodeDiscount>>> checkCode(String eventName, String promoCode) {
        Optional eventOptional = this.eventRepository.findOptionalByShortName(eventName);
        if (eventOptional.isEmpty()) {
            return new ValidatedResponse(ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("eventName", "Event not found.")}), null);
        }
        Event event = (Event)eventOptional.get();
        ValidatedResponse response = this.checkCode(event, promoCode);
        if (response.isSuccess()) {
            Pair value = (Pair)response.getValue();
            return new ValidatedResponse(ValidationResult.success(), (Object)Triple.of((Object)((Optional)value.getLeft()), (Object)event, (Object)((Optional)value.getRight())));
        }
        return new ValidatedResponse(ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("promoCode", "error.STEP_1_CODE_NOT_FOUND", "error.STEP_1_CODE_NOT_FOUND")}), null);
    }

    public ValidatedResponse<Pair<Optional<SpecialPrice>, Optional<PromoCodeDiscount>>> checkCode(Event event, String promoCode) {
        ZoneId eventZoneId = event.getZoneId();
        ZonedDateTime now = ZonedDateTime.now(this.clockProvider.withZone(eventZoneId));
        Optional<String> maybeSpecialCode = Optional.ofNullable(StringUtils.trimToNull((String)promoCode));
        Optional specialCode = maybeSpecialCode.flatMap(arg_0 -> ((SpecialPriceRepository)this.specialPriceRepository).getByCode(arg_0));
        Optional promotionCodeDiscount = maybeSpecialCode.flatMap(trimmedCode -> this.promoCodeRepository.findPublicPromoCodeInEventOrOrganization(event.getId(), trimmedCode));
        Pair result = Pair.of(specialCode, promotionCodeDiscount);
        ValidatedResponse errorResponse = new ValidatedResponse(ValidationResult.failed((ValidationResult.ErrorDescriptor[])new ValidationResult.ErrorDescriptor[]{new ValidationResult.ErrorDescriptor("promoCode", "error.STEP_1_CODE_NOT_FOUND", "error.STEP_1_CODE_NOT_FOUND")}), (Object)result);
        if (specialCode.isPresent()) {
            if (this.eventManager.getOptionalByIdAndActive(((SpecialPrice)specialCode.get()).getTicketCategoryId(), event.getId()).isEmpty()) {
                return errorResponse;
            }
            if (((SpecialPrice)specialCode.get()).getStatus() != SpecialPrice.Status.FREE) {
                return errorResponse;
            }
        } else if (promotionCodeDiscount.isPresent()) {
            PromoCodeDiscount pcd = (PromoCodeDiscount)promotionCodeDiscount.get();
            if (!pcd.isCurrentlyValid(eventZoneId, now) || this.isDiscountCodeUsageExceeded(pcd) || pcd.hasCurrencyCode() && !pcd.getCurrencyCode().equals(event.getCurrency())) {
                return errorResponse;
            }
        } else {
            return errorResponse;
        }
        return new ValidatedResponse(ValidationResult.success(), (Object)result);
    }

    private PromoCodeType checkPromoCodeType(int eventId, String trimmedCode) {
        if (trimmedCode == null) {
            return PromoCodeType.NOT_FOUND;
        }
        if (this.specialPriceRepository.getByCode(trimmedCode).isPresent()) {
            return PromoCodeType.SPECIAL_PRICE;
        }
        if (this.promoCodeRepository.findPublicPromoCodeInEventOrOrganization(eventId, trimmedCode).isPresent()) {
            return PromoCodeType.PROMO_CODE_DISCOUNT;
        }
        if (this.ticketCategoryRepository.findCodeInEvent(eventId, trimmedCode).isPresent()) {
            return PromoCodeType.TICKET_CATEGORY_CODE;
        }
        return PromoCodeType.NOT_FOUND;
    }

    private boolean isDiscountCodeUsageExceeded(PromoCodeDiscount discount) {
        return discount.getMaxUsage() != null && discount.getMaxUsage() <= this.promoCodeRepository.countConfirmedPromoCode(discount.getId());
    }

    private Pair<Optional<String>, BindingResult> makeSimpleReservation(Event event, int ticketCategoryId, String promoCode, ServletWebRequest request, Optional<PromoCodeDiscount> promoCodeDiscount, Principal principal) {
        Locale locale = RequestUtils.getMatchingLocale((ServletWebRequest)request, (Event)event);
        ReservationForm form = new ReservationForm();
        form.setPromoCode(promoCode);
        TicketReservationModification reservation = new TicketReservationModification();
        reservation.setQuantity(Integer.valueOf(1));
        reservation.setTicketCategoryId(Integer.valueOf(ticketCategoryId));
        form.setReservation(Collections.singletonList(reservation));
        BeanPropertyBindingResult bindingRes = new BeanPropertyBindingResult((Object)form, "reservationForm");
        return Pair.of((Object)this.createTicketReservation(form, (BindingResult)bindingRes, event, locale, promoCodeDiscount.map(PromoCodeDiscount::getPromoCode), principal), (Object)bindingRes);
    }

    private Optional<String> createTicketReservation(ReservationForm reservation, BindingResult bindingResult, Event event, Locale locale, Optional<String> promoCodeDiscount, Principal principal) {
        return ReservationUtil.validateCreateRequest((ReservationCreate)reservation, (Errors)bindingResult, (TicketReservationManager)this.ticketReservationManager, (EventManager)this.eventManager, (AdditionalServiceManager)this.additionalServiceManager, (String)promoCodeDiscount.orElse(null), (Event)event).flatMap(selected -> ReservationUtil.handleReservationCreationErrors(() -> this.ticketReservationManager.createTicketReservation(event, (List)selected.getLeft(), (List)selected.getRight(), promoCodeDiscount, locale, principal), (BindingResult)bindingResult, (PurchaseContext.PurchaseContextType)event.getType()));
    }

    public Optional<PromoCodeDiscount> findById(int id) {
        return this.promoCodeRepository.findOptionalById(id);
    }

    public void disablePromoCode(int promoCodeId) {
        this.promoCodeRepository.updateEventPromoCodeEnd(promoCodeId, ZonedDateTime.now(this.clockProvider.getClock()));
    }

    public int countUsage(int promoCodeId) {
        Optional code = this.findById(promoCodeId);
        if (code.isEmpty()) {
            return 0;
        }
        return this.promoCodeRepository.countConfirmedPromoCode(promoCodeId);
    }

    public List<PromoCodeUsageResult> retrieveDetailedUsage(int promoCodeId, Integer eventId) {
        return this.findById(promoCodeId).map(pc -> this.promoCodeRepository.findDetailedUsage(pc.getPromoCode(), eventId)).orElse(List.of());
    }

    @ConstructorProperties(value={"specialPriceRepository", "promoCodeRepository", "ticketCategoryRepository", "eventManager", "eventRepository", "ticketReservationManager", "clockProvider", "additionalServiceManager"})
    @Generated
    public PromoCodeRequestManager(SpecialPriceRepository specialPriceRepository, PromoCodeDiscountRepository promoCodeRepository, TicketCategoryRepository ticketCategoryRepository, EventManager eventManager, EventRepository eventRepository, TicketReservationManager ticketReservationManager, ClockProvider clockProvider, AdditionalServiceManager additionalServiceManager) {
        this.specialPriceRepository = specialPriceRepository;
        this.promoCodeRepository = promoCodeRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.eventManager = eventManager;
        this.eventRepository = eventRepository;
        this.ticketReservationManager = ticketReservationManager;
        this.clockProvider = clockProvider;
        this.additionalServiceManager = additionalServiceManager;
    }
}

