/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.form.ReadOnlyAdditionalFieldsContainer;
import alfio.manager.i18n.MessageSourceManager;
import alfio.model.AdditionalService;
import alfio.model.BookedAdditionalService;
import alfio.model.Event;
import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.PurchaseContextFieldDescription;
import alfio.model.PurchaseContextFieldValue;
import alfio.model.RestrictedValueStats;
import alfio.model.Ticket;
import alfio.model.api.v1.admin.AdditionalInfoRequest;
import alfio.model.modification.AdditionalFieldRequest;
import alfio.model.modification.EventModification;
import alfio.model.modification.TicketFieldDescriptionModification;
import alfio.model.result.ValidationResult;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.repository.AdditionalServiceRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.util.Json;
import alfio.util.LocaleUtil;
import alfio.util.MonetaryUtil;
import alfio.util.Validator;
import java.math.BigDecimal;
import java.time.Clock;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional
public class PurchaseContextFieldManager {
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final AdditionalServiceRepository additionalServiceRepository;
    private final MessageSourceManager messageSourceManager;

    public PurchaseContextFieldManager(PurchaseContextFieldRepository purchaseContextFieldRepository, AdditionalServiceRepository additionalServiceRepository, MessageSourceManager messageSourceManager) {
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.additionalServiceRepository = additionalServiceRepository;
        this.messageSourceManager = messageSourceManager;
    }

    public List<PurchaseContextFieldDescription> findDescriptions(PurchaseContext purchaseContext) {
        return this.purchaseContextFieldRepository.findAllDescriptions(PurchaseContextFieldManager.eventIdOrNull((PurchaseContext)purchaseContext), PurchaseContextFieldManager.descriptorIdOrNull((PurchaseContext)purchaseContext));
    }

    public Map<Long, List<PurchaseContextFieldDescription>> findDescriptionsGroupedByFieldId(PurchaseContext purchaseContext) {
        return this.findDescriptions(purchaseContext).stream().collect(Collectors.groupingBy(PurchaseContextFieldDescription::getFieldConfigurationId));
    }

    public Map<Integer, List<PurchaseContextFieldValue>> findAllValuesByTicketId(Integer ticketId) {
        return this.findAllValuesByTicketIds(List.of(ticketId));
    }

    public Map<Integer, List<PurchaseContextFieldValue>> findAllValuesByTicketIds(Collection<Integer> ticketIds) {
        return this.purchaseContextFieldRepository.findAllValuesByTicketIds(ticketIds).stream().collect(Collectors.groupingBy(PurchaseContextFieldValue::getTicketId));
    }

    public Map<UUID, List<PurchaseContextFieldValue>> findAllValuesBySubscriptionIds(Collection<UUID> subscriptionIds) {
        return this.purchaseContextFieldRepository.findAllValuesBySubscriptionIds(subscriptionIds).stream().collect(Collectors.groupingBy(PurchaseContextFieldValue::getSubscriptionId));
    }

    public List<PurchaseContextFieldConfiguration> findAdditionalFields(PurchaseContext purchaseContext) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return this.purchaseContextFieldRepository.findAdditionalFieldsForEvent(((Event)purchaseContext).getId());
        }
        return this.purchaseContextFieldRepository.findAdditionalFieldsForSubscriptionDescriptor(((SubscriptionDescriptor)purchaseContext).getId());
    }

    public void insertAdditionalField(PurchaseContext purchaseContext, AdditionalFieldRequest f, int order) {
        PurchaseContextFieldConfiguration.Context context;
        String serializedRestrictedValues = PurchaseContextFieldManager.toSerializedRestrictedValues((EventModification.WithRestrictedValues)f);
        int additionalServiceId = -1;
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            Event event = (Event)purchaseContext;
            Optional<EventModification.AdditionalService> linkedAdditionalService = Optional.ofNullable(f.getLinkedAdditionalService());
            additionalServiceId = linkedAdditionalService.map(as -> Optional.ofNullable(as.getId()).orElseGet(() -> this.findAdditionalService(event, as, event.getCurrency()))).orElse(-1);
            context = linkedAdditionalService.isPresent() ? PurchaseContextFieldConfiguration.Context.ADDITIONAL_SERVICE : PurchaseContextFieldConfiguration.Context.ATTENDEE;
        } else {
            context = PurchaseContextFieldConfiguration.Context.SUBSCRIPTION;
        }
        long configurationId = (Long)this.purchaseContextFieldRepository.insertConfiguration(PurchaseContextFieldManager.eventIdOrNull((PurchaseContext)purchaseContext), purchaseContext.getOrganizationId(), PurchaseContextFieldManager.descriptorIdOrNull((PurchaseContext)purchaseContext), f.getName(), order, f.getType(), serializedRestrictedValues, f.getMaxLength(), f.getMinLength(), f.isRequired(), context, Integer.valueOf(additionalServiceId), PurchaseContextFieldManager.generateJsonForList((Collection)f.getLinkedCategoriesIds())).getKey();
        f.getDescription().forEach((locale, value) -> this.purchaseContextFieldRepository.insertDescription(configurationId, locale, Json.GSON.toJson(value), purchaseContext.getOrganizationId()));
    }

    public void updateAdditionalField(long id, EventModification.UpdateAdditionalField f, int organizationId) {
        String serializedRestrictedValues = PurchaseContextFieldManager.toSerializedRestrictedValues((EventModification.WithRestrictedValues)f);
        this.purchaseContextFieldRepository.updateField(id, f.isRequired(), !f.isReadOnly(), serializedRestrictedValues, PurchaseContextFieldManager.toSerializedDisabledValues((EventModification.WithRestrictedValues)f), PurchaseContextFieldManager.generateJsonForList((Collection)f.getLinkedCategoriesIds()));
        f.getDescription().forEach((locale, value) -> {
            String val = Json.GSON.toJson((Object)value.getDescription());
            if (0 == this.purchaseContextFieldRepository.updateDescription(id, locale, val)) {
                this.purchaseContextFieldRepository.insertDescription(id, locale, val, organizationId);
            }
        });
    }

    public ValidationResult validateAndAddField(PurchaseContext purchaseContext, AdditionalFieldRequest field, Errors errors) {
        List fields = purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) ? this.purchaseContextFieldRepository.findAdditionalFieldsForEvent(((Event)purchaseContext).getId()) : this.purchaseContextFieldRepository.findAdditionalFieldsForSubscriptionDescriptor(((SubscriptionDescriptor)purchaseContext).getId());
        return Validator.validateAdditionalFields((List)fields, (AdditionalFieldRequest)field, (Errors)errors).ifSuccess(() -> this.addAdditionalField(purchaseContext, field));
    }

    public void addAdditionalFields(PurchaseContext purchaseContext, List<AdditionalFieldRequest> fields) {
        fields.forEach(field -> this.addAdditionalField(purchaseContext, field));
    }

    public void addAdditionalField(PurchaseContext purchaseContext, AdditionalFieldRequest field) {
        if (field.isUseDefinedOrder()) {
            this.insertAdditionalField(purchaseContext, field, field.getOrder());
        } else {
            Integer order = this.purchaseContextFieldRepository.findMaxOrderValue(PurchaseContextFieldManager.eventIdOrNull((PurchaseContext)purchaseContext), PurchaseContextFieldManager.descriptorIdOrNull((PurchaseContext)purchaseContext));
            this.insertAdditionalField(purchaseContext, field, order == null ? 0 : order + 1);
        }
    }

    public void deleteAdditionalField(long ticketFieldConfigurationId) {
        this.purchaseContextFieldRepository.deleteValues(ticketFieldConfigurationId);
        this.purchaseContextFieldRepository.deleteDescription(ticketFieldConfigurationId);
        this.purchaseContextFieldRepository.deleteField(ticketFieldConfigurationId);
    }

    public void swapAdditionalFieldPosition(long id1, long id2) {
        PurchaseContextFieldConfiguration field1 = this.purchaseContextFieldRepository.findById(id1);
        PurchaseContextFieldConfiguration field2 = this.purchaseContextFieldRepository.findById(id2);
        this.purchaseContextFieldRepository.updateFieldOrder(id1, field2.getOrder());
        this.purchaseContextFieldRepository.updateFieldOrder(id2, field1.getOrder());
    }

    public void setAdditionalFieldPosition(long id, int newPosition) {
        this.purchaseContextFieldRepository.updateFieldOrder(id, newPosition);
    }

    private Integer findAdditionalService(Event event, EventModification.AdditionalService as, String currencyCode) {
        ZoneId utc = Clock.systemUTC().getZone();
        int eventId = event.getId();
        ZoneId eventZoneId = event.getZoneId();
        String checksum = new AdditionalService(0, eventId, as.isFixPrice(), as.getOrdinal(), as.getAvailableQuantity(), as.getMaxQtyPerOrder(), as.getInception().toZonedDateTime(eventZoneId).withZoneSameInstant(utc), as.getExpiration().toZonedDateTime(eventZoneId).withZoneSameInstant(utc), as.getVat(), as.getVatType(), Optional.ofNullable(as.getPrice()).map(p -> MonetaryUtil.unitToCents((BigDecimal)p, (String)currencyCode)).orElse(0), as.getType(), as.getSupplementPolicy(), currencyCode, null, as.getMinPrice() != null ? Integer.valueOf(MonetaryUtil.unitToCents((BigDecimal)as.getMinPrice(), (String)currencyCode)) : null, as.getMaxPrice() != null ? Integer.valueOf(MonetaryUtil.unitToCents((BigDecimal)as.getMaxPrice(), (String)currencyCode)) : null).getChecksum();
        return this.additionalServiceRepository.loadAllForEvent(eventId).stream().filter(as1 -> as1.getChecksum().equals(checksum)).findFirst().map(AdditionalService::id).orElse(null);
    }

    public void updateFieldDescriptions(Map<String, TicketFieldDescriptionModification> descriptions, int organizationId) {
        descriptions.forEach((locale, value) -> {
            String description = Json.GSON.toJson((Object)value.getDescription());
            if (0 == this.purchaseContextFieldRepository.updateDescription(value.getTicketFieldConfigurationId(), locale, description)) {
                this.purchaseContextFieldRepository.insertDescription(value.getTicketFieldConfigurationId(), locale, description, organizationId);
            }
        });
    }

    private static String toSerializedRestrictedValues(EventModification.WithRestrictedValues f) {
        return AdditionalInfoRequest.WITH_RESTRICTED_VALUES.contains(f.getType()) ? PurchaseContextFieldManager.generateJsonForList((Collection)f.getRestrictedValuesAsString()) : null;
    }

    private static String toSerializedDisabledValues(EventModification.WithRestrictedValues f) {
        return AdditionalInfoRequest.WITH_RESTRICTED_VALUES.contains(f.getType()) ? PurchaseContextFieldManager.generateJsonForList((Collection)f.getDisabledValuesAsString()) : null;
    }

    private static String generateJsonForList(Collection<?> values) {
        return CollectionUtils.isNotEmpty(values) ? Json.GSON.toJson(values) : null;
    }

    private static Integer eventIdOrNull(PurchaseContext purchaseContext) {
        return purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) ? Integer.valueOf(((Event)purchaseContext).getId()) : null;
    }

    private static UUID descriptorIdOrNull(PurchaseContext purchaseContext) {
        return purchaseContext.ofType(PurchaseContext.PurchaseContextType.subscription) ? ((SubscriptionDescriptor)purchaseContext).getId() : null;
    }

    public List<RestrictedValueStats> retrieveStats(long id) {
        return this.purchaseContextFieldRepository.retrieveStats(id);
    }

    public void updateFieldsForReservation(ReadOnlyAdditionalFieldsContainer form, PurchaseContext purchaseContext, Integer ticketId, UUID subscriptionId) {
        this.purchaseContextFieldRepository.updateOrInsert(form.getAdditional(), purchaseContext, ticketId, subscriptionId);
    }

    public List<FieldConfigurationDescriptionAndValue> getFieldDescriptionAndValues(PurchaseContext purchaseContext, Ticket ticket, Subscription subscription, List<BookedAdditionalService> additionalServiceItems, String userLanguage, boolean formatValues) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            return this.getFieldDescriptionAndValuesForTicket(ticket, additionalServiceItems, (Event)purchaseContext, formatValues);
        }
        return this.getFieldDescriptionAndValuesForSubscription(subscription, (SubscriptionDescriptor)purchaseContext, userLanguage, formatValues);
    }

    private String extractValue(Map<String, PurchaseContextFieldValue> values, PurchaseContextFieldConfiguration fieldConfiguration, boolean transformValue, MessageSource messageSource, Locale locale) {
        return Optional.ofNullable(values.get(fieldConfiguration.getName())).map(pc -> {
            String value = StringUtils.trimToEmpty((String)pc.getValue());
            if (transformValue && fieldConfiguration.isDateOfBirth() && !value.isEmpty()) {
                return LocalDate.parse(value).format(DateTimeFormatter.ofPattern(messageSource.getMessage("common.date-format", null, locale), locale));
            }
            return value;
        }).orElse("");
    }

    private List<FieldConfigurationDescriptionAndValue> getFieldDescriptionAndValuesForTicket(Ticket ticket, List<BookedAdditionalService> additionalServiceItems, Event event, boolean formatValues) {
        Map descriptions = this.purchaseContextFieldRepository.findTranslationsFor(LocaleUtil.forLanguageTag((String)ticket.getUserLanguage()), ticket.getEventId());
        Map values = this.purchaseContextFieldRepository.findAllByTicketIdGroupedByName(Integer.valueOf(ticket.getId()), event.supportsLinkedAdditionalServices());
        Set additionalServiceIds = additionalServiceItems.stream().map(BookedAdditionalService::getAdditionalServiceId).collect(Collectors.toSet());
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor(event.getOrganizationId(), event.getId());
        Locale locale = Locale.forLanguageTag(ticket.getUserLanguage());
        return this.purchaseContextFieldRepository.findAdditionalFieldsForEvent(ticket.getEventId()).stream().filter(f -> {
            if (f.getContext() == PurchaseContextFieldConfiguration.Context.ATTENDEE) return true;
            if (!Optional.ofNullable(f.getAdditionalServiceId()).filter(additionalServiceIds::contains).isPresent()) return false;
            return true;
        }).filter(f -> CollectionUtils.isEmpty((Collection)f.getCategoryIds()) || f.getCategoryIds().contains(ticket.getCategoryId())).map(f -> {
            int count = Math.max(1, Optional.ofNullable(f.getAdditionalServiceId()).map(id -> (int)additionalServiceItems.stream().filter(i -> i.getAdditionalServiceId() == id.intValue()).count()).orElse(f.getCount()));
            return new FieldConfigurationDescriptionAndValue(f, descriptions.getOrDefault(f.getId(), PurchaseContextFieldDescription.MISSING_FIELD), count, this.extractValue(values, f, formatValues, messageSource, locale));
        }).collect(Collectors.toList());
    }

    private List<FieldConfigurationDescriptionAndValue> getFieldDescriptionAndValuesForSubscription(Subscription subscription, SubscriptionDescriptor descriptor, String userLanguage, boolean formatValues) {
        Map descriptions = this.findDescriptionsGroupedByFieldId((PurchaseContext)descriptor);
        Map values = this.purchaseContextFieldRepository.findAllValuesBySubscriptionIds(List.of(subscription.getId())).stream().collect(Collectors.toMap(PurchaseContextFieldValue::getName, Function.identity()));
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)descriptor);
        Locale locale = Locale.forLanguageTag(userLanguage);
        return this.purchaseContextFieldRepository.findAdditionalFieldsForSubscriptionDescriptor(descriptor.getId()).stream().map(f -> {
            Optional<PurchaseContextFieldDescription> description = descriptions.getOrDefault(f.getId(), List.of()).stream().filter(d -> userLanguage.equals(d.getLocale())).findFirst();
            return new FieldConfigurationDescriptionAndValue(f, description.orElse(PurchaseContextFieldDescription.MISSING_FIELD), 1, this.extractValue(values, f, formatValues, messageSource, locale));
        }).collect(Collectors.toList());
    }
}

