/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.PurchaseContextManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.model.PurchaseContext;
import alfio.model.TicketReservation;
import alfio.repository.EventRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketReservationRepository;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class PurchaseContextManager {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContextManager.class);
    private final EventRepository eventRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final TicketReservationRepository ticketReservationRepository;

    public PurchaseContextManager(EventRepository eventRepository, SubscriptionRepository subscriptionRepository, TicketReservationRepository ticketReservationRepository) {
        this.eventRepository = eventRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.ticketReservationRepository = ticketReservationRepository;
    }

    public Optional<? extends PurchaseContext> findBy(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier) {
        return switch (1.$SwitchMap$alfio$model$PurchaseContext$PurchaseContextType[purchaseContextType.ordinal()]) {
            case 1 -> this.eventRepository.findOptionalByShortName(publicIdentifier);
            case 2 -> this.subscriptionRepository.findOne(UUID.fromString(publicIdentifier));
            default -> throw new IllegalStateException("not a covered type " + purchaseContextType);
        };
    }

    Optional<? extends PurchaseContext> findById(PurchaseContext.PurchaseContextType purchaseContextType, String idAsString) {
        return switch (1.$SwitchMap$alfio$model$PurchaseContext$PurchaseContextType[purchaseContextType.ordinal()]) {
            case 1 -> this.eventRepository.findOptionalById(Integer.parseInt(idAsString));
            case 2 -> this.subscriptionRepository.findOne(UUID.fromString(idAsString));
            default -> throw new IllegalStateException("not a covered type " + purchaseContextType);
        };
    }

    public Optional<PurchaseContext> findByReservationId(String reservationId) {
        return this.ticketReservationRepository.findEventIdFor(reservationId).map(arg_0 -> ((EventRepository)this.eventRepository).findById(arg_0)).map(PurchaseContext.class::cast).or(() -> this.subscriptionRepository.findDescriptorByReservationId(reservationId));
    }

    public Optional<ConfigurationLevel> detectConfigurationLevel(String eventShortName, String subscriptionId) {
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{eventShortName, subscriptionId})) {
            return Optional.empty();
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)eventShortName)) {
                return this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventShortName).map(ConfigurationLevel::event);
            }
            return this.subscriptionRepository.findOrganizationIdForSubscription(UUID.fromString(subscriptionId)).map(ConfigurationLevel::organization);
        }
        catch (Exception ex) {
            log.warn("error while loading ConfigurationLevel", (Throwable)ex);
            return Optional.empty();
        }
    }

    public Optional<Pair<PurchaseContext, TicketReservation>> getReservationWithPurchaseContext(String reservationId) {
        return this.findByReservationId(reservationId).map(event -> Pair.of((Object)event, (Object)this.ticketReservationRepository.findReservationById(reservationId)));
    }

    public int getOrganizationId(PurchaseContext.PurchaseContextType purchaseContextType, String publicIdentifier) {
        if (purchaseContextType == PurchaseContext.PurchaseContextType.event) {
            return this.eventRepository.findOrganizationIdByShortName(publicIdentifier);
        }
        return (Integer)this.subscriptionRepository.findOrganizationIdForDescriptor(UUID.fromString(publicIdentifier)).orElseThrow();
    }
}

