/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.model.Event;
import alfio.model.PurchaseContext;
import alfio.model.ReservationPaymentDetail;
import alfio.model.TicketReservation;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.transaction.PaymentProxy;
import alfio.repository.TicketSearchRepository;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class PurchaseContextSearchManager {
    private static final int PAGE_SIZE = 50;
    private static final List<String> SUPPORTED_PAYMENT_METHODS = EnumSet.complementOf(EnumSet.of(PaymentProxy.NONE, PaymentProxy.ADMIN)).stream().map(Enum::name).collect(Collectors.toUnmodifiableList());
    private final TicketSearchRepository ticketSearchRepository;

    public Pair<List<TicketReservation>, Integer> findAllReservationsFor(PurchaseContext purchaseContext, Integer page, String search, List<TicketReservation.TicketReservationStatus> status) {
        int offset = page == null ? 0 : page * 50;
        Object toSearch = StringUtils.trimToNull((String)search);
        toSearch = toSearch == null ? null : "%" + (String)toSearch + "%";
        List toFilter = (status == null || status.isEmpty() ? Arrays.asList(TicketReservation.TicketReservationStatus.values()) : status).stream().map(Enum::toString).collect(Collectors.toList());
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            Event event = (Event)purchaseContext;
            List reservationsForEvent = this.ticketSearchRepository.findReservationsForEvent(event.getId(), offset, 50, (String)toSearch, toFilter);
            return Pair.of((Object)reservationsForEvent, (Object)this.ticketSearchRepository.countReservationsForEvent(event.getId(), (String)toSearch, toFilter));
        }
        SubscriptionDescriptor subscription = (SubscriptionDescriptor)purchaseContext;
        List reservationsForSubscription = this.ticketSearchRepository.findReservationsForSubscription(subscription.getId(), offset, 50, (String)toSearch, toFilter);
        return Pair.of((Object)reservationsForSubscription, (Object)this.ticketSearchRepository.countReservationsForSubscription(subscription.getId(), (String)toSearch, toFilter));
    }

    public Pair<List<ReservationPaymentDetail>, Integer> findAllPaymentsFor(PurchaseContext purchaseContext, Integer page, String search) {
        int offset = page == null ? 0 : page * 50;
        Object toSearch = StringUtils.trimToNull((String)search);
        toSearch = toSearch == null ? null : "%" + (String)toSearch + "%";
        List<String> toFilter = List.of(TicketReservation.TicketReservationStatus.COMPLETE.name());
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            Event event = (Event)purchaseContext;
            List reservationsForEvent = this.ticketSearchRepository.findAllPaymentsForEvent(event.getId(), offset, 50, (String)toSearch, toFilter, SUPPORTED_PAYMENT_METHODS);
            return Pair.of((Object)reservationsForEvent, (Object)this.ticketSearchRepository.countConfirmedPaymentsForEvent(event.getId(), (String)toSearch, toFilter, SUPPORTED_PAYMENT_METHODS));
        }
        throw new UnsupportedOperationException("not implemented");
    }

    public List<ReservationPaymentDetail> findAllPaymentsForExport(PurchaseContext purchaseContext, String search) {
        Object toSearch = StringUtils.trimToNull((String)search);
        toSearch = toSearch == null ? null : "%" + (String)toSearch + "%";
        List<String> toFilter = List.of(TicketReservation.TicketReservationStatus.COMPLETE.name());
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            Event event = (Event)purchaseContext;
            return this.ticketSearchRepository.findAllEventPaymentsForExport(event.getId(), (String)toSearch, toFilter, SUPPORTED_PAYMENT_METHODS);
        }
        throw new UnsupportedOperationException("not implemented");
    }

    @ConstructorProperties(value={"ticketSearchRepository"})
    @Generated
    public PurchaseContextSearchManager(TicketSearchRepository ticketSearchRepository) {
        this.ticketSearchRepository = ticketSearchRepository;
    }
}

