/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.BillingDocumentManager;
import alfio.manager.ExtensionManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.ReservationFinalizer;
import alfio.manager.WaitingQueueManager;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.FeeCalculator;
import alfio.manager.support.IncompatibleStateException;
import alfio.manager.support.RetryFinalizeReservation;
import alfio.manager.support.reservation.OrderSummaryGenerator;
import alfio.manager.support.reservation.ReservationAuditingHelper;
import alfio.manager.support.reservation.ReservationCostCalculator;
import alfio.manager.support.reservation.ReservationEmailContentHelper;
import alfio.manager.system.AdminJobExecutor;
import alfio.manager.system.AdminJobManager;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.AdditionalServiceItem;
import alfio.model.AllocationStatus;
import alfio.model.Audit;
import alfio.model.Configurable;
import alfio.model.CustomerName;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.OrderSummary;
import alfio.model.PurchaseContext;
import alfio.model.ReservationMetadata;
import alfio.model.SpecialPrice;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.TotalPrice;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.metadata.TicketMetadata;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.modification.TransactionMetadataModification;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.support.UserIdAndOrganizationId;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.command.FinalizeReservation;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.Transaction;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.AuditingRepository;
import alfio.repository.SpecialPriceRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TransactionRepository;
import alfio.repository.system.AdminJobQueueRepository;
import alfio.repository.user.UserRepository;
import alfio.util.ClockProvider;
import alfio.util.Json;
import alfio.util.LocaleUtil;
import alfio.util.MiscUtils;
import alfio.util.ReservationUtil;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalUnit;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ReservationFinalizer {
    private static final Logger log = LoggerFactory.getLogger(ReservationFinalizer.class);
    private final TransactionTemplate transactionTemplate;
    private final TicketReservationRepository ticketReservationRepository;
    private final UserRepository userRepository;
    private final ExtensionManager extensionManager;
    private final AuditingRepository auditingRepository;
    private final ClockProvider clockProvider;
    private final ConfigurationManager configurationManager;
    private final SubscriptionRepository subscriptionRepository;
    private final ReservationAuditingHelper auditingHelper;
    private final TicketRepository ticketRepository;
    private final ReservationEmailContentHelper reservationOperationHelper;
    private final SpecialPriceRepository specialPriceRepository;
    private final WaitingQueueManager waitingQueueManager;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final ReservationCostCalculator reservationCostCalculator;
    private final BillingDocumentManager billingDocumentManager;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final OrderSummaryGenerator orderSummaryGenerator;
    private final ReservationEmailContentHelper reservationHelper;
    private final TransactionRepository transactionRepository;
    private final AdminJobQueueRepository adminJobQueueRepository;
    private final PurchaseContextManager purchaseContextManager;
    private final Json json;

    public ReservationFinalizer(PlatformTransactionManager transactionManager, TicketReservationRepository ticketReservationRepository, UserRepository userRepository, ExtensionManager extensionManager, AuditingRepository auditingRepository, ClockProvider clockProvider, ConfigurationManager configurationManager, SubscriptionRepository subscriptionRepository, TicketRepository ticketRepository, ReservationEmailContentHelper reservationEmailContentHelper, SpecialPriceRepository specialPriceRepository, WaitingQueueManager waitingQueueManager, TicketCategoryRepository ticketCategoryRepository, ReservationCostCalculator reservationCostCalculator, BillingDocumentManager billingDocumentManager, AdditionalServiceItemRepository additionalServiceItemRepository, OrderSummaryGenerator orderSummaryGenerator, TransactionRepository transactionRepository, AdminJobQueueRepository adminJobQueueRepository, PurchaseContextManager purchaseContextManager, Json json) {
        this.ticketReservationRepository = ticketReservationRepository;
        this.userRepository = userRepository;
        this.extensionManager = extensionManager;
        this.auditingRepository = auditingRepository;
        this.clockProvider = clockProvider;
        this.configurationManager = configurationManager;
        this.subscriptionRepository = subscriptionRepository;
        this.ticketRepository = ticketRepository;
        this.reservationOperationHelper = reservationEmailContentHelper;
        this.specialPriceRepository = specialPriceRepository;
        this.waitingQueueManager = waitingQueueManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.reservationCostCalculator = reservationCostCalculator;
        this.billingDocumentManager = billingDocumentManager;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.transactionRepository = transactionRepository;
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(3);
        this.transactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)definition);
        this.orderSummaryGenerator = orderSummaryGenerator;
        this.reservationHelper = reservationEmailContentHelper;
        this.auditingHelper = new ReservationAuditingHelper(auditingRepository);
        this.adminJobQueueRepository = adminJobQueueRepository;
        this.purchaseContextManager = purchaseContextManager;
        this.json = json;
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT)
    public void finalizeCommandReceived(FinalizeReservation finalizeReservation) {
        this.transactionTemplate.executeWithoutResult(ctx -> this.processFinalizeReservation(finalizeReservation, ctx, true));
    }

    public void retryFinalizeReservation(RetryFinalizeReservation retryFinalizeReservation) {
        Pair purchaseContextAndReservation = (Pair)this.purchaseContextManager.getReservationWithPurchaseContext(retryFinalizeReservation.getReservationId()).orElseThrow();
        TicketReservation reservation = (TicketReservation)purchaseContextAndReservation.getRight();
        PurchaseContext purchaseContext = (PurchaseContext)purchaseContextAndReservation.getLeft();
        Pair costResult = this.reservationCostCalculator.totalReservationCostWithVAT(reservation);
        TotalPrice totalPrice = (TotalPrice)costResult.getLeft();
        OrderSummary orderSummary = this.orderSummaryGenerator.orderSummaryForReservation(reservation, purchaseContext);
        PaymentSpecification paymentSpecification = new PaymentSpecification(reservation, totalPrice, purchaseContext, null, orderSummary, retryFinalizeReservation.isTcAccepted(), retryFinalizeReservation.isPrivacyPolicyAccepted());
        this.transactionTemplate.executeWithoutResult(ctx -> this.processFinalizeReservation(new FinalizeReservation(paymentSpecification, retryFinalizeReservation.getPaymentProxy(), retryFinalizeReservation.isSendReservationConfirmationEmail(), retryFinalizeReservation.isSendTickets(), retryFinalizeReservation.getUsername(), retryFinalizeReservation.getOriginalStatus()), ctx, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinalizeReservation(FinalizeReservation finalizeReservation, TransactionStatus ctx, boolean scheduleRetryOnError) {
        Object savepoint = ctx.createSavepoint();
        PaymentSpecification spec = finalizeReservation.getPaymentSpecification();
        try {
            TicketReservation reservation = this.ticketReservationRepository.findReservationById(spec.getReservationId());
            Pair totalPrice = this.reservationCostCalculator.totalReservationCostWithVAT(reservation);
            ReservationMetadata metadata = this.ticketReservationRepository.getMetadata(reservation.getId());
            if (reservation.getStatus() != TicketReservation.TicketReservationStatus.COMPLETE && StringUtils.isBlank((CharSequence)reservation.getInvoiceNumber()) && !metadata.isReadyForConfirmation()) {
                boolean traceEnabled = log.isTraceEnabled();
                if (traceEnabled) {
                    log.trace("Generating invoice number for reservation {}", (Object)reservation.getId());
                }
                Optional invoiceNumberOptional = this.billingDocumentManager.generateInvoiceNumber(spec, (TotalPrice)totalPrice.getKey());
                invoiceNumberOptional.ifPresent(s -> this.setInvoiceNumber(spec.getReservationId(), s));
            }
            this.ticketReservationRepository.setMetadata(reservation.getId(), metadata.withReadyForConfirmation(true));
            ctx.releaseSavepoint(savepoint);
            savepoint = ctx.createSavepoint();
            this.completeReservation(finalizeReservation);
        }
        catch (Exception e) {
            ctx.rollbackToSavepoint(savepoint);
            if (!scheduleRetryOnError) {
                throw e;
            }
            boolean scheduled = (Boolean)AdminJobManager.executionScheduler((AdminJobExecutor.JobName)AdminJobExecutor.JobName.RETRY_RESERVATION_CONFIRMATION, Map.of("payload", this.json.asJsonString((Object)RetryFinalizeReservation.fromFinalizeReservation((FinalizeReservation)finalizeReservation))), (ZonedDateTime)ZonedDateTime.now(this.clockProvider.getClock()).plusSeconds(2L)).apply(this.adminJobQueueRepository);
            if (!scheduled) {
                log.warn("Cannot schedule retry for reservation {}", (Object)spec.getReservationId());
                throw e;
            }
            log.warn("Error while confirming reservation " + spec.getReservationId() + ". Will retry in 2s", (Throwable)e);
        }
        finally {
            ctx.releaseSavepoint(savepoint);
        }
    }

    private void setInvoiceNumber(String reservationId, String invoiceNumber) {
        if (log.isTraceEnabled()) {
            log.trace("Set invoice number {} for reservation {}", (Object)invoiceNumber, (Object)reservationId);
        }
        this.ticketReservationRepository.setInvoiceNumber(reservationId, invoiceNumber);
    }

    private void completeReservation(FinalizeReservation finalizeReservation) {
        PaymentSpecification spec = finalizeReservation.getPaymentSpecification();
        PaymentProxy paymentProxy = finalizeReservation.getPaymentProxy();
        String username = finalizeReservation.getUsername();
        String reservationId = spec.getReservationId();
        PurchaseContext purchaseContext = spec.getPurchaseContext();
        TicketReservation reservation = this.ticketReservationRepository.findReservationById(reservationId);
        if (reservation.getStatus() == TicketReservation.TicketReservationStatus.COMPLETE) {
            log.warn("Ignoring completeReservation for reservation {} with status COMPLETE", (Object)reservationId);
            return;
        }
        if (reservation.getStatus() != TicketReservation.TicketReservationStatus.FINALIZING && reservation.getStatus() != TicketReservation.TicketReservationStatus.OFFLINE_FINALIZING) {
            throw new IncompatibleStateException("Status " + reservation.getStatus() + " is not compatible with finalization.");
        }
        ReservationMetadata metadata = this.ticketReservationRepository.getMetadata(reservationId);
        if (!metadata.isReadyForConfirmation()) {
            throw new IncompatibleStateException("Reservation is not ready to be confirmed");
        }
        Integer userId = username != null ? Integer.valueOf(this.userRepository.getByUsername(username).getId()) : (Integer)this.ticketReservationRepository.getReservationOwnerAndOrganizationId(reservationId).map(UserIdAndOrganizationId::getUserId).orElse(null);
        this.ticketReservationRepository.setMetadata(reservationId, metadata.withFinalized(true));
        Locale locale = LocaleUtil.forLanguageTag((String)reservation.getUserLanguage());
        List tickets = null;
        if (paymentProxy != PaymentProxy.OFFLINE) {
            this.ticketReservationRepository.updateReservationStatus(reservationId, TicketReservation.TicketReservationStatus.COMPLETE.name());
            tickets = this.acquireItems(paymentProxy, reservationId, spec.getEmail(), spec.getCustomerName(), spec.getLocale().getLanguage(), spec.getBillingAddress(), spec.getCustomerReference(), spec.getPurchaseContext(), finalizeReservation.isSendTickets());
            this.extensionManager.handleReservationConfirmation(reservation, this.ticketReservationRepository.getBillingDetailsForReservation(reservationId), spec.getPurchaseContext());
        } else {
            this.ticketReservationRepository.updateReservationStatus(reservationId, finalizeReservation.getOriginalStatus().name());
        }
        Date eventTime = new Date();
        this.auditingRepository.insert(reservationId, userId, purchaseContext, Audit.EventType.RESERVATION_COMPLETE, eventTime, Audit.EntityType.RESERVATION, reservationId);
        this.ticketReservationRepository.updateRegistrationTimestamp(reservationId, ZonedDateTime.now(this.clockProvider.withZone(spec.getPurchaseContext().getZoneId())));
        if (spec.isTcAccepted()) {
            this.auditingRepository.insert(reservationId, userId, purchaseContext, Audit.EventType.TERMS_CONDITION_ACCEPTED, eventTime, Audit.EntityType.RESERVATION, reservationId, Collections.singletonList(Collections.singletonMap("termsAndConditionsUrl", spec.getPurchaseContext().getTermsAndConditionsUrl())));
        }
        if (ReservationUtil.hasPrivacyPolicy((PurchaseContext)spec.getPurchaseContext()) && spec.isPrivacyAccepted()) {
            this.auditingRepository.insert(reservationId, userId, purchaseContext, Audit.EventType.PRIVACY_POLICY_ACCEPTED, eventTime, Audit.EntityType.RESERVATION, reservationId, Collections.singletonList(Collections.singletonMap("privacyPolicyUrl", spec.getPurchaseContext().getPrivacyPolicyUrl())));
        }
        if (finalizeReservation.isSendReservationConfirmationEmail()) {
            TicketReservation updatedReservation = this.ticketReservationRepository.findReservationById(reservationId);
            this.sendConfirmationEmailIfNecessary(updatedReservation, tickets, purchaseContext, locale, username);
            this.reservationOperationHelper.sendReservationCompleteEmailToOrganizer(spec.getPurchaseContext(), updatedReservation, locale, username);
        }
    }

    public void sendConfirmationEmailIfNecessary(TicketReservation ticketReservation, List<Ticket> tickets, PurchaseContext purchaseContext, Locale locale, String username) {
        if (!this.ticketReservationRepository.getMetadata(ticketReservation.getId()).isFinalized()) {
            throw new IncompatibleStateException("Reservation confirmed but not yet finalized");
        }
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            Map config = this.configurationManager.getFor(List.of(ConfigurationKeys.SEND_RESERVATION_EMAIL_IF_NECESSARY, ConfigurationKeys.SEND_TICKETS_AUTOMATICALLY), purchaseContext.getConfigurationLevel());
            if (ticketReservation.getSrcPriceCts() > 0 || CollectionUtils.isEmpty(tickets) || tickets.size() > 1 || !tickets.get(0).getEmail().equals(ticketReservation.getEmail()) || !((ConfigurationManager.MaybeConfiguration)config.get(ConfigurationKeys.SEND_RESERVATION_EMAIL_IF_NECESSARY)).getValueAsBooleanOrDefault() || !((ConfigurationManager.MaybeConfiguration)config.get(ConfigurationKeys.SEND_TICKETS_AUTOMATICALLY)).getValueAsBooleanOrDefault()) {
                this.reservationOperationHelper.sendConfirmationEmail(purchaseContext, ticketReservation, locale, username);
            }
        } else {
            this.reservationOperationHelper.sendConfirmationEmail(purchaseContext, ticketReservation, locale, username);
        }
    }

    @Transactional
    public void acquireSpecialPriceTokens(String reservationId) {
        this.internalAcquireSpecialPriceTokens(reservationId);
    }

    private void internalAcquireSpecialPriceTokens(String reservationId) {
        this.specialPriceRepository.updateStatusForReservation(Collections.singletonList(reservationId), SpecialPrice.Status.TAKEN.toString());
    }

    private List<Ticket> acquireItems(PaymentProxy paymentProxy, String reservationId, String email, CustomerName customerName, String userLanguage, String billingAddress, String customerReference, PurchaseContext purchaseContext, boolean sendTickets) {
        switch (1.$SwitchMap$alfio$model$PurchaseContext$PurchaseContextType[purchaseContext.getType().ordinal()]) {
            case 1: {
                this.acquireEventTickets(paymentProxy, reservationId, purchaseContext, (Event)purchaseContext.event().orElseThrow());
                break;
            }
            case 2: {
                this.acquireSubscription(paymentProxy, reservationId, purchaseContext, customerName, email);
                break;
            }
            default: {
                throw new IllegalStateException("not supported purchase context");
            }
        }
        this.internalAcquireSpecialPriceTokens(reservationId);
        ZonedDateTime timestamp = ZonedDateTime.now(this.clockProvider.getClock());
        int updatedReservation = this.ticketReservationRepository.updateTicketReservation(reservationId, TicketReservation.TicketReservationStatus.COMPLETE.toString(), email, customerName.getFullName(), customerName.getFirstName(), customerName.getLastName(), userLanguage, billingAddress, timestamp, paymentProxy.toString(), customerReference);
        Validate.isTrue((updatedReservation == 1 ? 1 : 0) != 0, (String)("expected exactly one updated reservation, got " + updatedReservation), (Object[])new Object[0]);
        this.waitingQueueManager.fireReservationConfirmed(reservationId);
        TicketReservation reservation = (TicketReservation)this.findById(reservationId).orElseThrow(IllegalStateException::new);
        List assignedTickets = this.findTicketsInReservation(reservationId);
        assignedTickets.stream().filter(ticket -> StringUtils.isNotBlank((CharSequence)ticket.getFullName()) || StringUtils.isNotBlank((CharSequence)ticket.getFirstName()) || StringUtils.isNotBlank((CharSequence)ticket.getEmail())).forEach(ticket -> {
            Event event = (Event)purchaseContext.event().orElseThrow();
            Locale locale = LocaleUtil.forLanguageTag((String)ticket.getUserLanguage());
            Map additionalInfo = this.reservationOperationHelper.retrieveAttendeeAdditionalInfoForTicket(ticket);
            if ((paymentProxy != PaymentProxy.ADMIN || sendTickets) && this.configurationManager.getFor(ConfigurationKeys.SEND_TICKETS_AUTOMATICALLY, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsBooleanOrDefault()) {
                this.reservationOperationHelper.sendTicketByEmail(ticket, locale, event, this.reservationHelper.getTicketEmailGenerator(event, reservation, locale, additionalInfo));
            }
            this.extensionManager.handleTicketAssignment(ticket, this.ticketCategoryRepository.getById(ticket.getCategoryId().intValue()), additionalInfo);
        });
        return assignedTickets;
    }

    private void acquireSubscription(PaymentProxy paymentProxy, String reservationId, PurchaseContext purchaseContext, CustomerName customerName, String email) {
        if (log.isDebugEnabled()) {
            log.debug("Acquiring subscriptions for reservation {}; payment method: {}", (Object)MiscUtils.removeTabsAndNewlines((String)reservationId), (Object)paymentProxy);
        }
        SubscriptionDescriptor subscriptionDescriptor = (SubscriptionDescriptor)purchaseContext;
        ZonedDateTime validityFrom = null;
        ZonedDateTime validityTo = null;
        ZonedDateTime confirmationTimestamp = subscriptionDescriptor.now(this.clockProvider);
        if (subscriptionDescriptor.getValidityFrom() != null) {
            validityFrom = subscriptionDescriptor.getValidityFrom();
            validityTo = subscriptionDescriptor.getValidityTo();
        } else if (subscriptionDescriptor.getValidityUnits() != null) {
            validityFrom = confirmationTimestamp;
            TemporalUnit temporalUnit = Objects.requireNonNullElse(subscriptionDescriptor.getValidityTimeUnit(), SubscriptionDescriptor.SubscriptionTimeUnit.DAYS).getTemporalUnit();
            validityTo = confirmationTimestamp.plus(subscriptionDescriptor.getValidityUnits().intValue(), temporalUnit).withHour(23).withMinute(59).withSecond(59);
        }
        Subscription subscription = (Subscription)this.subscriptionRepository.findSubscriptionsByReservationId(reservationId).stream().findFirst().orElseThrow();
        int updatedSubscriptions = this.subscriptionRepository.confirmSubscription(reservationId, AllocationStatus.ACQUIRED, Objects.requireNonNullElse(subscription.getFirstName(), customerName.getFirstName()), Objects.requireNonNullElse(subscription.getLastName(), customerName.getLastName()), Objects.requireNonNullElse(subscription.getEmail(), email), subscriptionDescriptor.getMaxEntries(), validityFrom, validityTo, confirmationTimestamp, subscriptionDescriptor.getTimeZone());
        Validate.isTrue((updatedSubscriptions > 0 ? 1 : 0) != 0, (String)"must have updated at least one subscription", (Object[])new Object[0]);
        subscription = (Subscription)this.subscriptionRepository.findSubscriptionsByReservationId(reservationId).get(0);
        UUID subscriptionId = subscription.getId();
        this.auditingRepository.insert(reservationId, null, purchaseContext, Audit.EventType.SUBSCRIPTION_ACQUIRED, new Date(), Audit.EntityType.SUBSCRIPTION, subscriptionId.toString());
        SubscriptionMetadata originalMetadata = this.subscriptionRepository.getSubscriptionMetadata(subscriptionId);
        this.extensionManager.handleSubscriptionAssignmentMetadata(subscription, subscriptionDescriptor, originalMetadata, this.reservationOperationHelper.retrieveAttendeeAdditionalInfoForSubscription(subscriptionId)).ifPresent(metadata -> {
            SubscriptionMetadata metadataToSave = metadata;
            if (originalMetadata != null) {
                HashMap properties = new HashMap(originalMetadata.getProperties());
                properties.putAll(metadata.getProperties());
                metadataToSave = new SubscriptionMetadata(properties, originalMetadata.getConfiguration());
            }
            this.subscriptionRepository.setMetadataForSubscription(subscriptionId, metadataToSave);
        });
    }

    private void acquireEventTickets(PaymentProxy paymentProxy, String reservationId, PurchaseContext purchaseContext, Event event) {
        Ticket.TicketStatus ticketStatus = paymentProxy.isDeskPaymentRequired() ? Ticket.TicketStatus.TO_BE_PAID : Ticket.TicketStatus.ACQUIRED;
        AdditionalServiceItem.AdditionalServiceItemStatus asStatus = paymentProxy.isDeskPaymentRequired() ? AdditionalServiceItem.AdditionalServiceItemStatus.TO_BE_PAID : AdditionalServiceItem.AdditionalServiceItemStatus.ACQUIRED;
        Map preUpdateTicket = this.ticketRepository.findTicketsInReservation(reservationId).stream().collect(Collectors.toMap(Ticket::getId, Function.identity()));
        int updatedTickets = this.ticketRepository.updateTicketsStatusWithReservationId(reservationId, ticketStatus.toString());
        if (!this.configurationManager.getFor(ConfigurationKeys.ENABLE_TICKET_TRANSFER, purchaseContext.getConfigurationLevel()).getValueAsBooleanOrDefault()) {
            int locked = this.ticketRepository.forbidReassignment(preUpdateTicket.keySet());
            Validate.isTrue((updatedTickets == locked ? 1 : 0) != 0, (String)("Expected to lock " + updatedTickets + " tickets, locked " + locked), (Object[])new Object[0]);
            Map postUpdateTicket = this.ticketRepository.findTicketsInReservation(reservationId).stream().collect(Collectors.toMap(Ticket::getId, Function.identity()));
            postUpdateTicket.forEach((id, ticket) -> this.auditingHelper.auditUpdateTicket((Ticket)preUpdateTicket.get(id), Collections.emptyMap(), ticket, Collections.emptyMap(), event.getId()));
        }
        Map ticketsWithMetadataById = this.ticketRepository.findTicketsInReservationWithMetadata(reservationId).stream().collect(Collectors.toMap(twm -> twm.getTicket().getId(), Function.identity()));
        ticketsWithMetadataById.forEach((id, ticketWithMetadata) -> {
            Optional newMetadataOptional = this.extensionManager.handleTicketAssignmentMetadata(ticketWithMetadata, event, this.reservationOperationHelper.retrieveAttendeeAdditionalInfoForTicket(ticketWithMetadata.getTicket()));
            newMetadataOptional.ifPresent(metadata -> {
                TicketMetadataContainer existingContainer = TicketMetadataContainer.copyOf((TicketMetadataContainer)ticketWithMetadata.getMetadata());
                HashMap general = new HashMap(existingContainer.getMetadataForKey("general").orElseGet(TicketMetadata::empty).getAttributes());
                general.putAll(metadata.getAttributes());
                existingContainer.putMetadata("general", new TicketMetadata(null, null, general));
                this.ticketRepository.updateTicketMetadata(id.intValue(), existingContainer);
                this.auditingHelper.auditUpdateMetadata(reservationId, id.intValue(), event.getId(), existingContainer, ticketWithMetadata.getMetadata());
            });
            this.auditingHelper.auditUpdateTicket((Ticket)preUpdateTicket.get(id), Collections.emptyMap(), ticketWithMetadata.getTicket(), Collections.emptyMap(), event.getId());
        });
        int updatedAS = this.additionalServiceItemRepository.updateItemsStatusWithReservationUUID(event.getId(), reservationId, asStatus);
        Validate.isTrue((updatedTickets + updatedAS > 0 ? 1 : 0) != 0, (String)"no items have been updated", (Object[])new Object[0]);
    }

    public void confirmOfflinePayment(Event event, String reservationId, TransactionMetadataModification transactionMetadataModification, String username) {
        TicketReservation ticketReservation = (TicketReservation)this.findById(reservationId).orElseThrow(IllegalArgumentException::new);
        this.ticketReservationRepository.lockReservationForUpdate(reservationId);
        ReservationMetadata metadata = this.ticketReservationRepository.getMetadata(reservationId);
        if (!metadata.isReadyForConfirmation()) {
            throw new IncompatibleStateException("Reservation is not ready to be confirmed");
        }
        Validate.isTrue((ticketReservation.getPaymentMethod() == PaymentProxy.OFFLINE ? 1 : 0) != 0, (String)"invalid payment method", (Object[])new Object[0]);
        Validate.isTrue((boolean)ticketReservation.isPendingOfflinePayment(), (String)"invalid status", (Object[])new Object[0]);
        this.ticketReservationRepository.confirmOfflinePayment(reservationId, TicketReservation.TicketReservationStatus.COMPLETE.name(), event.now(this.clockProvider));
        this.registerAlfioTransaction(event, reservationId, transactionMetadataModification, PaymentProxy.OFFLINE);
        this.auditingRepository.insert(reservationId, (Integer)this.userRepository.findIdByUserName(username).orElse(null), Integer.valueOf(event.getId()), Audit.EventType.RESERVATION_OFFLINE_PAYMENT_CONFIRMED, new Date(), Audit.EntityType.RESERVATION, ticketReservation.getId());
        this.ticketReservationRepository.setMetadata(reservationId, metadata.withFinalized(true));
        CustomerName customerName = new CustomerName(ticketReservation.getFullName(), ticketReservation.getFirstName(), ticketReservation.getLastName(), event.mustUseFirstAndLastName());
        this.acquireItems(PaymentProxy.OFFLINE, reservationId, ticketReservation.getEmail(), customerName, ticketReservation.getUserLanguage(), ticketReservation.getBillingAddress(), ticketReservation.getCustomerReference(), (PurchaseContext)event, true);
        Locale language = ReservationUtil.getReservationLocale((TicketReservation)ticketReservation);
        TicketReservation finalReservation = this.ticketReservationRepository.findReservationById(reservationId);
        this.billingDocumentManager.createBillingDocument((PurchaseContext)event, finalReservation, username, this.orderSummaryGenerator.orderSummaryForReservation(finalReservation, (PurchaseContext)event));
        Map configuration = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.DEFERRED_BANK_TRANSFER_ENABLED, ConfigurationKeys.DEFERRED_BANK_TRANSFER_SEND_CONFIRMATION_EMAIL), ConfigurationLevel.event((EventAndOrganizationId)event));
        if (!((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.DEFERRED_BANK_TRANSFER_ENABLED)).getValueAsBooleanOrDefault() || ((ConfigurationManager.MaybeConfiguration)configuration.get(ConfigurationKeys.DEFERRED_BANK_TRANSFER_SEND_CONFIRMATION_EMAIL)).getValueAsBooleanOrDefault()) {
            this.reservationHelper.sendConfirmationEmail((PurchaseContext)event, (TicketReservation)this.findById(reservationId).orElseThrow(IllegalArgumentException::new), language, username);
        }
        this.extensionManager.handleReservationConfirmation(finalReservation, this.ticketReservationRepository.getBillingDetailsForReservation(reservationId), (PurchaseContext)event);
    }

    public void registerAlfioTransaction(Event event, String reservationId, TransactionMetadataModification transactionMetadataModification, PaymentProxy paymentProxy) {
        TotalPrice totalPrice = (TotalPrice)this.reservationCostCalculator.totalReservationCostWithVAT(reservationId).getLeft();
        int priceWithVAT = totalPrice.getPriceWithVAT();
        long platformFee = ((Optional)FeeCalculator.getCalculator((Configurable)event, (ConfigurationManager)this.configurationManager, (String)Objects.requireNonNullElse(totalPrice.getCurrencyCode(), event.getCurrency())).apply(this.ticketRepository.countTicketsInReservation(reservationId), Long.valueOf(priceWithVAT))).orElse(0L);
        Optional transactionOptional = this.transactionRepository.loadOptionalByReservationId(reservationId);
        String transactionId = paymentProxy.getKey() + "-" + System.currentTimeMillis();
        ZonedDateTime transactionTimestamp = this.getTransactionTimestamp(event, transactionMetadataModification);
        if (transactionOptional.isEmpty()) {
            this.transactionRepository.insert(transactionId, null, reservationId, transactionTimestamp, priceWithVAT, event.getCurrency(), "Offline payment confirmed for " + reservationId, paymentProxy.getKey(), platformFee, 0L, Transaction.Status.COMPLETE, this.buildTransactionMetadata(transactionMetadataModification));
        } else if (paymentProxy == PaymentProxy.OFFLINE) {
            Transaction transaction = (Transaction)transactionOptional.get();
            this.transactionRepository.update(transaction.getId(), transactionId, null, transactionTimestamp, platformFee, 0L, Transaction.Status.COMPLETE, this.buildTransactionMetadata(transactionMetadataModification));
        } else if (log.isWarnEnabled()) {
            log.warn("ON-Site check-in: ignoring transaction registration for reservationId {}", (Object)MiscUtils.removeTabsAndNewlines((String)reservationId));
        }
    }

    private ZonedDateTime getTransactionTimestamp(Event event, TransactionMetadataModification transactionMetadataModification) {
        if (transactionMetadataModification != null && transactionMetadataModification.getTimestamp() != null) {
            return transactionMetadataModification.getTimestamp().toLocalDateTime().atZone(event.getZoneId());
        }
        return event.now(this.clockProvider);
    }

    private Map<String, String> buildTransactionMetadata(TransactionMetadataModification transactionMetadataModification) {
        if (transactionMetadataModification != null && StringUtils.isNotBlank((CharSequence)transactionMetadataModification.getNotes())) {
            return Map.of("transactionNotes", transactionMetadataModification.getNotes());
        }
        return Map.of();
    }

    private Optional<TicketReservation> findById(String reservationId) {
        return this.ticketReservationRepository.findOptionalReservationById(reservationId);
    }

    private List<Ticket> findTicketsInReservation(String reservationId) {
        return this.ticketRepository.findTicketsInReservation(reservationId);
    }
}

