/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.form.ContactAndTicketsForm;
import alfio.controller.support.CustomBindingResult;
import alfio.manager.EuVatChecker;
import alfio.manager.ReverseChargeManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.system.ReservationPriceCalculator;
import alfio.model.Audit;
import alfio.model.Configurable;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.VatDetail;
import alfio.model.decorator.TicketPriceContainer;
import alfio.model.extension.CustomTaxPolicy;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.AdditionalServiceItemRepository;
import alfio.repository.AdditionalServiceRepository;
import alfio.repository.AuditingRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ReverseChargeManager {
    private static final Logger log = LoggerFactory.getLogger(ReverseChargeManager.class);
    private final PromoCodeDiscountRepository promoCodeDiscountRepository;
    private final AdditionalServiceItemRepository additionalServiceItemRepository;
    private final AdditionalServiceRepository additionalServiceRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final ConfigurationManager configurationManager;
    private final TicketReservationRepository ticketReservationRepository;
    private final EuVatChecker vatChecker;
    private final TicketReservationManager ticketReservationManager;
    private final TicketRepository ticketRepository;
    private final SubscriptionRepository subscriptionRepository;
    private final AuditingRepository auditingRepository;

    public void checkAndApplyVATRules(PurchaseContext purchaseContext, String reservationId, ContactAndTicketsForm contactAndTicketsForm, BindingResult bindingResult) {
        boolean isEvent;
        String country = contactAndTicketsForm.getVatCountryCode();
        Map reverseChargeConfiguration = EuVatChecker.loadConfigurationForReverseChargeCheck((ConfigurationManager)this.configurationManager, (Configurable)purchaseContext);
        if (EuVatChecker.reverseChargeEnabled((Map)reverseChargeConfiguration) && (country == null || this.isEUCountry(country))) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)bindingResult, (String)"vatNr", (String)"error.emptyField");
        }
        boolean reverseChargeInPerson = !(isEvent = purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) || ((ConfigurationManager.MaybeConfiguration)reverseChargeConfiguration.get(ConfigurationKeys.ENABLE_REVERSE_CHARGE_IN_PERSON)).getValueAsBooleanOrDefault();
        boolean reverseChargeOnline = !isEvent || ((ConfigurationManager.MaybeConfiguration)reverseChargeConfiguration.get(ConfigurationKeys.ENABLE_REVERSE_CHARGE_ONLINE)).getValueAsBooleanOrDefault();
        try {
            Optional vatDetail;
            Optional optionalReservation = this.ticketReservationRepository.findOptionalReservationById(reservationId);
            List categoriesList = optionalReservation.filter(res -> isEvent).map(res -> this.ticketCategoryRepository.findCategoriesInReservation(res.getId())).orElse(List.of());
            ArrayList noTaxCategories = new ArrayList();
            if (!categoriesList.isEmpty()) {
                noTaxCategories.addAll(this.configurationManager.getCategoriesWithNoTaxes(categoriesList.stream().map(TicketCategory::getId).collect(Collectors.toList())));
            }
            if ((vatDetail = this.performReverseChargeCheck(purchaseContext, contactAndTicketsForm, country, reverseChargeInPerson, reverseChargeOnline, optionalReservation, categoriesList)).isPresent()) {
                this.handleValidationResult(purchaseContext, reservationId, contactAndTicketsForm, bindingResult, country, isEvent, reverseChargeInPerson, reverseChargeOnline, categoriesList, noTaxCategories, (VatDetail)vatDetail.get());
            } else if (optionalReservation.isPresent() && contactAndTicketsForm.isItalyEInvoicingSplitPayment()) {
                this.handleSplitPayment(purchaseContext, reservationId, contactAndTicketsForm, country, (TicketReservation)optionalReservation.get(), categoriesList, noTaxCategories);
            } else if (optionalReservation.isPresent() && !noTaxCategories.isEmpty()) {
                TicketReservation reservation = (TicketReservation)optionalReservation.get();
                this.updateTicketsWithNoTaxSetting(purchaseContext, reservationId, reservation, categoriesList, noTaxCategories);
                this.updateBillingData(contactAndTicketsForm, purchaseContext, country, StringUtils.trimToNull((String)contactAndTicketsForm.getVatNr()), reservation, reservation.getVatStatus());
            }
        }
        catch (IllegalStateException ise) {
            bindingResult.rejectValue("vatNr", "error.vatVIESDown");
        }
    }

    private Optional<VatDetail> performReverseChargeCheck(PurchaseContext purchaseContext, ContactAndTicketsForm contactAndTicketsForm, String country, boolean reverseChargeInPerson, boolean reverseChargeOnline, Optional<TicketReservation> optionalReservation, List<TicketCategory> categoriesList) {
        return optionalReservation.filter(e -> {
            if (!(!purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) || reverseChargeInPerson && reverseChargeOnline)) {
                Event.EventFormat eventFormat = ((Event)purchaseContext.event().orElseThrow()).getFormat();
                return categoriesList.stream().anyMatch(this.findReverseChargeCategory(reverseChargeInPerson, reverseChargeOnline, eventFormat));
            }
            PriceContainer.VatStatus vatStatus = purchaseContext.getVatStatus();
            return vatStatus == PriceContainer.VatStatus.INCLUDED || vatStatus == PriceContainer.VatStatus.NOT_INCLUDED;
        }).filter(e -> this.vatChecker.isReverseChargeEnabledFor(purchaseContext)).flatMap(e -> this.vatChecker.checkVat(contactAndTicketsForm.getVatNr(), country, purchaseContext));
    }

    private void updateTicketsWithNoTaxSetting(PurchaseContext purchaseContext, String reservationId, TicketReservation reservation, List<TicketCategory> categoriesList, List<Integer> noTaxCategories) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            String currencyCode = reservation.getCurrencyCode();
            Event event = (Event)purchaseContext.event().orElseThrow();
            Map priceContainers = this.mapPriceContainersByCategoryId(categoriesList, c -> noTaxCategories.contains(c.getId()), currencyCode, reservation.getVatStatus(), (PromoCodeDiscount)reservation.getDiscount().orElse(null), event, noTaxCategories);
            this.updateTicketPricesByCategory(reservationId, currencyCode, event, priceContainers);
        }
    }

    private void handleSplitPayment(PurchaseContext purchaseContext, String reservationId, ContactAndTicketsForm contactAndTicketsForm, String country, TicketReservation reservation, List<TicketCategory> categoriesList, List<Integer> noTaxCategories) {
        this.updateTicketsWithNoTaxSetting(purchaseContext, reservationId, reservation, categoriesList, noTaxCategories);
        PriceContainer.VatStatus vatStatus = purchaseContext.getVatStatus() == PriceContainer.VatStatus.INCLUDED ? PriceContainer.VatStatus.INCLUDED_NOT_CHARGED : PriceContainer.VatStatus.NOT_INCLUDED_NOT_CHARGED;
        this.updateBillingData(contactAndTicketsForm, purchaseContext, country, StringUtils.trimToNull((String)contactAndTicketsForm.getVatNr()), reservation, vatStatus);
    }

    private void handleValidationResult(PurchaseContext purchaseContext, String reservationId, ContactAndTicketsForm contactAndTicketsForm, BindingResult bindingResult, String country, boolean isEvent, boolean reverseChargeInPerson, boolean reverseChargeOnline, List<TicketCategory> categoriesList, List<Integer> noTaxCategories, VatDetail vatValidation) {
        if (!vatValidation.isValid()) {
            bindingResult.rejectValue("vatNr", "error.STEP_2_INVALID_VAT");
        } else {
            TicketReservation reservation = (TicketReservation)this.ticketReservationManager.findById(reservationId).orElseThrow();
            String currencyCode = reservation.getCurrencyCode();
            PriceContainer.VatStatus vatStatus = ReverseChargeManager.determineVatStatus((PriceContainer.VatStatus)purchaseContext.getVatStatus(), (boolean)vatValidation.isVatExempt());
            PromoCodeDiscount discount = this.getDiscountOrNull(reservation);
            if (!isEvent || reverseChargeOnline && reverseChargeInPerson) {
                if (isEvent) {
                    Event event = (Event)purchaseContext.event().orElseThrow();
                    Map priceContainers = this.mapPriceContainersByCategoryId(categoriesList, a -> true, currencyCode, vatStatus, discount, event, noTaxCategories);
                    this.ticketRepository.updateVatStatusForReservation(reservationId, vatStatus);
                    this.updateTicketPricesByCategory(reservationId, currencyCode, event, priceContainers);
                }
                this.updateBillingData(contactAndTicketsForm, purchaseContext, country, StringUtils.trimToNull((String)vatValidation.getVatNr()), reservation, vatStatus);
            } else {
                Event event = (Event)purchaseContext.event().orElseThrow();
                Event.EventFormat eventFormat = event.getFormat();
                Map matchingCategories = this.mapPriceContainersByCategoryId(categoriesList, this.findReverseChargeCategory(reverseChargeInPerson, reverseChargeOnline, eventFormat), currencyCode, vatStatus, discount, event, noTaxCategories);
                this.updateTicketPricesByCategory(reservationId, currencyCode, event, matchingCategories);
                this.updateBillingData(contactAndTicketsForm, purchaseContext, country, StringUtils.trimToNull((String)vatValidation.getVatNr()), reservation, reservation.getVatStatus());
            }
            this.vatChecker.logSuccessfulValidation(vatValidation, reservationId, purchaseContext);
        }
    }

    private PromoCodeDiscount getDiscountOrNull(TicketReservation reservation) {
        if (reservation.getPromoCodeDiscountId() != null) {
            return this.promoCodeDiscountRepository.findById(reservation.getPromoCodeDiscountId().intValue());
        }
        return null;
    }

    public void applyCustomTaxPolicy(PurchaseContext purchaseContext, CustomTaxPolicy customTaxPolicy, String reservationId, ContactAndTicketsForm contactAndTicketsForm, CustomBindingResult bindingResult) {
        if (!purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            throw new IllegalStateException("Custom tax policy is only supported for events");
        }
        Event event = (Event)purchaseContext;
        TicketReservation reservation = (TicketReservation)this.ticketReservationManager.findById(reservationId).orElseThrow();
        String currencyCode = reservation.getCurrencyCode();
        Map ticketsInReservation = this.ticketRepository.findTicketsInReservation(reservationId).stream().collect(Collectors.toMap(t -> t.getPublicUuid().toString(), Function.identity()));
        Set<String> ticketIds = ticketsInReservation.keySet();
        if (customTaxPolicy.getTicketPolicies().stream().anyMatch(tp -> !ticketIds.contains(tp.getUuid()))) {
            log.warn("Error in custom tax policy: some tickets are not included in reservation {}", (Object)reservationId);
            bindingResult.reject("error.generic");
        } else {
            this.auditingRepository.insert(reservationId, null, purchaseContext, Audit.EventType.VAT_CUSTOM_CONFIGURATION_APPLIED, new Date(), Audit.EntityType.RESERVATION, reservationId, List.of(Map.of("policy", customTaxPolicy)));
            List priceMapping = customTaxPolicy.getTicketPolicies().stream().map(tcp -> ReverseChargeManager.toTicketPriceContainer((Ticket)((Ticket)ticketsInReservation.get(tcp.getUuid())), (CustomTaxPolicy.TicketTaxPolicy)tcp, (PromoCodeDiscount)this.getDiscountOrNull(reservation), (Event)event)).collect(Collectors.toList());
            this.updateTicketPrices(priceMapping, currencyCode, event);
            this.updateBillingData(contactAndTicketsForm, purchaseContext, reservation.getVatCountryCode(), StringUtils.trimToNull((String)reservation.getVatNr()), reservation, reservation.getVatStatus());
        }
    }

    private static TicketPriceContainer toTicketPriceContainer(Ticket ticket, CustomTaxPolicy.TicketTaxPolicy categoryTaxPolicy, PromoCodeDiscount discount, Event event) {
        return TicketPriceContainer.from((Ticket)ticket.withVatStatus(categoryTaxPolicy.getTaxPolicy()), (PriceContainer.VatStatus)categoryTaxPolicy.getTaxPolicy(), (BigDecimal)event.getVat(), (PriceContainer.VatStatus)event.getVatStatus(), (PromoCodeDiscount)discount);
    }

    public void resetVat(PurchaseContext purchaseContext, String reservationId) {
        if (purchaseContext.ofType(PurchaseContext.PurchaseContextType.event)) {
            TicketReservation reservation = this.ticketReservationRepository.findReservationById(reservationId);
            List categoriesList = this.ticketCategoryRepository.findCategoriesInReservation(reservationId);
            PromoCodeDiscount discount = this.getDiscountOrNull(reservation);
            Event event = (Event)purchaseContext.event().orElseThrow();
            Map priceContainers = this.mapPriceContainersByCategoryId(categoriesList, a -> true, reservation.getCurrencyCode(), reservation.getVatStatus(), discount, event, List.of());
            this.ticketRepository.updateVatStatusForReservation(reservationId, reservation.getVatStatus());
            this.updateTicketPricesByCategory(reservationId, reservation.getCurrencyCode(), event, priceContainers);
        }
    }

    private Map<Integer, TicketCategoryPriceContainer> mapPriceContainersByCategoryId(List<TicketCategory> categoriesList, Predicate<TicketCategory> filter, String currencyCode, PriceContainer.VatStatus vatStatus, PromoCodeDiscount discount, Event event, List<Integer> noTaxCategories) {
        return categoriesList.stream().filter(filter).map(c -> {
            PriceContainer.VatStatus categoryVatStatus = vatStatus;
            if (noTaxCategories.contains(c.getId())) {
                categoryVatStatus = PriceContainer.VatStatus.forceExempt((PriceContainer.VatStatus)vatStatus);
            }
            return new TicketCategoryPriceContainer(c.getId(), c.getSrcPriceCts(), currencyCode, event.getVat(), categoryVatStatus, discount);
        }).collect(Collectors.toMap(o -> o.categoryId, Function.identity()));
    }

    private void updateTicketPricesByCategory(String reservationId, String currencyCode, Event event, Map<Integer, TicketCategoryPriceContainer> matchingCategories) {
        MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])matchingCategories.entrySet().stream().map(entry -> ReverseChargeManager.buildParameterSourceForPriceUpdate((PriceContainer)((PriceContainer)entry.getValue()), (int)event.getId(), (int)((Integer)entry.getKey()), (String)currencyCode, m -> m.addValue("reservationId", (Object)reservationId))).toArray(MapSqlParameterSource[]::new);
        this.jdbcTemplate.batchUpdate(this.ticketRepository.updateTicketPriceForCategoryInReservation(), (SqlParameterSource[])parameterSources);
    }

    private void updateTicketPrices(List<TicketPriceContainer> ticketPrices, String currencyCode, Event event) {
        MapSqlParameterSource[] parameterSources = (MapSqlParameterSource[])ticketPrices.stream().map(entry -> ReverseChargeManager.buildParameterSourceForPriceUpdate((PriceContainer)entry, (int)event.getId(), (int)entry.getCategoryId(), (String)currencyCode, m -> m.addValue("uuid", (Object)entry.getUuid()))).toArray(MapSqlParameterSource[]::new);
        int[] updateResult = this.jdbcTemplate.batchUpdate(this.ticketRepository.bulkUpdateTicketPrice(), (SqlParameterSource[])parameterSources);
        Validate.isTrue((boolean)Arrays.stream(updateResult).allMatch(i -> i == 1), (String)"Error while updating ticket prices", (Object[])new Object[0]);
    }

    private static MapSqlParameterSource buildParameterSourceForPriceUpdate(PriceContainer value, int eventId, int categoryId, String currencyCode, UnaryOperator<MapSqlParameterSource> modifier) {
        return (MapSqlParameterSource)modifier.apply(new MapSqlParameterSource().addValue("categoryId", (Object)categoryId).addValue("eventId", (Object)eventId).addValue("srcPriceCts", (Object)value.getSrcPriceCts()).addValue("finalPriceCts", (Object)MonetaryUtil.unitToCents((BigDecimal)value.getFinalPrice(), (String)currencyCode)).addValue("vatCts", (Object)MonetaryUtil.unitToCents((BigDecimal)value.getVAT(), (String)currencyCode)).addValue("discountCts", (Object)MonetaryUtil.unitToCents((BigDecimal)value.getAppliedDiscount(), (String)currencyCode)).addValue("currencyCode", (Object)currencyCode).addValue("vatStatus", (Object)value.getVatStatus().name()));
    }

    private Predicate<TicketCategory> findReverseChargeCategory(boolean reverseChargeInPerson, boolean reverseChargeOnline, Event.EventFormat eventFormat) {
        return tc -> {
            if (eventFormat == Event.EventFormat.HYBRID) {
                return tc.getTicketAccessType() == TicketCategory.TicketAccessType.IN_PERSON ? reverseChargeInPerson : reverseChargeOnline;
            }
            return eventFormat == Event.EventFormat.IN_PERSON ? reverseChargeInPerson : reverseChargeOnline;
        };
    }

    private void updateBillingData(ContactAndTicketsForm contactAndTicketsForm, PurchaseContext purchaseContext, String country, String vatNr, TicketReservation reservation, PriceContainer.VatStatus vatStatus) {
        String reservationId = reservation.getId();
        PromoCodeDiscount discount = this.getDiscountOrNull(reservation);
        List additionalServiceItems = purchaseContext.ofType(PurchaseContext.PurchaseContextType.event) ? this.additionalServiceItemRepository.findByReservationUuid(((Event)purchaseContext.event().orElseThrow()).getId(), reservation.getId()) : List.of();
        List tickets = this.ticketReservationManager.findTicketsInReservation(reservation.getId());
        List additionalServices = purchaseContext.event().map(event -> this.additionalServiceRepository.loadAllForEvent(event.getId())).orElse(List.of());
        List subscriptions = this.subscriptionRepository.findSubscriptionsByReservationId(reservationId);
        Optional appliedSubscription = this.subscriptionRepository.findAppliedSubscriptionByReservationId(reservationId);
        ReservationPriceCalculator calculator = new ReservationPriceCalculator(reservation.withVatStatus(vatStatus), discount, tickets, additionalServiceItems, additionalServices, purchaseContext, subscriptions, appliedSubscription);
        String currencyCode = reservation.getCurrencyCode();
        this.ticketReservationRepository.updateBillingData(vatStatus, reservation.getSrcPriceCts(), MonetaryUtil.unitToCents((BigDecimal)calculator.getFinalPrice(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)calculator.getVAT(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)calculator.getAppliedDiscount(), (String)currencyCode), reservation.getCurrencyCode(), vatNr, country, contactAndTicketsForm.isInvoiceRequested(), reservationId);
    }

    private boolean isEUCountry(String countryCode) {
        return this.configurationManager.getForSystem(ConfigurationKeys.EU_COUNTRIES_LIST).getRequiredValue().contains(countryCode);
    }

    private static PriceContainer.VatStatus determineVatStatus(PriceContainer.VatStatus current, boolean isVatExempt) {
        if (!isVatExempt) {
            return current;
        }
        return current == PriceContainer.VatStatus.NOT_INCLUDED ? PriceContainer.VatStatus.NOT_INCLUDED_EXEMPT : PriceContainer.VatStatus.INCLUDED_EXEMPT;
    }

    @ConstructorProperties(value={"promoCodeDiscountRepository", "additionalServiceItemRepository", "additionalServiceRepository", "ticketCategoryRepository", "jdbcTemplate", "configurationManager", "ticketReservationRepository", "vatChecker", "ticketReservationManager", "ticketRepository", "subscriptionRepository", "auditingRepository"})
    @Generated
    public ReverseChargeManager(PromoCodeDiscountRepository promoCodeDiscountRepository, AdditionalServiceItemRepository additionalServiceItemRepository, AdditionalServiceRepository additionalServiceRepository, TicketCategoryRepository ticketCategoryRepository, NamedParameterJdbcTemplate jdbcTemplate, ConfigurationManager configurationManager, TicketReservationRepository ticketReservationRepository, EuVatChecker vatChecker, TicketReservationManager ticketReservationManager, TicketRepository ticketRepository, SubscriptionRepository subscriptionRepository, AuditingRepository auditingRepository) {
        this.promoCodeDiscountRepository = promoCodeDiscountRepository;
        this.additionalServiceItemRepository = additionalServiceItemRepository;
        this.additionalServiceRepository = additionalServiceRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.configurationManager = configurationManager;
        this.ticketReservationRepository = ticketReservationRepository;
        this.vatChecker = vatChecker;
        this.ticketReservationManager = ticketReservationManager;
        this.ticketRepository = ticketRepository;
        this.subscriptionRepository = subscriptionRepository;
        this.auditingRepository = auditingRepository;
    }
}

