/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.EuVatChecker;
import alfio.manager.ExtensionManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.Configurable;
import alfio.model.PurchaseContext;
import alfio.model.VatDetail;
import ch.digitalfondue.vatchecker.EUVatCheckResponse;
import ch.digitalfondue.vatchecker.EUVatChecker;
import java.beans.ConstructorProperties;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameCountryValidator
implements Predicate<String> {
    private static final Logger log = LoggerFactory.getLogger(SameCountryValidator.class);
    private final ConfigurationManager configurationManager;
    private final ExtensionManager extensionManager;
    private final PurchaseContext purchaseContext;
    private final String ticketReservationId;
    private final EuVatChecker checker;
    private final EUVatChecker client = new EUVatChecker();

    @Override
    public boolean test(String vatNr) {
        if (StringUtils.isEmpty((CharSequence)vatNr)) {
            log.warn("empty VAT number received for organizationId {}", (Object)this.purchaseContext.getOrganizationId());
        }
        String organizerCountry = EuVatChecker.organizerCountry((ConfigurationManager)this.configurationManager, (Configurable)this.purchaseContext);
        if (!EuVatChecker.validationEnabled((ConfigurationManager)this.configurationManager, (Configurable)this.purchaseContext)) {
            log.warn("VAT checking is not enabled for organizationId {} or country not defined ({})", (Object)this.purchaseContext.getOrganizationId(), (Object)organizerCountry);
            return false;
        }
        EUVatCheckResponse result = EuVatChecker.validateEUVat((String)vatNr, (String)organizerCountry, (EUVatChecker)this.client);
        boolean validStrict = result != null && result.isValid();
        boolean valid = validStrict;
        if (!valid && StringUtils.isNotBlank((CharSequence)vatNr)) {
            valid = this.extensionManager.handleTaxIdValidation(this.purchaseContext, vatNr, organizerCountry);
        }
        if (valid && StringUtils.isNotEmpty((CharSequence)this.ticketReservationId)) {
            VatDetail detail = new VatDetail(vatNr, organizerCountry, true, "", "", validStrict ? VatDetail.Type.VIES : VatDetail.Type.FORMAL, false);
            this.checker.logSuccessfulValidation(detail, this.ticketReservationId, this.purchaseContext);
        }
        return valid;
    }

    @ConstructorProperties(value={"configurationManager", "extensionManager", "purchaseContext", "ticketReservationId", "checker"})
    @Generated
    public SameCountryValidator(ConfigurationManager configurationManager, ExtensionManager extensionManager, PurchaseContext purchaseContext, String ticketReservationId, EuVatChecker checker) {
        this.configurationManager = configurationManager;
        this.extensionManager = extensionManager;
        this.purchaseContext = purchaseContext;
        this.ticketReservationId = ticketReservationId;
        this.checker = checker;
    }
}

