/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.EventManager;
import alfio.manager.NotificationManager;
import alfio.manager.i18n.I18nManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.system.ConfigurationManager;
import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.PurchaseContext;
import alfio.model.SpecialPrice;
import alfio.model.TicketCategory;
import alfio.model.modification.SendCodeModification;
import alfio.model.system.ConfigurationKeys;
import alfio.model.user.Organization;
import alfio.repository.SpecialPriceRepository;
import alfio.util.ClockProvider;
import alfio.util.LocaleUtil;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SpecialPriceManager {
    private static final Predicate<SendCodeModification> IS_CODE_PRESENT = v -> Optional.ofNullable(v.getCode()).isPresent();
    private final EventManager eventManager;
    private final NotificationManager notificationManager;
    private final SpecialPriceRepository specialPriceRepository;
    private final TemplateManager templateManager;
    private final MessageSourceManager messageSourceManager;
    private final I18nManager i18nManager;
    private final ConfigurationManager configurationManager;
    private final ClockProvider clockProvider;

    private List<String> checkCodeAssignment(Set<SendCodeModification> input, int categoryId, EventAndOrganizationId event, String username) {
        TicketCategory category = this.checkOwnership(categoryId, event, username);
        List<String> availableCodes = this.specialPriceRepository.findActiveByCategoryIdForUpdate(category.getId(), input.size()).stream().map(SpecialPrice::getCode).collect(Collectors.toList());
        Validate.isTrue((input.size() <= availableCodes.size() ? 1 : 0) != 0, (String)("Requested codes: " + input.size() + ", available: " + availableCodes.size() + "."), (Object[])new Object[0]);
        List requestedCodes = input.stream().filter(IS_CODE_PRESENT).map(SendCodeModification::getCode).collect(Collectors.toList());
        Validate.isTrue((requestedCodes.stream().distinct().count() == (long)requestedCodes.size() ? 1 : 0) != 0, (String)"Cannot assign the same code twice. Please fix the input file.", (Object[])new Object[0]);
        Validate.isTrue((boolean)new HashSet(availableCodes).containsAll(requestedCodes), (String)"some requested codes don't exist.", (Object[])new Object[0]);
        return availableCodes;
    }

    private TicketCategory checkOwnership(int categoryId, EventAndOrganizationId event, String username) {
        this.eventManager.checkOwnership(event, username, event.getOrganizationId());
        List categories = this.eventManager.loadTicketCategories(event);
        TicketCategory category = categories.stream().filter(tc -> tc.getId() == categoryId).findFirst().orElseThrow(IllegalArgumentException::new);
        Validate.isTrue((boolean)category.isAccessRestricted(), (String)"Access to the selected category is not restricted.", (Object[])new Object[0]);
        return category;
    }

    public List<SendCodeModification> linkAssigneeToCode(List<SendCodeModification> input, String eventName, int categoryId, String username) {
        EventAndOrganizationId event = this.eventManager.getEventAndOrganizationId(eventName, username);
        LinkedHashSet<SendCodeModification> set = new LinkedHashSet<SendCodeModification>(input);
        List availableCodes = this.checkCodeAssignment(set, categoryId, event, username);
        Iterator codes = availableCodes.iterator();
        return Stream.concat(set.stream().filter(IS_CODE_PRESENT), input.stream().filter(IS_CODE_PRESENT.negate()).map(p -> new SendCodeModification((String)codes.next(), p.getAssignee(), p.getEmail(), p.getLanguage()))).collect(Collectors.toList());
    }

    public List<SpecialPrice> loadSentCodes(String eventName, int categoryId, String username) {
        EventAndOrganizationId event = this.eventManager.getEventAndOrganizationId(eventName, username);
        this.checkOwnership(categoryId, event, username);
        Predicate<SpecialPrice> p = SpecialPrice::notSent;
        return this.specialPriceRepository.findAllByCategoryId(categoryId).stream().filter(p.negate()).collect(Collectors.toList());
    }

    public boolean clearRecipientData(String eventName, int categoryId, int codeId, String username) {
        EventAndOrganizationId event = this.eventManager.getEventAndOrganizationId(eventName, username);
        this.checkOwnership(categoryId, event, username);
        int result = this.specialPriceRepository.clearRecipientData(codeId, categoryId);
        Validate.isTrue((result <= 1 ? 1 : 0) != 0, (String)"too many records affected", (Object[])new Object[0]);
        return result == 1;
    }

    public boolean sendCodeToAssignee(List<SendCodeModification> input, String eventName, int categoryId, String username) {
        Event event = this.eventManager.getSingleEvent(eventName, username);
        Organization organization = this.eventManager.loadOrganizer((EventAndOrganizationId)event, username);
        LinkedHashSet<SendCodeModification> set = new LinkedHashSet<SendCodeModification>(input);
        this.checkCodeAssignment(set, categoryId, (EventAndOrganizationId)event, username);
        Validate.isTrue((boolean)set.stream().allMatch(IS_CODE_PRESENT), (String)"There are missing codes. Please check input file.", (Object[])new Object[0]);
        List eventLanguages = this.i18nManager.getEventLanguages(event.getLocales());
        Validate.isTrue((!eventLanguages.isEmpty() ? 1 : 0) != 0, (String)"No locales have been defined for the event. Please check the configuration", (Object[])new Object[0]);
        ContentLanguage defaultLocale = eventLanguages.contains(ContentLanguage.ENGLISH) ? ContentLanguage.ENGLISH : (ContentLanguage)eventLanguages.get(0);
        set.forEach(m -> {
            MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
            Locale locale = LocaleUtil.forLanguageTag((String)Objects.toString(StringUtils.trimToNull((String)m.getLanguage()), defaultLocale.getLanguage()));
            boolean usePartnerCode = this.configurationManager.getFor(ConfigurationKeys.USE_PARTNER_CODE_INSTEAD_OF_PROMOTIONAL, event.getConfigurationLevel()).getValueAsBooleanOrDefault();
            String promoCodeDescription = messageSource.getMessage("show-event.promo-code-type." + (usePartnerCode ? "partner" : "promotional"), null, null, locale);
            Map model = TemplateResource.prepareModelForSendReservedCode((Organization)organization, (Event)event, (SendCodeModification)m, (String)this.eventManager.getEventUrl(event), (String)promoCodeDescription);
            this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, m.getEmail(), messageSource.getMessage("email-code.subject", new Object[]{event.getDisplayName(), promoCodeDescription}, locale), () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.SEND_RESERVED_CODE, model, locale));
            int marked = this.specialPriceRepository.markAsSent(event.now(this.clockProvider), m.getAssignee().trim(), m.getEmail().trim(), m.getCode().trim());
            Validate.isTrue((marked == 1 ? 1 : 0) != 0, (String)("Expected exactly one row updated, got " + marked), (Object[])new Object[0]);
        });
        return true;
    }

    @ConstructorProperties(value={"eventManager", "notificationManager", "specialPriceRepository", "templateManager", "messageSourceManager", "i18nManager", "configurationManager", "clockProvider"})
    @Generated
    public SpecialPriceManager(EventManager eventManager, NotificationManager notificationManager, SpecialPriceRepository specialPriceRepository, TemplateManager templateManager, MessageSourceManager messageSourceManager, I18nManager i18nManager, ConfigurationManager configurationManager, ClockProvider clockProvider) {
        this.eventManager = eventManager;
        this.notificationManager = notificationManager;
        this.specialPriceRepository = specialPriceRepository;
        this.templateManager = templateManager;
        this.messageSourceManager = messageSourceManager;
        this.i18nManager = i18nManager;
        this.configurationManager = configurationManager;
        this.clockProvider = clockProvider;
    }
}

