/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.model.EventAndOrganizationId;
import alfio.model.SpecialPrice;
import alfio.model.TicketCategory;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.EventRepository;
import alfio.repository.SpecialPriceRepository;
import alfio.repository.TicketCategoryRepository;
import java.security.SecureRandom;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.text.RandomStringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SpecialPriceTokenGenerator {
    private static final Logger log = LoggerFactory.getLogger(SpecialPriceTokenGenerator.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final char[] ADMITTED_CHARACTERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final RandomStringGenerator RANDOM_STRING_GENERATOR = new RandomStringGenerator.Builder().selectFrom(ADMITTED_CHARACTERS).usingRandom(RANDOM::nextInt).get();
    private final SpecialPriceRepository specialPriceRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final EventRepository eventRepository;
    private final ConfigurationManager configurationManager;

    public SpecialPriceTokenGenerator(ConfigurationManager configurationManager, SpecialPriceRepository specialPriceRepository, TicketCategoryRepository ticketCategoryRepository, EventRepository eventRepository) {
        this.specialPriceRepository = specialPriceRepository;
        this.configurationManager = configurationManager;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.eventRepository = eventRepository;
    }

    public void generatePendingCodes() {
        StopWatch stopWatch = new StopWatch();
        log.trace("start pending codes generation");
        stopWatch.start();
        this.specialPriceRepository.findWaitingElements().forEach(arg_0 -> this.generateCode(arg_0));
        stopWatch.stop();
        log.trace("end. Took {} ms", (Object)stopWatch.getDuration().toMillis());
    }

    public void generatePendingCodesForCategory(int categoryId) {
        this.specialPriceRepository.findWaitingElementsForCategory(categoryId).forEach(arg_0 -> this.generateCode(arg_0));
    }

    private void generateCode(SpecialPrice.SpecialPriceTicketCategoryId specialPrice) {
        TicketCategory ticketCategory = (TicketCategory)this.ticketCategoryRepository.getByIdAndActive(specialPrice.getTicketCategoryId()).orElseThrow(IllegalStateException::new);
        EventAndOrganizationId event = this.eventRepository.findEventAndOrganizationIdById(ticketCategory.getEventId());
        int maxLength = this.configurationManager.getFor(ConfigurationKeys.SPECIAL_PRICE_CODE_LENGTH, ConfigurationLevel.ticketCategory((EventAndOrganizationId)event, (int)ticketCategory.getId())).getValueAsIntOrDefault(6);
        while (true) {
            try {
                log.trace("generate code for special price with id {}", (Object)specialPrice.getId());
                this.specialPriceRepository.updateCode(this.nextValidCode(maxLength), specialPrice.getId());
                log.trace("done.");
                return;
            }
            catch (DataAccessException e) {
                log.warn("got a duplicate. Retrying...", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private String nextValidCode(int maxLength) {
        String code;
        while (this.specialPriceRepository.countByCode(code = this.generateRandomCode(maxLength)) != 0) {
        }
        return code;
    }

    private String generateRandomCode(int maxLength) {
        return RANDOM_STRING_GENERATOR.generate(maxLength);
    }
}

