/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.form.SearchOptions;
import alfio.model.Event;
import alfio.model.modification.SubscriptionDescriptorModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.subscription.EventSubscriptionLink;
import alfio.model.subscription.LinkEventsToSubscriptionRequest;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.subscription.SubscriptionDescriptorWithStatistics;
import alfio.repository.EventRepository;
import alfio.repository.SubscriptionRepository;
import alfio.util.Json;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SubscriptionManager {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionManager.class);
    private final SubscriptionRepository subscriptionRepository;
    private final EventRepository eventRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final Environment environment;

    public List<SubscriptionDescriptor> findAll(int organizationId) {
        return this.subscriptionRepository.findAllByOrganizationIds(organizationId);
    }

    public Optional<UUID> createSubscriptionDescriptor(SubscriptionDescriptorModification subscriptionDescriptor) {
        UUID id = UUID.randomUUID();
        int maxAvailable = Objects.requireNonNullElse(subscriptionDescriptor.getMaxAvailable(), -1);
        int result = this.subscriptionRepository.createSubscriptionDescriptor(id, subscriptionDescriptor.getTitle(), subscriptionDescriptor.getDescription(), maxAvailable, subscriptionDescriptor.getOnSaleFrom(), subscriptionDescriptor.getOnSaleTo(), subscriptionDescriptor.getPriceCts(), Objects.requireNonNullElse(subscriptionDescriptor.getVat(), BigDecimal.ZERO), subscriptionDescriptor.getVatStatus(), subscriptionDescriptor.getCurrency(), Boolean.TRUE.equals(subscriptionDescriptor.getIsPublic()), subscriptionDescriptor.getOrganizationId(), Objects.requireNonNullElse(subscriptionDescriptor.getMaxEntries(), -1).intValue(), subscriptionDescriptor.getValidityType(), subscriptionDescriptor.getValidityTimeUnit(), subscriptionDescriptor.getValidityUnits(), subscriptionDescriptor.getValidityFrom(), subscriptionDescriptor.getValidityTo(), subscriptionDescriptor.getUsageType(), subscriptionDescriptor.getTermsAndConditionsUrl(), subscriptionDescriptor.getPrivacyPolicyUrl(), subscriptionDescriptor.getFileBlobId(), subscriptionDescriptor.getPaymentProxies(), UUID.randomUUID().toString(), subscriptionDescriptor.getTimeZone().toString(), Boolean.TRUE.equals(subscriptionDescriptor.getSupportsTicketsGeneration()));
        if (result != 1) {
            return Optional.empty();
        }
        if (maxAvailable > 0) {
            this.subscriptionRepository.preGenerateSubscriptions(subscriptionDescriptor, id, maxAvailable);
        }
        return Optional.of(id);
    }

    public Optional<UUID> updateSubscriptionDescriptor(SubscriptionDescriptorModification subscriptionDescriptor) {
        UUID subscriptionDescriptorId = subscriptionDescriptor.getId();
        return this.subscriptionRepository.findOne(subscriptionDescriptorId, subscriptionDescriptor.getOrganizationId()).flatMap(original -> {
            int maxAvailable = Objects.requireNonNullElse(subscriptionDescriptor.getMaxAvailable(), -1);
            int result = this.subscriptionRepository.updateSubscriptionDescriptor(subscriptionDescriptor.getTitle(), subscriptionDescriptor.getDescription(), maxAvailable, subscriptionDescriptor.getOnSaleFrom(), subscriptionDescriptor.getOnSaleTo(), subscriptionDescriptor.getPriceCts(), subscriptionDescriptor.getVat(), subscriptionDescriptor.getVatStatus(), subscriptionDescriptor.getCurrency(), Boolean.TRUE.equals(subscriptionDescriptor.getIsPublic()), Objects.requireNonNullElse(subscriptionDescriptor.getMaxEntries(), -1).intValue(), subscriptionDescriptor.getValidityType(), subscriptionDescriptor.getValidityTimeUnit(), subscriptionDescriptor.getValidityUnits(), subscriptionDescriptor.getValidityFrom(), subscriptionDescriptor.getValidityTo(), subscriptionDescriptor.getUsageType(), subscriptionDescriptor.getTermsAndConditionsUrl(), subscriptionDescriptor.getPrivacyPolicyUrl(), subscriptionDescriptor.getFileBlobId(), subscriptionDescriptor.getPaymentProxies(), subscriptionDescriptorId, original.getOrganizationId(), subscriptionDescriptor.getTimeZone().toString(), Boolean.TRUE.equals(subscriptionDescriptor.getSupportsTicketsGeneration()));
            if (result != 1) {
                return Optional.empty();
            }
            if (maxAvailable > 0 && maxAvailable > original.getMaxAvailable()) {
                int existing = Math.max(0, original.getMaxAvailable());
                this.subscriptionRepository.preGenerateSubscriptions(subscriptionDescriptor, subscriptionDescriptorId, maxAvailable - existing);
            } else if (maxAvailable > -1 && maxAvailable < original.getMaxAvailable()) {
                int invalidated;
                int amount = original.getMaxAvailable() - maxAvailable;
                Validate.isTrue((amount == (invalidated = this.subscriptionRepository.invalidateSubscriptions(subscriptionDescriptorId, amount)) ? 1 : 0) != 0, (String)"Cannot invalidate existing subscriptions. (wanted: %d got: %d)", (Object[])new Object[]{amount, invalidated});
            }
            if (original.getPrice() != subscriptionDescriptor.getPriceCts()) {
                this.subscriptionRepository.updatePriceForSubscriptions(subscriptionDescriptorId, subscriptionDescriptor.getPriceCts());
            }
            if (!Objects.equals(original.getMaxEntries(), subscriptionDescriptor.getMaxEntries())) {
                int maxEntries = Objects.requireNonNullElse(subscriptionDescriptor.getMaxEntries(), -1);
                int updatedSubscriptions = this.subscriptionRepository.updateMaxEntriesForSubscriptions(subscriptionDescriptorId, maxEntries);
                log.debug("SubscriptionDescriptor #{}: updated {} subscriptions. Modified max entries to {}", new Object[]{subscriptionDescriptorId, updatedSubscriptions, maxEntries});
            }
            return Optional.of(subscriptionDescriptorId);
        });
    }

    public Optional<SubscriptionDescriptor> findOne(UUID id, int organizationId) {
        return this.subscriptionRepository.findOne(id, organizationId);
    }

    public boolean setPublicStatus(UUID id, int organizationId, boolean isPublic) {
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"demo"}))) {
            throw new IllegalStateException("Cannot publish subscriptions while in demo mode");
        }
        return this.subscriptionRepository.setPublicStatus(id, organizationId, isPublic) == 1;
    }

    public List<SubscriptionDescriptor> getActivePublicSubscriptionsDescriptor(ZonedDateTime from, SearchOptions searchOptions) {
        return this.subscriptionRepository.findAllActiveAndPublic(from, searchOptions.getOrganizerSlug());
    }

    public Optional<SubscriptionDescriptor> getSubscriptionById(UUID id) {
        return this.subscriptionRepository.findOne(id);
    }

    public List<SubscriptionDescriptorWithStatistics> loadSubscriptionsWithStatistics(int organizationId) {
        return this.subscriptionRepository.findAllWithStatistics(organizationId);
    }

    public Optional<SubscriptionDescriptorWithStatistics> loadSubscriptionWithStatistics(UUID id, int organizationId) {
        return this.subscriptionRepository.findOneWithStatistics(id, organizationId);
    }

    public int linkSubscriptionToEvent(UUID subscriptionId, int eventId, int organizationId, int pricePerTicket, List<Integer> compatibleCategories) {
        return this.subscriptionRepository.linkSubscriptionAndEvent(subscriptionId, eventId, pricePerTicket, organizationId, Objects.requireNonNullElse(compatibleCategories, List.of()));
    }

    public List<EventSubscriptionLink> getLinkedEvents(int organizationId, UUID id) {
        return this.subscriptionRepository.findLinkedEvents(organizationId, id);
    }

    public int countFree(UUID subscriptionDescriptorId) {
        return this.subscriptionRepository.countFreeSubscriptionForDescriptor(subscriptionDescriptorId);
    }

    public List<SubscriptionDescriptor> loadActiveSubscriptionDescriptors(int organizationId) {
        return this.subscriptionRepository.findActiveSubscriptionsForOrganization(organizationId);
    }

    public Result<Boolean> deactivateDescriptor(int organizationId, UUID descriptorId) {
        this.removeAllEventLinksForSubscription(organizationId, descriptorId);
        int result = this.subscriptionRepository.deactivateDescriptor(descriptorId, organizationId);
        if (result == 1) {
            return Result.success((Object)true);
        }
        return Result.error((ErrorCode)ErrorCode.custom((String)"cannot-deactivate-subscription", (String)"Cannot deactivate subscription descriptor"));
    }

    public Result<List<EventSubscriptionLink>> updateLinkedEvents(int organizationId, UUID subscriptionId, List<LinkEventsToSubscriptionRequest> requests) {
        this.removeAllEventLinksForSubscription(organizationId, subscriptionId);
        if (requests.isEmpty()) {
            return Result.success(List.of());
        }
        Map<String, List<LinkEventsToSubscriptionRequest>> byName = requests.stream().collect(Collectors.groupingBy(LinkEventsToSubscriptionRequest::getSlug));
        List allEvents = this.eventRepository.findEventsByShortNames(organizationId, byName.keySet());
        MapSqlParameterSource[] parameters = (MapSqlParameterSource[])byName.entrySet().stream().map(entry -> {
            Event event = allEvents.stream().filter(e -> e.getShortName().equals(entry.getKey())).findFirst().orElseThrow();
            return new MapSqlParameterSource("eventId", (Object)event.getId()).addValue("subscriptionId", (Object)subscriptionId).addValue("pricePerTicket", (Object)0).addValue("organizationId", (Object)organizationId).addValue("compatibleCategories", (Object)Json.toJson(((List)entry.getValue()).stream().flatMap(v -> v.getCategories().stream()).collect(Collectors.toSet())));
        }).toArray(MapSqlParameterSource[]::new);
        int[] result = this.jdbcTemplate.batchUpdate("insert into subscription_event(event_id_fk, subscription_descriptor_id_fk, price_per_ticket, organization_id_fk, compatible_categories) values(:eventId, :subscriptionId, :pricePerTicket, :organizationId, :compatibleCategories::json) on conflict(subscription_descriptor_id_fk, event_id_fk) do update set price_per_ticket = excluded.price_per_ticket, compatible_categories = excluded.compatible_categories\n", (SqlParameterSource[])parameters);
        return new Result.Builder().checkPrecondition(() -> Arrays.stream(result).allMatch(r -> r == 1), ErrorCode.custom((String)"cannot-link", (String)"Cannot link events")).build(() -> this.getLinkedEvents(organizationId, subscriptionId));
    }

    public SubscriptionDescriptor findDescriptorBySubscriptionId(UUID subscriptionId) {
        return this.subscriptionRepository.findDescriptorBySubscriptionId(subscriptionId);
    }

    private void removeAllEventLinksForSubscription(int organizationId, UUID subscriptionId) {
        int removed = this.subscriptionRepository.removeAllLinksForSubscription(subscriptionId, organizationId);
        log.info("removed all event links ({}) for subscription {}", (Object)removed, (Object)subscriptionId);
    }

    @ConstructorProperties(value={"subscriptionRepository", "eventRepository", "jdbcTemplate", "environment"})
    @Generated
    public SubscriptionManager(SubscriptionRepository subscriptionRepository, EventRepository eventRepository, NamedParameterJdbcTemplate jdbcTemplate, Environment environment) {
        this.subscriptionRepository = subscriptionRepository;
        this.eventRepository = eventRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.environment = environment;
    }
}

