/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.manager.ExtensionManager;
import alfio.model.DescriptorIdAndReservationId;
import alfio.model.PurchaseContext;
import alfio.model.modification.SubscriptionDescriptorModification;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.system.command.CleanupReservations;
import alfio.repository.SubscriptionRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SubscriptionReservationManager {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionReservationManager.class);
    private final SubscriptionRepository subscriptionRepository;
    private final ExtensionManager extensionManager;

    public SubscriptionReservationManager(SubscriptionRepository subscriptionRepository, ExtensionManager extensionManager) {
        this.subscriptionRepository = subscriptionRepository;
        this.extensionManager = extensionManager;
    }

    @EventListener(value={CleanupReservations.class})
    public void cleanupReservations(CleanupReservations cleanupReservations) {
        PurchaseContext purchaseContext;
        if (cleanupReservations.purchaseContext() != null && (purchaseContext = cleanupReservations.purchaseContext()) instanceof SubscriptionDescriptor) {
            SubscriptionDescriptor sd = (SubscriptionDescriptor)purchaseContext;
            this.deleteReservationsForDescriptor(cleanupReservations.reservationIds(), sd, cleanupReservations.expired());
        } else if (cleanupReservations.purchaseContext() == null) {
            List involvedDescriptors = this.subscriptionRepository.findDescriptorsByReservationIds((Collection)cleanupReservations.reservationIds());
            Set descriptorsIdsNeedingUpdate = involvedDescriptors.stream().filter(d -> d.maxAvailable() > 0).map(DescriptorIdAndReservationId::descriptorId).collect(Collectors.toSet());
            if (descriptorsIdsNeedingUpdate.isEmpty()) {
                this.deleteReservationsForDescriptor(cleanupReservations.reservationIds(), null, cleanupReservations.expired());
            } else {
                Map descriptorsById = this.subscriptionRepository.findByIds(descriptorsIdsNeedingUpdate).stream().collect(Collectors.toMap(SubscriptionDescriptor::getId, Function.identity()));
                Map<UUID, List<DescriptorIdAndReservationId>> reservationByDescriptorId = involvedDescriptors.stream().collect(Collectors.groupingBy(DescriptorIdAndReservationId::descriptorId));
                for (Map.Entry<UUID, List<DescriptorIdAndReservationId>> entry : reservationByDescriptorId.entrySet()) {
                    List<String> reservations = entry.getValue().stream().map(DescriptorIdAndReservationId::reservationId).toList();
                    this.deleteReservationsForDescriptor(reservations, (SubscriptionDescriptor)descriptorsById.get(entry.getKey()), cleanupReservations.expired());
                }
            }
        }
    }

    private void deleteReservationsForDescriptor(List<String> reservationIds, SubscriptionDescriptor sd, boolean expired) {
        int deleted = this.subscriptionRepository.deleteSubscriptionWithReservationId(reservationIds);
        log.trace("deleted {} subscriptions", (Object)deleted);
        if (sd != null && sd.getMaxAvailable() > -1) {
            this.subscriptionRepository.preGenerateSubscriptions(SubscriptionDescriptorModification.fromModel((SubscriptionDescriptor)sd), sd.getId(), deleted);
            log.trace("created {} subscriptions to replace deleted", (Object)deleted);
        }
        if (expired) {
            this.extensionManager.handleReservationsExpired((PurchaseContext)sd, reservationIds);
        } else {
            this.extensionManager.handleReservationsCancelled((PurchaseContext)sd, reservationIds);
        }
    }
}

