/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.api.v2.model.AdditionalService;
import alfio.controller.api.v2.model.ItemsByCategory;
import alfio.controller.decorator.SaleableAdditionalService;
import alfio.controller.decorator.SaleableTicketCategory;
import alfio.controller.support.Formatters;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.EventStatisticsManager;
import alfio.manager.PromoCodeRequestManager;
import alfio.manager.TicketReservationManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.support.response.ValidatedResponse;
import alfio.manager.system.ConfigurationManager;
import alfio.model.AdditionalServiceText;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.LocalizedContent;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.SpecialPrice;
import alfio.model.TicketCategory;
import alfio.model.system.ConfigurationKeys;
import alfio.repository.EventRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.TicketCategoryDescriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional(readOnly=true)
public class TicketCategoryAvailabilityManager {
    private final TicketCategoryRepository ticketCategoryRepository;
    private final EventRepository eventRepository;
    private final ConfigurationManager configurationManager;
    private final MessageSourceManager messageSourceManager;
    private final PromoCodeRequestManager promoCodeRequestManager;
    private final ClockProvider clockProvider;
    private final PromoCodeDiscountRepository promoCodeRepository;
    private final TicketReservationManager ticketReservationManager;
    private final AdditionalServiceManager additionalServiceManager;
    private final TicketCategoryDescriptionRepository ticketCategoryDescriptionRepository;
    private final EventStatisticsManager eventStatisticsManager;

    public TicketCategoryAvailabilityManager(TicketCategoryRepository ticketCategoryRepository, EventRepository eventRepository, ConfigurationManager configurationManager, MessageSourceManager messageSourceManager, PromoCodeRequestManager promoCodeRequestManager, ClockProvider clockProvider, PromoCodeDiscountRepository promoCodeRepository, TicketReservationManager ticketReservationManager, AdditionalServiceManager additionalServiceManager, TicketCategoryDescriptionRepository ticketCategoryDescriptionRepository, EventStatisticsManager eventStatisticsManager) {
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.eventRepository = eventRepository;
        this.configurationManager = configurationManager;
        this.messageSourceManager = messageSourceManager;
        this.promoCodeRequestManager = promoCodeRequestManager;
        this.clockProvider = clockProvider;
        this.promoCodeRepository = promoCodeRepository;
        this.ticketReservationManager = ticketReservationManager;
        this.additionalServiceManager = additionalServiceManager;
        this.ticketCategoryDescriptionRepository = ticketCategoryDescriptionRepository;
        this.eventStatisticsManager = eventStatisticsManager;
    }

    public Optional<ItemsByCategory> getTicketCategories(String eventName, String code) {
        return this.eventRepository.findOptionalByShortName(eventName).filter(e -> e.getStatus() != Event.Status.DISABLED).map(event -> {
            Map configurations = this.configurationManager.getFor(List.of(ConfigurationKeys.DISPLAY_TICKETS_LEFT_INDICATOR, ConfigurationKeys.MAX_AMOUNT_OF_TICKETS_BY_RESERVATION, ConfigurationKeys.DISPLAY_EXPIRED_CATEGORIES, ConfigurationKeys.STOP_WAITING_QUEUE_SUBSCRIPTIONS, ConfigurationKeys.ENABLE_PRE_REGISTRATION, ConfigurationKeys.ENABLE_WAITING_QUEUE), event.getConfigurationLevel());
            Map ticketCategoryLevelConfiguration = this.configurationManager.getAllCategoriesAndValueWith((EventAndOrganizationId)event, ConfigurationKeys.MAX_AMOUNT_OF_TICKETS_BY_RESERVATION);
            MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
            ValidatedResponse appliedPromoCode = this.promoCodeRequestManager.checkCode(event, code);
            Optional specialCode = (Optional)((Pair)appliedPromoCode.getValue()).getLeft();
            Optional promoCodeDiscount = (Optional)((Pair)appliedPromoCode.getValue()).getRight();
            ZonedDateTime now = event.now(this.clockProvider);
            List ticketCategories = this.ticketCategoryRepository.findAllTicketCategories(event.getId());
            List saleableTicketCategories = ticketCategories.stream().filter(c -> !c.isAccessRestricted() || TicketCategoryAvailabilityManager.shouldDisplayRestrictedCategory((Optional)specialCode, (TicketCategory)c, (Optional)promoCodeDiscount)).map(category -> {
                int maxTickets = TicketCategoryAvailabilityManager.getMaxAmountOfTicketsPerReservation((Map)configurations, (Map)ticketCategoryLevelConfiguration, (int)category.getId());
                PromoCodeDiscount filteredPromoCode = promoCodeDiscount.filter(promoCode -> TicketCategoryAvailabilityManager.shouldApplyDiscount((PromoCodeDiscount)promoCode, (TicketCategory)category)).orElse(null);
                if (specialCode.isPresent()) {
                    maxTickets = Math.min(1, maxTickets);
                } else if (filteredPromoCode != null && filteredPromoCode.getMaxUsage() != null) {
                    maxTickets = filteredPromoCode.getMaxUsage() - this.promoCodeRepository.countConfirmedPromoCode(filteredPromoCode.getId());
                }
                return new SaleableTicketCategory(category, now, event, this.ticketReservationManager.countAvailableTickets((EventAndOrganizationId)event, category), maxTickets, filteredPromoCode);
            }).collect(Collectors.toList());
            List valid = saleableTicketCategories.stream().filter(tc -> !tc.getExpired()).collect(Collectors.toList());
            List ticketCategoryIds = valid.stream().map(SaleableTicketCategory::getId).collect(Collectors.toList());
            Map ticketCategoryDescriptions = this.ticketCategoryDescriptionRepository.descriptionsByTicketCategory(ticketCategoryIds);
            List categoriesNoTax = this.configurationManager.getCategoriesWithNoTaxes(ticketCategoryIds);
            boolean displayTicketsLeft = ((ConfigurationManager.MaybeConfiguration)configurations.get(ConfigurationKeys.DISPLAY_TICKETS_LEFT_INDICATOR)).getValueAsBooleanOrDefault();
            Map<Boolean, List<alfio.controller.api.v2.model.TicketCategory>> categoriesByExpiredFlag = saleableTicketCategories.stream().map(stc -> {
                Map description = Formatters.applyCommonMark(ticketCategoryDescriptions.getOrDefault(stc.getId(), Collections.emptyMap()), (MessageSource)messageSource);
                Map expiration = Formatters.getFormattedDate((LocalizedContent)event, (ZonedDateTime)stc.getZonedExpiration(), (String)"common.ticket-category.date-format", (MessageSource)messageSource);
                Map inception = Formatters.getFormattedDate((LocalizedContent)event, (ZonedDateTime)stc.getZonedInception(), (String)"common.ticket-category.date-format", (MessageSource)messageSource);
                return new alfio.controller.api.v2.model.TicketCategory(stc, description, inception, expiration, displayTicketsLeft && !stc.isAccessRestricted(), !categoriesNoTax.contains(stc.getId()));
            }).sorted(Comparator.comparingInt(alfio.controller.api.v2.model.TicketCategory::getOrdinal)).collect(Collectors.partitioningBy(alfio.controller.api.v2.model.TicketCategory::isExpired));
            Optional promoCode = Optional.of(appliedPromoCode).filter(ValidatedResponse::isSuccess).map(ValidatedResponse::getValue).flatMap(Pair::getRight);
            List saleableAdditionalServices = this.additionalServiceManager.loadAllForEvent(event.getId()).stream().map(as -> new SaleableAdditionalService(event, as, (PromoCodeDiscount)promoCode.orElse(null))).filter(Predicate.not(SaleableAdditionalService::isExpired)).collect(Collectors.toList());
            List saleableAdditionalServicesIds = saleableAdditionalServices.stream().map(SaleableAdditionalService::id).collect(Collectors.toList());
            Map additionalServiceTexts = this.additionalServiceManager.getDescriptionsByAdditionalServiceIds(saleableAdditionalServicesIds);
            List additionalServicesRes = saleableAdditionalServices.stream().map(as -> {
                Map expiration = Formatters.getFormattedDate((LocalizedContent)event, (ZonedDateTime)as.getZonedExpiration(), (String)"common.ticket-category.date-format", (MessageSource)messageSource);
                Map inception = Formatters.getFormattedDate((LocalizedContent)event, (ZonedDateTime)as.getZonedInception(), (String)"common.ticket-category.date-format", (MessageSource)messageSource);
                Map title = additionalServiceTexts.getOrDefault(as.id(), Collections.emptyMap()).getOrDefault(AdditionalServiceText.TextType.TITLE, Collections.emptyMap());
                Map description = Formatters.applyCommonMark(additionalServiceTexts.getOrDefault(as.id(), Collections.emptyMap()).getOrDefault(AdditionalServiceText.TextType.DESCRIPTION, Collections.emptyMap()), (MessageSource)messageSource);
                return new AdditionalService(as.id(), as.type(), as.supplementPolicy(), as.fixPrice(), as.availableItems().intValue(), as.maxQtyPerOrder(), as.getFree(), as.getFormattedFinalPrice(), as.getSupportsDiscount(), as.getDiscountedPrice(), as.getVatApplies(), as.getVatIncluded(), as.getVatPercentage().toString(), as.isExpired(), as.getSaleInFuture(), inception, expiration, title, description);
            }).collect(Collectors.toList());
            boolean displayWaitingQueueForm = EventUtil.displayWaitingQueueForm((Event)event, saleableTicketCategories, (Map)configurations, (Predicate)this.eventStatisticsManager.noSeatsAvailable());
            boolean preSales = EventUtil.isPreSales((Event)event, saleableTicketCategories);
            Predicate<SaleableTicketCategory> waitingQueueTargetCategory = tc -> !tc.getExpired() && !tc.isBounded();
            List unboundedCategories = saleableTicketCategories.stream().filter(waitingQueueTargetCategory).collect(Collectors.toList());
            List tcForWaitingList = unboundedCategories.stream().map(stc -> new ItemsByCategory.TicketCategoryForWaitingList(stc.getId(), stc.getName())).collect(Collectors.toList());
            List<alfio.controller.api.v2.model.TicketCategory> activeCategories = categoriesByExpiredFlag.get(false);
            List expiredCategories = ((ConfigurationManager.MaybeConfiguration)configurations.get(ConfigurationKeys.DISPLAY_EXPIRED_CATEGORIES)).getValueAsBooleanOrDefault() ? categoriesByExpiredFlag.get(true) : List.of();
            return new ItemsByCategory(activeCategories, expiredCategories, additionalServicesRes, displayWaitingQueueForm, preSales, tcForWaitingList);
        });
    }

    private static boolean shouldDisplayRestrictedCategory(Optional<SpecialPrice> specialCode, TicketCategory c, Optional<PromoCodeDiscount> optionalPromoCode) {
        PromoCodeDiscount promoCode;
        if (optionalPromoCode.isPresent() && (promoCode = optionalPromoCode.get()).getCodeType() == PromoCodeDiscount.CodeType.ACCESS && c.getId() == promoCode.getHiddenCategoryId().intValue()) {
            return true;
        }
        return specialCode.filter(sc -> sc.getTicketCategoryId() == c.getId()).isPresent();
    }

    private static int getMaxAmountOfTicketsPerReservation(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> eventLevelConf, Map<Integer, String> ticketCategoryLevelConf, int ticketCategory) {
        if (ticketCategoryLevelConf.containsKey(ticketCategory)) {
            return Integer.parseInt(ticketCategoryLevelConf.get(ticketCategory));
        }
        return eventLevelConf.get(ConfigurationKeys.MAX_AMOUNT_OF_TICKETS_BY_RESERVATION).getValueAsIntOrDefault(5);
    }

    private static boolean shouldApplyDiscount(PromoCodeDiscount promoCodeDiscount, TicketCategory ticketCategory) {
        if (promoCodeDiscount.getCodeType() == PromoCodeDiscount.CodeType.DISCOUNT) {
            return promoCodeDiscount.getCategories().isEmpty() || promoCodeDiscount.getCategories().contains(ticketCategory.getId());
        }
        return ticketCategory.isAccessRestricted() && ticketCategory.getId() == promoCodeDiscount.getHiddenCategoryId().intValue();
    }
}

