/*
 * Decompiled with CFR 0.152.
 */
package alfio.manager;

import alfio.controller.api.support.TicketHelper;
import alfio.controller.form.UpdateTicketOwnerForm;
import alfio.manager.AdditionalServiceManager;
import alfio.manager.BillingDocumentManager;
import alfio.manager.ExtensionManager;
import alfio.manager.GroupManager;
import alfio.manager.NotificationManager;
import alfio.manager.PaymentManager;
import alfio.manager.PurchaseContextManager;
import alfio.manager.ReservationFinalizer;
import alfio.manager.TicketReservationManager;
import alfio.manager.WaitingQueueManager;
import alfio.manager.i18n.MessageSourceManager;
import alfio.manager.payment.BankTransferManager;
import alfio.manager.payment.PaymentSpecification;
import alfio.manager.support.CategoryEvaluator;
import alfio.manager.support.PartialTicketTextGenerator;
import alfio.manager.support.PaymentResult;
import alfio.manager.support.PaymentWebhookResult;
import alfio.manager.support.RefundPriceContainer;
import alfio.manager.support.reservation.CannotProceedWithPayment;
import alfio.manager.support.reservation.InvalidSpecialPriceTokenException;
import alfio.manager.support.reservation.MissingSpecialPriceTokenException;
import alfio.manager.support.reservation.NotEnoughTicketsException;
import alfio.manager.support.reservation.OrderSummaryGenerator;
import alfio.manager.support.reservation.ReservationAuditingHelper;
import alfio.manager.support.reservation.ReservationCostCalculator;
import alfio.manager.support.reservation.ReservationEmailContentHelper;
import alfio.manager.support.reservation.TooManyTicketsForDiscountCodeException;
import alfio.manager.system.ConfigurationLevel;
import alfio.manager.system.ConfigurationManager;
import alfio.manager.user.UserManager;
import alfio.model.AllocationStatus;
import alfio.model.Audit;
import alfio.model.BillingDocument;
import alfio.model.CategoryAvailability;
import alfio.model.Configurable;
import alfio.model.CustomerName;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.OrderSummary;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.PurchaseContextFieldValue;
import alfio.model.ReservationIdAndEventId;
import alfio.model.ReservationMetadata;
import alfio.model.ReservationWithPurchaseContext;
import alfio.model.SpecialPrice;
import alfio.model.SummaryRow;
import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketReservation;
import alfio.model.TicketReservationAdditionalInfo;
import alfio.model.TicketReservationInvoicingAdditionalInfo;
import alfio.model.TicketReservationStatusAndValidation;
import alfio.model.TicketReservationWithTransaction;
import alfio.model.TotalPrice;
import alfio.model.checkin.CheckInFullInfo;
import alfio.model.decorator.TicketPriceContainer;
import alfio.model.metadata.SubscriptionMetadata;
import alfio.model.metadata.TicketMetadata;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.modification.ASReservationWithOptionalCodeModification;
import alfio.model.modification.AttendeeData;
import alfio.model.modification.TicketReservationWithOptionalCodeModification;
import alfio.model.modification.TransactionMetadataModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.result.WarningMessage;
import alfio.model.subscription.EventSubscriptionLink;
import alfio.model.subscription.MaxEntriesOverageDetails;
import alfio.model.subscription.Subscription;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.subscription.SubscriptionUsageExceeded;
import alfio.model.subscription.SubscriptionUsageExceededForEvent;
import alfio.model.subscription.SubscriptionWithUsageDetails;
import alfio.model.subscription.UsageDetails;
import alfio.model.system.ConfigurationKeys;
import alfio.model.system.command.CleanupReservations;
import alfio.model.system.command.FinalizeReservation;
import alfio.model.system.command.InvalidateAccess;
import alfio.model.transaction.PaymentContext;
import alfio.model.transaction.PaymentMethod;
import alfio.model.transaction.PaymentProvider;
import alfio.model.transaction.PaymentProxy;
import alfio.model.transaction.PaymentToken;
import alfio.model.transaction.Transaction;
import alfio.model.transaction.TransactionInitializationToken;
import alfio.model.transaction.TransactionRequest;
import alfio.model.transaction.TransactionWebhookPayload;
import alfio.model.transaction.capabilities.OfflineProcessor;
import alfio.model.transaction.capabilities.ServerInitiatedTransaction;
import alfio.model.transaction.capabilities.WebhookHandler;
import alfio.model.user.Organization;
import alfio.model.user.Role;
import alfio.model.user.User;
import alfio.repository.AuditingRepository;
import alfio.repository.BillingDocumentRepository;
import alfio.repository.EventRepository;
import alfio.repository.PromoCodeDiscountRepository;
import alfio.repository.PurchaseContextFieldRepository;
import alfio.repository.SpecialPriceRepository;
import alfio.repository.SubscriptionRepository;
import alfio.repository.TicketCategoryDescriptionRepository;
import alfio.repository.TicketCategoryRepository;
import alfio.repository.TicketRepository;
import alfio.repository.TicketReservationRepository;
import alfio.repository.TicketSearchRepository;
import alfio.repository.TransactionRepository;
import alfio.repository.user.OrganizationRepository;
import alfio.repository.user.UserRepository;
import alfio.util.ClockProvider;
import alfio.util.Json;
import alfio.util.LocaleUtil;
import alfio.util.MiscUtils;
import alfio.util.MonetaryUtil;
import alfio.util.PinGenerator;
import alfio.util.RenderedTemplate;
import alfio.util.ReservationUtil;
import alfio.util.SqlUtils;
import alfio.util.TemplateManager;
import alfio.util.TemplateResource;
import alfio.util.Wrappers;
import alfio.util.checkin.TicketCheckInUtil;
import java.math.BigDecimal;
import java.security.Principal;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.MessageSource;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Transactional
public class TicketReservationManager {
    private static final Logger log = LoggerFactory.getLogger(TicketReservationManager.class);
    public static final String NOT_YET_PAID_TRANSACTION_ID = "not-paid";
    private static final String STUCK_TICKETS_MSG = "there are stuck tickets for the event %s. Please check admin area.";
    private static final String STUCK_TICKETS_SUBJECT = "warning: stuck tickets found";
    private static final String ORGANIZATION = "organization";
    private static final String RESERVATION_ID = "reservationId";
    private final EventRepository eventRepository;
    private final OrganizationRepository organizationRepository;
    private final TicketRepository ticketRepository;
    private final TicketReservationRepository ticketReservationRepository;
    private final TicketCategoryRepository ticketCategoryRepository;
    private final TicketCategoryDescriptionRepository ticketCategoryDescriptionRepository;
    private final ConfigurationManager configurationManager;
    private final PaymentManager paymentManager;
    private final PromoCodeDiscountRepository promoCodeDiscountRepository;
    private final SpecialPriceRepository specialPriceRepository;
    private final TransactionRepository transactionRepository;
    private final NotificationManager notificationManager;
    private final MessageSourceManager messageSourceManager;
    private final TemplateManager templateManager;
    private final TransactionTemplate requiresNewTransactionTemplate;
    private final TransactionTemplate serializedTransactionTemplate;
    private final TransactionTemplate nestedTransactionTemplate;
    private final WaitingQueueManager waitingQueueManager;
    private final PurchaseContextFieldRepository purchaseContextFieldRepository;
    private final AuditingRepository auditingRepository;
    private final UserRepository userRepository;
    private final ExtensionManager extensionManager;
    private final TicketSearchRepository ticketSearchRepository;
    private final GroupManager groupManager;
    private final BillingDocumentRepository billingDocumentRepository;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final Json json;
    private final BillingDocumentManager billingDocumentManager;
    private final ClockProvider clockProvider;
    private final PurchaseContextManager purchaseContextManager;
    private final SubscriptionRepository subscriptionRepository;
    private final UserManager userManager;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final ReservationEmailContentHelper reservationHelper;
    private final ReservationCostCalculator reservationCostCalculator;
    private final OrderSummaryGenerator orderSummaryGenerator;
    private final ReservationAuditingHelper auditingHelper;
    private final ReservationFinalizer reservationFinalizer;
    private final AdditionalServiceManager additionalServiceManager;

    public TicketReservationManager(EventRepository eventRepository, OrganizationRepository organizationRepository, TicketRepository ticketRepository, TicketReservationRepository ticketReservationRepository, TicketCategoryRepository ticketCategoryRepository, TicketCategoryDescriptionRepository ticketCategoryDescriptionRepository, ConfigurationManager configurationManager, PaymentManager paymentManager, PromoCodeDiscountRepository promoCodeDiscountRepository, SpecialPriceRepository specialPriceRepository, TransactionRepository transactionRepository, NotificationManager notificationManager, MessageSourceManager messageSourceManager, TemplateManager templateManager, PlatformTransactionManager transactionManager, WaitingQueueManager waitingQueueManager, PurchaseContextFieldRepository purchaseContextFieldRepository, AdditionalServiceManager additionalServiceManager, AuditingRepository auditingRepository, UserRepository userRepository, ExtensionManager extensionManager, TicketSearchRepository ticketSearchRepository, GroupManager groupManager, BillingDocumentRepository billingDocumentRepository, NamedParameterJdbcTemplate jdbcTemplate, Json json, BillingDocumentManager billingDocumentManager, ClockProvider clockProvider, PurchaseContextManager purchaseContextManager, SubscriptionRepository subscriptionRepository, UserManager userManager, ApplicationEventPublisher applicationEventPublisher, ReservationCostCalculator reservationCostCalculator, ReservationEmailContentHelper reservationHelper, ReservationFinalizer reservationFinalizer, OrderSummaryGenerator orderSummaryGenerator) {
        this.eventRepository = eventRepository;
        this.organizationRepository = organizationRepository;
        this.ticketRepository = ticketRepository;
        this.ticketReservationRepository = ticketReservationRepository;
        this.ticketCategoryRepository = ticketCategoryRepository;
        this.ticketCategoryDescriptionRepository = ticketCategoryDescriptionRepository;
        this.configurationManager = configurationManager;
        this.paymentManager = paymentManager;
        this.promoCodeDiscountRepository = promoCodeDiscountRepository;
        this.specialPriceRepository = specialPriceRepository;
        this.transactionRepository = transactionRepository;
        this.notificationManager = notificationManager;
        this.messageSourceManager = messageSourceManager;
        this.templateManager = templateManager;
        this.waitingQueueManager = waitingQueueManager;
        this.requiresNewTransactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(3));
        DefaultTransactionDefinition serialized = new DefaultTransactionDefinition(3);
        serialized.setIsolationLevel(8);
        this.serializedTransactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)serialized);
        this.nestedTransactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(6));
        this.purchaseContextFieldRepository = purchaseContextFieldRepository;
        this.additionalServiceManager = additionalServiceManager;
        this.auditingRepository = auditingRepository;
        this.userRepository = userRepository;
        this.extensionManager = extensionManager;
        this.ticketSearchRepository = ticketSearchRepository;
        this.groupManager = groupManager;
        this.billingDocumentRepository = billingDocumentRepository;
        this.jdbcTemplate = jdbcTemplate;
        this.json = json;
        this.billingDocumentManager = billingDocumentManager;
        this.clockProvider = clockProvider;
        this.purchaseContextManager = purchaseContextManager;
        this.subscriptionRepository = subscriptionRepository;
        this.userManager = userManager;
        this.applicationEventPublisher = applicationEventPublisher;
        this.reservationCostCalculator = reservationCostCalculator;
        this.orderSummaryGenerator = orderSummaryGenerator;
        this.reservationHelper = reservationHelper;
        this.auditingHelper = new ReservationAuditingHelper(auditingRepository);
        this.reservationFinalizer = reservationFinalizer;
    }

    private String createSubscriptionReservation(SubscriptionDescriptor subscriptionDescriptor, Date reservationExpiration, Locale locale, Integer userId, SubscriptionMetadata metadata) throws CannotProceedWithPayment, NotEnoughTicketsException {
        UUID subscriptionId;
        String reservationId = UUID.randomUUID().toString();
        this.ticketReservationRepository.createNewReservation(reservationId, subscriptionDescriptor.now(this.clockProvider), reservationExpiration, null, locale.getLanguage(), (Integer)subscriptionDescriptor.event().map(EventAndOrganizationId::getId).orElse(null), subscriptionDescriptor.getVat(), Boolean.valueOf(subscriptionDescriptor.getVatStatus() == PriceContainer.VatStatus.INCLUDED), subscriptionDescriptor.getCurrency(), subscriptionDescriptor.getOrganizationId(), userId);
        if (subscriptionDescriptor.getMaxAvailable() > 0) {
            Optional optionalSubscription = this.subscriptionRepository.selectFreeSubscription(subscriptionDescriptor.getId());
            if (optionalSubscription.isEmpty()) {
                throw new NotEnoughTicketsException();
            }
            UUID subscription = (UUID)optionalSubscription.get();
            Validate.isTrue((this.subscriptionRepository.bindSubscriptionToReservation(reservationId, subscriptionDescriptor.getPrice(), AllocationStatus.PENDING, subscription) == 1 ? 1 : 0) != 0);
            subscriptionId = subscription;
        } else {
            subscriptionId = UUID.randomUUID();
            this.subscriptionRepository.createSubscription(subscriptionId, subscriptionDescriptor.getId(), reservationId, subscriptionDescriptor.getMaxEntries(), subscriptionDescriptor.getValidityFrom(), subscriptionDescriptor.getValidityTo(), subscriptionDescriptor.getPrice(), subscriptionDescriptor.getCurrency(), subscriptionDescriptor.getOrganizationId(), AllocationStatus.PENDING, subscriptionDescriptor.getMaxEntries(), subscriptionDescriptor.getTimeZone());
        }
        TotalPrice totalPrice = (TotalPrice)this.totalReservationCostWithVAT(reservationId).getLeft();
        PriceContainer.VatStatus vatStatus = subscriptionDescriptor.getVatStatus();
        this.ticketReservationRepository.updateBillingData(subscriptionDescriptor.getVatStatus(), this.calculateSrcPrice(vatStatus, totalPrice), totalPrice.getPriceWithVAT(), totalPrice.getVAT(), Math.abs(totalPrice.getDiscount()), subscriptionDescriptor.getCurrency(), null, null, false, reservationId);
        this.auditingRepository.insert(reservationId, null, (Integer)subscriptionDescriptor.event().map(EventAndOrganizationId::getId).orElse(null), Audit.EventType.RESERVATION_CREATE, new Date(), Audit.EntityType.RESERVATION, reservationId);
        if (!this.canProceedWithPayment((PurchaseContext)subscriptionDescriptor, totalPrice, reservationId)) {
            throw new CannotProceedWithPayment("No payment method applicable for purchase context  " + subscriptionDescriptor.getType() + " with public id " + subscriptionDescriptor.getPublicIdentifier());
        }
        if (metadata != null) {
            Validate.isTrue((this.subscriptionRepository.setMetadataForSubscription(subscriptionId, metadata) == 1 ? 1 : 0) != 0);
        }
        return reservationId;
    }

    public String createTicketReservation(Event event, List<TicketReservationWithOptionalCodeModification> list, List<ASReservationWithOptionalCodeModification> additionalServices, Date reservationExpiration, Optional<String> promotionCodeDiscount, Locale locale, boolean forWaitingQueue, Principal principal) throws NotEnoughTicketsException, MissingSpecialPriceTokenException, InvalidSpecialPriceTokenException {
        String reservationId = UUID.randomUUID().toString();
        Optional discount = promotionCodeDiscount.flatMap(promoCodeDiscount -> this.promoCodeDiscountRepository.findPromoCodeInEventOrOrganization(event.getId(), promoCodeDiscount));
        Optional dynamicDiscount = this.createDynamicPromoCode(discount, event, list, reservationId);
        discount.ifPresent(d -> {
            if (d.getMaxUsage() != null) {
                long appliedDiscountCount;
                this.promoCodeDiscountRepository.lockForCount(d.getId());
                Set discountedCategories = d.getCategories();
                long l = appliedDiscountCount = CollectionUtils.isEmpty((Collection)discountedCategories) ? (long)list.size() : list.stream().filter(t -> discountedCategories.contains(t.getTicketCategoryId())).count();
                if ((long)d.getMaxUsage().intValue() < (long)this.promoCodeDiscountRepository.countUsedPromoCode(d.getId()).intValue() + appliedDiscountCount) {
                    throw new TooManyTicketsForDiscountCodeException();
                }
            }
        });
        this.ticketReservationRepository.createNewReservation(reservationId, event.now(this.clockProvider), reservationExpiration, (Integer)dynamicDiscount.or(() -> discount).map(PromoCodeDiscount::getId).orElse(null), locale.getLanguage(), Integer.valueOf(event.getId()), event.getVat(), Boolean.valueOf(event.isVatIncluded()), event.getCurrency(), event.getOrganizationId(), this.retrievePublicUserId(principal));
        list.forEach(t -> this.reserveTicketsForCategory(event, reservationId, t, locale, forWaitingQueue, (PromoCodeDiscount)discount.orElse(null), (PromoCodeDiscount)dynamicDiscount.orElse(null)));
        this.additionalServiceManager.bookAdditionalServicesForReservation(event, reservationId, additionalServices, discount);
        TotalPrice totalPrice = (TotalPrice)this.totalReservationCostWithVAT(reservationId).getLeft();
        PriceContainer.VatStatus vatStatus = event.getVatStatus();
        this.ticketReservationRepository.updateBillingData(event.getVatStatus(), this.calculateSrcPrice(vatStatus, totalPrice), totalPrice.getPriceWithVAT(), totalPrice.getVAT(), Math.abs(totalPrice.getDiscount()), event.getCurrency(), null, null, false, reservationId);
        this.auditingRepository.insert(reservationId, null, Integer.valueOf(event.getId()), Audit.EventType.RESERVATION_CREATE, new Date(), Audit.EntityType.RESERVATION, reservationId);
        if (this.isDiscountCodeUsageExceeded(reservationId)) {
            throw new TooManyTicketsForDiscountCodeException();
        }
        if (!this.canProceedWithPayment((PurchaseContext)event, totalPrice, reservationId)) {
            throw new CannotProceedWithPayment("No payment method applicable for categories " + list.stream().map(t -> String.valueOf(t.getTicketCategoryId())).collect(Collectors.joining(", ")));
        }
        return reservationId;
    }

    private Optional<PromoCodeDiscount> createDynamicPromoCode(Optional<PromoCodeDiscount> existingDiscount, Event event, List<TicketReservationWithOptionalCodeModification> list, String reservationId) {
        if (existingDiscount.filter(dt -> dt.getCodeType() != PromoCodeDiscount.CodeType.ACCESS).isEmpty()) {
            return this.createDynamicPromoCodeIfNeeded(event, list, reservationId).flatMap(promoCodeDiscount -> this.promoCodeDiscountRepository.findPromoCodeInEventOrOrganization(event.getId(), promoCodeDiscount));
        }
        return existingDiscount;
    }

    Optional<String> createDynamicPromoCodeIfNeeded(Event event, List<TicketReservationWithOptionalCodeModification> list, String reservationId) {
        PromoCodeDiscount newCode;
        int result;
        Integer paidCategories = this.ticketCategoryRepository.countPaidCategoriesInReservation((Collection)list.stream().map(TicketReservationWithOptionalCodeModification::getTicketCategoryId).collect(Collectors.toSet()));
        if (paidCategories == null || paidCategories == 0) {
            return Optional.empty();
        }
        Optional newCodeOptional = this.extensionManager.handleDynamicDiscount(event, list.stream().collect(Collectors.groupingBy(TicketReservationWithOptionalCodeModification::getTicketCategoryId, Collectors.summingLong(TicketReservationWithOptionalCodeModification::getQuantity))), reservationId);
        if (newCodeOptional.isPresent() && (result = this.promoCodeDiscountRepository.addPromoCodeIfNotExists((newCode = (PromoCodeDiscount)newCodeOptional.get()).getPromoCode(), Integer.valueOf(event.getId()), event.getOrganizationId(), newCode.getUtcStart(), newCode.getUtcEnd(), newCode.getDiscountAmount(), newCode.getDiscountType(), "[]", null, null, null, newCode.getCodeType(), null)) > 0) {
            this.auditingRepository.insert(reservationId, null, Integer.valueOf(event.getId()), Audit.EventType.DYNAMIC_DISCOUNT_CODE_CREATED, new Date(), Audit.EntityType.RESERVATION, reservationId);
        }
        return newCodeOptional.map(PromoCodeDiscount::getPromoCode);
    }

    private int calculateSrcPrice(PriceContainer.VatStatus vatStatus, TotalPrice totalPrice) {
        return (vatStatus == PriceContainer.VatStatus.INCLUDED ? totalPrice.getPriceWithVAT() : totalPrice.getPriceWithVAT() - totalPrice.getVAT()) + Math.abs(totalPrice.getDiscount());
    }

    void reserveTicketsForCategory(Event event, String reservationId, TicketReservationWithOptionalCodeModification ticketReservation, Locale locale, boolean forWaitingQueue, PromoCodeDiscount accessCodeOrDiscount, PromoCodeDiscount dynamicDiscount) {
        List specialPrices;
        if (accessCodeOrDiscount != null && accessCodeOrDiscount.getCodeType() == PromoCodeDiscount.CodeType.ACCESS && ticketReservation.getTicketCategoryId().equals(accessCodeOrDiscount.getHiddenCategoryId()) && Boolean.TRUE.equals(this.ticketCategoryRepository.isAccessRestricted(accessCodeOrDiscount.getHiddenCategoryId()))) {
            specialPrices = this.reserveTokensForAccessCode(ticketReservation, accessCodeOrDiscount);
        } else {
            Optional specialPrice = this.fixToken(ticketReservation.getSpecialPrice(), ticketReservation.getTicketCategoryId().intValue(), event.getId(), ticketReservation);
            specialPrices = specialPrice.stream().collect(Collectors.toList());
        }
        List reservedForUpdate = this.reserveTickets(event.getId(), ticketReservation, forWaitingQueue ? Arrays.asList(Ticket.TicketStatus.RELEASED, Ticket.TicketStatus.PRE_RESERVED) : Collections.singletonList(Ticket.TicketStatus.FREE));
        int requested = ticketReservation.getQuantity();
        if (reservedForUpdate.size() != requested) {
            throw new NotEnoughTicketsException();
        }
        TicketCategory category = this.ticketCategoryRepository.getByIdAndActive(ticketReservation.getTicketCategoryId().intValue(), event.getId());
        this.initTicketsForReservation(event, reservationId, locale, accessCodeOrDiscount, specialPrices, reservedForUpdate, category, ticketReservation);
        Ticket ticket = this.ticketRepository.findById(((Integer)reservedForUpdate.get(0)).intValue(), category.getId());
        PromoCodeDiscount discountToApply = (PromoCodeDiscount)ObjectUtils.firstNonNull((Object[])new PromoCodeDiscount[]{dynamicDiscount, accessCodeOrDiscount});
        TicketPriceContainer priceContainer = TicketPriceContainer.from((Ticket)ticket, null, (BigDecimal)event.getVat(), (PriceContainer.VatStatus)event.getVatStatus(), (PromoCodeDiscount)discountToApply);
        String currencyCode = priceContainer.getCurrencyCode();
        this.ticketRepository.updateTicketPrice(reservedForUpdate, category.getId(), event.getId(), category.getSrcPriceCts(), MonetaryUtil.unitToCents((BigDecimal)priceContainer.getFinalPrice(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)priceContainer.getVAT(), (String)currencyCode), MonetaryUtil.unitToCents((BigDecimal)priceContainer.getAppliedDiscount(), (String)currencyCode), category.getCurrencyCode(), priceContainer.getVatStatus());
    }

    private void initTicketsForReservation(Event event, String reservationId, Locale locale, PromoCodeDiscount accessCodeOrDiscount, List<SpecialPrice> specialPrices, List<Integer> reservedForUpdate, TicketCategory category, TicketReservationWithOptionalCodeModification ticketReservation) {
        List attendees = Objects.requireNonNull(ticketReservation.getAttendees());
        if (!specialPrices.isEmpty()) {
            if (specialPrices.size() != reservedForUpdate.size()) {
                throw new NotEnoughTicketsException();
            }
            if (specialPrices.size() == 1) {
                Integer ticketId = reservedForUpdate.get(0);
                SpecialPrice sp2 = specialPrices.get(0);
                Integer accessCodeId = accessCodeOrDiscount != null && accessCodeOrDiscount.getHiddenCategoryId() != null ? Integer.valueOf(accessCodeOrDiscount.getId()) : null;
                TicketMetadata metadata = null;
                AttendeeData attendee = TicketReservationManager.getAtIndexOrEmpty((List)attendees, (int)0);
                if (attendee.hasMetadata()) {
                    metadata = new TicketMetadata(null, null, attendee.getMetadata());
                }
                this.ticketRepository.reserveTicket(reservationId, ticketId.intValue(), sp2.getId(), locale.getLanguage(), category.getSrcPriceCts(), category.getCurrencyCode(), event.getVatStatus(), TicketMetadataContainer.fromMetadata((TicketMetadata)metadata));
                if (attendee.hasContactData()) {
                    this.ticketRepository.updateTicketOwnerById(ticketId.intValue(), attendee.getEmail(), attendee.getFullName(), attendee.getFirstName(), attendee.getLastName());
                }
                if (attendee.hasAdditionalData()) {
                    this.purchaseContextFieldRepository.updateOrInsert(attendee.getAdditional(), (PurchaseContext)event, ticketId, null);
                }
                this.specialPriceRepository.updateStatus(sp2.getId(), SpecialPrice.Status.PENDING.toString(), null, accessCodeId);
            } else {
                AtomicInteger counter = new AtomicInteger(0);
                List ticketsAndSpecialPrices = specialPrices.stream().map(sp -> {
                    int index = counter.getAndIncrement();
                    return Triple.of((Object)((Integer)reservedForUpdate.get(index)), (Object)sp, (Object)TicketReservationManager.getAtIndexOrEmpty((List)attendees, (int)index));
                }).collect(Collectors.toList());
                this.jdbcTemplate.batchUpdate(this.ticketRepository.batchReserveTicketsForSpecialPrice(), (SqlParameterSource[])ticketsAndSpecialPrices.stream().map(triple -> {
                    String metadata = null;
                    AttendeeData attendee = (AttendeeData)triple.getRight();
                    if (attendee.hasMetadata()) {
                        metadata = this.json.asJsonString((Object)TicketMetadataContainer.fromMetadata((TicketMetadata)new TicketMetadata(null, null, attendee.getMetadata())));
                    }
                    return new MapSqlParameterSource("reservationId", (Object)reservationId).addValue("ticketId", triple.getLeft()).addValue("specialCodeId", (Object)((SpecialPrice)triple.getMiddle()).getId()).addValue("userLanguage", (Object)locale.getLanguage()).addValue("srcPriceCts", (Object)category.getSrcPriceCts()).addValue("currencyCode", (Object)category.getCurrencyCode()).addValue("ticketMetadata", (Object)Objects.requireNonNullElse(metadata, "{}")).addValue("firstName", (Object)attendee.getFirstName()).addValue("lastName", (Object)attendee.getLastName()).addValue("fullName", (Object)attendee.getFullName()).addValue("email", (Object)attendee.getEmail()).addValue("vatStatus", (Object)event.getVatStatus().toString());
                }).toArray(MapSqlParameterSource[]::new));
                this.specialPriceRepository.batchUpdateStatus(specialPrices.stream().map(SpecialPrice::getId).collect(Collectors.toList()), SpecialPrice.Status.PENDING, Integer.valueOf(Objects.requireNonNull(accessCodeOrDiscount).getId()));
                ticketsAndSpecialPrices.stream().filter(tsp -> ((AttendeeData)tsp.getRight()).hasAdditionalData()).forEach(tsp -> this.purchaseContextFieldRepository.updateOrInsert(((AttendeeData)tsp.getRight()).getAdditional(), (PurchaseContext)event, (Integer)tsp.getLeft(), null));
            }
        } else {
            int reserved = this.ticketRepository.reserveTickets(reservationId, reservedForUpdate, category, locale.getLanguage(), event.getVatStatus(), idx -> TicketReservationManager.getAtIndexOrEmpty((List)attendees, (int)idx));
            Validate.isTrue((reserved == reservedForUpdate.size() ? 1 : 0) != 0, (String)"Cannot reserve all tickets", (Object[])new Object[0]);
            for (int i = 0; i < reservedForUpdate.size(); ++i) {
                AttendeeData attendee = TicketReservationManager.getAtIndexOrEmpty((List)attendees, (int)i);
                if (!attendee.hasAdditionalData()) continue;
                this.purchaseContextFieldRepository.updateOrInsert(attendee.getAdditional(), (PurchaseContext)event, reservedForUpdate.get(i), null);
            }
        }
    }

    private static AttendeeData getAtIndexOrEmpty(List<AttendeeData> attendees, int index) {
        return Objects.requireNonNullElse((AttendeeData)MiscUtils.getAtIndexOrNull(attendees, (int)index), AttendeeData.empty());
    }

    List<SpecialPrice> reserveTokensForAccessCode(TicketReservationWithOptionalCodeModification ticketReservation, PromoCodeDiscount accessCode) {
        try {
            Validate.isTrue((boolean)this.promoCodeDiscountRepository.lockAccessCodeForUpdate(accessCode.getId()).equals(accessCode.getId()));
            List boundSpecialPrices = this.specialPriceRepository.bindToAccessCode(ticketReservation.getTicketCategoryId().intValue(), accessCode.getId(), ticketReservation.getQuantity().intValue());
            if (boundSpecialPrices.size() != ticketReservation.getQuantity().intValue()) {
                throw new NotEnoughTicketsException();
            }
            return boundSpecialPrices;
        }
        catch (Exception e) {
            log.trace("constraints violated", (Throwable)e);
            if (e instanceof NotEnoughTicketsException) {
                throw e;
            }
            throw new TooManyTicketsForDiscountCodeException();
        }
    }

    List<Integer> reserveTickets(int eventId, TicketReservationWithOptionalCodeModification ticketReservation, List<Ticket.TicketStatus> requiredStatuses) {
        return this.reserveTickets(eventId, ticketReservation.getTicketCategoryId().intValue(), ticketReservation.getQuantity().intValue(), requiredStatuses);
    }

    List<Integer> reserveTickets(int eventId, int categoryId, int qty, List<Ticket.TicketStatus> requiredStatuses) {
        TicketCategory category = this.ticketCategoryRepository.getByIdAndActive(categoryId, eventId);
        List statusesAsString = requiredStatuses.stream().map(Enum::name).collect(Collectors.toList());
        if (category.isBounded()) {
            return this.ticketRepository.selectTicketInCategoryForUpdateSkipLocked(eventId, categoryId, qty, statusesAsString);
        }
        return this.ticketRepository.selectNotAllocatedTicketsForUpdateSkipLocked(eventId, qty, statusesAsString);
    }

    Optional<SpecialPrice> fixToken(Optional<SpecialPrice> token, int ticketCategoryId, int eventId, TicketReservationWithOptionalCodeModification ticketReservation) {
        boolean canAccessRestrictedCategory;
        TicketCategory ticketCategory = this.ticketCategoryRepository.getByIdAndActive(ticketCategoryId, eventId);
        if (!ticketCategory.isAccessRestricted()) {
            return Optional.empty();
        }
        Optional<SpecialPrice> specialPrice = token.map(SpecialPrice::getCode).flatMap(arg_0 -> ((SpecialPriceRepository)this.specialPriceRepository).getForUpdateByCode(arg_0));
        if (token.isPresent() && specialPrice.isEmpty()) {
            throw new InvalidSpecialPriceTokenException();
        }
        boolean bl = canAccessRestrictedCategory = specialPrice.isPresent() && ((SpecialPrice)specialPrice.get()).getStatus() == SpecialPrice.Status.FREE && ((SpecialPrice)specialPrice.get()).getTicketCategoryId() == ticketCategoryId;
        if (canAccessRestrictedCategory && ticketReservation.getQuantity() > 1) {
            throw new NotEnoughTicketsException();
        }
        if (!canAccessRestrictedCategory && ticketCategory.isAccessRestricted()) {
            throw new MissingSpecialPriceTokenException();
        }
        return specialPrice;
    }

    public PaymentResult performPayment(PaymentSpecification spec, TotalPrice reservationCost, PaymentProxy proxy, PaymentMethod paymentMethod, Principal principal) {
        PaymentProxy paymentProxy = this.evaluatePaymentProxy(proxy, reservationCost);
        if (!this.acquireGroupMembers(spec.getReservationId(), spec.getPurchaseContext())) {
            this.groupManager.deleteWhitelistedTicketsForReservation(spec.getReservationId());
            return PaymentResult.failed((String)"error.STEP2_WHITELIST");
        }
        if (this.paymentMethodIsBlacklisted(paymentMethod, spec)) {
            log.warn("payment method {} forbidden for reservationId {}", (Object)paymentMethod, (Object)spec.getReservationId());
            return PaymentResult.failed((String)"error.STEP2_UNABLE_TO_TRANSITION");
        }
        if (!this.initPaymentProcess(reservationCost, paymentProxy, spec, principal)) {
            return PaymentResult.failed((String)"error.STEP2_UNABLE_TO_TRANSITION");
        }
        TicketReservation reservation = null;
        try {
            PaymentResult paymentResult;
            reservation = this.ticketReservationRepository.findReservationByIdForUpdate(spec.getReservationId());
            if (reservation.getStatus() == TicketReservation.TicketReservationStatus.COMPLETE) {
                return PaymentResult.successful((String)"");
            }
            this.ticketReservationRepository.updateBillingData(spec.getVatStatus(), reservation.getSrcPriceCts(), reservation.getFinalPriceCts(), reservation.getVatCts(), reservation.getDiscountCts(), reservation.getCurrencyCode(), spec.getVatNr(), spec.getVatCountryCode(), spec.isInvoiceRequested(), spec.getReservationId());
            if (this.isDiscountCodeUsageExceeded(spec.getReservationId())) {
                return PaymentResult.failed((String)"error.STEP2_DISCOUNT_CODE_USAGE_EXCEEDED");
            }
            if (reservationCost.requiresPayment()) {
                TransactionRequest transactionRequest = new TransactionRequest(reservationCost, this.ticketReservationRepository.getBillingDetailsForReservation(spec.getReservationId()));
                PaymentContext paymentContext = spec.getPaymentContext();
                paymentResult = this.paymentManager.streamActiveProvidersByProxy(paymentProxy, paymentContext).filter(paymentProvider -> paymentProvider.accept(paymentMethod, paymentContext, transactionRequest)).findFirst().map(paymentProvider -> paymentProvider.getTokenAndPay(spec)).orElseGet(() -> PaymentResult.failed((String)"error.STEP2_STRIPE_unexpected"));
            } else {
                paymentResult = PaymentResult.successful((String)"not-paid");
            }
            if (paymentResult.isSuccessful()) {
                reservation = this.ticketReservationRepository.findReservationById(spec.getReservationId());
                this.transitionToComplete(spec, paymentProxy, null);
            } else if (paymentResult.isFailed()) {
                this.reTransitionToPending(spec.getReservationId());
            }
            return paymentResult;
        }
        catch (Exception ex) {
            if (reservation != null && reservation.getStatus() != TicketReservation.TicketReservationStatus.IN_PAYMENT) {
                this.reTransitionToPending(spec.getReservationId());
            }
            log.error("unexpected error during payment confirmation", (Throwable)ex);
            return PaymentResult.failed((String)"error.STEP2_STRIPE_unexpected");
        }
    }

    private boolean paymentMethodIsBlacklisted(PaymentMethod paymentMethod, PaymentSpecification spec) {
        return this.configurationManager.getBlacklistedMethodsForReservation(spec.getPurchaseContext(), this.findCategoryIdsInReservation(spec.getReservationId())).stream().anyMatch(m -> m == paymentMethod);
    }

    public Collection<Integer> findCategoryIdsInReservation(String reservationId) {
        return this.findTicketsInReservation(reservationId).stream().map(Ticket::getCategoryId).collect(Collectors.toSet());
    }

    public boolean cancelPendingPayment(String reservationId, PurchaseContext purchaseContext) {
        Optional optionalReservation = this.findById(reservationId);
        if (optionalReservation.isEmpty()) {
            return false;
        }
        Optional optionalTransaction = this.transactionRepository.loadOptionalByReservationId(reservationId);
        if (optionalTransaction.isEmpty() || ((Transaction)optionalTransaction.get()).getStatus() != Transaction.Status.PENDING) {
            log.warn("Trying to cancel a non-pending transaction for reservation {}", (Object)reservationId);
            return false;
        }
        Transaction transaction = (Transaction)optionalTransaction.get();
        boolean remoteDeleteResult = this.paymentManager.lookupProviderByTransactionAndCapabilities(transaction, List.of(ServerInitiatedTransaction.class)).map(provider -> ((ServerInitiatedTransaction)provider).discardTransaction((Transaction)optionalTransaction.get(), purchaseContext)).orElse(true);
        if (remoteDeleteResult) {
            this.reTransitionToPending(reservationId);
            this.auditingRepository.insert(reservationId, null, (Integer)purchaseContext.event().map(EventAndOrganizationId::getId).orElse(null), Audit.EventType.RESET_PAYMENT, new Date(), Audit.EntityType.RESERVATION, reservationId);
            return true;
        }
        log.warn("Cannot delete payment with ID {} for reservation {}", (Object)transaction.getPaymentId(), (Object)reservationId);
        return false;
    }

    private void transitionToComplete(PaymentSpecification spec, PaymentProxy paymentProxy, String username) {
        TicketReservation.TicketReservationStatus status = ((TicketReservationStatusAndValidation)this.ticketReservationRepository.findOptionalStatusAndValidationById(spec.getReservationId()).orElseThrow()).getStatus();
        if (status != TicketReservation.TicketReservationStatus.COMPLETE) {
            this.completeReservation(spec, paymentProxy, true, true, username);
        }
    }

    private boolean isDiscountCodeUsageExceeded(String reservationId) {
        TicketReservation reservation = this.ticketReservationRepository.findReservationById(reservationId);
        if (reservation.getPromoCodeDiscountId() != null) {
            PromoCodeDiscount promoCode = this.promoCodeDiscountRepository.findById(reservation.getPromoCodeDiscountId().intValue());
            if (promoCode.getMaxUsage() == null) {
                return false;
            }
            int currentTickets = this.ticketReservationRepository.countTicketsInReservationForCategories(reservationId, (Collection)PromoCodeDiscount.categoriesOrNull((PromoCodeDiscount)promoCode));
            return Boolean.TRUE.equals(this.serializedTransactionTemplate.execute(status -> {
                Integer confirmedPromoCode = this.promoCodeDiscountRepository.countConfirmedPromoCode(promoCode.getId());
                return promoCode.getMaxUsage() < currentTickets + confirmedPromoCode;
            }));
        }
        return false;
    }

    public boolean containsCategoriesLinkedToGroups(String reservationId, int eventId) {
        List allLinks = this.groupManager.getLinksForEvent(eventId);
        if (allLinks.isEmpty()) {
            return false;
        }
        return this.ticketRepository.findTicketsInReservation(reservationId).stream().anyMatch(t -> allLinks.stream().anyMatch(lg -> lg.getTicketCategoryId() == null || lg.getTicketCategoryId().equals(t.getCategoryId())));
    }

    private PaymentProxy evaluatePaymentProxy(PaymentProxy proxy, TotalPrice reservationCost) {
        if (proxy != null) {
            return proxy;
        }
        if (reservationCost.getPriceWithVAT() == 0) {
            return PaymentProxy.NONE;
        }
        return PaymentProxy.STRIPE;
    }

    private boolean initPaymentProcess(TotalPrice reservationCost, PaymentProxy paymentProxy, PaymentSpecification spec, Principal principal) {
        if (reservationCost.getPriceWithVAT() > 0 && paymentProxy == PaymentProxy.STRIPE) {
            try {
                this.transitionToInPayment(spec, principal);
            }
            catch (Exception e) {
                log.debug(String.format("unable to flag the reservation %s as IN_PAYMENT", spec.getReservationId()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean acquireGroupMembers(String reservationId, PurchaseContext purchaseContext) {
        List linkedGroups = purchaseContext.event().map(event -> this.groupManager.getLinksForEvent(event.getId())).orElse(List.of());
        if (!linkedGroups.isEmpty()) {
            List ticketsInReservation = this.ticketRepository.findTicketsInReservation(reservationId);
            return Boolean.TRUE.equals(this.requiresNewTransactionTemplate.execute(status -> ticketsInReservation.stream().filter(ticket -> linkedGroups.stream().anyMatch(c -> c.getTicketCategoryId() == null || c.getTicketCategoryId().equals(ticket.getCategoryId()))).map(arg_0 -> ((GroupManager)this.groupManager).acquireMemberForTicket(arg_0)).reduce(true, Boolean::logicalAnd)));
        }
        return true;
    }

    public void confirmOfflinePayment(Event event, String reservationId, TransactionMetadataModification transactionMetadataModification, String username) {
        this.reservationFinalizer.confirmOfflinePayment(event, reservationId, transactionMetadataModification, username);
    }

    void registerAlfioTransactionForOnsitePayment(Event event, String reservationId) {
        this.reservationFinalizer.registerAlfioTransaction(event, reservationId, null, PaymentProxy.ON_SITE);
    }

    public void sendConfirmationEmail(PurchaseContext purchaseContext, TicketReservation ticketReservation, Locale language, String username) {
        this.reservationHelper.sendConfirmationEmail(purchaseContext, ticketReservation, language, username);
    }

    private Locale findReservationLanguage(String reservationId) {
        return this.ticketReservationRepository.findOptionalReservationById(reservationId).map(ReservationUtil::getReservationLocale).orElse(Locale.ENGLISH);
    }

    public void deleteOfflinePayment(Event event, String reservationId, boolean expired, boolean credit, boolean notify, String username) {
        TicketReservation reservation = (TicketReservation)this.findById(reservationId).orElseThrow(IllegalArgumentException::new);
        Validate.isTrue((reservation.getStatus() == TicketReservation.TicketReservationStatus.OFFLINE_PAYMENT || reservation.getStatus() == TicketReservation.TicketReservationStatus.DEFERRED_OFFLINE_PAYMENT ? 1 : 0) != 0, (String)"Invalid reservation status", (Object[])new Object[0]);
        Validate.isTrue((!credit || reservation.getStatus() != TicketReservation.TicketReservationStatus.DEFERRED_OFFLINE_PAYMENT ? 1 : 0) != 0, (String)"Cannot credit deferred payment", (Object[])new Object[0]);
        if (credit) {
            this.creditReservation(reservation, username, notify);
        } else {
            if (notify) {
                Map emailModel = this.reservationHelper.prepareModelForReservationEmail((PurchaseContext)event, reservation);
                Locale reservationLanguage = this.findReservationLanguage(reservationId);
                String subject = this.reservationHelper.getReservationEmailSubject((PurchaseContext)event, reservationLanguage, "reservation-email-expired-subject", reservation.getId());
                this.notificationManager.sendSimpleEmail((PurchaseContext)event, reservationId, reservation.getEmail(), subject, () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.OFFLINE_RESERVATION_EXPIRED_EMAIL, emailModel, reservationLanguage));
            }
            this.cancelReservation(reservation, expired, username);
        }
    }

    @Transactional
    public void issueCreditNoteForReservation(PurchaseContext purchaseContext, TicketReservation reservation, String username, boolean sendEmail) {
        String reservationId = reservation.getId();
        this.ticketReservationRepository.updateReservationStatus(reservationId, TicketReservation.TicketReservationStatus.CREDIT_NOTE_ISSUED.toString());
        this.auditingRepository.insert(reservationId, (Integer)this.userRepository.nullSafeFindIdByUserName(username).orElse(null), purchaseContext, Audit.EventType.CREDIT_NOTE_ISSUED, new Date(), Audit.EntityType.RESERVATION, reservationId);
        Map model = this.prepareModelForReservationEmail(purchaseContext, reservation, this.reservationHelper.getVAT(purchaseContext), this.orderSummaryForReservation(reservation, purchaseContext), this.ticketRepository.findTicketsInReservation(reservation.getId()), Map.of());
        BillingDocument billingDocument = this.billingDocumentManager.createBillingDocument(purchaseContext, reservation, username, BillingDocument.Type.CREDIT_NOTE, this.orderSummaryForReservation(reservation, purchaseContext));
        Organization organization = this.organizationRepository.getById(purchaseContext.getOrganizationId());
        this.extensionManager.handleCreditNoteGenerated(reservation, purchaseContext, ((OrderSummary)model.get("orderSummary")).getOriginalTotalPrice(), Long.valueOf(billingDocument.getId()), Map.of("organization", organization));
        if (sendEmail) {
            Locale reservationLocale = ReservationUtil.getReservationLocale((TicketReservation)reservation);
            this.notificationManager.sendSimpleEmail(purchaseContext, reservationId, reservation.getEmail(), this.reservationHelper.getReservationEmailSubject(purchaseContext, reservationLocale, "credit-note-issued-email-subject", reservation.getId()), () -> this.templateManager.renderTemplate(purchaseContext, TemplateResource.CREDIT_NOTE_ISSUED_EMAIL, model, reservationLocale), this.reservationHelper.generateBillingDocumentAttachment(purchaseContext, reservation, reservationLocale, billingDocument.getModel(), BillingDocument.Type.CREDIT_NOTE));
        }
    }

    void issuePartialCreditNoteForReservation(Event event, TicketReservation reservation, String username, List<Integer> ticketsId) {
        Validate.isTrue((boolean)TransactionSynchronizationManager.isActualTransactionActive(), (String)"issuePartialCreditNoteForReservation() needs to be called within an active transaction", (Object[])new Object[0]);
        log.trace("about to issue a partial credit note for reservation {}", (Object)reservation.getId());
        String reservationId = reservation.getId();
        this.auditingRepository.insert(reservationId, (Integer)this.userRepository.nullSafeFindIdByUserName(username).orElse(null), Integer.valueOf(event.getId()), Audit.EventType.CREDIT_NOTE_ISSUED, new Date(), Audit.EntityType.RESERVATION, reservationId);
        Map model = this.prepareModelForPartialCreditNote(event, reservation, this.ticketRepository.findByIds(ticketsId));
        log.trace("model for partial credit note created");
        OrderSummary orderSummary = (OrderSummary)model.get("orderSummary");
        BillingDocument billingDocument = this.billingDocumentManager.createBillingDocument((PurchaseContext)event, reservation, username, BillingDocument.Type.CREDIT_NOTE, orderSummary);
        Organization organization = this.organizationRepository.getById(event.getOrganizationId());
        this.extensionManager.handleCreditNoteGenerated(reservation, (PurchaseContext)event, orderSummary.getOriginalTotalPrice(), Long.valueOf(billingDocument.getId()), Map.of("organization", organization));
    }

    void issueCreditNoteForRefund(PurchaseContext purchaseContext, TicketReservation reservation, BigDecimal refundAmount, String username) {
        Validate.isTrue((boolean)TransactionSynchronizationManager.isActualTransactionActive(), (String)"issueCreditNoteForRefund() needs to be called within an active transaction", (Object[])new Object[0]);
        String currencyCode = reservation.getCurrencyCode();
        RefundPriceContainer priceContainer = new RefundPriceContainer(MonetaryUtil.unitToCents((BigDecimal)refundAmount, (String)currencyCode), currencyCode, reservation.getVatStatus(), reservation.getVatPercentageOrZero());
        String summaryRowTitle = this.messageSourceManager.getMessageSourceFor(purchaseContext).getMessage("invoice.refund.line-item", null, Locale.forLanguageTag(reservation.getUserLanguage()));
        String formattedPriceBeforeVat = MonetaryUtil.formatUnit((BigDecimal)priceContainer.getNetPrice(), (String)currencyCode);
        String formattedAmount = MonetaryUtil.formatUnit((BigDecimal)refundAmount, (String)currencyCode);
        TotalPrice cost = new TotalPrice(priceContainer.getSrcPriceCts(), MonetaryUtil.unitToCents((BigDecimal)priceContainer.getVAT(), (String)currencyCode), 0, 0, currencyCode);
        OrderSummary orderSummary = new OrderSummary(cost, List.of(new SummaryRow(summaryRowTitle, formattedAmount, formattedPriceBeforeVat, 1, formattedAmount, formattedPriceBeforeVat, MonetaryUtil.unitToCents((BigDecimal)refundAmount, (String)currencyCode), SummaryRow.SummaryType.TICKET, null, priceContainer.getVatStatus())), false, formattedAmount, MonetaryUtil.formatUnit((BigDecimal)priceContainer.getVAT(), (String)currencyCode), false, false, false, priceContainer.getVatPercentageOrZero().toPlainString(), priceContainer.getVatStatus(), formattedAmount);
        log.trace("model for partial credit note created");
        BillingDocument billingDocument = this.billingDocumentManager.createBillingDocument(purchaseContext, reservation, username, BillingDocument.Type.CREDIT_NOTE, orderSummary);
        Organization organization = this.organizationRepository.getById(purchaseContext.getOrganizationId());
        this.extensionManager.handleCreditNoteGenerated(reservation, purchaseContext, cost, Long.valueOf(billingDocument.getId()), Map.of("organization", organization));
    }

    @Transactional(readOnly=true)
    public Map<String, Object> prepareModelForReservationEmail(PurchaseContext purchaseContext, TicketReservation reservation, Optional<String> vat, OrderSummary summary, List<Ticket> ticketsToInclude, Map<String, Object> initialOptions) {
        return this.reservationHelper.prepareModelForReservationEmail(purchaseContext, reservation, vat, summary, ticketsToInclude, initialOptions);
    }

    public TicketReservationAdditionalInfo loadAdditionalInfo(String reservationId) {
        return this.ticketReservationRepository.getAdditionalInfo(reservationId);
    }

    private Map<String, Object> prepareModelForPartialCreditNote(Event event, TicketReservation reservation, List<Ticket> removedTickets) {
        OrderSummary orderSummary = this.orderSummaryGenerator.orderSummaryForCreditNote(reservation, (PurchaseContext)event, removedTickets);
        Optional optionalVat = this.reservationHelper.getVAT((PurchaseContext)event);
        return this.prepareModelForReservationEmail((PurchaseContext)event, reservation, optionalVat, orderSummary, removedTickets, Map.of());
    }

    private void transitionToInPayment(PaymentSpecification spec, Principal principal) {
        this.requiresNewTransactionTemplate.execute(status -> {
            Optional optionalStatusAndValidation = this.ticketReservationRepository.findOptionalStatusAndValidationById(spec.getReservationId());
            if (optionalStatusAndValidation.isPresent() && ((TicketReservationStatusAndValidation)optionalStatusAndValidation.get()).getStatus() == TicketReservation.TicketReservationStatus.COMPLETE) {
                Validate.isTrue((this.auditingRepository.countAuditsOfTypeForReservation(spec.getReservationId(), Audit.EventType.PAYMENT_CONFIRMED) == 1 ? 1 : 0) != 0, (String)"Trying to confirm an already paid reservation, but can't find autiting event", (Object[])new Object[0]);
            } else if (optionalStatusAndValidation.isPresent() && ((TicketReservationStatusAndValidation)optionalStatusAndValidation.get()).getStatus() == TicketReservation.TicketReservationStatus.PENDING) {
                int updatedReservation = this.ticketReservationRepository.updateTicketReservation(spec.getReservationId(), TicketReservation.TicketReservationStatus.IN_PAYMENT.toString(), spec.getEmail(), spec.getCustomerName().getFullName(), spec.getCustomerName().getFirstName(), spec.getCustomerName().getLastName(), spec.getLocale().getLanguage(), spec.getBillingAddress(), null, PaymentProxy.STRIPE.toString(), spec.getCustomerReference());
                Validate.isTrue((updatedReservation == 1 ? 1 : 0) != 0, (String)("expected exactly one updated reservation, got " + updatedReservation), (Object[])new Object[0]);
                if (principal != null && this.configurationManager.isPublicOpenIdEnabled()) {
                    this.ticketReservationRepository.setReservationOwner(spec.getReservationId(), this.retrievePublicUserId(principal));
                }
            }
            return null;
        });
    }

    public static boolean hasValidOfflinePaymentWaitingPeriod(PaymentContext context, ConfigurationManager configurationManager) {
        OptionalInt result = BankTransferManager.getOfflinePaymentWaitingPeriod((PaymentContext)context, (ConfigurationManager)configurationManager);
        return result.isPresent() && result.getAsInt() >= 0;
    }

    public static boolean isValidPaymentMethod(PaymentManager.PaymentMethodDTO paymentMethodDTO, PurchaseContext purchaseContext, ConfigurationManager configurationManager) {
        return paymentMethodDTO.isActive() && purchaseContext.getAllowedPaymentProxies().contains(paymentMethodDTO.getPaymentProxy()) && (!paymentMethodDTO.getPaymentProxy().equals((Object)PaymentProxy.OFFLINE) || TicketReservationManager.hasValidOfflinePaymentWaitingPeriod((PaymentContext)new PaymentContext(purchaseContext), (ConfigurationManager)configurationManager));
    }

    private void reTransitionToPending(String reservationId, boolean deleteTransactions) {
        int updatedReservation = this.ticketReservationRepository.updateReservationStatus(reservationId, TicketReservation.TicketReservationStatus.PENDING.toString());
        Validate.isTrue((updatedReservation == 1 ? 1 : 0) != 0, (String)("expected exactly one updated reservation, got " + updatedReservation), (Object[])new Object[0]);
        if (deleteTransactions) {
            this.transactionRepository.deleteForReservationsWithStatus(List.of(reservationId), Transaction.Status.PENDING);
        }
    }

    private void reTransitionToPending(String reservationId) {
        this.reTransitionToPending(reservationId, true);
    }

    public Optional<Triple<Event, TicketReservation, Ticket>> from(String eventName, String reservationId, Ticket ticket) {
        return this.eventRepository.findOptionalByShortName(eventName).flatMap(event -> this.ticketReservationRepository.findOptionalReservationById(reservationId).map(reservation -> Triple.of((Object)event, (Object)reservation, (Object)ticket))).filter(x -> {
            Ticket t = (Ticket)x.getRight();
            Event e = (Event)x.getLeft();
            TicketReservation tr = (TicketReservation)x.getMiddle();
            return tr.getId().equals(t.getTicketsReservationId()) && e.getId() == t.getEventId();
        });
    }

    public Optional<Triple<Event, TicketReservation, Ticket>> from(String eventName, String reservationId, String ticketIdentifier) {
        return this.ticketRepository.findOptionalByUUID(ticketIdentifier).flatMap(ticket -> this.from(eventName, reservationId, ticket));
    }

    public Optional<Triple<Event, TicketReservation, Ticket>> from(String eventName, String reservationId, UUID publicTicketUUID) {
        return this.ticketRepository.findOptionalByPublicUUID(publicTicketUUID).flatMap(ticket -> this.from(eventName, reservationId, ticket));
    }

    void completeReservation(PaymentSpecification spec, PaymentProxy paymentProxy, boolean sendReservationConfirmationEmail, boolean sendTickets, String username) {
        this.reservationFinalizer.acquireSpecialPriceTokens(spec.getReservationId());
        TicketReservation.TicketReservationStatus currentStatus = ((TicketReservationStatusAndValidation)this.ticketReservationRepository.findOptionalStatusAndValidationById(spec.getReservationId()).orElseThrow()).getStatus();
        TicketReservation.TicketReservationStatus targetStatus = TicketReservation.TicketReservationStatus.FINALIZING;
        if (currentStatus == TicketReservation.TicketReservationStatus.OFFLINE_PAYMENT || currentStatus == TicketReservation.TicketReservationStatus.DEFERRED_OFFLINE_PAYMENT) {
            targetStatus = TicketReservation.TicketReservationStatus.OFFLINE_FINALIZING;
        }
        this.ticketReservationRepository.updateReservationStatus(spec.getReservationId(), targetStatus.name());
        this.applicationEventPublisher.publishEvent((Object)new FinalizeReservation(spec, paymentProxy, sendReservationConfirmationEmail, sendTickets, username, currentStatus));
    }

    public PartialTicketTextGenerator getTicketEmailGenerator(Event event, TicketReservation ticketReservation, Locale ticketLanguage, Map<String, List<String>> additionalInfo) {
        return this.reservationHelper.getTicketEmailGenerator(event, ticketReservation, ticketLanguage, additionalInfo);
    }

    @Transactional
    public void cleanupExpiredReservations(Date expirationDate) {
        List expiredReservationIds = this.ticketReservationRepository.findExpiredReservationForUpdate(expirationDate);
        if (expiredReservationIds.isEmpty()) {
            return;
        }
        ArrayList reservationsToIgnore = new ArrayList();
        this.ticketReservationRepository.findReservationsWithPendingTransaction((Collection)expiredReservationIds).forEach(reservation -> {
            Optional purchaseContextOptional = this.purchaseContextManager.findByReservationId(reservation.getId());
            if (purchaseContextOptional.isPresent()) {
                PurchaseContext purchaseContext = (PurchaseContext)purchaseContextOptional.get();
                Optional resultOptional = this.forceTransactionCheck(purchaseContext, reservation);
                String reservationId = reservation.getId();
                if (resultOptional.isPresent()) {
                    PaymentResult result = (PaymentResult)resultOptional.get();
                    if (result.isSuccessful()) {
                        log.debug("Force check for expired reservation ID {} revealed a completed transaction. Will not delete.", (Object)reservationId);
                        reservationsToIgnore.add(reservationId);
                    } else {
                        boolean cancelPendingPaymentResult = this.cancelPendingPayment(reservationId, purchaseContext);
                        log.warn("Trying to force pending payment cancellation for reservation ID {}. Successful: {}", (Object)reservationId, (Object)cancelPendingPaymentResult);
                    }
                } else {
                    log.trace("No result from forceTransactionCheck for reservation ID {}", (Object)reservationId);
                }
            } else {
                log.warn("PurchaseContext not found for reservation ID {}", (Object)reservation.getId());
            }
        });
        List<String> toDelete = expiredReservationIds.stream().filter(id -> !reservationsToIgnore.contains(id)).toList();
        this.purchaseContextFieldRepository.deleteAllValuesForReservations(toDelete);
        this.applicationEventPublisher.publishEvent((Object)new CleanupReservations(null, toDelete, true));
        this.waitingQueueManager.cleanExpiredReservations(toDelete);
        this.transactionRepository.deleteForReservations(toDelete);
        this.ticketReservationRepository.remove(toDelete);
    }

    public void cleanupExpiredOfflineReservations(Date expirationDate) {
        this.ticketReservationRepository.findExpiredOfflineReservationsForUpdate(expirationDate).forEach(arg_0 -> this.cleanupOfflinePayment(arg_0));
    }

    private void cleanupOfflinePayment(String reservationId) {
        try {
            this.nestedTransactionTemplate.execute(tc -> {
                Event event = this.eventRepository.findByReservationId(reservationId);
                boolean enabled = this.configurationManager.getFor(ConfigurationKeys.AUTOMATIC_REMOVAL_EXPIRED_OFFLINE_PAYMENT, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsBooleanOrDefault();
                if (enabled) {
                    this.deleteOfflinePayment(event, reservationId, true, false, true, null);
                } else {
                    log.trace("Will not cleanup reservation with id {} because the automatic removal has been disabled", (Object)reservationId);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.error("error during reservation cleanup (id " + reservationId + ")", (Throwable)e);
        }
    }

    public void markExpiredInPaymentReservationAsStuck(Date expirationDate) {
        List stuckReservations = this.findStuckPaymentsToBeNotified(expirationDate);
        if (!stuckReservations.isEmpty()) {
            List ids = stuckReservations.stream().map(p -> ((TicketReservation)p.getLeft()).getId()).collect(Collectors.toList());
            this.ticketReservationRepository.updateReservationsStatus(ids, TicketReservation.TicketReservationStatus.STUCK.name());
            Map<Event, List<Pair>> reservationsGroupedByEvent = stuckReservations.stream().collect(Collectors.groupingBy(Pair::getRight));
            reservationsGroupedByEvent.forEach((event, reservations) -> {
                Organization organization = this.organizationRepository.getById(event.getOrganizationId());
                this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, organization.getEmail(), "warning: stuck tickets found", () -> RenderedTemplate.plaintext((String)"there are stuck tickets for the event %s. Please check admin area.".formatted(event.getDisplayName()), Map.of()));
                this.extensionManager.handleStuckReservations(event, reservations.stream().map(p -> ((TicketReservation)p.getLeft()).getId()).collect(Collectors.toList()));
            });
        }
    }

    private List<Pair<TicketReservation, Event>> findStuckPaymentsToBeNotified(Date expirationDate) {
        List stuckReservations = this.ticketReservationRepository.findStuckReservationsForUpdate(expirationDate);
        Map<Object, Object> events = !stuckReservations.isEmpty() ? this.eventRepository.findByIds((Collection)stuckReservations.stream().map(ReservationIdAndEventId::getEventId).collect(Collectors.toSet())).stream().collect(Collectors.toMap(EventAndOrganizationId::getId, Function.identity())) : Map.of();
        return stuckReservations.stream().map(id -> Pair.of((Object)this.ticketReservationRepository.findReservationById(id.getId()), (Object)((Event)events.get(id.getEventId())))).filter(reservationAndEvent -> {
            Event event = (Event)reservationAndEvent.getRight();
            TicketReservation reservation = (TicketReservation)reservationAndEvent.getLeft();
            Optional optionalTransaction = this.transactionRepository.loadOptionalByReservationIdAndStatusForUpdate(reservation.getId(), Transaction.Status.PENDING);
            if (optionalTransaction.isEmpty()) {
                return true;
            }
            Transaction transaction = (Transaction)optionalTransaction.get();
            PaymentContext paymentContext = new PaymentContext((PurchaseContext)event, reservation.getId());
            Optional paymentResultOptional = this.checkTransactionStatus((PurchaseContext)event, reservation);
            if (paymentResultOptional.isEmpty()) {
                return true;
            }
            Pair providerAndWebhookResult = (Pair)paymentResultOptional.get();
            PaymentWebhookResult paymentWebhookResult = (PaymentWebhookResult)providerAndWebhookResult.getRight();
            this.handlePaymentWebhookResult((PurchaseContext)event, (PaymentProvider)providerAndWebhookResult.getLeft(), paymentWebhookResult, reservation, transaction, paymentContext, "stuck-check", false);
            return paymentWebhookResult.getType() == PaymentWebhookResult.Type.NOT_RELEVANT;
        }).collect(Collectors.toList());
    }

    public Pair<TotalPrice, Optional<PromoCodeDiscount>> totalReservationCostWithVAT(String reservationId) {
        return this.reservationCostCalculator.totalReservationCostWithVAT(reservationId);
    }

    public Pair<TotalPrice, Optional<PromoCodeDiscount>> totalReservationCostWithVAT(TicketReservation reservation) {
        return this.reservationCostCalculator.totalReservationCostWithVAT(reservation);
    }

    public OrderSummary orderSummaryForReservationId(String reservationId, PurchaseContext purchaseContext) {
        return this.orderSummaryGenerator.orderSummaryForReservationId(reservationId, purchaseContext);
    }

    public OrderSummary orderSummaryForReservation(TicketReservation reservation, PurchaseContext context) {
        return this.orderSummaryGenerator.orderSummaryForReservation(reservation, context);
    }

    String reservationUrl(String reservationId) {
        return this.purchaseContextManager.findByReservationId(reservationId).map(pc -> this.reservationUrl(reservationId, pc)).orElse("");
    }

    public String reservationUrl(String reservationId, PurchaseContext purchaseContext) {
        return this.reservationUrl(this.ticketReservationRepository.findReservationById(reservationId), purchaseContext);
    }

    public String reservationUrlForExternalClients(String reservationId, PurchaseContext purchaseContext, String userLanguage, boolean userLoggedIn, String subscriptionId) {
        Map configMap = this.configurationManager.getFor(EnumSet.of(ConfigurationKeys.BASE_URL, ConfigurationKeys.OPENID_PUBLIC_ENABLED), purchaseContext.getConfigurationLevel());
        String baseUrl = StringUtils.removeEnd((String)((ConfigurationManager.MaybeConfiguration)configMap.get(ConfigurationKeys.BASE_URL)).getRequiredValue(), (String)"/");
        if (userLoggedIn && ((ConfigurationManager.MaybeConfiguration)configMap.get(ConfigurationKeys.OPENID_PUBLIC_ENABLED)).getValueAsBooleanOrDefault()) {
            return baseUrl + "/openid/" + purchaseContext.getType() + "/" + purchaseContext.getPublicIdentifier() + "/reservation/" + reservationId;
        }
        String cleanSubscriptionId = StringUtils.trimToNull((String)subscriptionId);
        return ReservationUtil.reservationUrl((String)baseUrl, (String)reservationId, (PurchaseContext)purchaseContext, (String)userLanguage, (String)(cleanSubscriptionId != null ? "subscription=" + cleanSubscriptionId : null));
    }

    String reservationUrl(TicketReservation reservation, PurchaseContext purchaseContext) {
        return ReservationUtil.reservationUrl((TicketReservation)reservation, (PurchaseContext)purchaseContext, (ConfigurationManager)this.configurationManager);
    }

    public String ticketOnlineCheckIn(Event event, String ticketId) {
        Ticket ticket = this.ticketRepository.findByUUID(ticketId);
        return TicketCheckInUtil.ticketOnlineCheckInUrl((Event)event, (Ticket)ticket, (String)this.configurationManager.baseUrl((PurchaseContext)event));
    }

    public int maxAmountOfTicketsForCategory(EventAndOrganizationId eventAndOrganizationId, int ticketCategoryId, String promoCode) {
        Integer maxTicketsPerAccessCode;
        if (StringUtils.isNotBlank((CharSequence)promoCode) && (maxTicketsPerAccessCode = (Integer)this.promoCodeDiscountRepository.findPromoCodeInEventOrOrganization(eventAndOrganizationId.getId(), promoCode).filter(d -> d.getCodeType() == PromoCodeDiscount.CodeType.ACCESS).map(PromoCodeDiscount::getMaxUsage).orElse(null)) != null) {
            return maxTicketsPerAccessCode;
        }
        return this.configurationManager.getFor(ConfigurationKeys.MAX_AMOUNT_OF_TICKETS_BY_RESERVATION, ConfigurationLevel.ticketCategory((EventAndOrganizationId)eventAndOrganizationId, (int)ticketCategoryId)).getValueAsIntOrDefault(5);
    }

    public Optional<TicketReservation> findByIdForEvent(String reservationId, int eventId) {
        return this.ticketReservationRepository.findOptionalReservationByIdAndEventId(reservationId, eventId);
    }

    public Optional<TicketReservation> findById(String reservationId) {
        return this.ticketReservationRepository.findOptionalReservationById(reservationId);
    }

    private Optional<TicketReservation> findByIdForNotification(String reservationId, Clock clock, int quietPeriod) {
        return this.findById(reservationId).filter(TicketReservationManager.notificationNotSent((Clock)clock, (int)quietPeriod));
    }

    private static Predicate<TicketReservation> notificationNotSent(Clock clock, int quietPeriod) {
        return r -> r.latestNotificationTimestamp(clock.getZone()).map(t -> t.truncatedTo(ChronoUnit.DAYS).plusDays(quietPeriod).isBefore(ZonedDateTime.now(clock).truncatedTo(ChronoUnit.DAYS))).orElse(true);
    }

    public void cancelPendingReservation(String reservationId, boolean expired, String username) {
        this.cancelPendingReservation(this.ticketReservationRepository.findReservationById(reservationId), expired, username);
    }

    private void cancelPendingReservation(TicketReservation reservation, boolean expired, String username) {
        Validate.isTrue((reservation.getStatus() == TicketReservation.TicketReservationStatus.PENDING ? 1 : 0) != 0, (String)"status is not PENDING", (Object[])new Object[0]);
        this.cancelReservation(reservation, expired, username);
    }

    private void cancelReservation(TicketReservation reservation, boolean expired, String username) {
        String reservationId = reservation.getId();
        this.purchaseContextManager.findByReservationId(reservationId).ifPresent(pc -> {
            this.cleanupReferencesToReservation(expired, username, reservationId, pc);
            this.removeReservation(pc, reservation, expired, username);
        });
    }

    private void creditReservation(TicketReservation reservation, String username, boolean sendEmail) {
        String reservationId = reservation.getId();
        Event event = this.eventRepository.findByReservationId(reservationId);
        this.billingDocumentManager.ensureBillingDocumentIsPresent((PurchaseContext)event, reservation, username, () -> this.orderSummaryForReservationId(reservation.getId(), (PurchaseContext)event));
        this.issueCreditNoteForReservation((PurchaseContext)event, reservation, username, sendEmail);
        this.cleanupReferencesToReservation(false, username, reservationId, (PurchaseContext)event);
        this.extensionManager.handleReservationsCreditNoteIssuedForEvent(event, Collections.singletonList(reservationId));
    }

    private void cleanupReferencesToReservation(boolean expired, String username, String reservationId, PurchaseContext purchaseContext) {
        List<String> reservationIdsToRemove = Collections.singletonList(reservationId);
        int tfvDeleted = this.purchaseContextFieldRepository.deleteAllValuesForReservations(reservationIdsToRemove);
        log.debug("deleted {} field values", (Object)tfvDeleted);
        this.applicationEventPublisher.publishEvent((Object)new CleanupReservations(purchaseContext, List.of(reservationId), expired));
        this.transactionRepository.deleteForReservations(List.of(reservationId));
        this.waitingQueueManager.fireReservationExpired(reservationId);
        this.auditingRepository.insert(reservationId, (Integer)this.userRepository.nullSafeFindIdByUserName(username).orElse(null), (Integer)purchaseContext.event().map(EventAndOrganizationId::getId).orElse(null), expired ? Audit.EventType.CANCEL_RESERVATION_EXPIRED : Audit.EventType.CANCEL_RESERVATION, new Date(), Audit.EntityType.RESERVATION, reservationId);
    }

    private void removeReservation(PurchaseContext purchaseContext, TicketReservation reservation, boolean expired, String username) {
        int removedReservation;
        String reservationIdToRemove = reservation.getId();
        List<String> wrappedReservationIdToRemove = Collections.singletonList(reservationIdToRemove);
        this.waitingQueueManager.cleanExpiredReservations(wrappedReservationIdToRemove);
        int result = this.billingDocumentRepository.deleteForReservation(reservationIdToRemove);
        if (result > 0) {
            log.warn("deleted {} documents for reservation id {}", (Object)result, (Object)reservationIdToRemove);
        }
        Validate.isTrue(((removedReservation = this.ticketReservationRepository.remove(wrappedReservationIdToRemove)) == 1 ? 1 : 0) != 0, (String)("expected exactly one removed reservation, got " + removedReservation), (Object[])new Object[0]);
        this.auditingRepository.insert(reservationIdToRemove, (Integer)this.userRepository.nullSafeFindIdByUserName(username).orElse(null), (Integer)purchaseContext.event().map(EventAndOrganizationId::getId).orElse(null), expired ? Audit.EventType.CANCEL_RESERVATION_EXPIRED : Audit.EventType.CANCEL_RESERVATION, new Date(), Audit.EntityType.RESERVATION, reservationIdToRemove);
    }

    public Optional<SpecialPrice> getSpecialPriceByCode(String code) {
        return this.specialPriceRepository.getByCode(code);
    }

    public List<Ticket> findTicketsInReservation(String reservationId) {
        return this.ticketRepository.findTicketsInReservation(reservationId);
    }

    public Optional<Ticket> findFirstInReservation(String reservationId) {
        return this.ticketRepository.findFirstTicketInReservation(reservationId);
    }

    public void updateTicketOwner(Ticket ticket, Locale locale, Event event, UpdateTicketOwnerForm updateTicketOwner, PartialTicketTextGenerator confirmationTextBuilder, PartialTicketTextGenerator ownerChangeTextBuilder, Optional<UserDetails> userDetails) {
        boolean admin;
        Ticket preUpdateTicket = this.ticketRepository.findByUUID(ticket.getUuid());
        if (preUpdateTicket.getLockedAssignment() && this.isTicketBeingReassigned(ticket, updateTicketOwner, event)) {
            log.warn("trying to update assignee for a locked ticket ({})", (Object)preUpdateTicket.getId());
            return;
        }
        Collector ticketFieldValueMapCollector = Collectors.groupingBy(PurchaseContextFieldValue::getName, Collectors.mapping(PurchaseContextFieldValue::getValue, Collectors.toList()));
        Map preUpdateTicketFields = this.purchaseContextFieldRepository.findAllByTicketId(ticket.getId()).stream().collect(ticketFieldValueMapCollector);
        String newEmail = StringUtils.trim((String)updateTicketOwner.getEmail());
        CustomerName customerName = new CustomerName(updateTicketOwner.getFullName(), updateTicketOwner.getFirstName(), updateTicketOwner.getLastName(), event.mustUseFirstAndLastName(), false);
        this.ticketRepository.updateTicketOwner(ticket.getUuid(), newEmail, customerName.getFullName(), customerName.getFirstName(), customerName.getLastName());
        Locale userLocale = Optional.ofNullable(StringUtils.trimToNull((String)updateTicketOwner.getUserLanguage())).map(LocaleUtil::forLanguageTag).orElse(locale);
        this.ticketRepository.updateOptionalTicketInfo(ticket.getUuid(), userLocale.getLanguage());
        this.purchaseContextFieldRepository.updateOrInsert(updateTicketOwner.getAdditional(), (PurchaseContext)event, Integer.valueOf(ticket.getId()), null);
        if (MapUtils.isNotEmpty((Map)updateTicketOwner.getAdditionalServices())) {
            this.additionalServiceManager.persistFieldsForAdditionalItems(event.getId(), event.getOrganizationId(), updateTicketOwner.getAdditionalServices(), List.of(ticket));
        }
        Ticket newTicket = this.ticketRepository.findByUUID(ticket.getUuid());
        boolean sendTicketAllowed = this.configurationManager.getFor(ConfigurationKeys.SEND_TICKETS_AUTOMATICALLY, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsBooleanOrDefault();
        if (!(!sendTicketAllowed || newTicket.getStatus() != Ticket.TicketStatus.ACQUIRED && newTicket.getStatus() != Ticket.TicketStatus.TO_BE_PAID || StringUtils.equalsIgnoreCase((CharSequence)newEmail, (CharSequence)ticket.getEmail()) && StringUtils.equalsIgnoreCase((CharSequence)customerName.getFullName(), (CharSequence)ticket.getFullName()))) {
            this.reservationHelper.sendTicketByEmail(newTicket, userLocale, event, confirmationTextBuilder);
        }
        if (!(admin = this.isAdmin(userDetails)) && StringUtils.isNotBlank((CharSequence)ticket.getEmail()) && !StringUtils.equalsIgnoreCase((CharSequence)newEmail, (CharSequence)ticket.getEmail()) && ticket.getStatus() == Ticket.TicketStatus.ACQUIRED) {
            Locale oldUserLocale = LocaleUtil.forLanguageTag((String)ticket.getUserLanguage());
            String subject = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event).getMessage("ticket-has-changed-owner-subject", new Object[]{event.getDisplayName()}, oldUserLocale);
            this.notificationManager.sendSimpleEmail((PurchaseContext)event, ticket.getTicketsReservationId(), ticket.getEmail(), subject, () -> ownerChangeTextBuilder.generate(newTicket));
            if (event.getBegin().isBefore(event.now(this.clockProvider))) {
                Organization organization = this.organizationRepository.getById(event.getOrganizationId());
                this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, organization.getEmail(), "WARNING: Ticket has been reassigned after event start", () -> ownerChangeTextBuilder.generate(newTicket));
            }
        }
        if (admin) {
            TicketReservation reservation = (TicketReservation)this.findById(ticket.getTicketsReservationId()).orElseThrow(IllegalStateException::new);
            String username = userDetails.orElseThrow().getUsername();
            log.warn("Reservation {}: forced assignee replacement old: {} new: {}", new Object[]{reservation.getId(), reservation.getFullName(), username});
            this.ticketReservationRepository.updateAssignee(reservation.getId(), username);
        }
        this.extensionManager.handleTicketAssignment(newTicket, this.ticketCategoryRepository.getById(ticket.getCategoryId().intValue()), updateTicketOwner.getAdditional());
        if (this.isTicketBeingReassigned(ticket, updateTicketOwner, event)) {
            this.invalidateAccess(event, ticket, true);
        }
        Ticket postUpdateTicket = this.ticketRepository.findByUUID(ticket.getUuid());
        Map postUpdateTicketFields = this.purchaseContextFieldRepository.findAllByTicketId(ticket.getId()).stream().collect(ticketFieldValueMapCollector);
        this.auditingHelper.auditUpdateTicket(preUpdateTicket, preUpdateTicketFields, postUpdateTicket, postUpdateTicketFields, event.getId());
    }

    boolean isTicketBeingReassigned(Ticket original, UpdateTicketOwnerForm updated, Event event) {
        if (StringUtils.isBlank((CharSequence)original.getEmail()) || StringUtils.isBlank((CharSequence)original.getFullName())) {
            return false;
        }
        CustomerName customerName = new CustomerName(updated.getFullName(), updated.getFirstName(), updated.getLastName(), event.mustUseFirstAndLastName());
        return StringUtils.isNotBlank((CharSequence)original.getEmail()) && StringUtils.isNotBlank((CharSequence)original.getFullName()) && (!StringUtils.equalsIgnoreCase((CharSequence)original.getEmail(), (CharSequence)updated.getEmail()) || !StringUtils.equalsIgnoreCase((CharSequence)original.getFullName(), (CharSequence)customerName.getFullName()));
    }

    private boolean isAdmin(Optional<UserDetails> userDetails) {
        return userDetails.flatMap(u -> u.getAuthorities().stream().map(a -> Role.fromRoleName((String)a.getAuthority())).filter(arg_0 -> Role.ADMIN.equals(arg_0)).findFirst()).isPresent();
    }

    public Optional<Triple<Event, TicketReservation, Ticket>> fetchComplete(String eventName, UUID ticketPublicUUID) {
        return this.ticketRepository.findOptionalByPublicUUID(ticketPublicUUID).flatMap(ticket -> this.from(eventName, ticket.getTicketsReservationId(), ticket).flatMap(triple -> {
            if (((TicketReservation)triple.getMiddle()).getStatus() == TicketReservation.TicketReservationStatus.COMPLETE) {
                return Optional.of(triple);
            }
            return Optional.empty();
        }));
    }

    public Optional<Triple<Event, TicketReservation, Ticket>> fetchCompleteAndAssigned(String eventName, UUID ticketIdentifier) {
        return this.fetchComplete(eventName, ticketIdentifier).flatMap(t -> {
            if (((Ticket)t.getRight()).getAssigned()) {
                return Optional.of(t);
            }
            return Optional.empty();
        });
    }

    public Optional<CheckInFullInfo> fetchCompleteAndAssignedForOnlineCheckIn(String eventName, UUID publicUUID) {
        return this.ticketRepository.getFullInfoForOnlineCheckin(eventName, publicUUID);
    }

    public void sendReminderForOfflinePayments() {
        Date expiration = DateUtils.truncate((Date)DateUtils.addHours((Date)new Date(), (int)this.configurationManager.getForSystem(ConfigurationKeys.OFFLINE_REMINDER_HOURS).getValueAsIntOrDefault(24)), (int)5);
        this.ticketReservationRepository.findAllOfflinePaymentReservationForNotificationForUpdate(expiration).stream().map(reservation -> {
            Optional ticket = this.ticketRepository.findFirstTicketInReservation(reservation.getId());
            Optional<Event> event = ticket.map(t -> this.eventRepository.findById(t.getEventId()));
            Optional<Locale> locale = ticket.map(t -> LocaleUtil.forLanguageTag((String)t.getUserLanguage()));
            return Triple.of((Object)reservation, event, locale);
        }).filter(p -> ((Optional)p.getMiddle()).isPresent()).filter(p -> {
            Event event = (Event)((Optional)p.getMiddle()).get();
            return DateUtils.truncate((Date)DateUtils.addHours((Date)new Date(), (int)this.configurationManager.getFor(ConfigurationKeys.OFFLINE_REMINDER_HOURS, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsIntOrDefault(24)), (int)5).compareTo(((TicketReservation)p.getLeft()).getValidity()) >= 0;
        }).map(p -> Triple.of((Object)((TicketReservation)p.getLeft()), (Object)((Event)((Optional)p.getMiddle()).orElseThrow()), (Object)((Locale)((Optional)p.getRight()).orElseThrow()))).forEach(p -> {
            TicketReservation reservation = (TicketReservation)p.getLeft();
            Event event = (Event)p.getMiddle();
            Map model = this.reservationHelper.prepareModelForReservationEmail((PurchaseContext)event, reservation);
            Locale locale = (Locale)p.getRight();
            this.ticketReservationRepository.flagAsOfflinePaymentReminderSent(reservation.getId());
            this.notificationManager.sendSimpleEmail((PurchaseContext)event, reservation.getId(), reservation.getEmail(), this.messageSourceManager.getMessageSourceFor((PurchaseContext)event).getMessage("reservation.reminder.mail.subject", new Object[]{this.configurationManager.getShortReservationID((Configurable)event, reservation)}, locale), () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.REMINDER_EMAIL, model, locale));
        });
    }

    public void sendReminderForOfflinePaymentsToEventManagers() {
        this.eventRepository.findAllActives(ZonedDateTime.now(this.clockProvider.getClock())).stream().filter(event -> {
            ZonedDateTime dateTimeForEvent = event.now(this.clockProvider);
            return dateTimeForEvent.truncatedTo(ChronoUnit.HOURS).getHour() == 5;
        }).forEachOrdered(event -> {
            ZonedDateTime dateTimeForEvent = event.now(this.clockProvider).truncatedTo(ChronoUnit.DAYS).plusDays(1L);
            List reservations = this.ticketReservationRepository.findAllOfflinePaymentReservationWithExpirationBeforeForUpdate(dateTimeForEvent, event.getId());
            log.info("for event {} there are {} pending offline payments to handle", (Object)event.getId(), (Object)reservations.size());
            if (!reservations.isEmpty()) {
                Organization organization = this.organizationRepository.getById(event.getOrganizationId());
                List cc = this.notificationManager.getCCForEventOrganizer((PurchaseContext)event);
                String subject = "There are %d pending offline payments that will expire in event: %s".formatted(reservations.size(), event.getDisplayName());
                String baseUrl = this.configurationManager.getFor(ConfigurationKeys.BASE_URL, ConfigurationLevel.event((EventAndOrganizationId)event)).getRequiredValue();
                Map model = TemplateResource.prepareModelForOfflineReservationExpiringEmailForOrganizer((Event)event, (List)reservations, (String)baseUrl);
                this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, organization.getEmail(), cc, subject, () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.OFFLINE_RESERVATION_EXPIRING_EMAIL_FOR_ORGANIZER, model, Locale.ENGLISH));
                this.extensionManager.handleOfflineReservationsWillExpire(event, reservations);
            }
        });
    }

    public void sendReminderForTicketAssignment() {
        this.getNotifiableEventsStream().map(e -> Pair.of((Object)e, (Object)this.ticketRepository.findAllReservationsConfirmedButNotAssignedForUpdate(e.getId()))).filter(p -> !((Set)p.getRight()).isEmpty()).forEach(p -> Wrappers.voidTransactionWrapper(arg_0 -> this.sendAssignmentReminder(arg_0), (Object)p));
    }

    public void sendReminderForOptionalData() {
        this.getNotifiableEventsStream().filter(e -> this.configurationManager.getFor(ConfigurationKeys.OPTIONAL_DATA_REMINDER_ENABLED, ConfigurationLevel.event((EventAndOrganizationId)e)).getValueAsBooleanOrDefault()).filter(e -> this.purchaseContextFieldRepository.countAdditionalFieldsForEvent(e.getId()) > 0).map(e -> Pair.of((Object)e, (Object)this.ticketRepository.findAllAssignedButNotYetNotifiedForUpdate(e.getId()))).filter(p -> !((List)p.getRight()).isEmpty()).forEach(p -> Wrappers.voidTransactionWrapper(arg_0 -> this.sendOptionalDataReminder(arg_0), (Object)p));
    }

    private void sendOptionalDataReminder(Pair<Event, List<Ticket>> eventAndTickets) {
        this.nestedTransactionTemplate.execute(ts -> {
            Event event = (Event)eventAndTickets.getLeft();
            MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
            int daysBeforeStart = this.configurationManager.getFor(ConfigurationKeys.ASSIGNMENT_REMINDER_START, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsIntOrDefault(10);
            List tickets = ((List)eventAndTickets.getRight()).stream().filter(t -> !this.purchaseContextFieldRepository.hasOptionalData(t.getId())).collect(Collectors.toList());
            Set notYetNotifiedReservations = tickets.stream().map(Ticket::getTicketsReservationId).distinct().filter(rid -> this.findByIdForNotification(rid, this.clockProvider.withZone(event.getZoneId()), daysBeforeStart).isPresent()).collect(Collectors.toSet());
            tickets.stream().filter(t -> notYetNotifiedReservations.contains(t.getTicketsReservationId())).forEach(t -> {
                int result = this.ticketRepository.flagTicketAsReminderSent(t.getId());
                Validate.isTrue((result == 1 ? 1 : 0) != 0);
                Map model = TemplateResource.prepareModelForReminderTicketAdditionalInfo((Organization)this.organizationRepository.getById(event.getOrganizationId()), (Event)event, (Ticket)t, (String)ReservationUtil.ticketUpdateUrl((Event)event, (Ticket)t, (ConfigurationManager)this.configurationManager));
                Locale locale = Optional.ofNullable(t.getUserLanguage()).map(LocaleUtil::forLanguageTag).orElseGet(() -> this.findReservationLanguage(t.getTicketsReservationId()));
                this.notificationManager.sendSimpleEmail((PurchaseContext)event, t.getTicketsReservationId(), t.getEmail(), messageSource.getMessage("reminder.ticket-additional-info.subject", new Object[]{event.getDisplayName()}, locale), () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.REMINDER_TICKET_ADDITIONAL_INFO, model, locale));
            });
            return null;
        });
    }

    Stream<Event> getNotifiableEventsStream() {
        return this.eventRepository.findAll().stream().filter(e -> {
            int daysBeforeStart = this.configurationManager.getFor(ConfigurationKeys.ASSIGNMENT_REMINDER_START, ConfigurationLevel.event((EventAndOrganizationId)e)).getValueAsIntOrDefault(10);
            int days = (int)ChronoUnit.DAYS.between(ZonedDateTime.now(this.clockProvider.withZone(e.getZoneId())).toLocalDate(), e.getBegin().toLocalDate());
            return days > 0 && days <= daysBeforeStart;
        });
    }

    private void sendAssignmentReminder(Pair<Event, Set<String>> p) {
        try {
            this.nestedTransactionTemplate.execute(ts -> {
                Event event = (Event)p.getLeft();
                MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
                ZoneId eventZoneId = event.getZoneId();
                int quietPeriod = this.configurationManager.getFor(ConfigurationKeys.ASSIGNMENT_REMINDER_INTERVAL, ConfigurationLevel.event((EventAndOrganizationId)event)).getValueAsIntOrDefault(3);
                ((Set)p.getRight()).stream().map(id -> this.findByIdForNotification(id, this.clockProvider.withZone(eventZoneId), quietPeriod)).flatMap(Optional::stream).forEach(reservation -> {
                    Map model = this.reservationHelper.prepareModelForReservationEmail((PurchaseContext)event, reservation);
                    this.ticketReservationRepository.updateLatestReminderTimestamp(reservation.getId(), ZonedDateTime.now(this.clockProvider.withZone(eventZoneId)));
                    Locale locale = this.findReservationLanguage(reservation.getId());
                    this.notificationManager.sendSimpleEmail((PurchaseContext)event, reservation.getId(), reservation.getEmail(), messageSource.getMessage("reminder.ticket-not-assigned.subject", new Object[]{event.getDisplayName()}, locale), () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.REMINDER_TICKETS_ASSIGNMENT_EMAIL, model, locale));
                });
                return null;
            });
        }
        catch (Exception ex) {
            log.warn("cannot send reminder message", (Throwable)ex);
        }
    }

    public TicketReservation findByPartialID(String reservationId) {
        Validate.notBlank((CharSequence)reservationId, (String)"invalid reservationId", (Object[])new Object[0]);
        Validate.matchesPattern((CharSequence)reservationId, (String)"^[^%]*$", (String)"invalid character found", (Object[])new Object[0]);
        List results = this.ticketReservationRepository.findByPartialID(StringUtils.trimToEmpty((String)reservationId).toLowerCase() + "%");
        Validate.isTrue((!results.isEmpty() ? 1 : 0) != 0, (String)"reservation not found", (Object[])new Object[0]);
        Validate.isTrue((results.size() == 1 ? 1 : 0) != 0, (String)"multiple results found. Try handling this reservation manually.", (Object[])new Object[0]);
        return (TicketReservation)results.get(0);
    }

    public String getShortReservationID(Configurable event, String reservationId) {
        return this.configurationManager.getShortReservationID(event, (TicketReservation)this.findById(reservationId).orElseThrow());
    }

    public CategoryAvailability countAvailableTickets(EventAndOrganizationId event, TicketCategory category) {
        if (category.isBounded()) {
            return this.ticketRepository.getCategoryAvailability(event.getId(), category.getId());
        }
        return this.ticketRepository.getUnboundedCategoryAvailability(event.getId(), category.getId());
    }

    public void releaseTicket(Event event, TicketReservation ticketReservation, Ticket ticket) {
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor((PurchaseContext)event);
        TicketCategory category = this.ticketCategoryRepository.getByIdAndActive(ticket.getCategoryId().intValue(), event.getId());
        boolean isFree = ticket.getFinalPriceCts() == 0;
        ConfigurationLevel configurationLevel = ticket.getCategoryId() != null ? ConfigurationLevel.ticketCategory((EventAndOrganizationId)event, (int)ticket.getCategoryId()) : ConfigurationLevel.event((EventAndOrganizationId)event);
        boolean enableFreeCancellation = this.configurationManager.getFor(ConfigurationKeys.ALLOW_FREE_TICKETS_CANCELLATION, configurationLevel).getValueAsBooleanOrDefault();
        boolean conditionsMet = CategoryEvaluator.isTicketCancellationAvailable((TicketCategoryRepository)this.ticketCategoryRepository, (Ticket)ticket);
        if (!(isFree && enableFreeCancellation && conditionsMet)) {
            throw new IllegalStateException("Cannot release reserved tickets");
        }
        this.invalidateAccess(event, ticket, false);
        String reservationId = ticketReservation.getId();
        int result = this.ticketRepository.releaseTicket(reservationId, UUID.randomUUID().toString(), UUID.randomUUID(), event.getId(), ticket.getId());
        Validate.isTrue((result == 1 ? 1 : 0) != 0, (String)"Expected 1 row to be updated, got %d".formatted(result), (Object[])new Object[0]);
        if (category.isAccessRestricted() || !category.isBounded()) {
            this.ticketRepository.unbindTicketsFromCategory(event.getId(), category.getId(), Collections.singletonList(ticket.getId()));
        }
        Organization organization = this.organizationRepository.getById(event.getOrganizationId());
        Map model = TemplateResource.buildModelForTicketHasBeenCancelled((Organization)organization, (Event)event, (Ticket)ticket);
        Locale locale = LocaleUtil.forLanguageTag((String)Optional.ofNullable(ticket.getUserLanguage()).orElse("en"));
        this.notificationManager.sendSimpleEmail((PurchaseContext)event, reservationId, ticket.getEmail(), messageSource.getMessage("email-ticket-released.subject", new Object[]{event.getDisplayName()}, locale), () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.TICKET_HAS_BEEN_CANCELLED, model, locale));
        String ticketCategoryDescription = this.ticketCategoryDescriptionRepository.findByTicketCategoryIdAndLocale(category.getId(), ticket.getUserLanguage()).orElse("");
        List additionalServiceItems = this.additionalServiceManager.findItemsInReservation(event.getId(), reservationId);
        Map adminModel = TemplateResource.buildModelForTicketHasBeenCancelledAdmin((Organization)organization, (Event)event, (Ticket)ticket, (String)ticketCategoryDescription, (List)additionalServiceItems, asi -> this.additionalServiceManager.loadItemTitle(asi, locale));
        this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, organization.getEmail(), messageSource.getMessage("email-ticket-released.admin.subject", new Object[]{ticket.getId(), event.getDisplayName()}, locale), () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.TICKET_HAS_BEEN_CANCELLED_ADMIN, adminModel, locale));
        int deletedValues = this.purchaseContextFieldRepository.deleteAllValuesForTicket(ticket.getId());
        log.debug("deleting {} field values for ticket {}", (Object)deletedValues, (Object)ticket.getId());
        this.auditingRepository.insert(reservationId, null, Integer.valueOf(event.getId()), Audit.EventType.CANCEL_TICKET, new Date(), Audit.EntityType.TICKET, Integer.toString(ticket.getId()));
        if (this.ticketRepository.countTicketsInReservation(reservationId) == 0 && this.transactionRepository.loadOptionalByReservationId(reservationId).isEmpty()) {
            this.cleanupReferencesToReservation(false, null, ticketReservation.getId(), (PurchaseContext)event);
            this.removeReservation((PurchaseContext)event, ticketReservation, false, null);
            this.auditingRepository.insert(reservationId, null, Integer.valueOf(event.getId()), Audit.EventType.CANCEL_RESERVATION, new Date(), Audit.EntityType.RESERVATION, reservationId);
        }
        this.extensionManager.handleTicketCancelledForEvent(event, Collections.singletonList(ticket.getUuid()));
    }

    private void invalidateAccess(Event event, Ticket ticket, boolean reassigned) {
        if (reassigned) {
            this.auditingRepository.insert(ticket.getTicketsReservationId(), null, Integer.valueOf(event.getId()), Audit.EventType.TICKET_HOLDER_CHANGED, new Date(), Audit.EntityType.TICKET, Integer.toString(ticket.getId()));
        }
        this.applicationEventPublisher.publishEvent((Object)new InvalidateAccess(ticket, this.ticketRepository.getTicketMetadata(ticket.getId()), event));
    }

    int getReservationTimeout(Configurable configurable) {
        return this.configurationManager.getFor(ConfigurationKeys.RESERVATION_TIMEOUT, configurable.getConfigurationLevel()).getValueAsIntOrDefault(25);
    }

    public void validateAndConfirmOfflinePayment(String reservationId, Event event, BigDecimal paidAmount, String username) {
        TicketReservation reservation = this.findByPartialID(reservationId);
        Optional optionalOrderSummary = Wrappers.optionally(() -> this.orderSummaryForReservationId(reservation.getId(), (PurchaseContext)event));
        Validate.isTrue((boolean)optionalOrderSummary.isPresent(), (String)"Reservation not found", (Object[])new Object[0]);
        OrderSummary orderSummary = (OrderSummary)optionalOrderSummary.orElseThrow();
        String currencyCode = orderSummary.getOriginalTotalPrice().getCurrencyCode();
        Validate.isTrue((MonetaryUtil.centsToUnit((int)orderSummary.getOriginalTotalPrice().getPriceWithVAT(), (String)currencyCode).compareTo(paidAmount) == 0 ? 1 : 0) != 0, (String)"paid price differs from due price", (Object[])new Object[0]);
        this.confirmOfflinePayment(event, reservation.getId(), null, username);
    }

    public List<TicketReservationWithTransaction> getPendingPayments(String eventName) {
        return this.eventRepository.findOptionalEventAndOrganizationIdByShortName(eventName).map(event -> this.ticketSearchRepository.findOfflineReservationsWithOptionalTransaction(event.getId())).orElse(List.of());
    }

    public Integer getPendingPaymentsCount(int eventId) {
        return this.ticketReservationRepository.findAllReservationsWaitingForPaymentCountInEventId(eventId);
    }

    public List<Pair<TicketReservation, BillingDocument>> findAllInvoices(int eventId) {
        List documents = this.billingDocumentRepository.findAllOfTypeForEvent(BillingDocument.Type.INVOICE, eventId);
        Map documentsByReservationId = documents.stream().collect(Collectors.toMap(BillingDocument::getReservationId, Function.identity()));
        return this.ticketReservationRepository.findByIds(documentsByReservationId.keySet()).stream().map(r -> Pair.of((Object)r, (Object)((BillingDocument)documentsByReservationId.get(r.getId())))).collect(Collectors.toList());
    }

    public Stream<Pair<TicketReservationWithTransaction, List<BillingDocument>>> streamAllDocumentsFor(int eventId) {
        Map<String, List<BillingDocument>> documentsByReservationId = this.billingDocumentRepository.findAllForEvent(eventId).stream().collect(Collectors.groupingBy(BillingDocument::getReservationId));
        Map reservations = this.ticketSearchRepository.findAllReservationsById(documentsByReservationId.keySet()).stream().collect(Collectors.toMap(trt -> trt.getTicketReservation().getId(), Function.identity()));
        return documentsByReservationId.entrySet().stream().map(entry -> Pair.of((Object)((TicketReservationWithTransaction)reservations.get(entry.getKey())), (Object)((List)entry.getValue())));
    }

    public Integer countBillingDocuments(int eventId) {
        return this.billingDocumentRepository.countAllForEvent(eventId);
    }

    public boolean hasPaidSupplements(int eventId, String reservationId) {
        return this.additionalServiceManager.hasPaidSupplements(eventId, reservationId);
    }

    public int revertTicketsToFreeIfAccessRestricted(int eventId) {
        List restrictedCategories = this.ticketCategoryRepository.findAllTicketCategories(eventId).stream().filter(TicketCategory::isAccessRestricted).map(TicketCategory::getId).collect(Collectors.toList());
        if (!restrictedCategories.isEmpty()) {
            int count = this.ticketRepository.revertToFreeForRestrictedCategories(eventId, restrictedCategories);
            if (count > 0) {
                log.debug("reverted {} tickets for categories {}", (Object)count, restrictedCategories);
            }
            return count;
        }
        return 0;
    }

    public void updateReservation(String reservationId, CustomerName customerName, String email, String billingAddressCompany, String billingAddressLine1, String billingAddressLine2, String billingAddressZip, String billingAddressCity, String billingAddressState, String vatCountryCode, String customerReference, String vatNr, boolean isInvoiceRequested, boolean addCompanyBillingDetails, boolean skipVatNr, boolean validated, Locale locale, Principal principal) {
        String completeBillingAddress = TicketReservationManager.buildCompleteBillingAddress((CustomerName)customerName, (String)billingAddressCompany, (String)billingAddressLine1, (String)billingAddressLine2, (String)billingAddressZip, (String)billingAddressCity, (String)billingAddressState, (String)vatCountryCode, (Locale)locale);
        this.ticketReservationRepository.updateTicketReservationWithValidation(reservationId, customerName.getFullName(), customerName.getFirstName(), customerName.getLastName(), email, billingAddressCompany, billingAddressLine1, billingAddressLine2, billingAddressZip, billingAddressCity, billingAddressState, completeBillingAddress, vatCountryCode, vatNr, isInvoiceRequested, addCompanyBillingDetails, skipVatNr, customerReference, validated);
        if (principal != null && this.configurationManager.isPublicOpenIdEnabled()) {
            this.ticketReservationRepository.setReservationOwner(reservationId, this.retrievePublicUserId(principal));
        }
    }

    public void setReservationOwner(String reservationId, String username, String email, String firstName, String lastName, String userLanguage) {
        if (this.configurationManager.isPublicOpenIdEnabled()) {
            Integer userId = this.userManager.createPublicUserIfNotExists(username, email, firstName, lastName);
            if (userId != null) {
                this.ticketReservationRepository.setReservationOwner(reservationId, userId);
                log.info("Assigned reservation {} to user ID {}", (Object)reservationId, (Object)userId);
            } else {
                log.info("UserId not found. Leaving reservation {} anonymous", (Object)reservationId);
            }
        } else {
            log.info("Public OpenID is not enabled. Leaving reservation {} anonymous", (Object)reservationId);
        }
        CustomerName customerName = new CustomerName(null, firstName, lastName, true);
        this.ticketReservationRepository.updateTicketReservation(reservationId, SpecialPrice.Status.PENDING.toString(), email, customerName.getFullName(), customerName.getFirstName(), customerName.getLastName(), userLanguage, null, null, null, null);
    }

    public void setReservationMetadata(String reservationId, ReservationMetadata metadata) {
        Validate.isTrue((this.ticketReservationRepository.setMetadata(reservationId, metadata) == 1 ? 1 : 0) != 0, (String)"Error while updating metadata", (Object[])new Object[0]);
    }

    public static String buildCompleteBillingAddress(CustomerName customerName, String billingAddressCompany, String billingAddressLine1, String billingAddressLine2, String billingAddressZip, String billingAddressCity, String billingAddressState, String countryCode, Locale locale) {
        Object companyName = StringUtils.stripToNull((String)billingAddressCompany);
        String fullName = StringUtils.stripToEmpty((String)customerName.getFullName());
        if (companyName != null && !fullName.isEmpty()) {
            companyName = (String)companyName + "\n" + fullName;
        }
        String country = null;
        if (countryCode != null) {
            country = TicketHelper.getLocalizedCountriesForVat((Locale)locale).stream().filter(c -> ((String)c.getKey()).equals(countryCode)).map(Pair::getValue).findFirst().orElse(null);
        }
        return Arrays.stream(StringUtils.stripAll((String[])new String[]{Objects.requireNonNullElse(companyName, fullName), billingAddressLine1, billingAddressLine2, StringUtils.stripToEmpty((String)billingAddressZip) + " " + StringUtils.stripToEmpty((String)billingAddressCity) + " " + StringUtils.stripToEmpty((String)billingAddressState), StringUtils.stripToNull((String)country)})).filter(Predicate.not(StringUtils::isEmpty)).collect(Collectors.joining("\n"));
    }

    public void updateReservationInvoicingAdditionalInformation(String reservationId, PurchaseContext purchaseContext, TicketReservationInvoicingAdditionalInfo ticketReservationInvoicingAdditionalInfo) {
        this.auditingRepository.insert(reservationId, null, (Integer)purchaseContext.event().map(EventAndOrganizationId::getId).orElse(null), Audit.EventType.BILLING_DATA_UPDATED, new Date(), Audit.EntityType.RESERVATION, reservationId, this.json.asJsonString(List.of(ticketReservationInvoicingAdditionalInfo)));
        this.ticketReservationRepository.updateInvoicingAdditionalInformation(reservationId, this.json.asJsonString((Object)ticketReservationInvoicingAdditionalInfo));
    }

    public PaymentWebhookResult processTransactionWebhook(String body, String signature, PaymentProxy paymentProxy, Map<String, String> additionalInfo) {
        return this.processTransactionWebhook(body, signature, paymentProxy, additionalInfo, new PaymentContext());
    }

    public PaymentWebhookResult processTransactionWebhook(String body, String signature, PaymentProxy paymentProxy, Map<String, String> additionalInfo, PaymentContext pc) {
        Optional paymentProviderOptional = this.paymentManager.streamActiveProvidersByProxyAndCapabilities(paymentProxy, pc, List.of(WebhookHandler.class)).findFirst();
        if (paymentProviderOptional.isEmpty()) {
            return PaymentWebhookResult.error((String)"payment provider not found");
        }
        PaymentProvider paymentProvider = (PaymentProvider)paymentProviderOptional.get();
        if (((WebhookHandler)paymentProvider).requiresSignedBody() && StringUtils.isBlank((CharSequence)signature)) {
            return PaymentWebhookResult.error((String)"signature is missing");
        }
        PaymentContext paymentContext = pc.getConfigurationLevel().isSystem() ? ((WebhookHandler)paymentProvider).detectPaymentContext(body).orElse(pc) : pc;
        Optional optionalTransactionWebhookPayload = ((WebhookHandler)paymentProvider).parseTransactionPayload(body, signature, additionalInfo, paymentContext);
        if (optionalTransactionWebhookPayload.isEmpty()) {
            return PaymentWebhookResult.error((String)"payload not recognized");
        }
        TransactionWebhookPayload transactionPayload = (TransactionWebhookPayload)optionalTransactionWebhookPayload.get();
        Optional optionalReservation = this.ticketReservationRepository.findOptionalReservationById(transactionPayload.getReservationId());
        if (optionalReservation.isEmpty()) {
            return PaymentWebhookResult.notRelevant((String)"reservation not found");
        }
        TicketReservation reservation = (TicketReservation)optionalReservation.get();
        Optional optionalTransaction = this.transactionRepository.lockLatestForUpdate(reservation.getId());
        if (optionalTransaction.isEmpty()) {
            return PaymentWebhookResult.notRelevant((String)"transaction not found");
        }
        Transaction transaction = (Transaction)optionalTransaction.get();
        if (this.reservationStatusNotCompatible(reservation) || transaction.getStatus() != Transaction.Status.PENDING) {
            log.warn("discarding transaction webhook {} for reservation id {} ({}). Transaction status is: {}", new Object[]{transactionPayload.getType(), reservation.getId(), reservation.getStatus(), transaction.getStatus()});
            return PaymentWebhookResult.notRelevant((String)"reservation status is not compatible");
        }
        PurchaseContext purchaseContext = (PurchaseContext)this.purchaseContextManager.findByReservationId(reservation.getId()).orElseThrow();
        PaymentContext paymentContextReloaded = new PaymentContext(purchaseContext);
        return this.paymentManager.lookupProviderByTransactionAndCapabilities(transaction, List.of(WebhookHandler.class)).map(provider -> {
            PaymentWebhookResult paymentWebhookResult = ((WebhookHandler)provider).processWebhook(transactionPayload, transaction, paymentContextReloaded);
            String operationType = transactionPayload.getType();
            return this.handlePaymentWebhookResult(purchaseContext, paymentProvider, paymentWebhookResult, reservation, transaction, paymentContextReloaded, operationType, true);
        }).orElseGet(() -> PaymentWebhookResult.error((String)"payment provider not found"));
    }

    private PaymentWebhookResult handlePaymentWebhookResult(PurchaseContext purchaseContext, PaymentProvider paymentProvider, PaymentWebhookResult paymentWebhookResult, TicketReservation reservation, Transaction transaction, PaymentContext paymentContext, String operationType, boolean moveToWatingExternalConfirmationAllowed) {
        switch (1.$SwitchMap$alfio$manager$support$PaymentWebhookResult$Type[paymentWebhookResult.getType().ordinal()]) {
            case 1: {
                log.trace("Discarding event {} for reservation {}", (Object)operationType, (Object)reservation.getId());
                break;
            }
            case 2: {
                if (reservation.getStatus() == TicketReservation.TicketReservationStatus.EXTERNAL_PROCESSING_PAYMENT && moveToWatingExternalConfirmationAllowed) {
                    String status = TicketReservation.TicketReservationStatus.WAITING_EXTERNAL_CONFIRMATION.name();
                    log.trace("Event {} received. Setting status {} for reservation {}", new Object[]{operationType, status, reservation.getId()});
                    this.ticketReservationRepository.updateReservationStatus(reservation.getId(), status);
                    break;
                }
                log.trace("Ignoring Event {}, as it cannot be applied for reservation {} ({})", new Object[]{operationType, reservation.getId(), reservation.getStatus()});
                break;
            }
            case 3: {
                log.trace("Event {} for reservation {} has been successfully processed.", (Object)operationType, (Object)reservation.getId());
                TotalPrice totalPrice = (TotalPrice)this.totalReservationCostWithVAT(reservation).getLeft();
                PaymentToken paymentToken = paymentWebhookResult.getPaymentToken();
                PaymentSpecification paymentSpecification = new PaymentSpecification(reservation, totalPrice, purchaseContext, paymentToken, this.orderSummaryForReservation(reservation, purchaseContext), true, ReservationUtil.hasPrivacyPolicy((PurchaseContext)purchaseContext));
                this.transitionToComplete(paymentSpecification, paymentToken.getPaymentProvider(), null);
                break;
            }
            case 4: {
                log.debug("Event {} for reservation {} has failed with reason: {}", new Object[]{operationType, reservation.getId(), paymentWebhookResult.getReason()});
                Date expiration = reservation.getValidity();
                Date now = new Date();
                int slackTime = this.configurationManager.getFor(ConfigurationKeys.RESERVATION_MIN_TIMEOUT_AFTER_FAILED_PAYMENT, paymentContext.getConfigurationLevel()).getValueAsIntOrDefault(10);
                PaymentMethod paymentMethodForTransaction = paymentProvider.getPaymentMethodForTransaction(transaction);
                if (expiration.before(now)) {
                    this.sendTransactionFailedEmail(purchaseContext, reservation, paymentMethodForTransaction, paymentWebhookResult, true);
                    this.cancelReservation(reservation, false, null);
                    break;
                }
                if (DateUtils.addMinutes((Date)expiration, (int)(-slackTime)).before(now)) {
                    this.ticketReservationRepository.updateValidity(reservation.getId(), DateUtils.addMinutes((Date)now, (int)slackTime));
                }
                this.reTransitionToPending(reservation.getId(), false);
                purchaseContext.event().ifPresent(event -> this.sendTransactionFailedEmail((PurchaseContext)event, reservation, paymentMethodForTransaction, paymentWebhookResult, false));
                break;
            }
            case 5: {
                this.reTransitionToPending(reservation.getId(), false);
                log.debug("Event {} for reservation {} has been cancelled", (Object)operationType, (Object)reservation.getId());
                break;
            }
        }
        return paymentWebhookResult;
    }

    public Optional<PaymentResult> forceTransactionCheck(PurchaseContext purchaseContext, TicketReservation reservation) {
        Optional optionalTransaction = this.transactionRepository.loadOptionalByReservationIdAndStatusForUpdate(reservation.getId(), Transaction.Status.PENDING);
        if (optionalTransaction.isEmpty()) {
            return Optional.empty();
        }
        Transaction transaction = (Transaction)optionalTransaction.get();
        PaymentContext paymentContext = new PaymentContext(purchaseContext, reservation.getId());
        return this.checkTransactionStatus(purchaseContext, reservation).map(providerAndWebhookResult -> {
            PaymentWebhookResult paymentWebhookResult = (PaymentWebhookResult)providerAndWebhookResult.getRight();
            this.handlePaymentWebhookResult(purchaseContext, (PaymentProvider)providerAndWebhookResult.getLeft(), paymentWebhookResult, reservation, transaction, paymentContext, "force-check", true);
            return switch (1.$SwitchMap$alfio$manager$support$PaymentWebhookResult$Type[paymentWebhookResult.getType().ordinal()]) {
                case 4, 5, 6 -> PaymentResult.failed((String)paymentWebhookResult.getReason());
                case 1, 7 -> PaymentResult.pending((String)transaction.getPaymentId());
                case 2 -> {
                    if (StringUtils.isNotEmpty((CharSequence)paymentWebhookResult.getRedirectUrl())) {
                        yield PaymentResult.redirect((String)paymentWebhookResult.getRedirectUrl());
                    }
                    yield PaymentResult.pending((String)transaction.getPaymentId());
                }
                default -> PaymentResult.successful((String)paymentWebhookResult.getPaymentToken().getToken());
            };
        });
    }

    private Optional<Pair<PaymentProvider, PaymentWebhookResult>> checkTransactionStatus(PurchaseContext purchaseContext, TicketReservation reservation) {
        Optional optionalTransaction = this.transactionRepository.loadOptionalByReservationIdAndStatusForUpdate(reservation.getId(), Transaction.Status.PENDING);
        if (optionalTransaction.isEmpty()) {
            return Optional.empty();
        }
        Transaction transaction = (Transaction)optionalTransaction.get();
        PaymentContext paymentContext = new PaymentContext(purchaseContext, reservation.getId());
        return this.paymentManager.lookupProviderByTransactionAndCapabilities(transaction, List.of(WebhookHandler.class)).map(provider -> Pair.of((Object)provider, (Object)((WebhookHandler)provider).forceTransactionCheck(reservation, transaction, paymentContext)));
    }

    private boolean reservationStatusNotCompatible(TicketReservation reservation) {
        TicketReservation.TicketReservationStatus status = reservation.getStatus();
        return status != TicketReservation.TicketReservationStatus.EXTERNAL_PROCESSING_PAYMENT && status != TicketReservation.TicketReservationStatus.WAITING_EXTERNAL_CONFIRMATION;
    }

    private void sendTransactionFailedEmail(PurchaseContext purchaseContext, TicketReservation reservation, PaymentMethod paymentMethod, PaymentWebhookResult paymentWebhookResult, boolean cancelReservation) {
        String shortReservationID = this.configurationManager.getShortReservationID((Configurable)purchaseContext, reservation);
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor(purchaseContext);
        Map<String, String> model = Map.of("organization", this.organizationRepository.getById(purchaseContext.getOrganizationId()), "reservationCancelled", cancelReservation, "reservation", reservation, "reservationId", shortReservationID, "eventName", purchaseContext.getDisplayName(), "provider", Objects.requireNonNullElse(paymentMethod, PaymentMethod.NONE).name(), "reason", paymentWebhookResult.getReason(), "reservationUrl", this.reservationUrl(reservation, purchaseContext));
        Locale locale = LocaleUtil.forLanguageTag((String)reservation.getUserLanguage());
        if (cancelReservation || this.configurationManager.getFor(ConfigurationKeys.NOTIFY_ALL_FAILED_PAYMENT_ATTEMPTS, purchaseContext.getConfigurationLevel()).getValueAsBooleanOrDefault()) {
            this.notificationManager.sendSimpleEmail(purchaseContext, reservation.getId(), reservation.getEmail(), messageSource.getMessage("email-transaction-failed.subject", new Object[]{shortReservationID, purchaseContext.getDisplayName()}, locale), () -> this.templateManager.renderTemplate(purchaseContext, TemplateResource.CHARGE_ATTEMPT_FAILED_EMAIL_FOR_ORGANIZER, model, locale), List.of());
        }
        this.notificationManager.sendSimpleEmail(purchaseContext, reservation.getId(), reservation.getEmail(), messageSource.getMessage("email-transaction-failed.subject", new Object[]{shortReservationID, purchaseContext.getDisplayName()}, locale), () -> this.templateManager.renderTemplate(purchaseContext, TemplateResource.CHARGE_ATTEMPT_FAILED_EMAIL, model, locale), List.of());
    }

    public Optional<TransactionInitializationToken> initTransaction(PurchaseContext purchaseContext, String reservationId, PaymentMethod paymentMethod, Map<String, List<String>> params) {
        this.ticketReservationRepository.lockReservationForUpdate(reservationId);
        TicketReservation reservation = this.ticketReservationRepository.findReservationById(reservationId);
        TransactionRequest transactionRequest = new TransactionRequest((TotalPrice)this.totalReservationCostWithVAT(reservation).getLeft(), this.ticketReservationRepository.getBillingDetailsForReservation(reservationId));
        Optional optionalProvider = this.paymentManager.lookupProviderByMethodAndCapabilities(paymentMethod, new PaymentContext(purchaseContext), transactionRequest, List.of(WebhookHandler.class, ServerInitiatedTransaction.class));
        if (optionalProvider.isEmpty()) {
            return Optional.empty();
        }
        MessageSource messageSource = this.messageSourceManager.getMessageSourceFor(purchaseContext);
        ServerInitiatedTransaction provider = (ServerInitiatedTransaction)optionalProvider.get();
        PaymentSpecification paymentSpecification = new PaymentSpecification(reservation, (TotalPrice)this.totalReservationCostWithVAT(reservation).getLeft(), purchaseContext, null, this.orderSummaryForReservation(reservation, purchaseContext), false, false);
        if (!this.acquireGroupMembers(reservationId, purchaseContext)) {
            this.groupManager.deleteWhitelistedTicketsForReservation(reservationId);
            String errorMessage = messageSource.getMessage("error.STEP2_WHITELIST", null, LocaleUtil.forLanguageTag((String)reservation.getUserLanguage()));
            return Optional.of(provider.errorToken(errorMessage, false));
        }
        TransactionInitializationToken transactionToken = provider.initTransaction(paymentSpecification, params);
        if (this.transitionToExternalProcessingPayment(reservation)) {
            this.auditingRepository.insert(reservationId, null, purchaseContext, Audit.EventType.INIT_PAYMENT, new Date(), Audit.EntityType.RESERVATION, reservationId);
        }
        return Optional.of(transactionToken);
    }

    private boolean transitionToExternalProcessingPayment(TicketReservation reservation) {
        String reservationId = reservation.getId();
        Optional optionalTransaction = this.transactionRepository.loadOptionalByReservationId(reservation.getId());
        if (optionalTransaction.filter(ot -> ot.getStatus() == Transaction.Status.PENDING).isEmpty()) {
            log.warn("trying to transition reservation {} to EXTERNAL_PROCESSING_PAYMENT but the current transaction is not PENDING. Ignoring the request...", (Object)reservationId);
            return false;
        }
        if (reservation.getStatus() != TicketReservation.TicketReservationStatus.PENDING) {
            log.warn("trying to transition reservation {} to EXTERNAL_PROCESSING_PAYMENT but the current status is {}. Ignoring the request...", (Object)reservationId, (Object)reservation.getStatus());
            return false;
        }
        this.ticketReservationRepository.updateReservationStatus(reservation.getId(), TicketReservation.TicketReservationStatus.EXTERNAL_PROCESSING_PAYMENT.name());
        return true;
    }

    public void checkOfflinePaymentsStatus() {
        this.eventRepository.findAllActives(ZonedDateTime.now(this.clockProvider.getClock())).forEach(arg_0 -> this.checkOfflinePaymentsForEvent(arg_0));
    }

    public Optional<String> createSubscriptionReservation(SubscriptionDescriptor subscriptionDescriptor, Locale locale, Principal principal) {
        return this.createSubscriptionReservation(subscriptionDescriptor, locale, principal, SubscriptionMetadata.empty());
    }

    public Optional<String> createSubscriptionReservation(SubscriptionDescriptor subscriptionDescriptor, Locale locale, Principal principal, SubscriptionMetadata metadata) {
        Date expiration = DateUtils.addMinutes((Date)new Date(), (int)this.getReservationTimeout((Configurable)subscriptionDescriptor));
        return Optional.of(this.createSubscriptionReservation(subscriptionDescriptor, expiration, locale, this.retrievePublicUserId(principal), metadata));
    }

    public Optional<String> createTicketReservation(Event event, List<TicketReservationWithOptionalCodeModification> list, List<ASReservationWithOptionalCodeModification> additionalServices, Optional<String> promoCodeDiscount, Locale locale, Principal principal) {
        Date expiration = DateUtils.addMinutes((Date)new Date(), (int)this.getReservationTimeout((Configurable)event));
        String reservationId = this.createTicketReservation(event, list, additionalServices, expiration, promoCodeDiscount, locale, false, principal);
        return Optional.of(reservationId);
    }

    boolean canProceedWithPayment(PurchaseContext purchaseContext, TotalPrice totalPrice, String reservationId) {
        if (!totalPrice.requiresPayment()) {
            return true;
        }
        List categoriesInReservation = this.ticketRepository.getCategoriesIdToPayInReservation(reservationId);
        List blacklistedPaymentMethods = this.configurationManager.getBlacklistedMethodsForReservation(purchaseContext, (Collection)categoriesInReservation);
        TransactionRequest transactionRequest = new TransactionRequest(totalPrice, this.ticketReservationRepository.getBillingDetailsForReservation(reservationId));
        List availableMethods = this.paymentManager.getPaymentMethods(purchaseContext, transactionRequest).stream().filter(pm -> pm.getStatus() == PaymentManager.PaymentMethodDTO.PaymentMethodStatus.ACTIVE && pm.getPaymentMethod() != PaymentMethod.NONE).collect(Collectors.toList());
        if (availableMethods.isEmpty() || availableMethods.stream().allMatch(pm -> blacklistedPaymentMethods.contains(pm.getPaymentMethod()))) {
            log.error("Cannot proceed with reservation. No payment methods available {} or all blacklisted {}", availableMethods, (Object)blacklistedPaymentMethods);
            return false;
        }
        return true;
    }

    public Result<Boolean> discardMatchingPayment(String eventName, String reservationId, int transactionId) {
        return this.eventRepository.findOptionalByShortName(eventName).flatMap(e -> this.ticketReservationRepository.findOptionalReservationById(reservationId).map(r -> Pair.of((Object)e, (Object)r))).flatMap(pair -> this.transactionRepository.loadOptionalByIdAndStatus(transactionId, Transaction.Status.OFFLINE_PENDING_REVIEW).map(transaction -> {
            this.auditingRepository.insert(reservationId, null, Integer.valueOf(((Event)pair.getLeft()).getId()), Audit.EventType.MATCHING_PAYMENT_DISCARDED, new Date(), Audit.EntityType.RESERVATION, reservationId);
            Validate.isTrue((this.transactionRepository.discardMatchingPayment(transactionId) == 1 ? 1 : 0) != 0, (String)"Transaction is in an incompatible state.", (Object[])new Object[0]);
            return Result.success((Object)true);
        })).orElse(Result.error((ErrorCode)ErrorCode.EventError.NOT_FOUND));
    }

    public void flagAsValidated(String reservationId, PurchaseContext purchaseContext, List<WarningMessage> warnings) {
        this.ticketReservationRepository.updateValidationStatus(reservationId, true);
        if (!warnings.isEmpty()) {
            this.auditingRepository.insert(reservationId, null, purchaseContext, Audit.EventType.WARNING_IGNORED, new Date(), Audit.EntityType.RESERVATION, reservationId, List.of(Map.of("warnings", warnings)));
        }
    }

    private void checkOfflinePaymentsForEvent(Event event) {
        log.trace("check offline payments for event {}", (Object)event.getShortName());
        PaymentContext paymentContext = new PaymentContext((PurchaseContext)event);
        List providers = this.paymentManager.streamActiveProvidersByProxyAndCapabilities(PaymentProxy.OFFLINE, paymentContext, List.of(OfflineProcessor.class)).collect(Collectors.toList());
        if (providers.isEmpty()) {
            log.trace("No active offline provider has been found. Exiting...");
            return;
        }
        Map pendingReservationsMap = this.ticketSearchRepository.findOfflineReservationsWithPendingTransaction(event.getId()).stream().collect(Collectors.toMap(tr -> tr.getTicketReservation().getId(), Function.identity()));
        if (pendingReservationsMap.isEmpty()) {
            log.trace("no pending reservations found. Exiting...");
            return;
        }
        ArrayList errors = new ArrayList();
        ArrayList confirmed = new ArrayList();
        ArrayList pendingReview = new ArrayList();
        int matchingCount = 0;
        for (int i = 0; !pendingReservationsMap.isEmpty() && i < providers.size(); ++i) {
            OfflineProcessor offlineProcessor = (OfflineProcessor)providers.get(i);
            Result matching = offlineProcessor.checkPendingReservations(pendingReservationsMap.values(), paymentContext, null);
            if (!matching.isSuccess()) continue;
            int resultSize = ((List)matching.getData()).size();
            log.trace("found {} matches for provider {}", (Object)(matchingCount += resultSize), (Object)offlineProcessor.getClass().getName());
            if (resultSize <= 0) continue;
            this.processResults(event, pendingReservationsMap, errors, confirmed, pendingReview, matching);
        }
        if (matchingCount > 0) {
            Organization organization = this.organizationRepository.getById(event.getOrganizationId());
            List cc = this.notificationManager.getCCForEventOrganizer((PurchaseContext)event);
            String subject = "%d matching payments found for: %s".formatted(matchingCount, event.getDisplayName());
            Map model = Map.of("matchingCount", matchingCount, "eventName", event.getDisplayName(), "pendingReviewMatches", !pendingReview.isEmpty(), "pendingReview", pendingReview, "automaticApprovedMatches", !confirmed.isEmpty(), "automaticApproved", confirmed, "automaticApprovalErrors", !errors.isEmpty(), "approvalErrors", errors);
            this.notificationManager.sendSimpleEmail((PurchaseContext)event, null, organization.getEmail(), cc, subject, () -> this.templateManager.renderTemplate((PurchaseContext)event, TemplateResource.OFFLINE_PAYMENT_MATCHES_FOUND, model, Locale.ENGLISH));
        }
    }

    private void processResults(Event event, Map<String, TicketReservationWithTransaction> pendingReservationsMap, ArrayList<String> errors, ArrayList<String> confirmed, ArrayList<String> pendingReview, Result<List<String>> matching) {
        List reservations = this.ticketSearchRepository.findOfflineReservationsWithTransaction((List)matching.getData());
        reservations.forEach(tr -> {
            String reservationId = tr.getTicketReservation().getId();
            this.auditingRepository.insert(reservationId, null, Integer.valueOf(event.getId()), Audit.EventType.MATCHING_PAYMENT_FOUND, new Date(), Audit.EntityType.RESERVATION, reservationId, this.json.asJsonString(List.of(tr.getTransaction().getMetadata())));
            pendingReservationsMap.remove(reservationId);
        });
        Map<Transaction.Status, List<TicketReservationWithTransaction>> byStatus = reservations.stream().collect(Collectors.groupingBy(tr -> tr.getTransaction().getStatus()));
        byStatus.getOrDefault(Transaction.Status.OFFLINE_MATCHING_PAYMENT_FOUND, List.of()).forEach(tr -> {
            String reservationId = tr.getTicketReservation().getId();
            if (this.automaticConfirmOfflinePayment(event, reservationId)) {
                log.trace("reservation {} confirmed automatically", (Object)reservationId);
                this.auditingRepository.insert(reservationId, null, Integer.valueOf(event.getId()), Audit.EventType.AUTOMATIC_PAYMENT_CONFIRMATION, new Date(), Audit.EntityType.RESERVATION, reservationId);
                confirmed.add(reservationId);
            } else {
                log.trace("got error while confirming reservation {}", (Object)reservationId);
                this.auditingRepository.insert(reservationId, null, Integer.valueOf(event.getId()), Audit.EventType.AUTOMATIC_PAYMENT_CONFIRMATION_FAILED, new Date(), Audit.EntityType.RESERVATION, reservationId);
                errors.add(reservationId);
            }
        });
        pendingReview.addAll(byStatus.getOrDefault(Transaction.Status.OFFLINE_PENDING_REVIEW, List.of()).stream().map(tr -> tr.getTicketReservation().getId()).collect(Collectors.toList()));
    }

    private boolean automaticConfirmOfflinePayment(Event event, String reservationId) {
        try {
            this.confirmOfflinePayment(event, reservationId, null, null);
            return true;
        }
        catch (Exception ex) {
            log.warn("Unable to confirm reservation " + reservationId, (Throwable)ex);
            return false;
        }
    }

    public boolean validateAndApplySubscriptionCode(PurchaseContext purchaseContext, TicketReservation reservation, Optional<UUID> subscriptionUUID, String pin, String email, BindingResult bindingResult) {
        int count;
        Assert.isTrue((boolean)purchaseContext.ofType(PurchaseContext.PurchaseContextType.event), (String)"PurchaseContext must be of type \"event\"");
        boolean isUUID = subscriptionUUID.isPresent();
        log.trace("is code UUID {}", (Object)isUUID);
        if (!isUUID && !PinGenerator.isPinValid((String)pin, (int)8)) {
            bindingResult.reject("error.restrictedValue");
            return false;
        }
        Assert.isTrue((pin.length() >= 8 ? 1 : 0) != 0, (String)"Pin must have a length of at least 8 characters");
        String partialUuid = !isUUID ? PinGenerator.pinToPartialUuid((String)pin, (int)8) : pin;
        boolean requireEmail = false;
        if (isUUID) {
            count = this.subscriptionRepository.countSubscriptionById(subscriptionUUID.get());
        } else {
            count = this.subscriptionRepository.countSubscriptionByPartialUuid(partialUuid);
            if (count > 1) {
                count = this.subscriptionRepository.countSubscriptionByPartialUuidAndEmail(partialUuid, email);
                requireEmail = true;
            }
        }
        log.trace("code count is {}", (Object)count);
        if (count == 0) {
            bindingResult.reject(isUUID ? "subscription.uuid.not.found" : "subscription.pin.not.found");
        }
        if (count > 1) {
            bindingResult.reject("subscription.code.insert.full");
        }
        if (bindingResult.hasErrors()) {
            return false;
        }
        UUID subscriptionId = isUUID ? UUID.fromString(pin) : (requireEmail ? this.subscriptionRepository.getSubscriptionIdByPartialUuidAndEmail(partialUuid, email) : this.subscriptionRepository.getSubscriptionIdByPartialUuid(partialUuid));
        SubscriptionDescriptor subscriptionDescriptor = this.subscriptionRepository.findDescriptorBySubscriptionId(subscriptionId);
        Subscription subscription = this.subscriptionRepository.findSubscriptionById(subscriptionId);
        subscription.isValid(Optional.of(bindingResult));
        if (bindingResult.hasErrors()) {
            return false;
        }
        try {
            return this.applySubscriptionCode(((Event)purchaseContext).getId(), reservation, subscriptionDescriptor, subscriptionId);
        }
        catch (SubscriptionUsageExceeded | SubscriptionUsageExceededForEvent ex) {
            bindingResult.reject(ex instanceof SubscriptionUsageExceeded ? "subscription.max-usage-reached" : "subscription.max-usage-reached-per-event");
            return false;
        }
    }

    boolean applySubscriptionCode(int eventId, TicketReservation reservation, SubscriptionDescriptor subscriptionDescriptor, UUID subscriptionId) throws SubscriptionUsageExceeded, SubscriptionUsageExceededForEvent {
        log.trace("entering applySubscription {}", (Object)subscriptionId);
        if (this.ticketReservationRepository.hasSubscriptionApplied(reservation.getId())) {
            return false;
        }
        Subscription subscription = this.subscriptionRepository.findSubscriptionByIdForUpdate(subscriptionId);
        if (!subscription.isValid()) {
            return false;
        }
        Optional linkOptional = this.subscriptionRepository.findLink(subscription.getOrganizationId(), subscription.getSubscriptionDescriptorId(), eventId);
        if (linkOptional.isEmpty()) {
            log.warn("Attempt to use subscription {} - descriptor {} for event {}", new Object[]{subscription.getId(), subscriptionDescriptor.getId(), eventId});
            return false;
        }
        EventSubscriptionLink link = (EventSubscriptionLink)linkOptional.get();
        if (CollectionUtils.isNotEmpty((Collection)link.getCompatibleCategories())) {
            Set bookedCategories = this.ticketCategoryRepository.findCategoriesInReservation(reservation.getId()).stream().map(TicketCategory::getId).collect(Collectors.toSet());
            if (CollectionUtils.intersection((Iterable)link.getCompatibleCategories(), bookedCategories).isEmpty()) {
                log.warn("Attempt to use subscription {} - descriptor {} unsuccessful for event {}. No compatible categories found (booked: {}).", new Object[]{subscription.getId(), subscriptionDescriptor.getId(), eventId, bookedCategories});
                return false;
            }
        }
        try {
            int limit;
            boolean oncePerEvent;
            log.trace("applying subscription {} to reservation {}", (Object)subscriptionId, (Object)reservation.getId());
            Integer eventIdToFilter = null;
            boolean bl = oncePerEvent = subscriptionDescriptor.getUsageType() == SubscriptionDescriptor.SubscriptionUsageType.ONCE_PER_EVENT;
            if (oncePerEvent) {
                limit = 1;
                eventIdToFilter = eventId;
            } else {
                limit = subscription.getMaxEntries() > -1 ? subscription.getMaxEntries() : Integer.MAX_VALUE;
            }
            int countExisting = this.ticketRepository.countSubscriptionUsage(subscriptionId, eventIdToFilter);
            if (countExisting >= limit) {
                throw oncePerEvent ? new SubscriptionUsageExceededForEvent(limit, countExisting + 1) : new SubscriptionUsageExceeded(limit, countExisting + 1);
            }
            this.ticketReservationRepository.applySubscription(reservation.getId(), subscription.getId());
            int count = CollectionUtils.isNotEmpty((Collection)link.getCompatibleCategories()) ? this.ticketRepository.applySubscriptionToTicketsInReservation(reservation.getId(), subscriptionId, (Collection)link.getCompatibleCategories(), limit - countExisting) : this.ticketRepository.applySubscriptionToTicketsInReservation(reservation.getId(), subscriptionId, limit - countExisting);
            log.trace("Applied subscription {} to {} tickets for reservation {}", new Object[]{subscriptionId, count, reservation.getId()});
        }
        catch (UncategorizedSQLException sqlException) {
            log.trace("got exception while trying to apply SubscriptionID {} to ReservationID {}", (Object)subscriptionId, (Object)reservation.getId());
            throw SqlUtils.findServerError((UncategorizedSQLException)sqlException).map(serverError -> {
                if (serverError.getMessage() == null || serverError.getDetail() == null) {
                    log.warn("Cannot retrieve ErrorDetails for SubscriptionID {} and ReservationID {}", (Object)subscriptionId, (Object)reservation.getId());
                    return sqlException;
                }
                MaxEntriesOverageDetails errorDetails = (MaxEntriesOverageDetails)this.json.fromJsonString(serverError.getDetail(), MaxEntriesOverageDetails.class);
                if (Objects.equals(serverError.getMessage(), SubscriptionUsageExceeded.ERROR)) {
                    return new SubscriptionUsageExceeded(errorDetails.getAllowed(), errorDetails.getRequested());
                }
                return new SubscriptionUsageExceededForEvent(errorDetails.getAllowed(), errorDetails.getRequested());
            }).orElse((RuntimeException)((Object)sqlException));
        }
        TotalPrice totalPrice = (TotalPrice)this.totalReservationCostWithVAT(reservation.getId()).getLeft();
        PurchaseContext purchaseContext = (PurchaseContext)this.purchaseContextManager.findByReservationId(reservation.getId()).orElseThrow();
        this.ticketReservationRepository.updateBillingData(reservation.getVatStatus(), this.calculateSrcPrice(purchaseContext.getVatStatus(), totalPrice), totalPrice.getPriceWithVAT(), totalPrice.getVAT(), Math.abs(totalPrice.getDiscount()), purchaseContext.getCurrency(), reservation.getVatNr(), reservation.getVatCountryCode(), reservation.isInvoiceRequested(), reservation.getId());
        log.trace("subscription applied. totalPrice is {}", (Object)totalPrice.getPriceWithVAT());
        return true;
    }

    public boolean removeSubscription(TicketReservation reservation) {
        String reservationId = reservation.getId();
        if (this.ticketReservationRepository.hasSubscriptionApplied(reservationId)) {
            this.ticketReservationRepository.applySubscription(reservationId, null);
            this.ticketRepository.removeSubscriptionFromTicketsInReservation(reservationId);
            return true;
        }
        return false;
    }

    public boolean validateAccessToReservation(TicketReservation reservation, Principal principal) {
        return this.ticketReservationRepository.getReservationOwnerAndOrganizationId(reservation.getId()).map(owner -> {
            Optional currentUserOptional = Optional.ofNullable(principal).map(Principal::getName).flatMap(arg_0 -> ((UserRepository)this.userRepository).findEnabledByUsername(arg_0));
            if (currentUserOptional.isEmpty()) {
                return false;
            }
            User currentUser = (User)currentUserOptional.get();
            return currentUser.getId() == owner.getUserId() || this.userManager.isOwnerOfOrganization(currentUser, owner.getOrganizationId());
        }).orElse(true);
    }

    public List<ReservationWithPurchaseContext> loadReservationsForUser(Principal principal) {
        Integer userId = this.retrievePublicUserId(principal);
        if (userId != null) {
            return this.ticketReservationRepository.findAllReservationsForUser(userId.intValue());
        }
        return List.of();
    }

    public Optional<SubscriptionWithUsageDetails> findSubscriptionDetails(String reservationId) {
        return this.subscriptionRepository.findSubscriptionsByReservationId(reservationId).stream().findFirst().map(s -> {
            int usageCount = this.ticketRepository.countSubscriptionUsage(s.getId(), null);
            return new SubscriptionWithUsageDetails(s, UsageDetails.fromSubscription((Subscription)s, (int)usageCount), this.ticketReservationRepository.findConfirmedReservationsBySubscriptionId(s.getId()));
        });
    }

    public Map<String, List<String>> retrieveAttendeeAdditionalInfoForTicket(Ticket ticket) {
        return this.reservationHelper.retrieveAttendeeAdditionalInfoForTicket(ticket);
    }

    private Integer retrievePublicUserId(Principal principal) {
        Integer userId = null;
        if (this.configurationManager.isPublicOpenIdEnabled() && principal != null) {
            userId = this.userRepository.findPublicUserIdByUsername(principal.getName()).orElse(null);
        }
        return userId;
    }
}

